/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.cmiLib.VersionChecker;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.WESchematicManager;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class SchematicsManager
implements WESchematicManager {
    private Residence plugin;

    public SchematicsManager(Residence residence) {
        this.plugin = residence;
    }

    @Override
    public boolean save(ClaimedResidence res) {
        if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1)) {
            return false;
        }
        if (this.plugin.getWorldEdit() == null) {
            return false;
        }
        if (res == null) {
            return false;
        }
        CuboidArea area2 = res.getAreaArray()[0];
        Vector bvmin = new Vector(area2.getLowLoc().getBlockX(), area2.getLowLoc().getBlockY(), area2.getLowLoc().getBlockZ());
        Vector bvmax = new Vector(area2.getHighLoc().getBlockX(), area2.getHighLoc().getBlockY(), area2.getHighLoc().getBlockZ());
        Vector origin = new Vector(area2.getLowLoc().getBlockX(), area2.getLowLoc().getBlockY(), area2.getLowLoc().getBlockZ());
        World bworld = Bukkit.getWorld((String)res.getWorld());
        if (bworld == null) {
            return false;
        }
        EditSession editSession = (EditSession)EditSession.class.getConstructor(BukkitWorld.class, Integer.class).newInstance(new BukkitWorld(bworld), Integer.MAX_VALUE);
        editSession.enableQueue();
        CuboidClipboard clipboard = new CuboidClipboard(bvmax.subtract(bvmin).add(new Vector(1, 1, 1)), origin);
        clipboard.setOrigin(origin);
        clipboard.copy(editSession);
        File dir = new File(this.plugin.getDataLocation(), "Schematics");
        if (!dir.exists()) {
            try {
                dir.mkdir();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (!(dir = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + res.getWorld())).exists()) {
            try {
                dir.mkdir();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        File file = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + res.getWorld() + File.separator + res.getName() + ".schematic");
        try {
            SchematicFormat.MCEDIT.save(clipboard, file);
        }
        catch (Exception e) {
            if (this.plugin.getWorldGuardVersion() >= 7) {
                editSession.flushSession();
            } else {
                editSession.getClass().getMethod("flushQueue", new Class[0]).invoke((Object)editSession, new Object[0]);
            }
            return false;
        }
        try {
            if (this.plugin.getWorldGuardVersion() >= 7) {
                editSession.flushSession();
            } else {
                editSession.getClass().getMethod("flushQueue", new Class[0]).invoke((Object)editSession, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean load(ClaimedResidence res) {
        CuboidClipboard cc;
        EditSession es;
        block18: {
            ClaimedResidence r2;
            ClaimedResidence r1;
            block17: {
                World bworld;
                block16: {
                    File file;
                    block15: {
                        if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1)) {
                            return false;
                        }
                        if (this.plugin.getWorldEdit() == null) {
                            return false;
                        }
                        if (res == null) {
                            return false;
                        }
                        bworld = Bukkit.getWorld((String)res.getWorld());
                        if (bworld == null) {
                            return false;
                        }
                        es = (EditSession)EditSession.class.getConstructor(BukkitWorld.class, Integer.class).newInstance(new BukkitWorld(bworld), Integer.MAX_VALUE);
                        file = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + res.getWorld() + File.separator + res.getName() + ".schematic");
                        if (file.exists()) break block15;
                        return false;
                    }
                    cc = null;
                    try {
                        cc = CuboidClipboard.loadSchematic((File)file);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        return false;
                    }
                    if (cc != null) break block16;
                    return false;
                }
                Vector or = cc.getOrigin();
                r1 = this.plugin.getResidenceManager().getByLoc(new Location(bworld, (double)or.getBlockX(), (double)or.getBlockY(), (double)or.getBlockZ()));
                r2 = this.plugin.getResidenceManager().getByLoc(new Location(bworld, (double)(or.getBlockX() + cc.getWidth() - 1), (double)(or.getBlockY() + cc.getHeight() - 1), (double)(or.getBlockZ() + cc.getLength() - 1)));
                if (r1 != null && r2 != null) break block17;
                return false;
            }
            if (r1.getName().equalsIgnoreCase(r2.getName())) break block18;
            return false;
        }
        try {
            try {
                cc.paste(es, cc.getOrigin(), false);
            }
            catch (MaxChangedBlocksException e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean delete(ClaimedResidence res) {
        if (this.plugin.getWorldEdit() == null) {
            return false;
        }
        if (res == null) {
            return false;
        }
        File file = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + res.getWorld() + File.separator + res.getName() + ".schematic");
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }

    @Override
    public boolean rename(ClaimedResidence res, String newName) {
        if (this.plugin.getWorldEdit() == null) {
            return false;
        }
        if (res == null) {
            return false;
        }
        File oldFile = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + res.getWorld() + File.separator + res.getName() + ".schematic");
        if (!oldFile.exists()) {
            return false;
        }
        File newFile = new File(this.plugin.getDataLocation(), "Schematics" + File.separator + res.getWorld() + File.separator + newName + ".schematic");
        return oldFile.renameTo(newFile);
    }
}

