/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.MinimizeFlags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class FlagPermissions {
    protected static ArrayList<String> validFlags = new ArrayList();
    protected static ArrayList<String> validPlayerFlags = new ArrayList();
    protected static ArrayList<String> validAreaFlags = new ArrayList();
    static final Map<Material, Flags> matUseFlagList = new EnumMap<Material, Flags>(Material.class);
    protected Map<UUID, String> cachedPlayerNameUUIDs = new HashMap<UUID, String>();
    protected Map<String, Map<String, Boolean>> playerFlags = new HashMap<String, Map<String, Boolean>>();
    protected Map<String, Map<String, Boolean>> groupFlags = new HashMap<String, Map<String, Boolean>>();
    protected Map<String, Boolean> cuboidFlags = Collections.synchronizedMap(new HashMap());
    protected FlagPermissions parent;
    protected static HashMap<String, ArrayList<String>> validFlagGroups = new HashMap();

    public FlagPermissions() {
        this.playerFlags = Collections.synchronizedMap(new HashMap());
        this.groupFlags = Collections.synchronizedMap(new HashMap());
        this.cachedPlayerNameUUIDs = Collections.synchronizedMap(new HashMap());
    }

    public static void addMaterialToUseFlag(Material mat, Flags flag) {
        if (mat == null) {
            return;
        }
        matUseFlagList.put(mat, flag);
    }

    public static void removeMaterialFromUseFlag(Material mat) {
        if (mat == null) {
            return;
        }
        matUseFlagList.remove(mat);
    }

    public static EnumMap<Material, Flags> getMaterialUseFlagList() {
        return (EnumMap)matUseFlagList;
    }

    public static void addFlag(Flags flag) {
        FlagPermissions.addFlag(flag.name());
    }

    public static void addFlag(String flag) {
        Flags f;
        if (!validFlags.contains(flag = flag.toLowerCase())) {
            validFlags.add(flag);
        }
        if (validFlagGroups.containsKey(flag)) {
            validFlagGroups.remove(flag);
        }
        if ((f = Flags.getFlag(flag)) == null) {
            Residence.getInstance().getPermissionManager().getAllFlags().setFlag(flag, FlagState.TRUE);
        }
    }

    public static void addPlayerOrGroupOnlyFlag(Flags flag) {
        FlagPermissions.addPlayerOrGroupOnlyFlag(flag.name());
    }

    public static void addPlayerOrGroupOnlyFlag(String flag) {
        Flags f;
        if (!validPlayerFlags.contains(flag = flag.toLowerCase())) {
            validPlayerFlags.add(flag);
        }
        if (validFlagGroups.containsKey(flag)) {
            validFlagGroups.remove(flag);
        }
        if ((f = Flags.getFlag(flag)) == null) {
            Residence.getInstance().getPermissionManager().getAllFlags().setFlag(flag, FlagState.TRUE);
        }
    }

    public static void addResidenceOnlyFlag(Flags flag) {
        FlagPermissions.addResidenceOnlyFlag(flag.name());
    }

    public static void addResidenceOnlyFlag(String flag) {
        Flags f;
        if (!validAreaFlags.contains(flag = flag.toLowerCase())) {
            validAreaFlags.add(flag);
        }
        if (validFlagGroups.containsKey(flag)) {
            validFlagGroups.remove(flag);
        }
        if ((f = Flags.getFlag(flag)) == null) {
            Residence.getInstance().getPermissionManager().getAllFlags().setFlag(flag, FlagState.TRUE);
        }
    }

    public static void addFlagToFlagGroup(String group, String flag) {
        if (!(validFlags.contains(group) || validAreaFlags.contains(group) || validPlayerFlags.contains(group))) {
            if (!validFlagGroups.containsKey(group)) {
                validFlagGroups.put(group, new ArrayList());
            }
            ArrayList<String> flags2 = validFlagGroups.get(group);
            flags2.add(flag);
        }
    }

    public static void removeFlagFromFlagGroup(String group, String flag) {
        if (validFlagGroups.containsKey(group)) {
            ArrayList<String> flags2 = validFlagGroups.get(group);
            flags2.remove(flag);
            if (flags2.isEmpty()) {
                validFlagGroups.remove(group);
            }
        }
    }

    public static boolean flagGroupExists(String group) {
        return validFlagGroups.containsKey(group);
    }

    public static void initValidFlags() {
        validAreaFlags.clear();
        validPlayerFlags.clear();
        validFlags.clear();
        validFlagGroups.clear();
        Enum[] enumArray = Flags.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Flags flag = enumArray[n2];
            switch (flag.getFlagMode()) {
                case Both: {
                    FlagPermissions.addFlag(flag);
                    break;
                }
                case Player: {
                    FlagPermissions.addPlayerOrGroupOnlyFlag(flag);
                    break;
                }
                case Residence: {
                    FlagPermissions.addResidenceOnlyFlag(flag);
                    break;
                }
            }
            ++n2;
        }
        Residence.getInstance().getConfigManager().UpdateGroupedFlagsFile();
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.REPEATER.getMaterial(), Flags.diode);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.COMPARATOR.getMaterial(), Flags.diode);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.CRAFTING_TABLE.getMaterial(), Flags.table);
        enumArray = CMIMaterial.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum one = enumArray[n2];
            if (((CMIMaterial)one).getMaterial() != null) {
                if (((CMIMaterial)one).isDoor()) {
                    matUseFlagList.put(((CMIMaterial)one).getMaterial(), Flags.door);
                }
                if (((CMIMaterial)one).isGate()) {
                    matUseFlagList.put(((CMIMaterial)one).getMaterial(), Flags.door);
                }
                if (((CMIMaterial)one).isTrapDoor()) {
                    matUseFlagList.put(((CMIMaterial)one).getMaterial(), Flags.door);
                }
                if (((CMIMaterial)one).isShulkerBox()) {
                    matUseFlagList.put(((CMIMaterial)one).getMaterial(), Flags.container);
                }
                if (((CMIMaterial)one).isButton()) {
                    matUseFlagList.put(((CMIMaterial)one).getMaterial(), Flags.button);
                }
                if (((CMIMaterial)one).isBed()) {
                    matUseFlagList.put(((CMIMaterial)one).getMaterial(), Flags.bed);
                }
                if (((CMIMaterial)one).isPotted()) {
                    matUseFlagList.put(((CMIMaterial)one).getMaterial(), Flags.flowerpot);
                }
            }
            ++n2;
        }
        if (CMIMaterial.DAYLIGHT_DETECTOR.getMaterial() != null) {
            matUseFlagList.put(CMIMaterial.DAYLIGHT_DETECTOR.getMaterial(), Flags.diode);
        }
        if (CMIMaterial.ENCHANTING_TABLE.getMaterial() != null) {
            FlagPermissions.addMaterialToUseFlag(CMIMaterial.ENCHANTING_TABLE.getMaterial(), Flags.enchant);
        }
        FlagPermissions.addMaterialToUseFlag(Material.LEVER, Flags.lever);
        FlagPermissions.addMaterialToUseFlag(Material.BREWING_STAND, Flags.brew);
        FlagPermissions.addMaterialToUseFlag(Material.CAKE, Flags.cake);
        FlagPermissions.addMaterialToUseFlag(Material.NOTE_BLOCK, Flags.note);
        FlagPermissions.addMaterialToUseFlag(Material.DRAGON_EGG, Flags.egg);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.COMMAND_BLOCK.getMaterial(), Flags.commandblock);
        FlagPermissions.addMaterialToUseFlag(Material.ANVIL, Flags.anvil);
        FlagPermissions.addMaterialToUseFlag(Material.FLOWER_POT, Flags.flowerpot);
        FlagPermissions.addMaterialToUseFlag(Material.BEACON, Flags.beacon);
        FlagPermissions.addMaterialToUseFlag(Material.JUKEBOX, Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.CHEST, Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.TRAPPED_CHEST, Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.HOPPER, Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.DROPPER, Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.FURNACE, Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.LEGACY_BURNING_FURNACE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.BARREL.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.BLAST_FURNACE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.CARTOGRAPHY_TABLE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.FLETCHING_TABLE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.GRINDSTONE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.LECTERN.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.LOOM.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.SMITHING_TABLE.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.SMOKER.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.COMPOSTER.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.STONECUTTER.getMaterial(), Flags.container);
        FlagPermissions.addMaterialToUseFlag(Material.DISPENSER, Flags.container);
        FlagPermissions.addMaterialToUseFlag(CMIMaterial.CAKE.getMaterial(), Flags.cake);
    }

    public static FlagPermissions parseFromConfigNode(String name, ConfigurationSection node) {
        FlagPermissions list2 = new FlagPermissions();
        if (!node.isConfigurationSection(name)) {
            return list2;
        }
        Set keys = node.getConfigurationSection(name).getKeys(false);
        if (keys == null) {
            return list2;
        }
        for (String key : keys) {
            boolean state = node.getBoolean(String.valueOf(name) + "." + key, false);
            Flags f = Flags.getFlag(key = key.toLowerCase());
            if (f != null) {
                f.setEnabled(state);
            }
            if (state) {
                list2.setFlag(key, FlagState.TRUE);
                continue;
            }
            list2.setFlag(key, FlagState.FALSE);
        }
        return list2;
    }

    public static FlagPermissions parseFromConfigNodeAsList(String node, String stage) {
        FlagPermissions list2 = new FlagPermissions();
        if (node.equalsIgnoreCase("true")) {
            list2.setFlag(node, FlagState.valueOf(stage));
        } else {
            list2.setFlag(node, FlagState.FALSE);
        }
        return list2;
    }

    protected Map<String, Boolean> getPlayerFlags(Player player, boolean allowCreate) {
        if (player == null) {
            return new HashMap<String, Boolean>();
        }
        UUID uuid = player.getUniqueId();
        Map<String, Boolean> flags2 = this.playerFlags.get(uuid.toString());
        if (flags2 == null && (flags2 = this.playerFlags.get(player.getName())) != null) {
            flags2 = this.playerFlags.remove(player.getName());
            this.playerFlags.put(uuid.toString(), flags2);
        }
        if (flags2 == null && allowCreate) {
            flags2 = Collections.synchronizedMap(new HashMap());
            this.playerFlags.put(uuid.toString(), flags2);
        }
        return flags2;
    }

    protected Map<String, Boolean> getPlayerFlags(String player, boolean allowCreate) {
        Map<Object, Object> flags2 = null;
        if (!Residence.getInstance().getConfigManager().isOfflineMode()) {
            UUID uuid = null;
            if (player.length() == 36) {
                try {
                    uuid = UUID.fromString(player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String resolvedName = Residence.getInstance().getPlayerName(uuid);
                if (resolvedName != null) {
                    player = resolvedName;
                } else if (this.cachedPlayerNameUUIDs.containsKey(uuid)) {
                    player = this.cachedPlayerNameUUIDs.get(uuid);
                }
            } else {
                uuid = Residence.getInstance().getPlayerUUID(player);
            }
            if (uuid == null) {
                Set<Map.Entry<UUID, String>> values = this.cachedPlayerNameUUIDs.entrySet();
                for (Map.Entry<UUID, String> value : values) {
                    if (!value.getValue().equals(player)) continue;
                    uuid = value.getKey();
                    break;
                }
            }
            if (uuid != null) {
                flags2 = this.playerFlags.get(uuid.toString());
            }
            if (flags2 == null) {
                flags2 = this.playerFlags.get(player);
                if (uuid != null && flags2 != null) {
                    flags2 = this.playerFlags.remove(player);
                    this.playerFlags.put(uuid.toString(), flags2);
                    this.cachedPlayerNameUUIDs.put(uuid, player);
                }
            } else {
                this.cachedPlayerNameUUIDs.put(uuid, player);
            }
            if (flags2 == null && allowCreate) {
                if (uuid != null) {
                    flags2 = Collections.synchronizedMap(new HashMap());
                    this.playerFlags.put(uuid.toString(), flags2);
                    this.cachedPlayerNameUUIDs.put(uuid, player);
                } else {
                    flags2 = Collections.synchronizedMap(new HashMap());
                    this.playerFlags.put(player, flags2);
                }
            }
        } else {
            for (Map.Entry<String, Map<String, Boolean>> one : this.playerFlags.entrySet()) {
                if (!one.getKey().equalsIgnoreCase(player)) continue;
                if (!one.getKey().equals(player)) {
                    Map<String, Boolean> r = this.playerFlags.remove(one.getKey());
                    this.playerFlags.put(player, r);
                }
                flags2 = one.getValue();
                break;
            }
            if (flags2 == null && allowCreate) {
                flags2 = Collections.synchronizedMap(new HashMap());
                this.playerFlags.put(player, flags2);
            }
        }
        return flags2;
    }

    public boolean setPlayerFlag(String player, String flag, FlagState state) {
        Map<String, Boolean> map = this.getPlayerFlags(player, state != FlagState.NEITHER);
        if (map == null) {
            return true;
        }
        if (state == FlagState.FALSE) {
            map.put(flag, false);
        } else if (state == FlagState.TRUE) {
            map.put(flag, true);
        } else if (state == FlagState.NEITHER && map.containsKey(flag)) {
            map.remove(flag);
        }
        if (map.isEmpty()) {
            this.removeAllPlayerFlags(player);
        }
        return true;
    }

    public void removeAllPlayerFlags(String player) {
        if (!Residence.getInstance().getConfigManager().isOfflineMode()) {
            UUID uuid = Residence.getInstance().getPlayerUUID(player);
            if (uuid == null) {
                for (Map.Entry<UUID, String> entry : this.cachedPlayerNameUUIDs.entrySet()) {
                    if (!entry.getValue().equals(player)) continue;
                    uuid = entry.getKey();
                    break;
                }
            }
            if (uuid != null) {
                this.playerFlags.remove(uuid.toString());
                this.cachedPlayerNameUUIDs.remove(uuid);
            }
            return;
        }
        this.playerFlags.remove(player);
    }

    public void removeAllGroupFlags(String group) {
        this.groupFlags.remove(group);
    }

    public boolean setGroupFlag(String group, String flag, FlagState state) {
        if (!this.groupFlags.containsKey(group = group.toLowerCase())) {
            this.groupFlags.put(group, Collections.synchronizedMap(new HashMap()));
        }
        Map<String, Boolean> map = this.groupFlags.get(group);
        if (state == FlagState.FALSE) {
            map.put(flag, false);
        } else if (state == FlagState.TRUE) {
            map.put(flag, true);
        } else if (state == FlagState.NEITHER && map.containsKey(flag)) {
            map.remove(flag);
        }
        if (map.isEmpty()) {
            this.groupFlags.remove(group);
        }
        return true;
    }

    public boolean setFlag(String flag, FlagState state) {
        if (state == FlagState.FALSE) {
            this.cuboidFlags.put(flag, false);
        } else if (state == FlagState.TRUE) {
            this.cuboidFlags.put(flag, true);
        } else if (state == FlagState.NEITHER && this.cuboidFlags.containsKey(flag)) {
            this.cuboidFlags.remove(flag);
        }
        return true;
    }

    public static FlagState stringToFlagState(String flagstate) {
        if (flagstate.equalsIgnoreCase("true") || flagstate.equalsIgnoreCase("t")) {
            return FlagState.TRUE;
        }
        if (flagstate.equalsIgnoreCase("false") || flagstate.equalsIgnoreCase("f")) {
            return FlagState.FALSE;
        }
        if (flagstate.equalsIgnoreCase("remove") || flagstate.equalsIgnoreCase("r")) {
            return FlagState.NEITHER;
        }
        return FlagState.INVALID;
    }

    public boolean playerHas(ResidencePlayer resPlayer, Flags flag, boolean def) {
        if (resPlayer == null) {
            return false;
        }
        return this.playerCheck(resPlayer.getPlayer(), flag.toString(), this.groupCheck(resPlayer.getGroup(), flag.toString(), this.has(flag, def)));
    }

    public boolean playerHas(Player player, Flags flag, boolean def) {
        if (player == null) {
            return false;
        }
        ResidencePlayer resPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = resPlayer.getGroup();
        return this.playerCheck(player, flag.toString(), this.groupCheck(group, flag.toString(), this.has(flag, def)));
    }

    public boolean playerHas(Player player, String world, Flags flag, boolean def) {
        if (player == null) {
            return false;
        }
        ResidencePlayer resPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = resPlayer.getGroup(world);
        return this.playerCheck(player, flag.toString(), this.groupCheck(group, flag.toString(), this.has(flag, def)));
    }

    @Deprecated
    public boolean playerHas(String player, String world, String flag, boolean def) {
        ResidencePlayer resPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = resPlayer.getGroup(world);
        return this.playerCheck(player, flag, this.groupCheck(group, flag, this.has(flag, def)));
    }

    public boolean groupHas(String group, String flag, boolean def) {
        return this.groupCheck(group, flag, this.has(flag, def));
    }

    private boolean playerCheck(Player player, String flag, boolean def) {
        Map<String, Boolean> pmap = this.getPlayerFlags(player, false);
        if (pmap != null && pmap.containsKey(flag)) {
            return pmap.get(flag);
        }
        if (this.parent != null) {
            return this.parent.playerCheck(player, flag, def);
        }
        return def;
    }

    @Deprecated
    private boolean playerCheck(String player, String flag, boolean def) {
        Map<String, Boolean> pmap = this.getPlayerFlags(player, false);
        if (pmap != null && pmap.containsKey(flag)) {
            return pmap.get(flag);
        }
        if (this.parent != null) {
            return this.parent.playerCheck(player, flag, def);
        }
        return def;
    }

    private boolean groupCheck(PermissionGroup group, String flag, boolean def) {
        if (group == null) {
            return def;
        }
        return this.groupCheck(group.getGroupName(), flag, def);
    }

    private boolean groupCheck(String group, String flag, boolean def) {
        Map<String, Boolean> gmap;
        if (this.groupFlags.containsKey(group) && (gmap = this.groupFlags.get(group)).containsKey(flag)) {
            return gmap.get(flag);
        }
        if (this.parent != null) {
            return this.parent.groupCheck(group, flag, def);
        }
        return def;
    }

    public boolean has(Flags flag, FlagCombo f) {
        switch (f) {
            case FalseOrNone: {
                return !this.has(flag, false);
            }
            case OnlyFalse: {
                return !this.has(flag, true);
            }
            case OnlyTrue: {
                return this.has(flag, false);
            }
            case TrueOrNone: {
                return this.has(flag, true);
            }
        }
        return false;
    }

    public boolean has(Flags flag, boolean def) {
        return this.has(flag, def, true);
    }

    public boolean has(Flags flag, boolean def, boolean checkParent) {
        if (this.cuboidFlags.containsKey(flag.toString())) {
            return this.cuboidFlags.get(flag.toString());
        }
        if (checkParent && this.parent != null) {
            return this.parent.has(flag, def);
        }
        return def;
    }

    @Deprecated
    public boolean has(String flag, boolean def) {
        return this.has(flag, def, true);
    }

    @Deprecated
    public boolean has(String flag, boolean def, boolean checkParent) {
        if (this.cuboidFlags.containsKey(flag)) {
            return this.cuboidFlags.get(flag);
        }
        if (checkParent && this.parent != null) {
            return this.parent.has(flag, def);
        }
        return def;
    }

    public boolean isPlayerSet(String player, String flag) {
        Map<String, Boolean> flags2 = this.getPlayerFlags(player, false);
        if (flags2 == null) {
            return false;
        }
        return flags2.containsKey(flag);
    }

    public boolean inheritanceIsPlayerSet(String player, String flag) {
        Map<String, Boolean> flags2 = this.getPlayerFlags(player, false);
        if (flags2 == null) {
            return this.parent == null ? false : this.parent.inheritanceIsPlayerSet(player, flag);
        }
        return flags2.containsKey(flag) ? true : (this.parent == null ? false : this.parent.inheritanceIsPlayerSet(player, flag));
    }

    public boolean isGroupSet(String group, String flag) {
        Map<String, Boolean> flags2 = this.groupFlags.get(group = group.toLowerCase());
        if (flags2 == null) {
            return false;
        }
        return flags2.containsKey(flag);
    }

    public boolean inheritanceIsGroupSet(String group, String flag) {
        Map<String, Boolean> flags2 = this.groupFlags.get(group = group.toLowerCase());
        if (flags2 == null) {
            return this.parent == null ? false : this.parent.inheritanceIsGroupSet(group, flag);
        }
        return flags2.containsKey(flag) ? true : (this.parent == null ? false : this.parent.inheritanceIsGroupSet(group, flag));
    }

    public boolean isSet(String flag) {
        return this.cuboidFlags.containsKey(flag);
    }

    public boolean inheritanceIsSet(String flag) {
        return this.cuboidFlags.containsKey(flag) ? true : (this.parent == null ? false : this.parent.inheritanceIsSet(flag));
    }

    public boolean checkValidFlag(String flag, boolean globalflag) {
        if (validFlags.contains(flag)) {
            return true;
        }
        return globalflag ? validAreaFlags.contains(flag) : validPlayerFlags.contains(flag);
    }

    public Map<String, Object> save(String world) {
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        if (Residence.getInstance().getConfigManager().isNewSaveMechanic()) {
            MinimizeFlags min;
            HashMap<String, Integer> playerFlagsClone = new HashMap<String, Integer>();
            for (Map.Entry<String, Map<String, Boolean>> one : this.playerFlags.entrySet()) {
                MinimizeFlags min2 = Residence.getInstance().getResidenceManager().addFlagsTempCache(world, one.getValue());
                playerFlagsClone.put(one.getKey(), min2.getId());
            }
            root.put("PlayerFlags", playerFlagsClone);
            if (!this.groupFlags.isEmpty()) {
                HashMap<String, Integer> GroupFlagsClone = new HashMap<String, Integer>();
                for (Map.Entry<String, Map<String, Boolean>> one : this.groupFlags.entrySet()) {
                    MinimizeFlags min3 = Residence.getInstance().getResidenceManager().addFlagsTempCache(world, one.getValue());
                    GroupFlagsClone.put(one.getKey(), min3.getId());
                }
                root.put("GroupFlags", GroupFlagsClone);
            }
            if ((min = Residence.getInstance().getResidenceManager().addFlagsTempCache(world, this.cuboidFlags)) == null) {
                root.put("AreaFlags", new HashMap<String, Boolean>(this.cuboidFlags));
            } else {
                root.put("AreaFlags", min.getId());
            }
        } else {
            root.put("PlayerFlags", FlagPermissions.clone(this.playerFlags));
            if (!this.groupFlags.isEmpty()) {
                root.put("GroupFlags", FlagPermissions.clone(this.groupFlags));
            }
            root.put("AreaFlags", new HashMap<String, Boolean>(this.cuboidFlags));
        }
        return root;
    }

    private static HashMap<String, Map<String, Boolean>> clone(Map<String, Map<String, Boolean>> map) {
        HashMap<String, Map<String, Boolean>> nm = new HashMap<String, Map<String, Boolean>>();
        for (Map.Entry<String, Map<String, Boolean>> one : map.entrySet()) {
            nm.put(one.getKey(), new HashMap<String, Boolean>(one.getValue()));
        }
        return nm;
    }

    public static FlagPermissions load(Map<String, Object> root) throws Exception {
        FlagPermissions newperms = new FlagPermissions();
        return FlagPermissions.load(root, newperms);
    }

    protected static FlagPermissions load(Map<String, Object> root, FlagPermissions newperms) throws Exception {
        Iterator uuid2;
        Map<Object, Object> ft;
        HashMap<String, Map<String, Boolean>> t;
        Map.Entry one;
        if (root.containsKey("LastKnownPlayerNames")) {
            newperms.cachedPlayerNameUUIDs = (Map)root.get("LastKnownPlayerNames");
        }
        if (root.containsKey("PlayerFlags")) {
            boolean old = true;
            Iterator iterator = ((HashMap)root.get("PlayerFlags")).entrySet().iterator();
            if (iterator.hasNext() && (one = iterator.next()).getValue() instanceof Integer) {
                old = false;
            }
            if (old) {
                newperms.playerFlags = (Map)root.get("PlayerFlags");
            } else if (newperms instanceof ResidencePermissions) {
                t = new HashMap();
                ft = new HashMap();
                for (Map.Entry one2 : ((HashMap)root.get("PlayerFlags")).entrySet()) {
                    ft = Residence.getInstance().getResidenceManager().getChacheFlags(((ResidencePermissions)newperms).getWorld(), (Integer)one2.getValue());
                    if (ft == null || ft.isEmpty()) continue;
                    t.put((String)one2.getKey(), new HashMap<Object, Object>(ft));
                }
                if (!t.isEmpty()) {
                    newperms.playerFlags = t;
                }
            }
        }
        for (Map.Entry<String, Map<String, Boolean>> one3 : newperms.playerFlags.entrySet()) {
            if (one3.getKey().length() != 32) continue;
            try {
                uuid2 = UUID.fromString(one3.getKey());
                OfflinePlayer player = Residence.getInstance().getOfflinePlayer((UUID)((Object)uuid2));
                newperms.cachedPlayerNameUUIDs.put((UUID)((Object)uuid2), player.getName());
            }
            catch (Exception uuid2) {
                // empty catch block
            }
        }
        if (root.containsKey("GroupFlags")) {
            boolean old = true;
            uuid2 = ((HashMap)root.get("GroupFlags")).entrySet().iterator();
            if (uuid2.hasNext() && (one = (Map.Entry)uuid2.next()).getValue() instanceof Integer) {
                old = false;
            }
            if (old) {
                newperms.groupFlags = (Map)root.get("GroupFlags");
            } else if (newperms instanceof ResidencePermissions) {
                t = new HashMap<String, Map<String, Boolean>>();
                ft = new HashMap();
                for (Map.Entry one2 : ((HashMap)root.get("GroupFlags")).entrySet()) {
                    ft = Residence.getInstance().getResidenceManager().getChacheFlags(((ResidencePermissions)newperms).getWorld(), (Integer)one2.getValue());
                    if (ft == null || ft.isEmpty()) continue;
                    t.put((String)one2.getKey(), new HashMap<Object, Object>(ft));
                }
                if (!t.isEmpty()) {
                    newperms.groupFlags = t;
                }
            }
        }
        if (root.containsKey("AreaFlags")) {
            boolean old = true;
            if (root.get("AreaFlags") instanceof Integer) {
                old = false;
            }
            if (old) {
                newperms.cuboidFlags = (Map)root.get("AreaFlags");
            } else if (newperms instanceof ResidencePermissions) {
                Map<Object, Object> ft2 = new HashMap();
                ft2 = Residence.getInstance().getResidenceManager().getChacheFlags(((ResidencePermissions)newperms).getWorld(), (Integer)root.get("AreaFlags"));
                if (ft2 != null && !ft2.isEmpty()) {
                    newperms.cuboidFlags = new HashMap<Object, Object>(ft2);
                }
            }
        } else {
            newperms.cuboidFlags = Residence.getInstance().getConfigManager().getGlobalResidenceDefaultFlags().getFlags();
        }
        String ownerName = null;
        String uuid3 = null;
        if (root.containsKey("OwnerLastKnownName")) {
            ownerName = (String)root.get("OwnerLastKnownName");
            uuid3 = root.containsKey("OwnerUUID") ? (String)root.get("OwnerUUID") : Residence.getInstance().getTempUserUUID();
        }
        if (Residence.getInstance().getConfigManager().isOfflineMode()) {
            newperms.convertFlagsUUIDsToPlayerNames();
        } else {
            newperms.convertPlayerNamesToUUIDs(ownerName, uuid3);
        }
        return newperms;
    }

    private void convertFlagsUUIDsToPlayerNames() {
        HashMap<String, String> converts = new HashMap<String, String>();
        for (String string : this.playerFlags.keySet()) {
            if (string.length() != 36) continue;
            String uuid = string;
            if (uuid.equalsIgnoreCase(Residence.getInstance().getServerLandUUID())) {
                converts.put(uuid, Residence.getInstance().getServerLandName());
                continue;
            }
            String name = Residence.getInstance().getPlayerName(uuid);
            if (name == null) continue;
            converts.put(uuid, name);
        }
        for (Map.Entry entry : converts.entrySet()) {
            if (!this.playerFlags.containsKey(entry.getKey())) continue;
            Map<String, Boolean> replace = this.playerFlags.get(entry.getKey());
            this.playerFlags.remove(entry.getKey());
            this.playerFlags.put((String)entry.getValue(), replace);
        }
    }

    private void convertPlayerNamesToUUIDs(String OwnerName, String owneruuid) {
        Object uuid;
        HashMap<String, String> converts = new HashMap<String, String>();
        ArrayList<String> Toremove = new ArrayList<String>();
        for (String string : this.playerFlags.keySet()) {
            if (string.length() != 36) {
                uuid = null;
                uuid = OwnerName != null && OwnerName.equals(string) && !owneruuid.equals(Residence.getInstance().getTempUserUUID()) ? owneruuid : Residence.getInstance().getPlayerUUIDString(string);
                if (uuid != null) {
                    converts.put(string, (String)uuid);
                    continue;
                }
                if (OwnerName == null || OwnerName.equals(string)) continue;
                Toremove.add(string);
                continue;
            }
            String pname = Residence.getInstance().getPlayerName(string);
            if (pname == null) continue;
            try {
                UUID uuid2 = UUID.fromString(string);
                this.cachedPlayerNameUUIDs.put(uuid2, pname);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (String string : Toremove) {
            this.playerFlags.remove(string);
        }
        for (Map.Entry entry : converts.entrySet()) {
            this.playerFlags.put((String)entry.getValue(), this.playerFlags.remove(entry.getKey()));
            try {
                uuid = UUID.fromString((String)entry.getValue());
                this.cachedPlayerNameUUIDs.put((UUID)uuid, (String)entry.getKey());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String listFlags() {
        return this.listFlags(0, 0);
    }

    public String listFlags(Integer split) {
        return this.listFlags(split, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listFlags(Integer split, Integer totalShow) {
        Set<Map.Entry<String, Boolean>> set2;
        StringBuilder sbuild = new StringBuilder();
        Set<Map.Entry<String, Boolean>> set3 = set2 = this.cuboidFlags.entrySet();
        synchronized (set3) {
            Iterator<Map.Entry<String, Boolean>> it = set2.iterator();
            int i = -1;
            int t = 0;
            String haveColor = Residence.getInstance().getLM().getMessage(lm.Flag_haveColor, new Object[0]);
            String denyColor = Residence.getInstance().getLM().getMessage(lm.Flag_denyColor, new Object[0]);
            String havePrefix = Residence.getInstance().getLM().getMessage(lm.Flag_havePrefix, new Object[0]);
            String denyPrefix = Residence.getInstance().getLM().getMessage(lm.Flag_denyPrefix, new Object[0]);
            while (it.hasNext()) {
                Map.Entry<String, Boolean> next = it.next();
                String fname = next.getKey();
                Flags flag = Flags.getFlag(fname);
                if (flag != null && !flag.isGlobalyEnabled()) continue;
                if (flag != null) {
                    fname = flag.getName();
                }
                ++i;
                if (totalShow > 0 && ++t > totalShow) break;
                if (split > 0 && i >= split) {
                    i = 0;
                    sbuild.append("\n");
                }
                if (next.getValue().booleanValue()) {
                    sbuild.append(haveColor).append(havePrefix).append(fname);
                    if (!it.hasNext()) continue;
                    sbuild.append(" ");
                    continue;
                }
                sbuild.append(denyColor).append(denyPrefix).append(fname);
                if (!it.hasNext()) continue;
                sbuild.append(" ");
            }
        }
        if (sbuild.length() == 0) {
            sbuild.append("none");
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)sbuild.toString());
    }

    public Map<String, Boolean> getFlags() {
        return this.cuboidFlags;
    }

    public Map<String, Boolean> getPlayerFlags(String player) {
        return this.getPlayerFlags(player, false);
    }

    @Deprecated
    public Set<String> getposibleFlags() {
        return FlagPermissions.getAllPosibleFlags();
    }

    public static Set<String> getAllPosibleFlags() {
        HashSet<String> t = new HashSet<String>();
        t.addAll(validFlags);
        t.addAll(validPlayerFlags);
        return t;
    }

    public static ArrayList<String> getPosibleAreaFlags() {
        return validAreaFlags;
    }

    public List<String> getPosibleFlags(Player player, boolean residence, boolean resadmin2) {
        HashSet<String> flags2 = new HashSet<String>();
        for (Map.Entry<String, Boolean> one : Residence.getInstance().getPermissionManager().getAllFlags().getFlags().entrySet()) {
            String fname;
            Flags flag;
            if (!one.getValue().booleanValue() && !resadmin2 && !PermissionManager.ResPerm.flag_$1.hasSetPermission((CommandSender)player, one.getKey().toLowerCase()) || !residence && !FlagPermissions.getAllPosibleFlags().contains(one.getKey()) || (flag = Flags.getFlag(fname = one.getKey())) != null && !flag.isGlobalyEnabled()) continue;
            flags2.add(one.getKey());
        }
        return new ArrayList<String>(flags2);
    }

    public String listPlayerFlags(String player) {
        Map<String, Boolean> flags2 = this.getPlayerFlags(player, false);
        if (flags2 != null) {
            return this.printPlayerFlags(flags2);
        }
        return "none";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String printPlayerFlags(Map<String, Boolean> flags2) {
        StringBuilder sbuild = new StringBuilder();
        if (flags2 == null) {
            return "none";
        }
        Set<Map.Entry<String, Boolean>> set2 = flags2.entrySet();
        String haveColor = Residence.getInstance().getLM().getMessage(lm.Flag_haveColor, new Object[0]);
        String denyColor = Residence.getInstance().getLM().getMessage(lm.Flag_denyColor, new Object[0]);
        String havePrefix = Residence.getInstance().getLM().getMessage(lm.Flag_havePrefix, new Object[0]);
        String denyPrefix = Residence.getInstance().getLM().getMessage(lm.Flag_denyPrefix, new Object[0]);
        Map<String, Boolean> map = flags2;
        synchronized (map) {
            Iterator<Map.Entry<String, Boolean>> it = set2.iterator();
            while (it.hasNext()) {
                Map.Entry<String, Boolean> next = it.next();
                String fname = next.getKey();
                Flags flag = Flags.getFlag(next.getKey());
                if (flag != null && !flag.isGlobalyEnabled()) continue;
                if (flag != null) {
                    fname = flag.getName();
                }
                if (next.getValue().booleanValue()) {
                    sbuild.append(haveColor).append(havePrefix).append(fname);
                    if (!it.hasNext()) continue;
                    sbuild.append(" ");
                    continue;
                }
                sbuild.append(denyColor).append(denyPrefix).append(fname);
                if (!it.hasNext()) continue;
                sbuild.append(" ");
            }
        }
        if (sbuild.length() == 0) {
            sbuild.append("none");
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)sbuild.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listOtherPlayersFlags(String player) {
        Set<Map.Entry<String, Map<String, Boolean>>> set2;
        String uuids = Residence.getInstance().getPlayerUUIDString(player);
        StringBuilder sbuild = new StringBuilder();
        Set<Map.Entry<String, Map<String, Boolean>>> set3 = set2 = this.playerFlags.entrySet();
        synchronized (set3) {
            for (Map.Entry<String, Map<String, Boolean>> nextEnt : set2) {
                String resolvedName;
                String next = nextEnt.getKey();
                if ((Residence.getInstance().getConfigManager().isOfflineMode() || next.equals(player) || next.equals(uuids)) && (!Residence.getInstance().getConfigManager().isOfflineMode() || next.equals(player))) continue;
                String perms = this.printPlayerFlags(nextEnt.getValue());
                if (next.length() == 36 && (resolvedName = Residence.getInstance().getPlayerName(next)) != null) {
                    try {
                        UUID uuid = UUID.fromString(next);
                        this.cachedPlayerNameUUIDs.put(uuid, resolvedName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    next = resolvedName;
                }
                if (perms.equals("none")) continue;
                sbuild.append(next).append(ChatColor.WHITE).append("[").append(perms).append(ChatColor.WHITE).append("] ");
            }
        }
        return sbuild.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listPlayersFlags() {
        Set<Map.Entry<String, Map<String, Boolean>>> set2;
        StringBuilder sbuild = new StringBuilder();
        Set<Map.Entry<String, Map<String, Boolean>>> set3 = set2 = this.playerFlags.entrySet();
        synchronized (set3) {
            for (Map.Entry<String, Map<String, Boolean>> nextEnt : set2) {
                String resolvedName;
                String next = nextEnt.getKey();
                String perms = this.printPlayerFlags(nextEnt.getValue());
                if (next.length() == 36 && (resolvedName = Residence.getInstance().getPlayerName(next)) != null) {
                    try {
                        UUID uuid = UUID.fromString(next);
                        this.cachedPlayerNameUUIDs.put(uuid, resolvedName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    next = resolvedName;
                }
                if (next.equalsIgnoreCase(Residence.getInstance().getServerLandName()) || perms.equals("none")) continue;
                sbuild.append(next).append(ChatColor.WHITE).append("[").append(perms).append(ChatColor.WHITE).append("] ");
            }
        }
        return sbuild.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawMessage listPlayersFlagsRaw(String player, String text) {
        Set<Map.Entry<String, Map<String, Boolean>>> set2;
        RawMessage rm = new RawMessage();
        rm.add(text);
        Set<Map.Entry<String, Map<String, Boolean>>> set3 = set2 = this.playerFlags.entrySet();
        synchronized (set3) {
            Iterator<Map.Entry<String, Map<String, Boolean>>> it = set2.iterator();
            boolean random = true;
            String ownColor = Residence.getInstance().getLM().getMessage(lm.Flag_ownColor, new Object[0]);
            String p1Color = Residence.getInstance().getLM().getMessage(lm.Flag_p1Color, new Object[0]);
            String p2Color = Residence.getInstance().getLM().getMessage(lm.Flag_p2Color, new Object[0]);
            while (it.hasNext()) {
                String resolvedName;
                Map.Entry<String, Map<String, Boolean>> nextEnt = it.next();
                String next = nextEnt.getKey();
                String perms = this.printPlayerFlags(nextEnt.getValue());
                if (next.length() == 36 && (resolvedName = Residence.getInstance().getPlayerName(next)) != null) {
                    try {
                        UUID uuid = UUID.fromString(next);
                        this.cachedPlayerNameUUIDs.put(uuid, resolvedName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    next = resolvedName;
                }
                if (next.equalsIgnoreCase(Residence.getInstance().getServerLandName()) || perms.equals("none")) continue;
                if (random) {
                    random = false;
                    next = player.equals(next) ? String.valueOf(ownColor) + next + "&r" : String.valueOf(p2Color) + next + "&r";
                } else {
                    random = true;
                    next = player.equals(next) ? String.valueOf(ownColor) + next + "&r" : String.valueOf(p1Color) + next + "&r";
                }
                rm.add(next, this.splitBy(5, perms));
                rm.add(" ");
            }
        }
        return rm;
    }

    protected String splitBy(int by, String perms) {
        if (perms.contains(" ")) {
            String[] splited = perms.split(" ");
            int i = 0;
            perms = "";
            String[] stringArray = splited;
            int n = splited.length;
            int n2 = 0;
            while (n2 < n) {
                String one = stringArray[n2];
                perms = String.valueOf(perms) + one + " ";
                if (++i >= by) {
                    i = 0;
                    perms = String.valueOf(perms) + "\n";
                }
                ++n2;
            }
        }
        return perms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listGroupFlags() {
        Set<String> set2;
        StringBuilder sbuild = new StringBuilder();
        Set<String> set3 = set2 = this.groupFlags.keySet();
        synchronized (set3) {
            for (String next : set2) {
                String perms = this.listGroupFlags(next);
                if (perms.equals("none")) continue;
                sbuild.append(next).append("[").append(ChatColor.DARK_AQUA).append(perms).append(ChatColor.RED).append("] ");
            }
        }
        return sbuild.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listGroupFlags(String group) {
        if (this.groupFlags.containsKey(group = group.toLowerCase())) {
            StringBuilder sbuild = new StringBuilder();
            Map<String, Boolean> get = this.groupFlags.get(group);
            Set<Map.Entry<String, Boolean>> set2 = get.entrySet();
            String haveColor = Residence.getInstance().getLM().getMessage(lm.Flag_haveColor, new Object[0]);
            String denyColor = Residence.getInstance().getLM().getMessage(lm.Flag_denyColor, new Object[0]);
            String havePrefix = Residence.getInstance().getLM().getMessage(lm.Flag_havePrefix, new Object[0]);
            String denyPrefix = Residence.getInstance().getLM().getMessage(lm.Flag_denyPrefix, new Object[0]);
            Map<String, Boolean> map = get;
            synchronized (map) {
                Iterator<Map.Entry<String, Boolean>> it = set2.iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Boolean> next = it.next();
                    if (next.getValue().booleanValue()) {
                        sbuild.append(haveColor).append(havePrefix).append(next.getKey());
                        if (!it.hasNext()) continue;
                        sbuild.append(" ");
                        continue;
                    }
                    sbuild.append(denyColor).append(denyPrefix).append(next.getKey());
                    if (!it.hasNext()) continue;
                    sbuild.append(" ");
                }
            }
            if (sbuild.length() == 0) {
                this.groupFlags.remove(group);
                sbuild.append("none");
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)sbuild.toString());
        }
        return "none";
    }

    public void clearFlags() {
        this.groupFlags.clear();
        this.playerFlags.clear();
        this.cuboidFlags.clear();
    }

    public void printFlags(Player player) {
        Residence.getInstance().msg((CommandSender)player, lm.General_ResidenceFlags, this.listFlags());
        Residence.getInstance().msg((CommandSender)player, lm.General_PlayersFlags, this.listPlayerFlags(player.getName()));
        Residence.getInstance().msg((CommandSender)player, lm.General_GroupFlags, this.listGroupFlags());
        Residence.getInstance().msg((CommandSender)player, lm.General_OthersFlags, this.listOtherPlayersFlags(player.getName()));
    }

    public void copyUserPermissions(String fromUser, String toUser) {
        Map<String, Boolean> get = this.getPlayerFlags(fromUser, false);
        if (get != null) {
            Map<String, Boolean> targ = this.getPlayerFlags(toUser, true);
            for (Map.Entry<String, Boolean> entry : get.entrySet()) {
                targ.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Deprecated
    public void clearPlayersFlags(String user) {
        this.removeAllPlayerFlags(user);
    }

    public void setParent(FlagPermissions p) {
        this.parent = p;
    }

    public FlagPermissions getParent() {
        return this.parent;
    }

    public static enum FlagCombo {
        OnlyTrue,
        OnlyFalse,
        TrueOrNone,
        FalseOrNone;

    }

    public static enum FlagState {
        TRUE,
        FALSE,
        NEITHER,
        INVALID;


        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

