/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.permissions;

public class PermissionInfo {
    private String permission;
    private boolean enabled = false;
    private Long delay = 1000L;
    private Long lastChecked = null;
    private Double maxValue = null;
    private Double minValue = null;

    public PermissionInfo(String permission, Long delay) {
        this.permission = permission;
        if (delay != null) {
            this.delay = delay;
        }
    }

    public boolean isTimeToRecalculate() {
        return this.lastChecked == null || this.delay + this.lastChecked < System.currentTimeMillis();
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public Long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public Long getLastChecked() {
        if (this.lastChecked == null) {
            this.lastChecked = System.currentTimeMillis();
        }
        return this.lastChecked;
    }

    public void setLastChecked(long lastChecked) {
        this.lastChecked = lastChecked;
    }

    public Double getMaxValue() {
        return this.maxValue;
    }

    public Double getMaxValue(Double defaultV) {
        return this.maxValue == null ? defaultV : this.maxValue;
    }

    public void setMaxValue(Double maxValue) {
        this.maxValue = maxValue;
    }

    public Double getMinValue() {
        return this.minValue;
    }

    public Double getMinValue(Double defaultV) {
        return this.minValue == null ? defaultV : this.minValue;
    }

    public void setMinValue(Double minValue) {
        this.minValue = minValue;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

