/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.cmiLib.ActionBarTitleMessages;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import com.bekvon.bukkit.cmiLib.VersionChecker;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.StuckInfo;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.ResidenceChangedEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceOwnerChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.listeners.ResidenceBlockListener;
import com.bekvon.bukkit.residence.listeners.ResidenceEntityListener;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ResidencePlayerListener
implements Listener {
    protected Map<UUID, ClaimedResidence> currentRes;
    protected Map<UUID, Long> lastUpdate;
    protected Map<UUID, Location> lastOutsideLoc;
    protected Map<UUID, StuckInfo> stuckTeleportCounter;
    protected int minUpdateTime;
    protected boolean chatenabled;
    protected Set<UUID> playerToggleChat = new HashSet<UUID>();
    private Residence plugin;
    HashMap<UUID, Long> informar = new HashMap();

    public ResidencePlayerListener(Residence plugin) {
        this.currentRes = new HashMap<UUID, ClaimedResidence>();
        this.lastUpdate = new HashMap<UUID, Long>();
        this.lastOutsideLoc = new HashMap<UUID, Location>();
        this.stuckTeleportCounter = new HashMap<UUID, StuckInfo>();
        this.playerToggleChat.clear();
        this.minUpdateTime = plugin.getConfigManager().getMinMoveUpdateInterval();
        this.chatenabled = plugin.getConfigManager().chatEnabled();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
        }
        this.plugin = plugin;
    }

    public void reload() {
        this.currentRes = new HashMap<UUID, ClaimedResidence>();
        this.lastUpdate = new HashMap<UUID, Long>();
        this.lastOutsideLoc = new HashMap<UUID, Location>();
        this.stuckTeleportCounter = new HashMap<UUID, StuckInfo>();
        this.playerToggleChat.clear();
        this.minUpdateTime = this.plugin.getConfigManager().getMinMoveUpdateInterval();
        this.chatenabled = this.plugin.getConfigManager().chatEnabled();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    @EventHandler
    public void onJump(PlayerMoveEvent event) {
        if (!Flags.jump3.isGlobalyEnabled() && !Flags.jump2.isGlobalyEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isFlying()) {
            return;
        }
        if (event.getTo().getY() - event.getFrom().getY() != (double)0.42f) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(player.getLocation());
        if (Flags.jump2.isGlobalyEnabled() && perms.has(Flags.jump2, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.setVelocity(player.getVelocity().add(player.getVelocity().multiply(0.3)));
        } else if (Flags.jump3.isGlobalyEnabled() && perms.has(Flags.jump3, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.setVelocity(player.getVelocity().add(player.getVelocity().multiply(0.6)));
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerPickupItemEvent(PlayerPickupItemEvent event) {
        if (!Flags.itempickup.isGlobalyEnabled()) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getItem().getLocation());
        if (res == null) {
            return;
        }
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        if (!res.getPermissions().playerHas(event.getPlayer(), Flags.itempickup, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        event.setCancelled(true);
        event.getItem().setPickupDelay(this.plugin.getConfigManager().getItemPickUpDelay() * 20);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDropItemEvent(PlayerDropItemEvent event) {
        if (!Flags.itemdrop.isGlobalyEnabled()) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getPlayer().getLocation());
        if (res == null) {
            return;
        }
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        if (!res.getPermissions().playerHas(event.getPlayer(), Flags.itemdrop, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerGlobalChat(AsyncPlayerChatEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatEnabled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatSelfModify()) {
            return;
        }
        Player player = event.getPlayer();
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (rPlayer == null) {
            return;
        }
        if (rPlayer.getResList().size() == 0) {
            return;
        }
        ClaimedResidence res = rPlayer.getMainResidence();
        if (res == null) {
            return;
        }
        String honorific = this.plugin.getConfigManager().getGlobalChatFormat().replace("%1", res.getTopParentName());
        String format = event.getFormat();
        format = format.replace("%1$s", String.valueOf(honorific) + "%1$s");
        event.setFormat(format);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerChatGlobalLow(AsyncPlayerChatEvent event) {
        this.procEvent(event);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    private void processNEvent(AsyncPlayerChatEvent event) {
        this.procEvent(event);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void processHEvent(AsyncPlayerChatEvent event) {
        this.procEvent(event);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void processHHEvent(AsyncPlayerChatEvent event) {
        this.procEvent(event);
    }

    private void procEvent(AsyncPlayerChatEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isGlobalChatEnabled()) {
            return;
        }
        if (this.plugin.getConfigManager().isGlobalChatSelfModify()) {
            return;
        }
        String format = event.getFormat();
        if (!format.contains("{residence}")) {
            return;
        }
        Player player = event.getPlayer();
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (rPlayer == null) {
            return;
        }
        ClaimedResidence res = rPlayer.getMainResidence();
        String honorific = this.plugin.getConfigManager().getGlobalChatFormat().replace("%1", res == null ? "" : res.getTopParentName());
        if (honorific.equalsIgnoreCase(" ")) {
            honorific = "";
        }
        format = format.replace("{residence}", honorific);
        event.setFormat(format);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceBackup(ResidenceFlagChangeEvent event) {
        if (!event.getFlag().equalsIgnoreCase(Flags.backup.toString())) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.getConfigManager().RestoreAfterRentEnds) {
            return;
        }
        if (!this.plugin.getConfigManager().SchematicsSaveOnFlagChange) {
            return;
        }
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        if (player != null && !PermissionManager.ResPerm.backup.hasPermission((CommandSender)player)) {
            event.setCancelled(true);
        } else {
            this.plugin.getSchematicManager().save(event.getResidence());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceBackupRename(ResidenceRenameEvent event) {
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        this.plugin.getSchematicManager().rename(event.getResidence(), event.getNewResidenceName());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceDelete(ResidenceDeleteEvent event) {
        if (this.plugin.getSchematicManager() == null) {
            return;
        }
        this.plugin.getSchematicManager().delete(event.getResidence());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFirstLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPlayedBefore()) {
            ResidenceBlockListener.newPlayers.add(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (!this.plugin.getConfigManager().isRentInformOnEnding()) {
            return;
        }
        final Player player = event.getPlayer();
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                List<String> list2 = ResidencePlayerListener.this.plugin.getRentManager().getRentedLandsList(player.getName());
                if (list2.isEmpty()) {
                    return;
                }
                for (String one : list2) {
                    RentedLand rentedland = ResidencePlayerListener.this.plugin.getRentManager().getRentedLand(one);
                    if (rentedland == null || rentedland.AutoPay || rentedland.endTime - System.currentTimeMillis() >= (long)(ResidencePlayerListener.this.plugin.getConfigManager().getRentInformBefore() * 60 * 24 * 7)) continue;
                    ResidencePlayerListener.this.plugin.msg((CommandSender)player, lm.Residence_EndingRent, one, GetTime.getTime(rentedland.endTime));
                }
            }
        }, (long)this.plugin.getConfigManager().getRentInformDelay() * 20L);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onFishingRodUse(PlayerFishEvent event) {
        if (!Flags.hook.isGlobalyEnabled()) {
            return;
        }
        if (event == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getCaught() == null) {
            return;
        }
        if (this.plugin.getNms().isArmorStandEntity(event.getCaught().getType()) || event.getCaught() instanceof Boat || event.getCaught() instanceof LivingEntity) {
            FlagPermissions perm = this.plugin.getPermsByLoc(event.getCaught().getLocation());
            ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getCaught().getLocation());
            if (perm.has(Flags.hook, FlagPermissions.FlagCombo.OnlyFalse)) {
                event.setCancelled(true);
                if (res != null) {
                    this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.hook, res.getName()});
                }
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeDayNight(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.day.toString()) && !event.getFlag().equalsIgnoreCase(Flags.night.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.resetPlayerTime();
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.day.toString())) {
                    for (Player one : event.getResidence().getPlayersInResidence()) {
                        one.setPlayerTime(6000L, false);
                    }
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.night.toString())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setPlayerTime(14000L, false);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeGlow(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.glow.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                if (!VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1) || !event.getFlag().equalsIgnoreCase(Flags.glow.toString())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setGlowing(false);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (!event.getFlag().equalsIgnoreCase(Flags.glow.toString()) || !VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1)) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setGlowing(true);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceDeleteEvent(ResidenceDeleteEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ClaimedResidence res = event.getResidence();
        if (res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.setWalkSpeed(0.2f);
            }
        }
        if (res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.resetPlayerWeather();
            }
        }
        if (event.getPlayer() != null && res.getPermissions().playerHas(event.getPlayer(), Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                this.fly(one, false);
            }
        }
        if (res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.setGlowing(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getPermissionManager().removeFromCache(player);
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(player.getLocation());
        if (res == null) {
            return;
        }
        if (res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.setWalkSpeed(0.2f);
        }
        if (res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
            player.resetPlayerWeather();
        }
        if (res.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
            this.fly(player, false);
        }
        if (res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1)) {
            player.setGlowing(false);
        }
        this.plugin.getPlayerManager().getResidencePlayer(player).onQuit();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeWSpeed(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.wspeed1.toString()) && !event.getFlag().equalsIgnoreCase(Flags.wspeed2.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setWalkSpeed(0.2f);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.wspeed1.toString())) {
                    for (Player one : event.getResidence().getPlayersInResidence()) {
                        one.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
                    }
                    if (!event.getResidence().getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) break;
                    event.getResidence().getPermissions().setFlag(Flags.wspeed2.toString(), FlagPermissions.FlagState.NEITHER);
                    break;
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.wspeed2.toString())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
                }
                if (!event.getResidence().getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) break;
                event.getResidence().getPermissions().setFlag(Flags.wspeed1.toString(), FlagPermissions.FlagState.NEITHER);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeWSpeed(ResidenceOwnerChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ClaimedResidence res = event.getResidence();
        if (res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.setWalkSpeed(0.2f);
            }
        }
        if (res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.resetPlayerWeather();
            }
        }
        if (res.getPermissions().has(Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                this.fly(one, false);
            }
        }
        if (res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1)) {
            for (Player one : event.getResidence().getPlayersInResidence()) {
                one.setGlowing(false);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeJump(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.jump2.toString()) && !event.getFlag().equalsIgnoreCase(Flags.jump3.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: 
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.jump2.toString())) {
                    if (!event.getResidence().getPermissions().has(Flags.jump3, FlagPermissions.FlagCombo.OnlyTrue)) break;
                    event.getResidence().getPermissions().setFlag(Flags.jump3.toString(), FlagPermissions.FlagState.NEITHER);
                    break;
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.jump3.toString()) || !event.getResidence().getPermissions().has(Flags.jump2, FlagPermissions.FlagCombo.OnlyTrue)) break;
                event.getResidence().getPermissions().setFlag(Flags.jump2.toString(), FlagPermissions.FlagState.NEITHER);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeSunRain(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.sun.toString()) && !event.getFlag().equalsIgnoreCase(Flags.rain.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.resetPlayerWeather();
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                if (event.getFlag().equalsIgnoreCase(Flags.sun.toString())) {
                    for (Player one : event.getResidence().getPlayersInResidence()) {
                        one.setPlayerWeather(WeatherType.CLEAR);
                    }
                }
                if (!event.getFlag().equalsIgnoreCase(Flags.rain.toString())) break;
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    one.setPlayerWeather(WeatherType.DOWNFALL);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeFly(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase(Flags.fly.toString())) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    this.fly(one, false);
                }
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                for (Player one : event.getResidence().getPlayersInResidence()) {
                    this.fly(one, true);
                }
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        String t;
        if (!Flags.command.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        ClaimedResidence res = this.getCurrentResidence(player.getUniqueId());
        if (res == null) {
            return;
        }
        if (!res.getPermissions().playerHas(player, Flags.command, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            return;
        }
        if (PermissionManager.ResPerm.bypass_command.hasPermission((CommandSender)player, 10000L, new String[0])) {
            return;
        }
        String msg = event.getMessage().replace(" ", "_").toLowerCase();
        int white = 0;
        int black = 0;
        for (String oneWhite : res.getCmdWhiteList()) {
            t = oneWhite.toLowerCase();
            if (!msg.startsWith("/" + t)) continue;
            if (t.contains("_") && t.split("_").length > white) {
                white = t.split("_").length;
                continue;
            }
            if (white != 0) continue;
            white = 1;
        }
        for (String oneBlack : res.getCmdBlackList()) {
            t = oneBlack.toLowerCase();
            if (!msg.startsWith("/" + t)) continue;
            if (msg.contains("_")) {
                black = t.split("_").length;
                break;
            }
            black = 1;
            break;
        }
        if (black == 0) {
            for (String oneBlack : res.getCmdBlackList()) {
                t = oneBlack.toLowerCase();
                if (!t.equalsIgnoreCase("*")) continue;
                if (!msg.contains("_")) break;
                black = msg.split("_").length;
                break;
            }
        }
        if (white != 0 && white >= black || black == 0) {
            return;
        }
        event.setCancelled(true);
        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.command, res.getName()});
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignInteract(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !CMIMaterial.isSign(block.getType())) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location loc = block.getLocation();
        Signs s = this.plugin.getSignUtil().getSigns().getResSign(loc);
        if (s == null) {
            return;
        }
        ClaimedResidence res = s.getResidence();
        boolean ForSale = res.isForSell();
        boolean ForRent = res.isForRent();
        String landName = res.getName();
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (ForSale) {
                Bukkit.dispatchCommand((CommandSender)player, (String)("res market buy " + landName));
                return;
            }
            if (ForRent) {
                if (res.isRented() && player.isSneaking()) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)("res market release " + landName));
                } else {
                    boolean stage = true;
                    if (player.isSneaking()) {
                        stage = false;
                    }
                    Bukkit.dispatchCommand((CommandSender)player, (String)("res market rent " + landName + " " + stage));
                }
                return;
            }
        } else if (event.getAction() == Action.LEFT_CLICK_BLOCK && ForRent && res.isRented() && this.plugin.getRentManager().getRentingPlayer(res).equals(player.getName())) {
            this.plugin.getRentManager().payRent(player, res, false);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onSignCreate(SignChangeEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getBlock();
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        if (!ChatColor.stripColor((String)event.getLine(0)).equalsIgnoreCase(this.plugin.msg(lm.Sign_TopLine, new Object[0]))) {
            return;
        }
        Signs signInfo = new Signs();
        Location loc = sign.getLocation();
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence res = null;
        if (!event.getLine(1).equalsIgnoreCase("")) {
            String resname = event.getLine(1);
            if (!event.getLine(2).equalsIgnoreCase("")) {
                resname = String.valueOf(resname) + "." + event.getLine(2);
            }
            if (!event.getLine(3).equalsIgnoreCase("")) {
                resname = String.valueOf(resname) + "." + event.getLine(3);
            }
            if ((res = this.plugin.getResidenceManager().getByName(resname)) == null) {
                this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                return;
            }
        } else {
            res = this.plugin.getResidenceManager().getByLoc(loc);
        }
        if (res == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        final ClaimedResidence residence = res;
        signInfo.setResidence(res);
        signInfo.setLocation(loc);
        this.plugin.getSignUtil().getSigns().addSign(signInfo);
        this.plugin.getSignUtil().saveSigns();
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ResidencePlayerListener.this.plugin.getSignUtil().CheckSign(residence);
            }
        }, 5L);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignDestroy(BlockBreakEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (!CMIMaterial.isSign(block.getType())) {
            return;
        }
        Location loc = block.getLocation();
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        Signs s = this.plugin.getSignUtil().getSigns().getResSign(loc);
        if (s == null) {
            return;
        }
        this.plugin.getSignUtil().getSigns().removeSign(s);
        if (s.getResidence() != null) {
            s.getResidence().getSignsInResidence().remove(s);
        }
        this.plugin.getSignUtil().saveSigns();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        String pname = event.getPlayer().getName();
        this.currentRes.remove(event.getPlayer().getUniqueId());
        this.lastUpdate.remove(event.getPlayer().getUniqueId());
        this.lastOutsideLoc.remove(event.getPlayer().getUniqueId());
        this.plugin.getChatManager().removeFromChannel(pname);
        this.plugin.getPlayerListener().removePlayerResidenceChat(event.getPlayer());
        this.plugin.addOfflinePlayerToChache((OfflinePlayer)event.getPlayer());
        this.plugin.getAutoSelectionManager().getList().remove(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerWorldChange(PlayerChangedWorldEvent event) {
        ClaimedResidence res;
        if (!Flags.nofly.isGlobalyEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(player.getLocation(), player);
        if (!(!player.getAllowFlight() && !player.isFlying() || !perms.has(Flags.nofly, false) || this.plugin.isResAdminOn(player) || (res = this.plugin.getResidenceManager().getByLoc(player.getLocation())) != null && res.isOwner(player))) {
            Location lc = player.getLocation();
            Location location = new Location(lc.getWorld(), lc.getX(), (double)lc.getBlockY(), lc.getZ());
            location.setPitch(lc.getPitch());
            location.setYaw(lc.getYaw());
            int from = location.getBlockY();
            int maxH = location.getWorld().getMaxHeight() - 1;
            maxH = location.getWorld().getHighestBlockAt(location).getLocation().getBlockY() + 3;
            if (location.getWorld().getEnvironment() == World.Environment.NETHER) {
                maxH = 100;
            }
            int i = 0;
            while (i < maxH) {
                location.setY((double)(from - i));
                Block block = location.getBlock();
                if (!ResidencePlayerListener.isEmptyBlock(block)) {
                    location.setY((double)(from - i + 1));
                    break;
                }
                if (location.getBlockY() <= 0) {
                    player.setFlying(false);
                    player.setAllowFlight(false);
                    this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, location.getWorld().getName()});
                    return;
                }
                ++i;
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, location.getWorld().getName()});
            player.closeInventory();
            player.teleport(location);
            player.setFlying(false);
            player.setAllowFlight(false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.lastUpdate.put(player.getUniqueId(), 0L);
        if (this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
            this.plugin.turnResAdminOn(player);
        }
        this.handleNewLocation(player, player.getLocation(), true);
        this.plugin.getPlayerManager().playerJoin(player);
        if (PermissionManager.ResPerm.versioncheck.hasPermission((CommandSender)player)) {
            this.plugin.getVersionChecker().VersionCheck(player);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerSpawn(PlayerRespawnEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getRespawnLocation().getWorld())) {
            return;
        }
        Location loc = event.getRespawnLocation();
        Boolean bed = event.isBedSpawn();
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (!res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (bed.booleanValue()) {
            loc = player.getWorld().getSpawnLocation();
        }
        if ((res = this.plugin.getResidenceManager().getByLoc(loc)) != null && res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse)) {
            loc = res.getOutsideFreeLoc(loc, player);
        }
        this.plugin.msg((CommandSender)player, lm.General_NoSpawn, new Object[0]);
        event.setRespawnLocation(loc);
    }

    private boolean isContainer(Material mat, Block block) {
        return FlagPermissions.getMaterialUseFlagList().containsKey(mat) && FlagPermissions.getMaterialUseFlagList().get(mat).equals((Object)Flags.container) || this.plugin.getConfigManager().getCustomContainers().contains((Object)CMIMaterial.get(block));
    }

    private boolean isCanUseEntity_RClickOnly(Material mat, Block block) {
        switch (mat.name()) {
            case "REDSTONE_COMPARATOR": 
            case "DIODE_BLOCK_OFF": 
            case "CRAFTING_TABLE": 
            case "DAYLIGHT_DETECTOR": 
            case "REDSTONE_COMPARATOR_OFF": 
            case "REDSTONE_COMPARATOR_ON": 
            case "DIODE_BLOCK_ON": 
            case "ITEM_FRAME": 
            case "WORKBENCH": 
            case "COMPARATOR": 
            case "CAKE_BLOCK": 
            case "BED_BLOCK": 
            case "ANVIL": 
            case "DIODE": 
            case "REPEATER": 
            case "ENCHANTING_TABLE": 
            case "DAYLIGHT_DETECTOR_INVERTED": 
            case "FLOWER_POT": 
            case "BREWING_STAND": 
            case "ENCHANTMENT_TABLE": 
            case "COMMAND": 
            case "BEACON": {
                return true;
            }
        }
        CMIMaterial cmat = CMIMaterial.get(mat);
        if (cmat != null && cmat.isPotted()) {
            return true;
        }
        return this.plugin.getConfigManager().getCustomRightClick().contains((Object)CMIMaterial.get(block));
    }

    public boolean isCanUseEntity_BothClick(Material mat, Block block) {
        CMIMaterial m = CMIMaterial.get(mat);
        if (m.isDoor()) {
            return true;
        }
        if (m.isButton()) {
            return true;
        }
        if (m.isGate()) {
            return true;
        }
        if (m.isTrapDoor()) {
            return true;
        }
        switch (m) {
            case DRAGON_EGG: 
            case LEVER: 
            case NOTE_BLOCK: 
            case PISTON: 
            case STICKY_PISTON: {
                return true;
            }
        }
        return Residence.getInstance().getConfigManager().getCustomBothClick().contains((Object)CMIMaterial.get(block));
    }

    public static boolean isEmptyBlock(Block block) {
        CMIMaterial cb = CMIMaterial.get(block);
        switch (cb) {
            case COBWEB: 
            case ITEM_FRAME: 
            case PAINTING: 
            case STRING: 
            case TRIPWIRE: 
            case TRIPWIRE_HOOK: 
            case VINE: 
            case WALL_SIGN: {
                return true;
            }
        }
        if (cb.isSapling()) {
            return true;
        }
        if (cb.isAir()) {
            return true;
        }
        return cb.isButton();
    }

    private boolean isCanUseEntity(Material mat, Block block) {
        return this.isCanUseEntity_BothClick(mat, block) || this.isCanUseEntity_RClickOnly(mat, block);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerFireInteract(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block relativeBlock = block.getRelative(event.getBlockFace());
        if (relativeBlock == null) {
            return;
        }
        if (relativeBlock.getType() != Material.FIRE) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        boolean hasplace = perms.playerHas(player, Flags.place, perms.playerHas(player, Flags.build, true));
        if (hasplace) {
            return;
        }
        event.setCancelled(true);
        this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlatePress(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        CMIMaterial mat = CMIMaterial.get(block);
        if (!this.plugin.isResAdminOn(player)) {
            boolean hasuse = perms.playerHas(player, Flags.use, true);
            boolean haspressure = perms.playerHas(player, Flags.pressure, hasuse);
            if ((!hasuse && !haspressure || !haspressure) && mat.isPlate()) {
                event.setCancelled(true);
                return;
            }
        }
        if (!(perms.playerHas(player, Flags.trample, perms.playerHas(player, Flags.build, true)) || mat != CMIMaterial.FARMLAND && mat != CMIMaterial.SOUL_SAND)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSelection(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        CMIMaterial heldItem = CMIMaterial.get(player.getItemInHand());
        if (heldItem != this.plugin.getConfigManager().getSelectionTool()) {
            return;
        }
        if (this.plugin.getWorldEditTool() == this.plugin.getConfigManager().getSelectionTool()) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            event.setCancelled(true);
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        boolean resadmin2 = this.plugin.isResAdminOn(player);
        if (PermissionManager.ResPerm.select.hasPermission((CommandSender)player) || PermissionManager.ResPerm.create.hasPermission((CommandSender)player) && !PermissionManager.ResPerm.select.hasSetPermission((CommandSender)player, new String[0]) || group.canCreateResidences() && !PermissionManager.ResPerm.create.hasSetPermission((CommandSender)player, new String[0]) && !PermissionManager.ResPerm.select.hasSetPermission((CommandSender)player, new String[0]) || resadmin2) {
            Block block = event.getClickedBlock();
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                Location loc = block.getLocation();
                this.plugin.getSelectionManager().placeLoc1(player, loc, true);
                this.plugin.msg((CommandSender)player, lm.Select_PrimaryPoint, this.plugin.msg(lm.General_CoordsTop, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                event.setCancelled(true);
            } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK && this.plugin.getNms().isMainHand(event)) {
                Location loc = block.getLocation();
                this.plugin.getSelectionManager().placeLoc2(player, loc, true);
                this.plugin.msg((CommandSender)player, lm.Select_SecondaryPoint, this.plugin.msg(lm.General_CoordsBottom, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                event.setCancelled(true);
            }
            if (this.plugin.getSelectionManager().hasPlacedBoth(player)) {
                this.plugin.getSelectionManager().showSelectionInfoInActionBar(player);
                this.plugin.getSelectionManager().updateLocations(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInfoCheck(PlayerInteractEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        CMIMaterial heldItem = CMIMaterial.get(item);
        if (heldItem != this.plugin.getConfigManager().getInfoTool()) {
            return;
        }
        if (this.isContainer(block.getType(), block)) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (res != null) {
            this.plugin.getResidenceManager().printAreaInfo(res.getName(), (CommandSender)player, false);
        } else {
            this.plugin.msg((CommandSender)player, lm.Residence_NoResHere, new Object[0]);
        }
        event.setCancelled(true);
    }

    private static boolean placingMinecart(Block block, ItemStack item) {
        return block != null && block.getType().name().contains("RAIL") && item != null && item.getType().name().contains("MINECART");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        block22: {
            boolean hasuse;
            FlagPermissions perms;
            CMIMaterial blockM;
            Player player;
            block23: {
                block26: {
                    Flags result;
                    ClaimedResidence res;
                    Material mat;
                    Block block;
                    block25: {
                        block24: {
                            if (event.getPlayer() == null) {
                                return;
                            }
                            if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
                                return;
                            }
                            player = event.getPlayer();
                            block = event.getClickedBlock();
                            if (block == null) {
                                return;
                            }
                            ItemStack iih = event.getItem();
                            CMIMaterial heldItem = CMIMaterial.get(iih);
                            mat = block.getType();
                            if (!(event.getAction() == Action.PHYSICAL || (this.isContainer(mat, block) || this.isCanUseEntity_RClickOnly(mat, block)) && event.getAction() == Action.RIGHT_CLICK_BLOCK || this.isCanUseEntity_BothClick(mat, block) || heldItem.equals((Object)this.plugin.getConfigManager().getSelectionTool()) || heldItem.equals((Object)this.plugin.getConfigManager().getInfoTool()) || heldItem.isDye() || heldItem.equals((Object)CMIMaterial.ARMOR_STAND) || heldItem.isBoat() || ResidencePlayerListener.placingMinecart(block, iih))) {
                                return;
                            }
                            if (event.getAction() != Action.LEFT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
                                return;
                            }
                            boolean resadmin2 = this.plugin.isResAdminOn(player);
                            if (resadmin2) {
                                return;
                            }
                            if (!this.plugin.getItemManager().isAllowed(heldItem.getMaterial(), this.plugin.getPlayerManager().getResidencePlayer(player).getGroup(), player.getWorld().getName())) {
                                this.plugin.msg((CommandSender)player, lm.General_ItemBlacklisted, new Object[0]);
                                event.setCancelled(true);
                                return;
                            }
                            blockM = CMIMaterial.get(block);
                            perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
                            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                                if (heldItem.isDye()) {
                                    CMIMaterial btype = CMIMaterial.get(block);
                                    if ((heldItem.equals((Object)CMIMaterial.BONE_MEAL) && (btype == CMIMaterial.GRASS_BLOCK || btype == CMIMaterial.GRASS || btype.isSapling()) || heldItem == CMIMaterial.COCOA_BEANS && blockM == CMIMaterial.JUNGLE_WOOD) && !(perms = this.plugin.getPermsByLocForPlayer(block.getRelative(event.getBlockFace()).getLocation(), player)).playerHas(player, Flags.build, true)) {
                                        this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
                                        event.setCancelled(true);
                                        return;
                                    }
                                }
                                if ((heldItem.equals((Object)CMIMaterial.ARMOR_STAND) || heldItem.isBoat()) && !(perms = this.plugin.getPermsByLocForPlayer(block.getRelative(event.getBlockFace()).getLocation(), player)).playerHas(player, Flags.build, true)) {
                                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
                                    event.setCancelled(true);
                                    return;
                                }
                                if (ResidencePlayerListener.placingMinecart(block, iih) && !(perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player)).playerHas(player, Flags.build, true)) {
                                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
                                    event.setCancelled(true);
                                    return;
                                }
                            }
                            if (!this.isContainer(mat, block) && !this.isCanUseEntity(mat, block)) break block22;
                            hasuse = perms.playerHas(player, Flags.use, true);
                            res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
                            if (res != null && res.isUnderRaid() && res.getRaid().isDefender(player) && !ConfigManager.RaidDefenderContainerUsage && (result = FlagPermissions.getMaterialUseFlagList().get(mat)) != null && result.equals((Object)Flags.container)) {
                                event.setCancelled(true);
                                this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
                                return;
                            }
                            if (res != null && res.isOwner(player) || (result = FlagPermissions.getMaterialUseFlagList().get(mat)) == null || perms.playerHas(player, result, hasuse)) break block23;
                            if (!hasuse && !result.equals((Object)Flags.container)) break block24;
                            if (res == null || !res.isUnderRaid() || !res.getRaid().isAttacker(player)) {
                                event.setCancelled(true);
                                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{result});
                                return;
                            }
                            break block23;
                        }
                        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) break block25;
                        if (res == null || !res.isUnderRaid() || !res.getRaid().isAttacker(player)) {
                            event.setCancelled(true);
                            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{result});
                            return;
                        }
                        break block23;
                    }
                    if (!this.isCanUseEntity_BothClick(mat, block)) break block26;
                    if (res != null && res.isUnderRaid() && res.getRaid().isAttacker(player)) break block23;
                    event.setCancelled(true);
                    this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{result});
                }
                return;
            }
            if (this.plugin.getConfigManager().getCustomContainers().contains((Object)blockM) && !perms.playerHas(player, Flags.container, hasuse)) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
                return;
            }
            if (this.plugin.getConfigManager().getCustomBothClick().contains((Object)blockM) && !hasuse) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.use});
                return;
            }
            if (this.plugin.getConfigManager().getCustomRightClick().contains((Object)blockM) && event.getAction() == Action.RIGHT_CLICK_BLOCK && !hasuse) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.use});
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTradeEntity(PlayerInteractEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.VILLAGER) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res != null && res.getPermissions().playerHas(player, Flags.trade, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.trade, res.getName()});
            event.setCancelled(true);
        }
    }

    private static boolean canRide(EntityType type) {
        switch (type.name().toLowerCase()) {
            case "donkey": 
            case "pig": 
            case "horse": 
            case "llama": {
                return true;
            }
        }
        return false;
    }

    private static boolean canHaveContainer(EntityType type) {
        switch (type.name().toLowerCase()) {
            case "donkey": 
            case "horse": 
            case "llama": {
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithHorse(PlayerInteractEntityEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (!Flags.container.isGlobalyEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (!ResidencePlayerListener.canHaveContainer(ent.getType())) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.container, FlagPermissions.FlagCombo.OnlyFalse) && player.isSneaking()) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.container, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithRidable(PlayerInteractEntityEvent event) {
        if (!Flags.riding.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (!ResidencePlayerListener.canRide(ent.getType())) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && !res.getPermissions().playerHas(player, Flags.riding, FlagPermissions.FlagCombo.TrueOrNone)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.riding, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithMinecartStorage(PlayerInteractEntityEvent event) {
        if (!Flags.container.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.MINECART_CHEST && ent.getType() != EntityType.MINECART_HOPPER) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.container, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.container, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteractWithMinecart(PlayerInteractEntityEvent event) {
        if (!Flags.riding.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.MINECART && ent.getType() != EntityType.BOAT) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.riding, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.riding, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDyeSheep(PlayerInteractEntityEvent event) {
        if (!Flags.dye.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.SHEEP) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.dye, FlagPermissions.FlagCombo.OnlyFalse)) {
            ItemStack iih = this.plugin.getNms().itemInMainHand(player);
            ItemStack iiho = CMIReflections.getItemInOffHand(player);
            if (iih == null && iiho == null) {
                return;
            }
            if (iih != null && !CMIMaterial.isDye(iih.getType()) && iiho != null && !CMIMaterial.isDye(iiho.getType())) {
                return;
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.dye, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        if (!Flags.shear.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getEntity();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (res == null) {
            return;
        }
        if (!res.isOwner(player) && res.getPermissions().playerHas(player, Flags.shear, FlagPermissions.FlagCombo.OnlyFalse)) {
            ItemStack iih = this.plugin.getNms().itemInMainHand(player);
            ItemStack iiho = CMIReflections.getItemInOffHand(player);
            if (iih == null && iiho == null) {
                return;
            }
            if (iih != null && !CMIMaterial.SHEARS.equals(iih.getType()) && iiho != null && !CMIMaterial.SHEARS.equals(iiho.getType())) {
                return;
            }
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.shear, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerItemFrameInteract(PlayerInteractEntityEvent event) {
        if (!Flags.container.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Entity ent = event.getRightClicked();
        if (ent.getType() != EntityType.ITEM_FRAME) {
            return;
        }
        if (!(ent instanceof Hanging)) {
            return;
        }
        Material heldItem = this.plugin.getNms().itemInMainHand(player).getType();
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(ent.getLocation(), player);
        String world = player.getWorld().getName();
        ResidencePlayer resPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = resPlayer.getGroup();
        if (!this.plugin.getItemManager().isAllowed(heldItem, group, world)) {
            this.plugin.msg((CommandSender)player, lm.General_ItemBlacklisted, new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (!perms.playerHas(player, Flags.container, perms.playerHas(player, Flags.use, true))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        FlagPermissions perms;
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Location loc = event.getBlockClicked().getLocation();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res != null) {
            if (this.plugin.getConfigManager().preventRentModify() && this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(res.getName())) {
                this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
                event.setCancelled(true);
                return;
            }
            Material mat = event.getBucket();
            if (res.getPermissions().playerHas(player, Flags.build, FlagPermissions.FlagCombo.OnlyFalse) && this.plugin.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && (mat == Material.LAVA_BUCKET || mat == Material.WATER_BUCKET)) {
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
                event.setCancelled(true);
                return;
            }
        }
        if (!(perms = this.plugin.getPermsByLocForPlayer(loc, player)).playerHas(player, Flags.build, true)) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.build});
            event.setCancelled(true);
            return;
        }
        Material mat = event.getBucket();
        int level = this.plugin.getConfigManager().getPlaceLevel();
        if (res == null && this.plugin.getConfigManager().isNoLavaPlace() && loc.getBlockY() >= level - 1 && this.plugin.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && mat == Material.LAVA_BUCKET) {
            if (!this.plugin.msg(lm.General_CantPlaceLava, new Object[0]).equalsIgnoreCase("")) {
                this.plugin.msg((CommandSender)player, lm.General_CantPlaceLava, level);
            }
            event.setCancelled(true);
            return;
        }
        if (res == null && this.plugin.getConfigManager().isNoWaterPlace() && loc.getBlockY() >= level - 1 && this.plugin.getConfigManager().getNoPlaceWorlds().contains(loc.getWorld().getName()) && mat == Material.WATER_BUCKET) {
            if (!this.plugin.msg(lm.General_CantPlaceWater, new Object[0]).equalsIgnoreCase("")) {
                this.plugin.msg((CommandSender)player, lm.General_CantPlaceWater, level);
            }
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(event.getBlockClicked().getLocation());
        if (res != null && this.plugin.getConfigManager().preventRentModify() && this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(res.getName())) {
            this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
            event.setCancelled(true);
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(event.getBlockClicked().getLocation(), player);
        boolean hasdestroy = perms.playerHas(player, Flags.destroy, perms.playerHas(player, Flags.build, true));
        if (!hasdestroy) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location loc = event.getTo();
        if (this.plugin.isResAdminOn(player)) {
            this.handleNewLocation(player, loc, false);
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND || event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL || event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
            if (res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse) && !res.isOwner(player)) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Residence_MoveDeny, res.getName());
                return;
            }
        } else if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && res.getPermissions().playerHas(player, Flags.enderpearl, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.enderpearl, res.getName()});
            return;
        }
        if ((event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN || event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) && this.plugin.getConfigManager().isBlockAnyTeleportation() && !res.isOwner(player) && res.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player)) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.General_TeleportDeny, res.getName());
            return;
        }
        if (this.plugin.getNms().isChorusTeleport(event.getCause()) && !res.isOwner(player) && res.getPermissions().playerHas(player, Flags.chorustp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player)) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.chorustp, res.getName()});
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDeath(final PlayerDeathEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location loc = player.getLocation();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (res.getPermissions().has(Flags.keepinv, false)) {
            event.setKeepInventory(true);
            if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_14_R1)) {
                event.getDrops().clear();
            }
        }
        if (res.getPermissions().has(Flags.keepexp, false)) {
            event.setKeepLevel(true);
            event.setDroppedExp(0);
        }
        if (res.getPermissions().has(Flags.respawn, false) && Bukkit.getVersion().toString().contains("Spigot")) {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    try {
                        event.getEntity().spigot().respawn();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 20L);
        }
    }

    private static Location getSafeLocation(Location loc) {
        Block block;
        int curY = loc.getBlockY();
        int i = 0;
        while (i <= curY) {
            block = loc.clone().add(0.0, (double)(-i), 0.0).getBlock();
            if (!block.isEmpty() && block.getLocation().clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() && block.getLocation().clone().add(0.0, 2.0, 0.0).getBlock().isEmpty()) {
                return loc.clone().add(0.0, (double)(-i + 1), 0.0);
            }
            ++i;
        }
        i = 0;
        while (i <= loc.getWorld().getMaxHeight() - curY) {
            block = loc.clone().add(0.0, (double)i, 0.0).getBlock();
            if (!block.isEmpty() && block.getLocation().clone().add(0.0, 1.0, 0.0).getBlock().isEmpty() && block.getLocation().clone().add(0.0, 2.0, 0.0).getBlock().isEmpty()) {
                return loc.clone().add(0.0, (double)(i + 1), 0.0);
            }
            ++i;
        }
        return null;
    }

    private void fly(Player player, boolean state) {
        if (player.getGameMode() != GameMode.SURVIVAL && player.getGameMode() != GameMode.ADVENTURE) {
            return;
        }
        if (!state) {
            boolean land = player.isFlying();
            player.setFlying(state);
            player.setAllowFlight(state);
            if (land) {
                Location loc = ResidencePlayerListener.getSafeLocation(player.getLocation());
                if (loc == null && (loc = this.plugin.getConfigManager().getFlyLandLocation()) == null) {
                    loc = ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
                }
                if (loc != null) {
                    player.closeInventory();
                    player.teleport(loc);
                }
            }
        } else {
            player.setAllowFlight(state);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceChange(ResidenceChangedEvent event) {
        ClaimedResidence res = event.getTo();
        ClaimedResidence ResOld = event.getFrom();
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (res == null && ResOld != null) {
            if (ResOld.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue) || ResOld.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerTime();
            }
            if (ResOld.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) || ResOld.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(0.2f);
            }
            if (ResOld.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) || ResOld.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerWeather();
            }
            if (ResOld.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                this.fly(player, false);
            }
            if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1) && ResOld.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setGlowing(false);
            }
        }
        if (res != null && ResOld != null && !res.equals(ResOld)) {
            if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1)) {
                if (res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setGlowing(true);
                } else if (ResOld.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                    player.setGlowing(false);
                }
            }
            if (res.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                this.fly(player, true);
            } else if (ResOld.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                this.fly(player, false);
            }
            if (res.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(6000L, false);
            } else if (ResOld.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerTime();
            }
            if (res.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(14000L, false);
            } else if (ResOld.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerTime();
            }
            if (res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
            } else if (ResOld.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(0.2f);
            }
            if (res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
            } else if (ResOld.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(0.2f);
            }
            if (res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.CLEAR);
            } else if (ResOld.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerWeather();
            }
            if (res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.DOWNFALL);
            } else if (ResOld.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue) && !res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.resetPlayerWeather();
            }
        }
        if (res != null && ResOld == null) {
            if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1) && res.getPermissions().has(Flags.glow, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setGlowing(true);
            }
            if (res.getPermissions().playerHas(player, Flags.fly, FlagPermissions.FlagCombo.OnlyTrue)) {
                this.fly(player, true);
            }
            if (res.getPermissions().has(Flags.day, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(6000L, false);
            }
            if (res.getPermissions().has(Flags.night, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerTime(14000L, false);
            }
            if (res.getPermissions().has(Flags.wspeed1, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed1().floatValue());
            }
            if (res.getPermissions().has(Flags.wspeed2, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setWalkSpeed(this.plugin.getConfigManager().getWalkSpeed2().floatValue());
            }
            if (res.getPermissions().has(Flags.sun, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.CLEAR);
            }
            if (res.getPermissions().has(Flags.rain, FlagPermissions.FlagCombo.OnlyTrue)) {
                player.setPlayerWeather(WeatherType.DOWNFALL);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location locfrom = event.getFrom();
        Location locto = event.getTo();
        if (locfrom.getBlockX() == locto.getBlockX() && locfrom.getBlockY() == locto.getBlockY() && locfrom.getBlockZ() == locto.getBlockZ()) {
            return;
        }
        Long last = this.lastUpdate.get(player.getUniqueId());
        if (last != null && System.currentTimeMillis() - last < (long)this.plugin.getConfigManager().getMinMoveUpdateInterval()) {
            return;
        }
        this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
        boolean handled = this.handleNewLocation(player, locto, true);
        if (!handled) {
            event.setCancelled(true);
        }
        if (!this.plugin.getTeleportDelayMap().isEmpty() && this.plugin.getConfigManager().getTeleportDelay() > 0 && this.plugin.getTeleportDelayMap().contains(player.getName())) {
            this.plugin.getTeleportDelayMap().remove(player.getName());
            this.plugin.msg((CommandSender)player, lm.General_TeleportCanceled, new Object[0]);
            if (this.plugin.getConfigManager().isTeleportTitleMessage()) {
                ActionBarTitleMessages.sendTitle(player, "", "");
            }
        }
    }

    private static boolean teleport(Player player, Location loc) {
        if (player == null || !player.isOnline() || loc == null) {
            return false;
        }
        return player.teleport(loc);
    }

    public boolean handleNewLocation(final Player player, Location loc, boolean move) {
        UUID uuid;
        ClaimedResidence ResOld;
        ClaimedResidence res;
        ClaimedResidence orres = res = this.plugin.getResidenceManager().getByLoc(loc);
        String areaname = null;
        String subzone2 = null;
        if (res != null) {
            areaname = res.getName();
            while (res.getSubzoneByLoc(loc) != null) {
                res = res.getSubzoneByLoc(player.getLocation());
                subzone2 = res.getName();
                areaname = String.valueOf(areaname) + "." + subzone2;
            }
        }
        if ((ResOld = this.currentRes.get(uuid = player.getUniqueId())) == null) {
            this.currentRes.remove(uuid);
        } else if (res != null && ResOld.getName().equals(res.getName())) {
            if (Flags.nofly.isGlobalyEnabled() && player.isFlying() && res.getPermissions().playerHas(player, Flags.nofly, FlagPermissions.FlagCombo.OnlyTrue) && !this.plugin.isResAdminOn(player) && !res.isOwner(player)) {
                Location lc = player.getLocation();
                Location location = new Location(lc.getWorld(), lc.getX(), (double)lc.getBlockY(), lc.getZ());
                location.setPitch(lc.getPitch());
                location.setYaw(lc.getYaw());
                int from = location.getBlockY();
                int maxH = from + 3;
                maxH = location.getWorld().getEnvironment() == World.Environment.NETHER ? 100 : location.getWorld().getHighestBlockAt(location).getLocation().getBlockY() + 3;
                int i = 0;
                while (i < maxH) {
                    location.setY((double)(from - i));
                    Block block = location.getBlock();
                    if (!ResidencePlayerListener.isEmptyBlock(block)) {
                        location.setY((double)(from - i + 1));
                        break;
                    }
                    if (location.getBlockY() <= 0) {
                        Location lastLoc = this.lastOutsideLoc.get(uuid);
                        player.closeInventory();
                        boolean teleported = false;
                        teleported = lastLoc != null ? ResidencePlayerListener.teleport(player, lastLoc) : ResidencePlayerListener.teleport(player, res.getOutsideFreeLoc(loc, player));
                        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, orres.getName()});
                        return teleported;
                    }
                    ++i;
                }
                this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, orres.getName()});
                player.closeInventory();
                boolean teleported = ResidencePlayerListener.teleport(player, location);
                if (!teleported) {
                    return false;
                }
                player.setFlying(false);
                player.setAllowFlight(false);
            }
            this.lastOutsideLoc.put(uuid, loc);
            return true;
        }
        if (!this.plugin.getAutoSelectionManager().getList().isEmpty()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ResidencePlayerListener.this.plugin.getAutoSelectionManager().UpdateSelection(player);
                }
            });
        }
        if (res == null) {
            this.lastOutsideLoc.put(uuid, loc);
            if (ResOld != null) {
                ResidenceChangedEvent chgEvent = new ResidenceChangedEvent(ResOld, null, player);
                this.plugin.getServ().getPluginManager().callEvent((Event)chgEvent);
                this.currentRes.remove(uuid);
            }
            return true;
        }
        if (move) {
            if (res.isUnderRaid()) {
                Location newLoc;
                if (res.getRaid().isAttacker(player.getUniqueId()) || res.getRaid().isDefender(player.getUniqueId())) {
                    return true;
                }
                Location lastLoc = this.lastOutsideLoc.get(uuid);
                if (this.plugin.getConfigManager().BounceAnimation()) {
                    Visualizer v = new Visualizer(player);
                    v.setErrorAreas(res);
                    v.setOnce(true);
                    this.plugin.getSelectionManager().showBounds(player, v);
                }
                ClaimedResidence preRes = this.plugin.getResidenceManager().getByLoc(lastLoc);
                boolean teleported = false;
                if (preRes != null && preRes.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player, 10000L, new String[0])) {
                    newLoc = res.getOutsideFreeLoc(loc, player);
                    player.closeInventory();
                    teleported = ResidencePlayerListener.teleport(player, newLoc);
                } else if (lastLoc != null) {
                    StuckInfo info2 = this.updateStuckTeleport(player, loc);
                    player.closeInventory();
                    if (info2 != null && info2.getTimesTeleported() > 5) {
                        Location newLoc2 = res.getOutsideFreeLoc(loc, player);
                        teleported = ResidencePlayerListener.teleport(player, newLoc2);
                    } else {
                        teleported = ResidencePlayerListener.teleport(player, lastLoc);
                    }
                } else {
                    newLoc = res.getOutsideFreeLoc(loc, player);
                    player.closeInventory();
                    teleported = ResidencePlayerListener.teleport(player, newLoc);
                }
                switch (this.plugin.getConfigManager().getEnterLeaveMessageType()) {
                    case ActionBar: 
                    case TitleBar: {
                        ResidencePermissions perms = res.getPermissions();
                        if (!((FlagPermissions)perms).has(Flags.title, FlagPermissions.FlagCombo.TrueOrNone)) break;
                        ActionBarTitleMessages.send(player, this.plugin.msg(lm.Raid_cantDo, new Object[0]));
                        break;
                    }
                    case ChatBox: {
                        this.plugin.msg((CommandSender)player, lm.Raid_cantDo, orres.getName());
                        break;
                    }
                }
                return teleported;
            }
            if (res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.OnlyFalse) && !this.plugin.isResAdminOn(player) && !res.isOwner(player) && !PermissionManager.ResPerm.admin_move.hasPermission((CommandSender)player, 10000L, new String[0])) {
                Location newLoc;
                Location lastLoc = this.lastOutsideLoc.get(uuid);
                if (this.plugin.getConfigManager().BounceAnimation()) {
                    Visualizer v = new Visualizer(player);
                    v.setErrorAreas(res);
                    v.setOnce(true);
                    this.plugin.getSelectionManager().showBounds(player, v);
                }
                ClaimedResidence preRes = this.plugin.getResidenceManager().getByLoc(lastLoc);
                boolean teleported = false;
                if (preRes != null && preRes.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.OnlyFalse) && !PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player, 10000L, new String[0])) {
                    newLoc = res.getOutsideFreeLoc(loc, player);
                    player.closeInventory();
                    teleported = ResidencePlayerListener.teleport(player, newLoc);
                } else if (lastLoc != null) {
                    StuckInfo info3 = this.updateStuckTeleport(player, loc);
                    player.closeInventory();
                    if (info3 != null && info3.getTimesTeleported() > 5) {
                        Location newLoc3 = res.getOutsideFreeLoc(loc, player);
                        teleported = ResidencePlayerListener.teleport(player, newLoc3);
                    } else {
                        teleported = ResidencePlayerListener.teleport(player, lastLoc);
                    }
                } else {
                    newLoc = res.getOutsideFreeLoc(loc, player);
                    player.closeInventory();
                    teleported = ResidencePlayerListener.teleport(player, newLoc);
                }
                switch (this.plugin.getConfigManager().getEnterLeaveMessageType()) {
                    case ActionBar: 
                    case TitleBar: {
                        ResidencePermissions perms = res.getPermissions();
                        if (!((FlagPermissions)perms).has(Flags.title, FlagPermissions.FlagCombo.TrueOrNone)) break;
                        ActionBarTitleMessages.send(player, this.plugin.msg(lm.Residence_MoveDeny, orres.getName()));
                        break;
                    }
                    case ChatBox: {
                        this.plugin.msg((CommandSender)player, lm.Residence_MoveDeny, orres.getName());
                        break;
                    }
                }
                return teleported;
            }
            if (Flags.nofly.isGlobalyEnabled() && player.isFlying() && res.getPermissions().playerHas(player, Flags.nofly, FlagPermissions.FlagCombo.OnlyTrue) && !this.plugin.isResAdminOn(player) && !res.isOwner(player)) {
                Location lc = player.getLocation();
                Location location = new Location(lc.getWorld(), lc.getX(), (double)lc.getBlockY(), lc.getZ());
                location.setPitch(lc.getPitch());
                location.setYaw(lc.getYaw());
                int from = location.getBlockY();
                int maxH = location.getWorld().getMaxHeight() - 1;
                boolean teleported = false;
                int i = 0;
                while (i < maxH) {
                    location.setY((double)(from - i));
                    Block block = location.getBlock();
                    if (!ResidencePlayerListener.isEmptyBlock(block)) {
                        location.setY((double)(from - i + 1));
                        break;
                    }
                    if (location.getBlockY() <= 0) {
                        Location lastLoc = this.lastOutsideLoc.get(uuid);
                        player.closeInventory();
                        teleported = lastLoc != null ? ResidencePlayerListener.teleport(player, lastLoc) : ResidencePlayerListener.teleport(player, res.getOutsideFreeLoc(loc, player));
                        this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, orres.getName()});
                        return teleported;
                    }
                    ++i;
                }
                this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.nofly, orres.getName()});
                player.closeInventory();
                teleported = ResidencePlayerListener.teleport(player, location);
                if (!teleported) {
                    return false;
                }
                player.setFlying(false);
                player.setAllowFlight(false);
            }
        }
        this.lastOutsideLoc.put(uuid, loc);
        if (!this.currentRes.containsKey(uuid) || ResOld != res) {
            this.currentRes.put(uuid, res);
            ResidenceChangedEvent chgEvent = new ResidenceChangedEvent(ResOld, res, player);
            this.plugin.getServ().getPluginManager().callEvent((Event)chgEvent);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerTeleportEvent(PlayerTeleportEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        ClaimedResidence fromRes = this.plugin.getResidenceManager().getByLoc(from);
        ClaimedResidence toRes = this.plugin.getResidenceManager().getByLoc(to);
        if (fromRes != null && toRes != null && fromRes.equals(toRes)) {
            return;
        }
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        ResidenceChangedEvent chgEvent = new ResidenceChangedEvent(fromRes, toRes, event.getPlayer());
        this.plugin.getServ().getPluginManager().callEvent((Event)chgEvent);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceChangeMessagePrint(ResidenceChangedEvent event) {
        Long time;
        Player player;
        ClaimedResidence res;
        ClaimedResidence from = event.getFrom();
        ClaimedResidence to = event.getTo();
        String message2 = null;
        ClaimedResidence claimedResidence = res = from == null ? to : from;
        if (from == null && to != null) {
            message2 = to.getEnterMessage();
            res = to;
        }
        if (from != null && to == null) {
            message2 = from.getLeaveMessage();
            res = from;
        }
        if (from != null && to != null) {
            message2 = to.getEnterMessage();
            res = to;
        }
        if ((player = event.getPlayer()).hasMetadata("NPC")) {
            return;
        }
        if (message2 != null && ((time = this.informar.get(player.getUniqueId())) == null || time + 100L < System.currentTimeMillis())) {
            if (res.getPermissions().has(Flags.title, FlagPermissions.FlagCombo.TrueOrNone)) {
                switch (this.plugin.getConfigManager().getEnterLeaveMessageType()) {
                    case ActionBar: {
                        ActionBarTitleMessages.send(player, ChatColor.YELLOW + this.insertMessages(player, res, message2));
                        break;
                    }
                    case ChatBox: {
                        this.plugin.msg(player, ChatColor.YELLOW + this.insertMessages(player, res, message2));
                        break;
                    }
                    case TitleBar: {
                        ActionBarTitleMessages.sendTitle(player, ChatColor.YELLOW + this.insertMessages(player, res, message2));
                        break;
                    }
                }
            }
            this.informar.put(player.getUniqueId(), System.currentTimeMillis());
        }
        if (to != null && this.plugin.getConfigManager().isEnterAnimation() && to.isTopArea() && (from == null || from.getTopParent() != to)) {
            to.showBounds(player, true);
        }
        if (from == null || res == null) {
            return;
        }
        if (res != from.getParent() && this.plugin.getConfigManager().isExtraEnterMessage() && !res.isOwner(player) && (this.plugin.getRentManager().isForRent(from) || this.plugin.getTransactionManager().isForSale(from))) {
            if (this.plugin.getRentManager().isForRent(from) && !this.plugin.getRentManager().isRented(from)) {
                RentableLand rentable = this.plugin.getRentManager().getRentableLand(from);
                if (rentable != null) {
                    ActionBarTitleMessages.send(player, this.plugin.msg(lm.Residence_CanBeRented, from.getName(), rentable.cost, rentable.days));
                }
            } else if (this.plugin.getTransactionManager().isForSale(from) && !res.isOwner(player)) {
                int sale = this.plugin.getTransactionManager().getSaleAmount(from);
                ActionBarTitleMessages.send(player, this.plugin.msg(lm.Residence_CanBeBought, from.getName(), sale));
            }
        }
    }

    private StuckInfo updateStuckTeleport(Player player, Location loc) {
        if (loc.getY() >= player.getLocation().getY()) {
            return null;
        }
        StuckInfo info2 = this.stuckTeleportCounter.get(player.getUniqueId());
        if (info2 == null) {
            info2 = new StuckInfo(player);
            this.stuckTeleportCounter.put(player.getUniqueId(), info2);
        }
        info2.updateLastTp();
        return info2;
    }

    public String insertMessages(Player player, ClaimedResidence res, String message2) {
        try {
            message2 = message2.replaceAll("%player", player.getName());
            message2 = message2.replaceAll("%owner", res.getPermissions().getOwner());
            message2 = message2.replaceAll("%residence", res.getName());
        }
        catch (Exception ex) {
            return "";
        }
        return message2;
    }

    public void doHeals() {
        if (!Flags.healing.isGlobalyEnabled()) {
            return;
        }
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                Player damage;
                double health;
                ClaimedResidence res = this.getCurrentResidence(player.getUniqueId());
                if (res == null || !res.getPermissions().has(Flags.healing, false) || !((health = (damage = player).getHealth()) < damage.getMaxHealth()) || player.isDead()) continue;
                player.setHealth(health + 1.0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void feed() {
        if (!Flags.feed.isGlobalyEnabled()) {
            return;
        }
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                int food;
                ClaimedResidence res = this.getCurrentResidence(player.getUniqueId());
                if (res == null || !res.getPermissions().has(Flags.feed, false) || (food = player.getFoodLevel()) >= 20 || player.isDead()) continue;
                player.setFoodLevel(food + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void DespawnMobs() {
        if (!Flags.nomobs.isGlobalyEnabled()) {
            return;
        }
        try {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                ClaimedResidence res = this.getCurrentResidence(player.getUniqueId());
                if (res == null || !res.getPermissions().has(Flags.nomobs, false)) continue;
                List entities = Bukkit.getServer().getWorld(res.getWorld()).getEntities();
                for (Entity ent : entities) {
                    ClaimedResidence ares;
                    if (!ResidenceEntityListener.isMonster(ent) || !res.containsLoc(ent.getLocation()) || !(ares = this.plugin.getResidenceManager().getByLoc(ent.getLocation())).getPermissions().has(Flags.nomobs, FlagPermissions.FlagCombo.OnlyTrue)) continue;
                    ent.remove();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        String pname = event.getPlayer().getName();
        if (!this.chatenabled || !this.playerToggleChat.contains(event.getPlayer().getUniqueId())) {
            return;
        }
        ChatChannel channel = this.plugin.getChatManager().getPlayerChannel(pname);
        if (channel != null) {
            channel.chat(pname, event.getMessage());
        }
        event.setCancelled(true);
    }

    public void tooglePlayerResidenceChat(Player player, String residence) {
        this.playerToggleChat.add(player.getUniqueId());
        this.plugin.msg((CommandSender)player, lm.Chat_ChatChannelChange, residence);
    }

    @Deprecated
    public void removePlayerResidenceChat(String pname) {
        this.removePlayerResidenceChat(Bukkit.getPlayer((String)pname));
    }

    public void removePlayerResidenceChat(Player player) {
        if (player == null) {
            return;
        }
        this.playerToggleChat.remove(player.getUniqueId());
        this.plugin.msg((CommandSender)player, lm.Chat_ChatChannelLeave, new Object[0]);
    }

    public ClaimedResidence getCurrentResidence(UUID uuid) {
        return this.currentRes.get(uuid);
    }
}

