/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.cmiLib.ActionBarTitleMessages;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.VersionChecker;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Witch;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class ResidenceEntityListener
implements Listener {
    Residence plugin;

    public ResidenceEntityListener(Residence plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEndermanChangeBlock(EntityChangeBlockEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (event.getEntityType() != EntityType.ENDERMAN) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.destroy, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityInteract(EntityInteractEvent event) {
        if (!Flags.trample.isGlobalyEnabled()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(block.getWorld())) {
            return;
        }
        CMIMaterial mat = CMIMaterial.get(block);
        Entity entity = event.getEntity();
        FlagPermissions perms = this.plugin.getPermsByLoc(block.getLocation());
        boolean hastrample = perms.has(Flags.trample, perms.has(Flags.build, true));
        if (!hastrample && entity.getType() != EntityType.FALLING_BLOCK && (mat.equals((Object)CMIMaterial.FARMLAND) || mat.equals((Object)CMIMaterial.SOUL_SAND))) {
            event.setCancelled(true);
        }
    }

    public static boolean isMonster(Entity ent) {
        return ent instanceof Monster || ent instanceof Slime || ent instanceof Ghast;
    }

    private static boolean isTamed(Entity ent) {
        return ent instanceof Tameable ? ((Tameable)ent).isTamed() : false;
    }

    private static boolean damageableProjectile(Entity ent) {
        if (ent instanceof Projectile && ent.getType().toString().equalsIgnoreCase("Splash_potion")) {
            for (PotionEffect one : ((ThrownPotion)ent).getEffects()) {
                for (String oneHarm : Residence.getInstance().getConfigManager().getNegativePotionEffects()) {
                    if (!oneHarm.equalsIgnoreCase(one.getType().getName())) continue;
                    return true;
                }
            }
        }
        return ent instanceof Arrow || ent instanceof Projectile && ent.getType().toString().equalsIgnoreCase("Trident");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKilling(EntityDamageByEntityEvent event) {
        if (!Flags.animalkilling.isGlobalyEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        if (!ResidenceEntityListener.damageableProjectile(damager) && !(damager instanceof Player)) {
            return;
        }
        if (ResidenceEntityListener.damageableProjectile(damager) && !(((Projectile)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Projectile)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (this.plugin.isResAdminOn(cause)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        if (res.getPermissions().playerHas(cause, Flags.animalkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)cause, lm.Residence_FlagDeny, new Object[]{Flags.animalkilling, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalKillingByFlame(EntityCombustByEntityEvent event) {
        if (!Flags.animalkilling.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        Entity damager = event.getCombuster();
        if (!ResidenceEntityListener.damageableProjectile(damager) && !(damager instanceof Player)) {
            return;
        }
        if (ResidenceEntityListener.damageableProjectile(damager) && !(((Projectile)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Projectile)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (this.plugin.isResAdminOn(cause)) {
            return;
        }
        if (res.getPermissions().playerHas(cause, Flags.animalkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)cause, lm.Residence_FlagDeny, new Object[]{Flags.animalkilling, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalDamageByMobs(EntityDamageByEntityEvent event) {
        FlagPermissions world;
        if (!Flags.animalkilling.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player || damager instanceof Player) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(entity.getLocation());
        if (!perms.has(Flags.animalkilling, (world = this.plugin.getWorldFlags().getPerms(entity.getWorld().getName())).has(Flags.animalkilling, true))) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void OnEntityDeath(EntityDeathEvent event) {
        if (!Flags.mobitemdrop.isGlobalyEnabled() && !Flags.mobexpdrop.isGlobalyEnabled()) {
            return;
        }
        LivingEntity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (ent instanceof Player) {
            return;
        }
        Location loc = ent.getLocation();
        FlagPermissions perms = this.plugin.getPermsByLoc(loc);
        if (!perms.has(Flags.mobitemdrop, true)) {
            event.getDrops().clear();
        }
        if (!perms.has(Flags.mobexpdrop, true)) {
            event.setDroppedExp(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void VehicleDestroy(VehicleDestroyEvent event) {
        FlagPermissions perms;
        if (!Flags.vehicledestroy.isGlobalyEnabled()) {
            return;
        }
        Entity damager = event.getAttacker();
        if (damager == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(damager.getWorld())) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (vehicle == null) {
            return;
        }
        if ((damager instanceof Projectile && !(((Projectile)damager).getShooter() instanceof Player) || !(damager instanceof Player)) && !(perms = this.plugin.getPermsByLoc(vehicle.getLocation())).has(Flags.vehicledestroy, true)) {
            event.setCancelled(true);
            return;
        }
        Player cause = null;
        if (damager instanceof Player) {
            cause = (Player)damager;
        } else if (damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player) {
            cause = (Player)((Projectile)damager).getShooter();
        }
        if (cause == null) {
            return;
        }
        if (this.plugin.isResAdminOn(cause)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(vehicle.getLocation());
        if (res == null) {
            return;
        }
        if (res.getPermissions().playerHas(cause, Flags.vehicledestroy, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)cause, lm.Residence_FlagDeny, new Object[]{Flags.vehicledestroy, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void MonsterKilling(EntityDamageByEntityEvent event) {
        if (!Flags.mobkilling.isGlobalyEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(entity.getWorld())) {
            return;
        }
        if (!ResidenceEntityListener.isMonster(entity)) {
            return;
        }
        Entity damager = event.getDamager();
        if (!ResidenceEntityListener.damageableProjectile(damager) && !(damager instanceof Player)) {
            return;
        }
        if (ResidenceEntityListener.damageableProjectile(damager) && !(((Projectile)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Projectile)damager).getShooter();
        if (cause == null) {
            return;
        }
        if (this.plugin.isResAdminOn(cause)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        if (res.getPermissions().playerHas(cause, Flags.mobkilling, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)cause, lm.Residence_FlagDeny, new Object[]{Flags.mobkilling, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void AnimalLeash(PlayerLeashEntityEvent event) {
        if (!Flags.leash.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getEntity();
        if (!this.plugin.getNms().isAnimal(entity)) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        if (res.getPermissions().playerHas(player, Flags.leash, FlagPermissions.FlagCombo.OnlyFalse)) {
            this.plugin.msg((CommandSender)player, lm.Residence_FlagDeny, new Object[]{Flags.leash, res.getName()});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onWitherSpawn(CreatureSpawnEvent event) {
        if (!Flags.witherspawn.isGlobalyEnabled()) {
            return;
        }
        LivingEntity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (ent.getType() != EntityType.WITHER) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getLocation());
        if (perms.has(Flags.witherspawn, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPhantomSpawn(CreatureSpawnEvent event) {
        if (VersionChecker.Version.isCurrentLower(VersionChecker.Version.v1_13_R1)) {
            return;
        }
        if (!Flags.phantomspawn.isGlobalyEnabled()) {
            return;
        }
        LivingEntity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (ent.getType() != EntityType.PHANTOM) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getLocation());
        if (perms.has(Flags.phantomspawn, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        block20: {
            FlagPermissions perms;
            LivingEntity ent;
            block19: {
                ent = event.getEntity();
                if (ent == null) {
                    return;
                }
                if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
                    return;
                }
                perms = this.plugin.getPermsByLoc(event.getLocation());
                if (!this.plugin.getNms().isAnimal((Entity)ent)) break block19;
                if (!perms.has(Flags.animals, true)) {
                    event.setCancelled(true);
                    return;
                }
                switch (event.getSpawnReason()) {
                    case BUILD_WITHER: {
                        break;
                    }
                    case BUILD_SNOWMAN: 
                    case BUILD_IRONGOLEM: 
                    case CUSTOM: 
                    case DEFAULT: {
                        if (perms.has(Flags.canimals, FlagPermissions.FlagCombo.OnlyFalse)) {
                            event.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                    case NATURAL: 
                    case JOCKEY: 
                    case CHUNK_GEN: 
                    case EGG: 
                    case VILLAGE_DEFENSE: 
                    case VILLAGE_INVASION: 
                    case BREEDING: 
                    case NETHER_PORTAL: 
                    case DISPENSE_EGG: 
                    case CURED: 
                    case OCELOT_BABY: 
                    case MOUNT: {
                        if (perms.has(Flags.nanimals, FlagPermissions.FlagCombo.OnlyFalse)) {
                            event.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                    case SPAWNER: 
                    case SPAWNER_EGG: {
                        if (perms.has(Flags.sanimals, FlagPermissions.FlagCombo.OnlyFalse)) {
                            event.setCancelled(true);
                            return;
                        }
                        break block20;
                    }
                }
                break block20;
            }
            if (ResidenceEntityListener.isMonster((Entity)ent)) {
                if (perms.has(Flags.monsters, FlagPermissions.FlagCombo.OnlyFalse)) {
                    event.setCancelled(true);
                    return;
                }
                switch (event.getSpawnReason()) {
                    case BUILD_WITHER: 
                    case CUSTOM: 
                    case DEFAULT: {
                        if (!perms.has(Flags.cmonsters, FlagPermissions.FlagCombo.OnlyFalse)) break;
                        event.setCancelled(true);
                        return;
                    }
                    case NATURAL: 
                    case JOCKEY: 
                    case CHUNK_GEN: 
                    case LIGHTNING: 
                    case SLIME_SPLIT: 
                    case NETHER_PORTAL: 
                    case DISPENSE_EGG: 
                    case INFECTION: 
                    case CURED: 
                    case SILVERFISH_BLOCK: 
                    case MOUNT: {
                        if (!perms.has(Flags.nmonsters, FlagPermissions.FlagCombo.OnlyFalse)) break;
                        event.setCancelled(true);
                        return;
                    }
                    case SPAWNER: 
                    case SPAWNER_EGG: {
                        if (!perms.has(Flags.smonsters, FlagPermissions.FlagCombo.OnlyFalse)) break;
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(player.getWorld())) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(event.getEntity().getLocation(), player);
        if (!perms.playerHas(player, Flags.place, perms.playerHas(player, Flags.build, true))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.place});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (!Flags.shoot.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.getEntityType().equals((Object)EntityType.THROWN_EXP_BOTTLE)) {
            return;
        }
        if (event.getEntity().getShooter() instanceof Player && this.plugin.isResAdminOn((Player)event.getEntity().getShooter())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getEntity().getLocation());
        if (perms.has(Flags.shoot, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            if (event.getEntity().getShooter() instanceof Player) {
                this.plugin.msg((CommandSender)((Player)event.getEntity().getShooter()), lm.Flag_Deny, new Object[]{Flags.shoot});
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        Hanging ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (!(event.getRemover() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getRemover();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        if (this.plugin.getResidenceManager().isOwnerOfLocation(player, ent.getLocation())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(ent.getLocation(), player);
        if (!perms.playerHas(player, Flags.destroy, perms.playerHas(player, Flags.build, true))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreakEventByExplosion(HangingBreakEvent event) {
        Hanging ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (!event.getCause().equals((Object)HangingBreakEvent.RemoveCause.EXPLOSION)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(ent.getLocation());
        if (perms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreakEvent(HangingBreakEvent event) {
        Hanging ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (!event.getEntity().getType().equals((Object)EntityType.ITEM_FRAME)) {
            return;
        }
        if (!event.getCause().equals((Object)HangingBreakEvent.RemoveCause.PHYSICS)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(ent.getLocation());
        if (!perms.has(Flags.destroy, perms.has(Flags.build, true))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onHangingBreakByEntity(HangingBreakByEntityEvent event) {
        Hanging ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        if (event.getRemover() instanceof Player) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(ent.getLocation());
        if (!perms.has(Flags.destroy, perms.has(Flags.build, true))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        if (!Flags.burn.isGlobalyEnabled()) {
            return;
        }
        Entity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(ent.getLocation());
        if (!perms.has(Flags.burn, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        Entity ent = event.getEntity();
        if (ent == null) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(ent.getWorld())) {
            return;
        }
        EntityType entity = event.getEntityType();
        FlagPermissions perms = this.plugin.getPermsByLoc(ent.getLocation());
        switch (entity) {
            case CREEPER: {
                if (!Flags.creeper.isGlobalyEnabled() || perms.has(Flags.creeper, perms.has(Flags.explode, true))) break;
                if (this.plugin.getConfigManager().isCreeperExplodeBelow()) {
                    if (ent.getLocation().getBlockY() >= this.plugin.getConfigManager().getCreeperExplodeBelowLevel()) {
                        event.setCancelled(true);
                        ent.remove();
                        break;
                    }
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
                    if (res == null) break;
                    event.setCancelled(true);
                    ent.remove();
                    break;
                }
                event.setCancelled(true);
                ent.remove();
                break;
            }
            case PRIMED_TNT: 
            case MINECART_TNT: {
                if (!Flags.tnt.isGlobalyEnabled() || perms.has(Flags.tnt, perms.has(Flags.explode, true))) break;
                if (this.plugin.getConfigManager().isTNTExplodeBelow()) {
                    if (ent.getLocation().getBlockY() >= this.plugin.getConfigManager().getTNTExplodeBelowLevel()) {
                        event.setCancelled(true);
                        ent.remove();
                        break;
                    }
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
                    if (res == null) break;
                    event.setCancelled(true);
                    ent.remove();
                    break;
                }
                event.setCancelled(true);
                ent.remove();
                break;
            }
            case FIREBALL: 
            case SMALL_FIREBALL: {
                if (!Flags.explode.isGlobalyEnabled() || !perms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !perms.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) break;
                event.setCancelled(true);
                ent.remove();
                break;
            }
            case WITHER_SKULL: {
                if (!Flags.explode.isGlobalyEnabled() || !perms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !perms.has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) break;
                event.setCancelled(true);
                ent.remove();
                break;
            }
            case WITHER: {
                break;
            }
            default: {
                if (!perms.has(Flags.destroy, FlagPermissions.FlagCombo.OnlyFalse)) break;
                event.setCancelled(true);
                ent.remove();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        FlagPermissions world;
        FlagPermissions perms;
        Boolean remove2;
        Boolean cancel;
        Entity ent;
        block43: {
            block44: {
                Location loc = event.getLocation();
                if (this.plugin.isDisabledWorldListener(loc.getWorld())) {
                    return;
                }
                if (event.isCancelled()) {
                    return;
                }
                ent = event.getEntity();
                cancel = false;
                remove2 = true;
                perms = this.plugin.getPermsByLoc(loc);
                world = this.plugin.getWorldFlags().getPerms(loc.getWorld().getName());
                if (ent == null) break block44;
                switch (event.getEntityType()) {
                    case CREEPER: {
                        ClaimedResidence res;
                        if (!Flags.creeper.isGlobalyEnabled()) break block43;
                        if (!perms.has(Flags.creeper, perms.has(Flags.explode, true))) {
                            if (this.plugin.getConfigManager().isCreeperExplodeBelow()) {
                                if (loc.getBlockY() >= this.plugin.getConfigManager().getCreeperExplodeBelowLevel()) {
                                    cancel = true;
                                    break;
                                }
                                res = this.plugin.getResidenceManager().getByLoc(loc);
                                if (res != null) {
                                    cancel = true;
                                    break;
                                }
                                break block43;
                            } else {
                                cancel = true;
                                break;
                            }
                        }
                        break block43;
                    }
                    case PRIMED_TNT: 
                    case MINECART_TNT: {
                        ClaimedResidence res;
                        if (Flags.tnt.isGlobalyEnabled()) {
                            if (!perms.has(Flags.tnt, perms.has(Flags.explode, true))) {
                                if (this.plugin.getConfigManager().isTNTExplodeBelow()) {
                                    if (loc.getBlockY() >= this.plugin.getConfigManager().getTNTExplodeBelowLevel()) {
                                        cancel = true;
                                        break;
                                    }
                                    res = this.plugin.getResidenceManager().getByLoc(loc);
                                    if (res != null) {
                                        cancel = true;
                                        break;
                                    }
                                    break block43;
                                } else {
                                    cancel = true;
                                    break;
                                }
                            }
                        }
                        break block43;
                    }
                    case FIREBALL: 
                    case SMALL_FIREBALL: {
                        if (!Flags.explode.isGlobalyEnabled()) {
                            return;
                        }
                        if (perms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) || perms.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) {
                            cancel = true;
                            break;
                        }
                        break block43;
                    }
                    case WITHER_SKULL: 
                    case WITHER: {
                        if (Flags.explode.isGlobalyEnabled()) {
                            if (perms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) || perms.has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) {
                                cancel = true;
                                break;
                            }
                        }
                        break block43;
                    }
                    case ENDER_DRAGON: {
                        remove2 = false;
                        break;
                    }
                    default: {
                        if (!perms.has(Flags.destroy, world.has(Flags.destroy, true))) {
                            cancel = true;
                            remove2 = false;
                            break;
                        }
                        break block43;
                    }
                }
                break block43;
            }
            if (!perms.has(Flags.destroy, world.has(Flags.destroy, true))) {
                cancel = true;
            }
        }
        if (cancel.booleanValue()) {
            event.setCancelled(true);
            if (ent != null && remove2.booleanValue() && !event.getEntityType().equals((Object)EntityType.WITHER)) {
                ent.remove();
            }
            return;
        }
        ArrayList<Block> preserve = new ArrayList<Block>();
        block15: for (Block block : event.blockList()) {
            FlagPermissions blockperms = this.plugin.getPermsByLoc(block.getLocation());
            if (ent != null) {
                switch (event.getEntityType()) {
                    case CREEPER: {
                        ClaimedResidence res;
                        if (!Flags.creeper.isGlobalyEnabled()) continue block15;
                        if (blockperms.has(Flags.creeper, blockperms.has(Flags.explode, true))) continue block15;
                        if (this.plugin.getConfigManager().isCreeperExplodeBelow()) {
                            if (block.getY() >= this.plugin.getConfigManager().getCreeperExplodeBelowLevel()) {
                                preserve.add(block);
                                break;
                            }
                            res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
                            if (res == null) continue block15;
                            preserve.add(block);
                            break;
                        }
                        preserve.add(block);
                        break;
                    }
                    case PRIMED_TNT: 
                    case MINECART_TNT: {
                        ClaimedResidence res;
                        if (!Flags.tnt.isGlobalyEnabled()) continue block15;
                        if (blockperms.has(Flags.tnt, blockperms.has(Flags.explode, true))) continue block15;
                        if (this.plugin.getConfigManager().isTNTExplodeBelow()) {
                            if (block.getY() >= this.plugin.getConfigManager().getTNTExplodeBelowLevel()) {
                                preserve.add(block);
                                break;
                            }
                            res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
                            if (res == null) continue block15;
                            preserve.add(block);
                            break;
                        }
                        preserve.add(block);
                        break;
                    }
                    case ENDER_DRAGON: {
                        if (!Flags.dragongrief.isGlobalyEnabled()) continue block15;
                        if (!blockperms.has(Flags.dragongrief, FlagPermissions.FlagCombo.OnlyFalse)) continue block15;
                        preserve.add(block);
                        break;
                    }
                    case ENDER_CRYSTAL: {
                        if (!Flags.explode.isGlobalyEnabled()) continue block15;
                        if (!blockperms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse)) continue block15;
                        preserve.add(block);
                        break;
                    }
                    case FIREBALL: 
                    case SMALL_FIREBALL: {
                        if (!Flags.explode.isGlobalyEnabled()) continue block15;
                        if (!blockperms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !perms.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) continue block15;
                        preserve.add(block);
                        break;
                    }
                    case WITHER_SKULL: 
                    case WITHER: {
                        if (!Flags.explode.isGlobalyEnabled()) continue block15;
                        if (!blockperms.has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse) && !blockperms.has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) continue block15;
                        preserve.add(block);
                        break;
                    }
                    default: {
                        if (!blockperms.has(Flags.destroy, FlagPermissions.FlagCombo.OnlyFalse)) continue block15;
                        preserve.add(block);
                        break;
                    }
                }
                continue;
            }
            if (blockperms.has(Flags.destroy, world.has(Flags.destroy, true))) continue;
            preserve.add(block);
        }
        for (Block block : preserve) {
            event.blockList().remove(block);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSplashPotion(EntityChangeBlockEvent event) {
        if (!Flags.witherdestruction.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity ent = event.getEntity();
        if (ent.getType() != EntityType.WITHER) {
            return;
        }
        if (!this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.witherdestruction, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSplashPotion(PotionSplashEvent event) {
        if (!Flags.pvp.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        ProjectileSource shooter = event.getPotion().getShooter();
        if (shooter instanceof Witch) {
            return;
        }
        boolean harmfull = false;
        block0: for (PotionEffect one : event.getPotion().getEffects()) {
            for (String oneHarm : this.plugin.getConfigManager().getNegativePotionEffects()) {
                if (!oneHarm.equalsIgnoreCase(one.getType().getName())) continue;
                harmfull = true;
                break block0;
            }
        }
        if (!harmfull) {
            return;
        }
        ThrownPotion ent = event.getEntity();
        boolean srcpvp = this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
        for (LivingEntity target : event.getAffectedEntities()) {
            if (target.getType() != EntityType.PLAYER) continue;
            Boolean tgtpvp = this.plugin.getPermsByLoc(target.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
            if (!srcpvp || !tgtpvp.booleanValue()) {
                event.setIntensity(target, 0.0);
                continue;
            }
            ClaimedResidence area2 = this.plugin.getResidenceManager().getByLoc(target.getLocation());
            if (!(target instanceof Player) || !(shooter instanceof Player)) continue;
            Player attacker = null;
            if (shooter instanceof Player) {
                attacker = (Player)shooter;
            }
            if (attacker == null) continue;
            if (!(target instanceof Player)) {
                return;
            }
            ClaimedResidence srcarea = this.plugin.getResidenceManager().getByLoc(attacker.getLocation());
            if (srcarea == null || area2 == null || !srcarea.equals(area2) || !srcarea.getPermissions().playerHas((Player)target, Flags.friendlyfire, FlagPermissions.FlagCombo.OnlyFalse) || !srcarea.getPermissions().playerHas(attacker, Flags.friendlyfire, FlagPermissions.FlagCombo.OnlyFalse)) continue;
            ActionBarTitleMessages.send(attacker, this.plugin.getLM().getMessage(lm.General_NoFriendlyFire, new Object[0]));
            event.setIntensity(target, 0.0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PlayerKillingByFlame(EntityCombustByEntityEvent event) {
        if (!Flags.pvp.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(entity.getLocation());
        if (res == null) {
            return;
        }
        Entity damager = event.getCombuster();
        if (!ResidenceEntityListener.damageableProjectile(damager) && !(damager instanceof Player)) {
            return;
        }
        if (ResidenceEntityListener.damageableProjectile(damager) && !(((Projectile)damager).getShooter() instanceof Player)) {
            return;
        }
        Player cause = null;
        cause = damager instanceof Player ? (Player)damager : (Player)((Projectile)damager).getShooter();
        if (cause == null) {
            return;
        }
        Boolean srcpvp = this.plugin.getPermsByLoc(cause.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
        Boolean tgtpvp = this.plugin.getPermsByLoc(entity.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
        if (!srcpvp.booleanValue() || !tgtpvp.booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void OnFallDamage(EntityDamageEvent event) {
        if (!Flags.falldamage.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Entity ent = event.getEntity();
        if (!(ent instanceof Player)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.falldamage, FlagPermissions.FlagCombo.TrueOrNone)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void OnArmorStandFlameDamage(EntityDamageEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK) {
            return;
        }
        Entity ent = event.getEntity();
        if (!this.plugin.getNms().isArmorStandEntity(ent.getType()) && !(ent instanceof Arrow)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.destroy, true)) {
            event.setCancelled(true);
            ent.setFireTicks(0);
        }
    }

    @EventHandler
    public void OnArmorStandExplosion(EntityDamageEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        Entity ent = event.getEntity();
        if (!this.plugin.getNms().isArmorStandEntity(ent.getType()) && !(ent instanceof Arrow)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.destroy, true)) {
            event.setCancelled(true);
            ent.setFireTicks(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityCatchingFire(EntityDamageByEntityEvent event) {
        if (!Flags.pvp.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (!ResidenceEntityListener.damageableProjectile(event.getDamager())) {
            return;
        }
        if (event.getEntity() == null || !(event.getEntity() instanceof Player)) {
            return;
        }
        Projectile projectile = (Projectile)event.getDamager();
        FlagPermissions perms = this.plugin.getPermsByLoc(projectile.getLocation());
        if (!perms.has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
            projectile.setFireTicks(0);
        }
    }

    @EventHandler
    public void OnPlayerDamageByLightning(EntityDamageEvent event) {
        if (!Flags.pvp.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.LIGHTNING) {
            return;
        }
        Entity ent = event.getEntity();
        if (!(ent instanceof Player)) {
            return;
        }
        if (!this.plugin.getPermsByLoc(ent.getLocation()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByFireballEvent(EntityDamageByEntityEvent event) {
        if (!Flags.fireball.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity dmgr = event.getDamager();
        if (dmgr.getType() != EntityType.SMALL_FIREBALL && dmgr.getType() != EntityType.FIREBALL) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getEntity().getLocation());
        if (perms.has(Flags.fireball, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByWitherEvent(EntityDamageByEntityEvent event) {
        if (!Flags.witherdamage.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity dmgr = event.getDamager();
        if (dmgr.getType() != EntityType.WITHER && dmgr.getType() != EntityType.WITHER_SKULL) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getEntity().getLocation());
        if (perms.has(Flags.witherdamage, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        ItemFrame it;
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntityType() != EntityType.ENDER_CRYSTAL && event.getEntityType() != EntityType.ITEM_FRAME && !this.plugin.getNms().isArmorStandEntity(event.getEntityType())) {
            return;
        }
        Entity dmgr = event.getDamager();
        Player player = null;
        if (dmgr instanceof Player) {
            player = (Player)event.getDamager();
        } else if (dmgr instanceof Projectile && ((Projectile)dmgr).getShooter() instanceof Player) {
            player = (Player)((Projectile)dmgr).getShooter();
        } else {
            FlagPermissions perms;
            if (dmgr instanceof Projectile && !(((Projectile)dmgr).getShooter() instanceof Player)) {
                Location loc = event.getEntity().getLocation();
                FlagPermissions perm = this.plugin.getPermsByLoc(loc);
                if (perm.has(Flags.destroy, FlagPermissions.FlagCombo.OnlyFalse)) {
                    event.setCancelled(true);
                }
                return;
            }
            if (dmgr.getType() == EntityType.PRIMED_TNT || dmgr.getType() == EntityType.MINECART_TNT) {
                if (Flags.explode.isGlobalyEnabled() && (perms = this.plugin.getPermsByLoc(event.getEntity().getLocation())).has(Flags.explode, FlagPermissions.FlagCombo.OnlyFalse)) {
                    event.setCancelled(true);
                    return;
                }
            } else if ((dmgr.getType() == EntityType.WITHER_SKULL || dmgr.getType() == EntityType.WITHER) && Flags.witherdamage.isGlobalyEnabled() && (perms = this.plugin.getPermsByLoc(event.getEntity().getLocation())).has(Flags.witherdamage, FlagPermissions.FlagCombo.OnlyFalse)) {
                event.setCancelled(true);
                return;
            }
        }
        Location loc = event.getEntity().getLocation();
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(loc);
        if (res == null) {
            return;
        }
        if (ResidenceEntityListener.isMonster(dmgr) && !res.getPermissions().has(Flags.destroy, false)) {
            event.setCancelled(true);
            return;
        }
        if (player == null) {
            return;
        }
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(loc, player);
        if (event.getEntityType() == EntityType.ITEM_FRAME && (it = (ItemFrame)event.getEntity()).getItem() != null) {
            if (!perms.playerHas(player, Flags.container, true)) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
            }
            return;
        }
        if (!perms.playerHas(player, Flags.destroy, perms.playerHas(player, Flags.build, true))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        Entity ent = event.getEntity();
        if (ent.hasMetadata("NPC")) {
            return;
        }
        boolean tamedAnimal = ResidenceEntityListener.isTamed(ent);
        ClaimedResidence area2 = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent attackevent = (EntityDamageByEntityEvent)event;
            Entity damager = attackevent.getDamager();
            if (area2 != null && ent instanceof Player && damager instanceof Player && (area2.getPermissions().has(Flags.overridepvp, false) || this.plugin.getConfigManager().isOverridePvp() && area2.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.OnlyFalse))) {
                Player player;
                Player damage = player = (Player)event.getEntity();
                damage.damage(event.getDamage());
                damage.setVelocity(damager.getLocation().getDirection());
                event.setCancelled(true);
                return;
            }
            ClaimedResidence srcarea = null;
            if (damager != null) {
                srcarea = this.plugin.getResidenceManager().getByLoc(damager.getLocation());
            }
            boolean srcpvp = true;
            boolean allowSnowBall = false;
            boolean isSnowBall = false;
            boolean isOnFire = false;
            if (srcarea != null) {
                srcpvp = srcarea.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone);
            }
            if (((ent = attackevent.getEntity()) instanceof Player || tamedAnimal) && (damager instanceof Player || damager instanceof Projectile && ((Projectile)damager).getShooter() instanceof Player) && event.getCause() != EntityDamageEvent.DamageCause.FALL) {
                Player attacker = null;
                if (damager instanceof Player) {
                    attacker = (Player)damager;
                } else if (damager instanceof Projectile) {
                    Projectile project = (Projectile)damager;
                    if (project.getType() == EntityType.SNOWBALL && srcarea != null) {
                        isSnowBall = true;
                        allowSnowBall = srcarea.getPermissions().has(Flags.snowball, FlagPermissions.FlagCombo.TrueOrNone);
                    }
                    if (project.getFireTicks() > 0) {
                        isOnFire = true;
                    }
                    attacker = (Player)((Projectile)damager).getShooter();
                }
                if (!(ent instanceof Player)) {
                    return;
                }
                if (srcarea != null && area2 != null && srcarea.equals(area2) && attacker != null && area2.isUnderRaid() && area2.getRaid().onSameTeam(attacker, (Player)ent) && !ConfigManager.RaidFriendlyFire) {
                    event.setCancelled(true);
                }
                if (srcarea != null && area2 != null && srcarea.equals(area2) && attacker != null && area2.isUnderRaid() && !area2.getRaid().onSameTeam(attacker, (Player)ent)) {
                    return;
                }
                if (srcarea != null && area2 != null && srcarea.equals(area2) && attacker != null && srcarea.getPermissions().playerHas((Player)ent, Flags.friendlyfire, FlagPermissions.FlagCombo.OnlyFalse) && srcarea.getPermissions().playerHas(attacker, Flags.friendlyfire, FlagPermissions.FlagCombo.OnlyFalse)) {
                    ActionBarTitleMessages.send(attacker, this.plugin.getLM().getMessage(lm.General_NoFriendlyFire, new Object[0]));
                    if (isOnFire) {
                        ent.setFireTicks(0);
                    }
                    event.setCancelled(true);
                }
                if (!srcpvp && !isSnowBall || !allowSnowBall && isSnowBall) {
                    if (attacker != null) {
                        this.plugin.msg((CommandSender)attacker, lm.General_NoPVPZone, new Object[0]);
                    }
                    if (isOnFire) {
                        ent.setFireTicks(0);
                    }
                    event.setCancelled(true);
                    return;
                }
                if (area2 == null) {
                    FlagPermissions aPerm;
                    if (damager != null && !this.plugin.getWorldFlags().getPerms(damager.getWorld().getName()).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
                        if (attacker != null) {
                            this.plugin.msg((CommandSender)attacker, lm.General_WorldPVPDisabled, new Object[0]);
                        }
                        if (isOnFire) {
                            ent.setFireTicks(0);
                        }
                        event.setCancelled(true);
                        return;
                    }
                    if (attacker != null && !(aPerm = this.plugin.getPermsByLoc(attacker.getLocation())).has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone)) {
                        this.plugin.msg((CommandSender)attacker, lm.General_NoPVPZone, new Object[0]);
                        if (isOnFire) {
                            ent.setFireTicks(0);
                        }
                        event.setCancelled(true);
                        return;
                    }
                } else if (!isSnowBall && !area2.getPermissions().has(Flags.pvp, FlagPermissions.FlagCombo.TrueOrNone) || isSnowBall && !allowSnowBall) {
                    if (attacker != null) {
                        this.plugin.msg((CommandSender)attacker, lm.General_NoPVPZone, new Object[0]);
                    }
                    if (isOnFire) {
                        ent.setFireTicks(0);
                    }
                    event.setCancelled(true);
                    return;
                }
                return;
            }
            if ((ent instanceof Player || tamedAnimal) && damager instanceof Creeper) {
                if (area2 == null && !this.plugin.getWorldFlags().getPerms(damager.getWorld().getName()).has(Flags.creeper, true)) {
                    event.setCancelled(true);
                } else if (area2 != null && !area2.getPermissions().has(Flags.creeper, true)) {
                    event.setCancelled(true);
                }
            }
        }
        if (area2 == null) {
            if (!this.plugin.getWorldFlags().getPerms(ent.getWorld().getName()).has(Flags.damage, true) && (ent instanceof Player || tamedAnimal)) {
                event.setCancelled(true);
            }
        } else if (!area2.getPermissions().has(Flags.damage, true) && (ent instanceof Player || tamedAnimal)) {
            event.setCancelled(true);
        }
        if (event.isCancelled() && (ent instanceof Player || tamedAnimal) && (event.getCause() == EntityDamageEvent.DamageCause.FIRE || event.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK)) {
            ent.setFireTicks(0);
        }
    }
}

