/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.cmiLib.ActionBarTitleMessages;
import com.bekvon.bukkit.cmiLib.CMIBlock;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.VersionChecker;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.commands.auto;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ResidenceBlockListener
implements Listener {
    private List<String> MessageInformed = new ArrayList<String>();
    private Set<UUID> ResCreated = new HashSet<UUID>();
    public static Set<UUID> newPlayers = new HashSet<UUID>();
    private Residence plugin;
    public static final String SourceResidenceName = "SourceResidenceName";

    public ResidenceBlockListener(Residence residence) {
        this.plugin = residence;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onAnvilInventoryClick(InventoryClickEvent e) {
        if (!Flags.anvilbreak.isGlobalyEnabled()) {
            return;
        }
        Inventory inv = e.getInventory();
        try {
            if (inv == null || inv.getType() != InventoryType.ANVIL || e.getInventory().getLocation() == null) {
                return;
            }
        }
        catch (Exception | NoSuchMethodError ex) {
            return;
        }
        Block b = e.getInventory().getLocation().getBlock();
        if (b == null || !CMIMaterial.isAnvil(b.getType())) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(e.getInventory().getLocation());
        if (res == null) {
            return;
        }
        if (e.getRawSlot() != 2) {
            return;
        }
        if (e.getCurrentItem() == null || e.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (!res.getPermissions().has(Flags.anvilbreak, FlagPermissions.FlagCombo.OnlyFalse)) {
            return;
        }
        if (VersionChecker.Version.isCurrentLower(VersionChecker.Version.v1_13_R1)) {
            try {
                b.getClass().getMethod("setData", Byte.TYPE).invoke((Object)b, (byte)1);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
        } else {
            b.setType(CMIMaterial.ANVIL.getMaterial());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlantGrow(BlockGrowEvent event) {
        if (!Flags.grow.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.grow, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onVineGrow(BlockSpreadEvent event) {
        if (!Flags.grow.isGlobalyEnabled()) {
            return;
        }
        if (event.getSource().getType() != Material.VINE) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.grow, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onleaveDecay(LeavesDecayEvent event) {
        if (!Flags.decay.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.decay, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onTreeGrowt(StructureGrowEvent event) {
        if (!Flags.grow.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getLocation());
        if (!perms.has(Flags.grow, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onTreeGrow(StructureGrowEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getWorld())) {
            return;
        }
        ClaimedResidence startRes = this.plugin.getResidenceManager().getByLoc(event.getLocation());
        List blocks = event.getBlocks();
        int i = 0;
        for (BlockState one : blocks) {
            ClaimedResidence targetRes = this.plugin.getResidenceManager().getByLoc(one.getLocation());
            if (startRes == null && targetRes != null || targetRes != null && startRes != null && !startRes.getName().equals(targetRes.getName()) && !startRes.isOwner(targetRes.getOwner())) {
                BlockState matas = (BlockState)blocks.get(i);
                matas.setType(Material.AIR);
                blocks.set(i, matas);
            }
            ++i;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = event.getBlock();
        Material mat = block.getType();
        String world = block.getWorld().getName();
        ResidencePlayer resPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = resPlayer.getGroup();
        if (this.plugin.getItemManager().isIgnored(mat, group, world)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (res != null && res.getItemIgnoreList().isListed(mat)) {
            return;
        }
        if (this.plugin.getConfigManager().enabledRentSystem() && res != null && this.plugin.getConfigManager().preventRentModify() && res.isRented()) {
            this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
            event.setCancelled(true);
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        boolean hasdestroy = perms.playerHas(player, Flags.destroy, perms.playerHas(player, Flags.build, true));
        if (res != null && res.isUnderRaid() && (res.getRaid().isAttacker(player.getUniqueId()) && ConfigManager.RaidAttackerBlockBreak || res.getRaid().isDefender(player.getUniqueId()) && ConfigManager.RaidDefenderBlockBreak)) {
            hasdestroy = true;
        }
        if (!hasdestroy) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.destroy});
            event.setCancelled(true);
        } else if (mat == Material.CHEST && !perms.playerHas(player, Flags.container, true)) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.container});
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        FlagPermissions perms;
        if (!Flags.snowtrail.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!(event instanceof EntityBlockFormEvent)) {
            return;
        }
        if (((EntityBlockFormEvent)event).getEntity() instanceof Snowman && !(perms = this.plugin.getPermsByLoc(event.getBlock().getLocation())).has(Flags.snowtrail, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onIceForm(BlockFormEvent event) {
        if (!Flags.iceform.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Material ice = Material.getMaterial((String)"FROSTED_ICE");
        if (event.getNewState().getType() != Material.SNOW && event.getNewState().getType() != Material.ICE && ice != null && ice != event.getNewState().getType()) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.iceform, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onIceMelt(BlockFadeEvent event) {
        if (!Flags.icemelt.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!CMIMaterial.get(event.getNewState().getType()).equals((Object)CMIMaterial.WATER) && event.getBlock().getState().getType() != Material.SNOW && event.getBlock().getState().getType() != Material.SNOW_BLOCK) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.icemelt, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (!Flags.fallinprotection.isGlobalyEnabled()) {
            return;
        }
        if (event.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        Entity ent = event.getEntity();
        if (!ent.hasMetadata(SourceResidenceName)) {
            ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
            String resName = res == null ? "NULL" : res.getName();
            ent.setMetadata(SourceResidenceName, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)resName));
        } else {
            String resName;
            String saved = ((MetadataValue)ent.getMetadata(SourceResidenceName).get(0)).asString();
            ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(ent.getLocation());
            if (res != null && res.getPermissions().has(Flags.fallinprotection, FlagPermissions.FlagCombo.OnlyFalse)) {
                return;
            }
            String string = resName = res == null ? "NULL" : res.getName();
            if (!saved.equalsIgnoreCase(resName)) {
                event.setCancelled(true);
                ent.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockFall(EntityChangeBlockEvent event) {
        if (!Flags.fallinprotection.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isBlockFall()) {
            return;
        }
        if (event.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        if (event.getTo().hasGravity()) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        if (!this.plugin.getConfigManager().getBlockFallWorlds().contains(block.getLocation().getWorld().getName())) {
            return;
        }
        if (block.getY() <= this.plugin.getConfigManager().getBlockFallLevel()) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        Location loc = new Location(block.getLocation().getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
        int i = loc.getBlockY() - 1;
        while (i >= this.plugin.getConfigManager().getBlockFallLevel() - 1) {
            block12: {
                block13: {
                    ClaimedResidence targetRes;
                    loc.setY((double)i);
                    if (loc.getBlock().getType() == Material.AIR || (targetRes = this.plugin.getResidenceManager().getByLoc(loc)) == null) break block12;
                    if (res == null || res.getName().equals(targetRes.getName())) break block13;
                    if (targetRes.getPermissions().has(Flags.fallinprotection, FlagPermissions.FlagCombo.OnlyFalse)) break block12;
                    event.setCancelled(true);
                    block.setType(Material.AIR);
                }
                return;
            }
            --i;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChestPlace(BlockPlaceEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().ShowNoobMessage()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) {
            return;
        }
        if (this.plugin.getPlayerManager().getResidenceCount(player.getUniqueId()) != 0) {
            return;
        }
        if (this.MessageInformed.contains(player.getName())) {
            return;
        }
        if (!PermissionManager.ResPerm.newguyresidence.hasPermission((CommandSender)player)) {
            return;
        }
        this.plugin.msg((CommandSender)player, lm.General_NewPlayerInfo, new Object[0]);
        this.MessageInformed.add(player.getName());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onChestPlaceNearResidence(BlockPlaceEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) {
            return;
        }
        ClaimedResidence orRes = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        boolean cancel = false;
        ClaimedResidence res = null;
        Block b = block.getLocation().clone().add(0.0, 0.0, -1.0).getBlock();
        if (b.getType() == block.getType() && (res = this.plugin.getResidenceManager().getByLoc(b.getLocation())) != null && !res.equals(orRes)) {
            cancel = true;
        }
        if ((b = block.getLocation().clone().add(0.0, 0.0, 1.0).getBlock()).getType() == block.getType() && (res = this.plugin.getResidenceManager().getByLoc(b.getLocation())) != null && !res.equals(orRes)) {
            cancel = true;
        }
        if ((b = block.getLocation().clone().add(1.0, 0.0, 0.0).getBlock()).getType() == block.getType() && (res = this.plugin.getResidenceManager().getByLoc(b.getLocation())) != null && !res.equals(orRes)) {
            cancel = true;
        }
        if ((b = block.getLocation().clone().add(-1.0, 0.0, 0.0).getBlock()).getType() == block.getType() && (res = this.plugin.getResidenceManager().getByLoc(b.getLocation())) != null && !res.equals(orRes)) {
            cancel = true;
        }
        if (cancel) {
            ActionBarTitleMessages.send(player, this.plugin.msg(lm.General_CantPlaceChest, new Object[0]));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChestPlaceCreateRes(BlockPlaceEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!this.plugin.getConfigManager().isNewPlayerUse()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.CHEST && block.getType() != Material.TRAPPED_CHEST) {
            return;
        }
        if (this.plugin.getPlayerManager().getResidenceCount(player.getUniqueId()) != 0) {
            return;
        }
        if (this.ResCreated.contains(player.getUniqueId())) {
            return;
        }
        if (!newPlayers.contains(player.getUniqueId())) {
            return;
        }
        Location loc = block.getLocation();
        this.plugin.getSelectionManager().placeLoc1(player, new Location(loc.getWorld(), (double)(loc.getBlockX() - 1), (double)(loc.getBlockY() - 1), (double)(loc.getBlockZ() - 1)), true);
        this.plugin.getSelectionManager().placeLoc2(player, new Location(loc.getWorld(), (double)(loc.getBlockX() + 1), (double)(loc.getBlockY() + 1), (double)(loc.getBlockZ() + 1)), true);
        ResidenceBlockListener.resize(this.plugin, player, this.plugin.getSelectionManager().getSelectionCuboid(player), !this.plugin.getConfigManager().isNewPlayerFree(), this.plugin.getConfigManager().getNewPlayerRangeX() * 2, this.plugin.getConfigManager().getNewPlayerRangeY() * 2, this.plugin.getConfigManager().getNewPlayerRangeZ() * 2);
        boolean created = this.plugin.getResidenceManager().addResidence(player, player.getName(), this.plugin.getSelectionManager().getPlayerLoc1(player), this.plugin.getSelectionManager().getPlayerLoc2(player), this.plugin.getConfigManager().isNewPlayerFree());
        if (created) {
            this.ResCreated.add(player.getUniqueId());
            newPlayers.remove(player.getUniqueId());
        }
    }

    public static void resize(Residence plugin, Player player, CuboidArea cuboid, boolean checkBalance, int maxX, int maxY, int maxZ) {
        ResidencePlayer rPlayer = plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        double cost = cuboid.getCost(group);
        double balance = 0.0;
        if (plugin.getEconomyManager() != null) {
            balance = plugin.getEconomyManager().getBalance(player.getName());
        }
        auto.direction dir = auto.direction.Top;
        ArrayList<auto.direction> locked = new ArrayList<auto.direction>();
        boolean checkCollision = plugin.getConfigManager().isAutomaticResidenceCreationCheckCollision();
        int skipped = 0;
        int done = 0;
        while (skipped < 6 && ++done <= 10000) {
            if (locked.contains((Object)dir)) {
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            CuboidArea c = new CuboidArea();
            c.setLowLocation(cuboid.getLowLoc().clone().add(-dir.getLow().getX(), -dir.getLow().getY(), -dir.getLow().getZ()));
            c.setHighLocation(cuboid.getHighLoc().clone().add(dir.getHigh().getX(), dir.getHigh().getY(), dir.getHigh().getZ()));
            if (c.getLowLoc().getY() < 0.0) {
                c.getLowLoc().setY(0.0);
                locked.add(dir);
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            if (c.getHighLoc().getY() >= (double)c.getWorld().getMaxHeight()) {
                c.getHighLoc().setY((double)(c.getWorld().getMaxHeight() - 1));
                locked.add(dir);
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            if (checkCollision && plugin.getResidenceManager().collidesWithResidence(c) != null) {
                locked.add(dir);
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            if (c.getXSize() >= maxX - group.getMinX()) {
                locked.add(dir);
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            if (c.getYSize() >= maxY - group.getMinY()) {
                locked.add(dir);
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            if (c.getZSize() >= maxZ - group.getMinZ()) {
                locked.add(dir);
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            skipped = 0;
            if (checkBalance && plugin.getConfigManager().enableEconomy() && (cost = c.getCost(group)) > balance) break;
            cuboid.setLowLocation(c.getLowLoc());
            cuboid.setHighLocation(c.getHighLoc());
            dir = dir.getNext();
        }
        plugin.getSelectionManager().placeLoc1(player, cuboid.getLowLoc());
        plugin.getSelectionManager().placeLoc2(player, cuboid.getHighLoc());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        CMIBlock cb;
        Block sec;
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.isResAdminOn(player)) {
            return;
        }
        Block block = event.getBlock();
        Material mat = block.getType();
        String world = block.getWorld().getName();
        ResidencePlayer resPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = resPlayer.getGroup();
        if (this.plugin.getItemManager().isIgnored(mat, group, world)) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(block.getLocation());
        if (this.plugin.getConfigManager().enabledRentSystem() && res != null) {
            String resname = res.getName();
            if (this.plugin.getConfigManager().preventRentModify() && this.plugin.getRentManager().isRented(resname)) {
                this.plugin.msg((CommandSender)player, lm.Rent_ModifyDeny, new Object[0]);
                event.setCancelled(true);
                return;
            }
        }
        if (res != null && !res.getItemBlacklist().isAllowed(mat)) {
            this.plugin.msg((CommandSender)player, lm.General_ItemBlacklisted, new Object[0]);
            event.setCancelled(true);
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(block.getLocation(), player);
        boolean hasplace = perms.playerHas(player, Flags.place, perms.playerHas(player, Flags.build, true));
        if (res != null && res.isUnderRaid() && (res.getRaid().isAttacker(player.getUniqueId()) && ConfigManager.RaidAttackerBlockPlace || res.getRaid().isDefender(player.getUniqueId()) && ConfigManager.RaidDefenderBlockPlace)) {
            hasplace = true;
        }
        if (!hasplace) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.place});
            return;
        }
        if (CMIMaterial.isBed(mat) && (sec = (cb = new CMIBlock(block)).getSecondaryBedBlock()) != null && !(hasplace = (perms = this.plugin.getPermsByLocForPlayer(sec.getLocation(), player)).playerHas(player, Flags.place, perms.playerHas(player, Flags.build, true)))) {
            event.setCancelled(true);
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.place});
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockSpread(BlockSpreadEvent event) {
        if (!Flags.spread.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Location loc = event.getBlock().getLocation();
        FlagPermissions perms = this.plugin.getPermsByLoc(loc);
        if (!perms.has(Flags.spread, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!Flags.piston.isGlobalyEnabled()) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.piston, true)) {
            event.setCancelled(true);
            return;
        }
        if (!Flags.pistonprotection.isGlobalyEnabled()) {
            return;
        }
        List<Block> blocks = this.plugin.getNms().getPistonRetractBlocks(event);
        if (!event.isSticky()) {
            return;
        }
        ClaimedResidence pistonRes = this.plugin.getResidenceManager().getByLoc(event.getBlock().getLocation());
        for (Block block : blocks) {
            Location locFrom = block.getLocation();
            ClaimedResidence blockFrom = this.plugin.getResidenceManager().getByLoc(locFrom);
            if (blockFrom == null || blockFrom == pistonRes || pistonRes != null && blockFrom.isOwner(pistonRes.getOwner()) || !blockFrom.getPermissions().has(Flags.pistonprotection, FlagPermissions.FlagCombo.OnlyTrue)) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!Flags.piston.isGlobalyEnabled()) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.piston, true)) {
            event.setCancelled(true);
            return;
        }
        if (!Flags.pistonprotection.isGlobalyEnabled()) {
            return;
        }
        ClaimedResidence pistonRes = this.plugin.getResidenceManager().getByLoc(event.getBlock().getLocation());
        BlockFace dir = event.getDirection();
        for (Block block : event.getBlocks()) {
            Location locFrom = block.getLocation();
            Location locTo = new Location(block.getWorld(), (double)(block.getX() + dir.getModX()), (double)(block.getY() + dir.getModY()), (double)(block.getZ() + dir.getModZ()));
            ClaimedResidence blockFrom = this.plugin.getResidenceManager().getByLoc(locFrom);
            ClaimedResidence blockTo = this.plugin.getResidenceManager().getByLoc(locTo);
            if (pistonRes == null && blockTo != null && blockTo.getPermissions().has(Flags.pistonprotection, FlagPermissions.FlagCombo.OnlyTrue)) {
                event.setCancelled(true);
                return;
            }
            if (blockTo != null && blockFrom == null && blockTo.getPermissions().has(Flags.pistonprotection, FlagPermissions.FlagCombo.OnlyTrue)) {
                event.setCancelled(true);
                return;
            }
            if (blockTo == null || blockFrom == null || (pistonRes == null || blockTo.isOwner(pistonRes.getOwner())) && blockTo.isOwner(blockFrom.getOwner()) || !blockTo.getPermissions().has(Flags.pistonprotection, FlagPermissions.FlagCombo.OnlyTrue)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        ClaimedResidence fromRes = this.plugin.getResidenceManager().getByLoc(event.getBlock().getLocation());
        ClaimedResidence toRes = this.plugin.getResidenceManager().getByLoc(event.getToBlock().getLocation());
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getToBlock().getLocation());
        boolean hasflow = perms.has(Flags.flow, FlagPermissions.FlagCombo.TrueOrNone);
        Material mat = event.getBlock().getType();
        if (perms.has(Flags.flowinprotection, FlagPermissions.FlagCombo.TrueOrNone) && (fromRes == null && toRes != null || fromRes != null && toRes != null && !fromRes.equals(toRes) && !fromRes.isOwner(toRes.getOwner()))) {
            event.setCancelled(true);
            return;
        }
        if (perms.has(Flags.flow, FlagPermissions.FlagCombo.OnlyFalse)) {
            event.setCancelled(true);
            return;
        }
        if (mat == Material.LAVA) {
            if (!perms.has(Flags.lavaflow, hasflow)) {
                event.setCancelled(true);
            }
            return;
        }
        if (mat == Material.WATER) {
            if (!perms.has(Flags.waterflow, hasflow)) {
                event.setCancelled(true);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLandDryFade(BlockFadeEvent event) {
        if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1)) {
            return;
        }
        if (!Flags.dryup.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        CMIMaterial mat = CMIMaterial.get(event.getBlock());
        if (!mat.equals((Object)CMIMaterial.FARMLAND)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getNewState().getLocation());
        if (!perms.has(Flags.dryup, true)) {
            Block b = event.getBlock();
            try {
                b.getClass().getMethod("setData", Byte.TYPE).invoke((Object)b, (byte)7);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLandDryPhysics(BlockPhysicsEvent event) {
        if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1)) {
            return;
        }
        if (!Flags.dryup.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (!event.getBlock().getWorld().isChunkLoaded((int)Math.floor(event.getBlock().getLocation().getX()) >> 4, (int)Math.floor(event.getBlock().getLocation().getZ()) >> 4)) {
            return;
        }
        CMIMaterial mat = CMIMaterial.get(event.getBlock());
        if (!mat.equals((Object)CMIMaterial.FARMLAND)) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (perms.has(Flags.dryup, FlagPermissions.FlagCombo.OnlyFalse)) {
            Block b = event.getBlock();
            try {
                b.getClass().getMethod("setData", Byte.TYPE).invoke((Object)b, (byte)7);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                e1.printStackTrace();
            }
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onDispense(BlockDispenseEvent event) {
        ClaimedResidence sourceres;
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Location location = new Location(event.getBlock().getWorld(), (double)event.getVelocity().getBlockX(), (double)event.getVelocity().getBlockY(), (double)event.getVelocity().getBlockZ());
        ClaimedResidence targetres = this.plugin.getResidenceManager().getByLoc(location);
        if (targetres == null && location.getBlockY() >= this.plugin.getConfigManager().getPlaceLevel() && this.plugin.getConfigManager().getNoPlaceWorlds().contains(location.getWorld().getName())) {
            ItemStack mat = event.getItem();
            if (this.plugin.getConfigManager().isNoLavaPlace() && mat.getType() == Material.LAVA_BUCKET) {
                event.setCancelled(true);
                return;
            }
            if (this.plugin.getConfigManager().isNoWaterPlace() && mat.getType() == Material.WATER_BUCKET) {
                event.setCancelled(true);
                return;
            }
        }
        if (((sourceres = this.plugin.getResidenceManager().getByLoc(event.getBlock().getLocation())) == null && targetres != null || sourceres != null && targetres == null || sourceres != null && targetres != null && !sourceres.getName().equals(targetres.getName())) && (event.getItem().getType() == Material.LAVA_BUCKET || event.getItem().getType() == Material.WATER_BUCKET)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onLavaWaterFlow(BlockFromToEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        Material mat = event.getBlock().getType();
        Location location = event.getToBlock().getLocation();
        if (!this.plugin.getConfigManager().getNoFlowWorlds().contains(location.getWorld().getName())) {
            return;
        }
        if (location.getBlockY() < this.plugin.getConfigManager().getFlowLevel()) {
            return;
        }
        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(location);
        if (res != null) {
            return;
        }
        if (this.plugin.getConfigManager().isNoLava() && mat == Material.LAVA) {
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getConfigManager().isNoWater() && mat == Material.WATER) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (!Flags.firespread.isGlobalyEnabled()) {
            return;
        }
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
        if (!perms.has(Flags.firespread, true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getBlock().getWorld())) {
            return;
        }
        BlockIgniteEvent.IgniteCause cause = event.getCause();
        if (cause == BlockIgniteEvent.IgniteCause.SPREAD) {
            if (!Flags.firespread.isGlobalyEnabled()) {
                return;
            }
            FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
            if (!perms.has(Flags.firespread, true)) {
                event.setCancelled(true);
            }
        } else if (cause == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL) {
            if (!Flags.ignite.isGlobalyEnabled()) {
                return;
            }
            Player player = event.getPlayer();
            FlagPermissions perms = this.plugin.getPermsByLocForPlayer(event.getBlock().getLocation(), player);
            if (player != null && !perms.playerHas(player, Flags.ignite, true) && !this.plugin.isResAdminOn(player)) {
                event.setCancelled(true);
                this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.ignite});
            }
        } else {
            if (!Flags.ignite.isGlobalyEnabled()) {
                return;
            }
            FlagPermissions perms = this.plugin.getPermsByLoc(event.getBlock().getLocation());
            if (!perms.has(Flags.ignite, true)) {
                event.setCancelled(true);
            }
        }
    }
}

