/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.gui;

import com.bekvon.bukkit.CMIGUI.CMIGuiButton;
import com.bekvon.bukkit.CMIGUI.GUIManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.gui.FlagData;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class setFlagInfo {
    private ClaimedResidence residence;
    private Player player;
    private String targetPlayer = null;
    private LinkedHashMap<Flags, List<String>> description = new LinkedHashMap();
    private List<CMIGuiButton> buttons = new ArrayList<CMIGuiButton>();
    private boolean admin = false;

    public setFlagInfo(ClaimedResidence residence, Player player, boolean admin) {
        this.residence = residence;
        this.player = player;
        this.admin = admin;
        this.fillFlagDescriptions();
    }

    public setFlagInfo(ClaimedResidence residence, Player player, String targetPlayer, boolean admin) {
        this.residence = residence;
        this.player = player;
        this.targetPlayer = targetPlayer;
        this.admin = admin;
        this.fillFlagDescriptions();
    }

    public void setAdmin(boolean state) {
        this.admin = state;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public ClaimedResidence getResidence() {
        return this.residence;
    }

    public Player getPlayer() {
        return this.player;
    }

    private void fillFlagDescriptions() {
        Flags[] flagsArray = Flags.values();
        int n = flagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Flags flag = flagsArray[n2];
            ArrayList<String> lore = new ArrayList<String>();
            int i = 0;
            String sentence = "";
            String[] stringArray = flag.getDesc().split(" ");
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String oneWord = stringArray[n4];
                sentence = String.valueOf(sentence) + oneWord + " ";
                if (i > 4) {
                    lore.add(ChatColor.YELLOW + sentence);
                    sentence = "";
                    i = 0;
                }
                ++i;
                ++n4;
            }
            lore.add(ChatColor.YELLOW + sentence);
            this.description.put(flag, lore);
            ++n2;
        }
    }

    public void recalculate() {
        if (this.targetPlayer == null) {
            this.recalculateResidence();
        } else {
            this.recalculatePlayer();
        }
    }

    private void recalculateResidence() {
        this.buttons.clear();
        List<String> flags2 = this.residence.getPermissions().getPosibleFlags(this.player, true, this.admin);
        HashMap<String, Boolean> resFlags = new HashMap<String, Boolean>();
        Map<String, Object> TempPermMap = new LinkedHashMap<String, Object>();
        Map<String, Boolean> globalFlags = Residence.getInstance().getPermissionManager().getAllFlags().getFlags();
        for (Map.Entry<String, Boolean> one : this.residence.getPermissions().getFlags().entrySet()) {
            if (!flags2.contains(one.getKey())) continue;
            resFlags.put(one.getKey(), one.getValue());
        }
        for (Map.Entry<String, Boolean> one : globalFlags.entrySet()) {
            String fname = one.getKey();
            Flags flag = Flags.getFlag(fname);
            if (flag != null && !flag.isGlobalyEnabled() || !flags2.contains(one.getKey())) continue;
            if (resFlags.containsKey(one.getKey())) {
                TempPermMap.put(one.getKey(), (Object)((Boolean)resFlags.get(one.getKey()) != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE));
                continue;
            }
            TempPermMap.put(one.getKey(), (Object)FlagPermissions.FlagState.NEITHER);
        }
        if (this.targetPlayer == null) {
            TempPermMap.remove("admin");
        }
        TempPermMap = Residence.getInstance().getSortingManager().sortByKeyASC(TempPermMap);
        LinkedHashMap permMap = new LinkedHashMap();
        for (Map.Entry entry : TempPermMap.entrySet()) {
            permMap.put((String)entry.getKey(), entry.getValue());
        }
        final String string = this.admin ? "resadmin" : "res";
        int i = 0;
        for (final Map.Entry one : permMap.entrySet()) {
            i = i > 44 ? 0 : i;
            CMIGuiButton button = new CMIGuiButton(i, this.updateLook((String)one.getKey())){

                @Override
                public void click(GUIManager.GUIClickType type) {
                    String command2 = "true";
                    switch (type) {
                        case Left: {
                            break;
                        }
                        case Right: {
                            command2 = "false";
                            break;
                        }
                        case LeftShift: 
                        case RightShift: 
                        case MiddleMouse: {
                            command2 = "remove";
                            break;
                        }
                    }
                    Bukkit.dispatchCommand((CommandSender)setFlagInfo.this.player, (String)(String.valueOf(string) + " set " + setFlagInfo.this.residence.getName() + " " + (String)one.getKey() + " " + command2));
                    if (Residence.getInstance().getConfigManager().isConsoleLogsShowFlagChanges()) {
                        Residence.getInstance().consoleMessage(String.valueOf(setFlagInfo.this.player.getName()) + " issued server command: /" + string + " set " + setFlagInfo.this.residence.getName() + " " + (String)one.getKey() + " " + command2);
                    }
                    this.updateLooks();
                }

                @Override
                public void updateLooks() {
                    this.setItem(setFlagInfo.this.updateLook((String)one.getKey()));
                    this.hideItemFlags();
                    this.update();
                }
            };
            button.hideItemFlags();
            this.buttons.add(button);
            ++i;
        }
        this.description.clear();
    }

    private void recalculatePlayer() {
        HashMap<String, Boolean> globalFlags = new HashMap<String, Boolean>();
        Flags[] flagsArray = Flags.values();
        int n = flagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Flags oneFlag = flagsArray[n2];
            globalFlags.put(oneFlag.toString(), oneFlag.isEnabled());
            ++n2;
        }
        List<String> flags2 = this.residence.getPermissions().getPosibleFlags(this.player, false, this.admin);
        HashMap<String, Boolean> resFlags = new HashMap<String, Boolean>();
        for (Map.Entry entry : this.residence.getPermissions().getFlags().entrySet()) {
            if (!flags2.contains(entry.getKey())) continue;
            resFlags.put((String)entry.getKey(), (Boolean)entry.getValue());
        }
        if (this.targetPlayer != null) {
            Set<String> set2 = FlagPermissions.getAllPosibleFlags();
            HashMap<String, Boolean> temp = new HashMap<String, Boolean>();
            for (String string : set2) {
                if (!globalFlags.containsKey(string)) continue;
                temp.put(string, (Boolean)globalFlags.get(string));
            }
            globalFlags = temp;
            Map<String, Boolean> map = this.residence.getPermissions().getPlayerFlags(this.targetPlayer);
            if (map != null) {
                for (Map.Entry<String, Boolean> entry : map.entrySet()) {
                    resFlags.put(entry.getKey(), entry.getValue());
                }
            }
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry one : globalFlags.entrySet()) {
            if (!flags2.contains(one.getKey())) continue;
            if (resFlags.containsKey(one.getKey())) {
                linkedHashMap.put((String)one.getKey(), (Object)((Boolean)resFlags.get(one.getKey()) != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE));
                continue;
            }
            linkedHashMap.put((String)one.getKey(), (Object)FlagPermissions.FlagState.NEITHER);
        }
        LinkedHashMap linkedHashMap2 = (LinkedHashMap)Residence.getInstance().getSortingManager().sortByKeyASC(linkedHashMap);
        LinkedHashMap permMap = new LinkedHashMap();
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            permMap.put((String)entry.getKey(), entry.getValue());
        }
        final String string = this.targetPlayer == null ? "" : " " + this.targetPlayer;
        final String string2 = this.admin ? "resadmin" : "res";
        int i = 0;
        for (final Map.Entry one : permMap.entrySet()) {
            i = i > 44 ? 0 : i;
            CMIGuiButton button = new CMIGuiButton(i, this.updateLook((String)one.getKey())){

                @Override
                public void click(GUIManager.GUIClickType type) {
                    String command2 = "true";
                    switch (type) {
                        case Left: {
                            break;
                        }
                        case Right: {
                            command2 = "false";
                            break;
                        }
                        case LeftShift: 
                        case RightShift: 
                        case MiddleMouse: {
                            command2 = "remove";
                            break;
                        }
                    }
                    Bukkit.dispatchCommand((CommandSender)setFlagInfo.this.player, (String)(String.valueOf(string2) + " pset " + setFlagInfo.this.residence.getName() + string + " " + (String)one.getKey() + " " + command2));
                    if (Residence.getInstance().getConfigManager().isConsoleLogsShowFlagChanges()) {
                        Residence.getInstance().consoleMessage(String.valueOf(setFlagInfo.this.player.getName()) + " issued server command: /" + string2 + " pset " + setFlagInfo.this.residence.getName() + string + " " + (String)one.getKey() + " " + command2);
                    }
                    this.updateLooks();
                }

                @Override
                public void updateLooks() {
                    this.setItem(setFlagInfo.this.updateLook((String)one.getKey()));
                    this.hideItemFlags();
                    this.update();
                }
            };
            ++i;
            button.hideItemFlags();
            this.buttons.add(button);
        }
        this.description.clear();
    }

    private ItemStack updateLook(String flagName) {
        Boolean have = null;
        ResidencePermissions fp = this.residence.getPermissions();
        if (this.targetPlayer != null) {
            if (fp.playerHas(this.targetPlayer, flagName, FlagPermissions.FlagCombo.OnlyTrue)) {
                have = true;
            } else if (fp.playerHas(this.targetPlayer, flagName, FlagPermissions.FlagCombo.OnlyFalse)) {
                have = false;
            }
        } else if (fp.has(flagName, FlagPermissions.FlagCombo.OnlyTrue)) {
            have = true;
        } else if (fp.has(flagName, FlagPermissions.FlagCombo.OnlyFalse)) {
            have = false;
        }
        FlagPermissions.FlagState state = FlagPermissions.FlagState.NEITHER;
        if (have != null) {
            state = have != false ? FlagPermissions.FlagState.TRUE : FlagPermissions.FlagState.FALSE;
        }
        ItemStack MiscInfo = Residence.getInstance().getConfigManager().getGuiBottonStates(state).clone();
        FlagData flagData = Residence.getInstance().getFlagUtilManager().getFlagData();
        if (flagData.contains(flagName)) {
            MiscInfo = flagData.getItem(flagName).clone();
        }
        if (state == FlagPermissions.FlagState.TRUE) {
            ItemMeta im = MiscInfo.getItemMeta();
            im.addEnchant(Enchantment.LUCK, 1, true);
            MiscInfo.setItemMeta(im);
        } else {
            MiscInfo.removeEnchantment(Enchantment.LUCK);
        }
        ItemMeta MiscInfoMeta = MiscInfo.getItemMeta();
        Flags flag = Flags.getFlag(flagName);
        if (flag != null) {
            flagName = flag.getName();
        }
        if (flagName == null) {
            flagName = "Unknown";
        }
        if (MiscInfoMeta == null) {
            return MiscInfo;
        }
        MiscInfoMeta.setDisplayName(ChatColor.GREEN + flagName);
        ArrayList<String> lore = new ArrayList<String>();
        String variable = "";
        switch (state) {
            case FALSE: {
                variable = Residence.getInstance().msg(lm.General_False, new Object[0]);
                break;
            }
            case TRUE: {
                variable = Residence.getInstance().msg(lm.General_True, new Object[0]);
                break;
            }
            case NEITHER: {
                variable = Residence.getInstance().msg(lm.General_Removed, new Object[0]);
            }
        }
        lore.add(Residence.getInstance().msg(lm.General_FlagState, variable));
        if (this.description.containsKey((Object)flag)) {
            lore.addAll((Collection)this.description.get((Object)flag));
        }
        lore.addAll(Residence.getInstance().msgL(lm.Gui_Actions));
        MiscInfoMeta.setLore(lore);
        MiscInfo.setItemMeta(MiscInfoMeta);
        return MiscInfo;
    }

    public List<CMIGuiButton> getButtons() {
        return this.buttons;
    }
}

