/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.MarketBuyInterface;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.EconomyInterface;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.text.help.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TransactionManager
implements MarketBuyInterface {
    private Set<ClaimedResidence> sellAmount;
    private Residence plugin;

    public TransactionManager(Residence plugin) {
        this.plugin = plugin;
        this.sellAmount = new HashSet<ClaimedResidence>();
    }

    public boolean chargeEconomyMoney(Player player, double chargeamount) {
        EconomyInterface econ = this.plugin.getEconomyManager();
        if (econ == null) {
            this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
            return false;
        }
        if (!econ.canAfford(player.getName(), chargeamount)) {
            this.plugin.msg((CommandSender)player, lm.Economy_NotEnoughMoney, new Object[0]);
            return false;
        }
        econ.subtract(player.getName(), chargeamount);
        try {
            if (chargeamount != 0.0) {
                this.plugin.msg((CommandSender)player, lm.Economy_MoneyCharged, this.plugin.getEconomyManager().format(chargeamount), econ.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean giveEconomyMoney(Player player, double amount) {
        if (player == null) {
            return false;
        }
        if (amount == 0.0) {
            return true;
        }
        EconomyInterface econ = this.plugin.getEconomyManager();
        if (econ == null) {
            this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
            return false;
        }
        econ.add(player.getName(), amount);
        this.plugin.msg((CommandSender)player, lm.Economy_MoneyAdded, this.plugin.getEconomyManager().format(amount), econ.getName());
        return true;
    }

    @Deprecated
    public boolean giveEconomyMoney(String playerName, double amount) {
        if (playerName == null) {
            return false;
        }
        if (amount == 0.0) {
            return true;
        }
        EconomyInterface econ = this.plugin.getEconomyManager();
        if (econ == null) {
            return false;
        }
        econ.add(playerName, amount);
        return true;
    }

    public void putForSale(String areaname, Player player, int amount, boolean resadmin2) {
        ClaimedResidence res = this.plugin.getResidenceManager().getByName(areaname);
        this.putForSale(res, player, amount, resadmin2);
    }

    public void putForSale(ClaimedResidence res, Player player, int amount, boolean resadmin2) {
        if (res == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (this.plugin.getConfigManager().enabledRentSystem() && !resadmin2) {
            if (res.isForRent()) {
                this.plugin.msg((CommandSender)player, lm.Economy_RentSellFail, new Object[0]);
                return;
            }
            if (res.isSubzoneForRent()) {
                this.plugin.msg((CommandSender)player, lm.Economy_SubzoneRentSellFail, new Object[0]);
                return;
            }
            if (res.isParentForRent()) {
                this.plugin.msg((CommandSender)player, lm.Economy_ParentRentSellFail, new Object[0]);
                return;
            }
        }
        if (!this.plugin.getConfigManager().isSellSubzone() && res.isSubzone()) {
            this.plugin.msg((CommandSender)player, lm.Economy_SubzoneSellFail, new Object[0]);
            return;
        }
        if (!resadmin2) {
            if (!this.plugin.getConfigManager().enableEconomy() || this.plugin.getEconomyManager() == null) {
                this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
                return;
            }
            ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
            if (!(resadmin2 || rPlayer.getGroup().canSellLand() || PermissionManager.ResPerm.sell.hasPermission((CommandSender)player))) {
                this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return;
            }
            if (amount <= 0) {
                this.plugin.msg((CommandSender)player, lm.Invalid_Amount, new Object[0]);
                return;
            }
        }
        if (!res.isOwner(player) && !resadmin2) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return;
        }
        if (this.sellAmount.contains(res)) {
            this.plugin.msg((CommandSender)player, lm.Economy_AlreadySellFail, new Object[0]);
            return;
        }
        res.setSellPrice(amount);
        this.sellAmount.add(res);
        this.plugin.getSignUtil().CheckSign(res);
        this.plugin.msg((CommandSender)player, lm.Residence_ForSale, res.getName(), amount);
    }

    @Override
    public boolean putForSale(String areaname, int amount) {
        ClaimedResidence res = this.plugin.getResidenceManager().getByName(areaname);
        return this.putForSale(res, amount);
    }

    public boolean putForSale(ClaimedResidence res, int amount) {
        if (res == null) {
            return false;
        }
        if (this.plugin.getConfigManager().enabledRentSystem() && (res.isForRent() || res.isSubzoneForRent() || res.isParentForRent())) {
            return false;
        }
        if (this.sellAmount.contains(res)) {
            return false;
        }
        res.setSellPrice(amount);
        this.sellAmount.add(res);
        return true;
    }

    @Override
    public void buyPlot(String areaname, Player player, boolean resadmin2) {
        ClaimedResidence res = this.plugin.getResidenceManager().getByName(areaname);
        this.buyPlot(res, player, resadmin2);
    }

    public void buyPlot(ClaimedResidence res, Player player, boolean resadmin2) {
        EconomyInterface econ;
        if (res == null || !res.isForSell()) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        if (!resadmin2) {
            boolean canbuy;
            if (!this.plugin.getConfigManager().enableEconomy() || this.plugin.getEconomyManager() == null) {
                this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
                return;
            }
            boolean bl = canbuy = group.canBuyLand() || PermissionManager.ResPerm.buy.hasPermission((CommandSender)player);
            if (!canbuy && !resadmin2) {
                this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return;
            }
        }
        if (res.getPermissions().getOwner().equals(player.getName())) {
            this.plugin.msg((CommandSender)player, lm.Economy_OwnerBuyFail, new Object[0]);
            return;
        }
        if (this.plugin.getResidenceManager().getOwnedZoneCount(player.getName()) >= rPlayer.getMaxRes() && !resadmin2) {
            this.plugin.msg((CommandSender)player, lm.Residence_TooMany, new Object[0]);
            return;
        }
        Server serv = this.plugin.getServ();
        int amount = res.getSellPrice();
        if (!resadmin2 && !group.buyLandIgnoreLimits()) {
            CuboidArea[] areas;
            CuboidArea[] cuboidAreaArray = areas = res.getAreaArray();
            int n = areas.length;
            int n2 = 0;
            while (n2 < n) {
                CuboidArea thisarea = cuboidAreaArray[n2];
                if (!res.isSubzone() && !res.isSmallerThanMax(player, thisarea, resadmin2) || res.isSubzone() && !res.isSmallerThanMaxSubzone(player, thisarea, resadmin2)) {
                    this.plugin.msg((CommandSender)player, lm.Residence_BuyTooBig, new Object[0]);
                    return;
                }
                ++n2;
            }
        }
        if ((econ = this.plugin.getEconomyManager()) == null) {
            this.plugin.msg((CommandSender)player, lm.Economy_MarketDisabled, new Object[0]);
            return;
        }
        String buyerName = player.getName();
        String sellerName = res.getPermissions().getOwner();
        Player sellerNameFix = this.plugin.getServ().getPlayer(sellerName);
        if (sellerNameFix != null) {
            sellerName = sellerNameFix.getName();
        }
        if (econ.canAfford(buyerName, amount)) {
            if (!econ.transfer(buyerName, sellerName, amount)) {
                player.sendMessage(ChatColor.RED + "Error, could not transfer " + amount + " from " + buyerName + " to " + sellerName);
                return;
            }
            res.getPermissions().setOwner(player, true);
            res.getPermissions().applyDefaultFlags();
            this.removeFromSale(res);
            if (this.plugin.getConfigManager().isRemoveLwcOnBuy()) {
                this.plugin.getResidenceManager().removeLwcFromResidence(player, res);
            }
            this.plugin.getSignUtil().CheckSign(res);
            Visualizer v = new Visualizer(player);
            v.setAreas(res);
            this.plugin.getSelectionManager().showBounds(player, v);
            this.plugin.msg((CommandSender)player, lm.Economy_MoneyCharged, this.plugin.getEconomyManager().format(amount), econ.getName());
            this.plugin.msg((CommandSender)player, lm.Residence_Bought, res.getResidenceName());
            Player seller = serv.getPlayer(sellerName);
            if (seller != null && seller.isOnline()) {
                seller.sendMessage(this.plugin.msg(lm.Residence_Buy, player.getName(), res.getResidenceName()));
                seller.sendMessage(this.plugin.msg(lm.Economy_MoneyCredit, this.plugin.getEconomyManager().format(amount), econ.getName()));
            }
        } else {
            this.plugin.msg((CommandSender)player, lm.Economy_NotEnoughMoney, new Object[0]);
        }
    }

    public void removeFromSale(Player player, String areaname, boolean resadmin2) {
        ClaimedResidence res = this.plugin.getResidenceManager().getByName(areaname);
        this.removeFromSale(player, res, resadmin2);
    }

    public void removeFromSale(Player player, ClaimedResidence res, boolean resadmin2) {
        if (res == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Area, new Object[0]);
            return;
        }
        if (!res.isForSell()) {
            this.plugin.msg((CommandSender)player, lm.Residence_NotForSale, new Object[0]);
            return;
        }
        if (res.isOwner(player) || resadmin2) {
            this.removeFromSale(res);
            this.plugin.getSignUtil().CheckSign(res);
            this.plugin.msg((CommandSender)player, lm.Residence_StopSelling, new Object[0]);
        } else {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        }
    }

    @Override
    public void removeFromSale(String areaname) {
        ClaimedResidence res = this.plugin.getResidenceManager().getByName(areaname);
        this.removeFromSale(res);
    }

    public void removeFromSale(ClaimedResidence res) {
        if (res == null) {
            return;
        }
        this.sellAmount.remove(res);
        this.plugin.getSignUtil().removeSign(res);
    }

    @Override
    public boolean isForSale(String areaname) {
        ClaimedResidence res = this.plugin.getResidenceManager().getByName(areaname);
        return this.isForSale(res);
    }

    public boolean isForSale(ClaimedResidence res) {
        if (res == null) {
            return false;
        }
        return this.sellAmount.contains(res);
    }

    public boolean viewSaleInfo(String areaname, Player player) {
        ClaimedResidence res = this.plugin.getResidenceManager().getByName(areaname);
        return this.viewSaleInfo(res, player);
    }

    public boolean viewSaleInfo(ClaimedResidence res, Player player) {
        String etime;
        if (res == null || !res.isForSell()) {
            return false;
        }
        if (!this.sellAmount.contains(res)) {
            return false;
        }
        this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
        this.plugin.msg((CommandSender)player, lm.Area_Name, res.getName());
        this.plugin.msg((CommandSender)player, lm.Economy_SellAmount, res.getSellPrice());
        if (this.plugin.getConfigManager().useLeases() && (etime = this.plugin.getLeaseManager().getExpireTime(res)) != null) {
            this.plugin.msg((CommandSender)player, lm.Economy_LeaseExpire, etime);
        }
        this.plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
        return true;
    }

    public void printForSaleResidences(Player player, int page) {
        ArrayList<ClaimedResidence> toRemove = new ArrayList<ClaimedResidence>();
        this.plugin.msg((CommandSender)player, lm.Economy_LandForSale, new Object[0]);
        StringBuilder sbuild = new StringBuilder();
        sbuild.append(ChatColor.GREEN);
        PageInfo pi = new PageInfo(10, this.sellAmount.size(), page);
        int position = -1;
        for (ClaimedResidence res : this.sellAmount) {
            if (++position > pi.getEnd()) break;
            if (!pi.isInRange(position)) continue;
            if (res == null) {
                toRemove.add(res);
                continue;
            }
            this.plugin.msg((CommandSender)player, lm.Economy_SellList, pi.getPositionForOutput(position), res.getName(), res.getSellPrice(), res.getOwner());
        }
        for (ClaimedResidence one : toRemove) {
            this.sellAmount.remove(one);
        }
        this.plugin.getInfoPageManager().ShowPagination((CommandSender)player, pi, "/res market list sell");
    }

    public void clearSales() {
        for (ClaimedResidence res : this.sellAmount) {
            if (res == null) continue;
            res.setSellPrice(-1);
        }
        this.sellAmount.clear();
        System.out.println("[Residence] - ReInit land selling.");
    }

    @Override
    public int getSaleAmount(String areaname) {
        ClaimedResidence res = this.plugin.getResidenceManager().getByName(areaname);
        return this.getSaleAmount(res);
    }

    public int getSaleAmount(ClaimedResidence res) {
        if (res == null) {
            return -1;
        }
        return res.getSellPrice();
    }

    public void load(Map<String, Integer> root) {
        if (root == null) {
            return;
        }
        for (Map.Entry<String, Integer> one : root.entrySet()) {
            ClaimedResidence res = this.plugin.getResidenceManager().getByName(one.getKey());
            if (res == null) continue;
            res.setSellPrice(one.getValue());
            this.sellAmount.add(res);
        }
    }

    @Override
    public Map<String, Integer> getBuyableResidences() {
        HashMap<String, Integer> list2 = new HashMap<String, Integer>();
        for (ClaimedResidence res : this.sellAmount) {
            if (res == null) continue;
            list2.put(res.getName(), res.getSellPrice());
        }
        return list2;
    }

    public Map<String, Integer> save() {
        return this.getBuyableResidences();
    }
}

