/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ResidenceBank {
    Double storedMoney = 0.0;
    ClaimedResidence res;

    public ResidenceBank(ClaimedResidence parent) {
        this.res = parent;
    }

    @Deprecated
    public int getStoredMoney() {
        return this.storedMoney.intValue();
    }

    public Double getStoredMoneyD() {
        return this.storedMoney;
    }

    public String getStoredMoneyFormated() {
        try {
            return Residence.getInstance().getEconomyManager().format(this.storedMoney);
        }
        catch (Exception e) {
            return String.valueOf(this.storedMoney);
        }
    }

    public void setStoredMoney(double amount) {
        this.storedMoney = amount;
    }

    public void add(double amount) {
        this.storedMoney = this.storedMoney + amount;
    }

    public boolean hasEnough(double amount) {
        return this.storedMoney >= amount;
    }

    public void subtract(double amount) {
        this.storedMoney = this.storedMoney - amount;
        if (this.storedMoney < 0.0) {
            this.storedMoney = 0.0;
        }
    }

    @Deprecated
    public void withdraw(CommandSender sender, int amount, boolean resadmin2) {
        this.withdraw(sender, (double)amount, resadmin2);
    }

    public void withdraw(CommandSender sender, double amount, boolean resadmin2) {
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        if (!Residence.getInstance().getConfigManager().enableEconomy()) {
            Residence.getInstance().msg(sender, lm.Economy_MarketDisabled, new Object[0]);
        }
        if (!resadmin2 && !this.res.getPermissions().playerHas(player, Flags.bank, FlagPermissions.FlagCombo.OnlyTrue)) {
            Residence.getInstance().msg(sender, lm.Bank_NoAccess, new Object[0]);
            return;
        }
        if (!this.hasEnough(amount)) {
            Residence.getInstance().msg(sender, lm.Bank_NoMoney, new Object[0]);
            return;
        }
        if (!resadmin2 && this.res.isRented() && !this.res.getRentedLand().player.equalsIgnoreCase(sender.getName())) {
            Residence.getInstance().msg(sender, lm.Bank_rentedWithdraw, this.res.getName());
            return;
        }
        if (sender instanceof Player && Residence.getInstance().getEconomyManager().add(sender.getName(), amount) || !(sender instanceof Player)) {
            this.subtract(amount);
            Residence.getInstance().msg(sender, lm.Bank_Withdraw, String.format("%.2f", amount));
        }
    }

    @Deprecated
    public void deposit(CommandSender sender, int amount, boolean resadmin2) {
        this.deposit(sender, (double)amount, resadmin2);
    }

    public void deposit(CommandSender sender, double amount, boolean resadmin2) {
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        if (!Residence.getInstance().getConfigManager().enableEconomy()) {
            Residence.getInstance().msg(sender, lm.Economy_MarketDisabled, new Object[0]);
        }
        if (!resadmin2 && !this.res.getPermissions().playerHas(player, Flags.bank, FlagPermissions.FlagCombo.OnlyTrue)) {
            Residence.getInstance().msg(sender, lm.Bank_NoAccess, new Object[0]);
            return;
        }
        if (sender instanceof Player && !Residence.getInstance().getEconomyManager().canAfford(sender.getName(), amount)) {
            Residence.getInstance().msg(sender, lm.Economy_NotEnoughMoney, new Object[0]);
            return;
        }
        if (sender instanceof Player && Residence.getInstance().getEconomyManager().subtract(sender.getName(), amount) || !(sender instanceof Player)) {
            this.add(amount);
            Residence.getInstance().msg(sender, lm.Bank_Deposit, Residence.getInstance().getEconomyManager().format(amount));
        }
    }
}

