/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.economy;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.economy.EconomyInterface;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.api.Economy;
import com.earth2me.essentials.api.NoLoanPermittedException;
import com.earth2me.essentials.api.UserDoesNotExistException;
import org.bukkit.entity.Player;

public class EssentialsEcoAdapter
implements EconomyInterface {
    Essentials plugin;

    public EssentialsEcoAdapter(Essentials p) {
        this.plugin = p;
        String serverland = Residence.getInstance().getServerLandName();
        if (!Economy.playerExists((String)serverland)) {
            Economy.createNPC((String)serverland);
        }
    }

    @Override
    public double getBalance(Player player) {
        try {
            if (Economy.playerExists((String)player.getName())) {
                return Economy.getMoney((String)player.getName());
            }
            return 0.0;
        }
        catch (UserDoesNotExistException ex) {
            return 0.0;
        }
    }

    @Override
    public double getBalance(String playerName) {
        try {
            if (Economy.playerExists((String)playerName)) {
                return Economy.getMoney((String)playerName);
            }
            return 0.0;
        }
        catch (UserDoesNotExistException ex) {
            return 0.0;
        }
    }

    @Override
    public boolean canAfford(String playerName, double amount) {
        try {
            if (Economy.playerExists((String)playerName)) {
                return Economy.hasEnough((String)playerName, (double)amount);
            }
            return false;
        }
        catch (UserDoesNotExistException ex) {
            return false;
        }
    }

    @Override
    public boolean add(String playerName, double amount) {
        if (Economy.playerExists((String)playerName)) {
            try {
                Economy.add((String)playerName, (double)amount);
                return true;
            }
            catch (UserDoesNotExistException ex) {
                return false;
            }
            catch (NoLoanPermittedException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean subtract(String playerName, double amount) {
        if (Economy.playerExists((String)playerName)) {
            try {
                Economy.subtract((String)playerName, (double)amount);
                return true;
            }
            catch (UserDoesNotExistException ex) {
                return false;
            }
            catch (NoLoanPermittedException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean transfer(String playerFrom, String playerTo, double amount) {
        block4: {
            block5: {
                try {
                    if (!Economy.playerExists((String)playerFrom) || !Economy.playerExists((String)playerTo) || !Economy.hasEnough((String)playerFrom, (double)amount)) break block4;
                    if (this.subtract(playerFrom, amount)) break block5;
                    return false;
                }
                catch (UserDoesNotExistException ex) {
                    return false;
                }
            }
            if (!this.add(playerTo, amount)) {
                this.add(playerFrom, amount);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "EssentialsEconomy";
    }

    @Override
    public String format(double amount) {
        return Economy.format((double)amount);
    }
}

