/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.containers;

import com.bekvon.bukkit.residence.BossBar.BossBarInfo;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.PlayerGroup;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.raid.ResidenceRaid;
import com.bekvon.bukkit.residence.vaultinterface.ResidenceVaultAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ResidencePlayer {
    private String userName = null;
    private Player player = null;
    private OfflinePlayer ofPlayer = null;
    private UUID uuid = null;
    private Set<ClaimedResidence> ResidenceList = new HashSet<ClaimedResidence>();
    private ClaimedResidence mainResidence = null;
    private PlayerGroup groups = null;
    private int maxRes = -1;
    private int maxRents = -1;
    private int maxSubzones = -1;
    private int maxSubzoneDepth = -1;
    private int maxValue = 9999;
    private Long lastRaidAttackTimer = 0L;
    private Long lastRaidDefendTimer = 0L;
    private ResidenceRaid raid = null;
    private Long lastMaxResRecalculation = 0L;
    private Long lastMaxRentsRecalculation = 0L;
    private Long lastMaxSubzonesRecalculation = 0L;
    private Long lastMaxSubzonesDepthRecalculation = 0L;
    private boolean updated = false;
    HashMap<String, BossBarInfo> barMap = new HashMap();

    public ResidencePlayer(OfflinePlayer off) {
        if (off == null) {
            return;
        }
        this.uuid = off.getUniqueId();
        this.userName = off.getName();
        Residence.getInstance().addOfflinePlayerToChache(off);
        this.updatePlayer();
    }

    public ResidencePlayer(Player player) {
        if (player == null) {
            return;
        }
        Residence.getInstance().addOfflinePlayerToChache((OfflinePlayer)player);
        this.updatePlayer(player);
    }

    public boolean isOnline() {
        this.updatePlayer();
        return this.player != null && this.player.isOnline();
    }

    public ResidencePlayer(String userName, UUID uuid) {
        this.userName = userName;
        this.uuid = uuid;
    }

    public ResidencePlayer(String userName) {
        this.userName = userName;
    }

    public void setMainResidence(ClaimedResidence res) {
        if (this.mainResidence != null) {
            this.mainResidence.setMainResidence(false);
        }
        this.mainResidence = res;
    }

    public ClaimedResidence getMainResidence() {
        if (this.mainResidence == null || !this.mainResidence.isOwner(this.getPlayerName())) {
            for (ClaimedResidence claimedResidence : this.ResidenceList) {
                if (claimedResidence == null || !claimedResidence.isMainResidence()) continue;
                this.mainResidence = claimedResidence;
                return this.mainResidence;
            }
            for (String string : Residence.getInstance().getRentManager().getRentedLands(this.userName)) {
                ClaimedResidence res = Residence.getInstance().getResidenceManager().getByName(string);
                if (res == null) continue;
                this.mainResidence = res;
                return this.mainResidence;
            }
            for (ClaimedResidence claimedResidence : this.ResidenceList) {
                if (claimedResidence == null) continue;
                this.mainResidence = claimedResidence;
                return this.mainResidence;
            }
        }
        return this.mainResidence;
    }

    public void recountMaxRes() {
        if (this.lastMaxResRecalculation + 10000L > System.currentTimeMillis()) {
            return;
        }
        this.lastMaxResRecalculation = System.currentTimeMillis();
        if (this.getGroup() != null) {
            this.maxRes = this.getGroup().getMaxZones();
        }
        int n = this.maxRes = this.maxRes == -1 ? this.maxValue : this.maxRes;
        if (this.player != null && this.player.isOnline()) {
            if (PermissionManager.ResPerm.max_res_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxRes = this.maxValue;
                return;
            }
        } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_res_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxRes = this.maxValue;
            return;
        }
        int i = 1;
        while (i <= Residence.getInstance().getConfigManager().getMaxResCount()) {
            if (this.player != null && this.player.isOnline()) {
                if (PermissionManager.ResPerm.max_res_$1.hasSetPermission((CommandSender)this.player, String.valueOf(i))) {
                    this.maxRes = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_res_$1.getPermission(String.valueOf(i)), Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxRes = i;
            }
            ++i;
        }
    }

    public void recountMaxRents() {
        if (this.lastMaxRentsRecalculation + 10000L > System.currentTimeMillis()) {
            return;
        }
        this.lastMaxRentsRecalculation = System.currentTimeMillis();
        if (this.player != null) {
            if (PermissionManager.ResPerm.max_rents_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxRents = this.maxValue;
                return;
            }
        } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_rents_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxRents = this.maxValue;
            return;
        }
        int i = 1;
        while (i <= Residence.getInstance().getConfigManager().getMaxRentCount()) {
            if (this.player != null) {
                if (PermissionManager.ResPerm.max_rents_$1.hasSetPermission((CommandSender)this.player, String.valueOf(i))) {
                    this.maxRents = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_rents_$1.getPermission(String.valueOf(i)), Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxRents = i;
            }
            ++i;
        }
        int m = this.getGroup().getMaxRents();
        int n = m = m == -1 ? this.maxValue : m;
        if (this.maxRents < m) {
            this.maxRents = m;
        }
    }

    public int getMaxRents() {
        this.recountMaxRents();
        return this.maxRents;
    }

    public void recountMaxSubzones() {
        if (this.lastMaxSubzonesRecalculation + 10000L > System.currentTimeMillis()) {
            return;
        }
        this.lastMaxSubzonesRecalculation = System.currentTimeMillis();
        if (this.player != null) {
            if (PermissionManager.ResPerm.max_subzones_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxSubzones = this.maxValue;
                return;
            }
        } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_subzones_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxSubzones = this.maxValue;
            return;
        }
        int i = 1;
        while (i <= Residence.getInstance().getConfigManager().getMaxSubzonesCount()) {
            if (this.player != null) {
                if (PermissionManager.ResPerm.max_subzones_$1.hasSetPermission((CommandSender)this.player, String.valueOf(i))) {
                    this.maxSubzones = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_subzones_$1.getPermission(String.valueOf(i)), Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxSubzones = i;
            }
            ++i;
        }
        int m = this.getGroup().getMaxSubzones();
        int n = m = m == -1 ? this.maxValue : m;
        if (this.maxSubzones < m) {
            this.maxSubzones = m;
        }
    }

    public int getMaxSubzones() {
        this.recountMaxSubzones();
        return this.maxSubzones;
    }

    public void recountMaxSubzoneDepth() {
        if (this.lastMaxSubzonesDepthRecalculation + 10000L > System.currentTimeMillis()) {
            return;
        }
        this.lastMaxSubzonesDepthRecalculation = System.currentTimeMillis();
        if (this.player != null) {
            if (PermissionManager.ResPerm.max_subzonedepth_unlimited.hasSetPermission((CommandSender)this.player, new String[0])) {
                this.maxSubzoneDepth = this.maxValue;
                return;
            }
        } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_subzonedepth_unlimited.getPermission(), Residence.getInstance().getConfigManager().getDefaultWorld())) {
            this.maxSubzoneDepth = this.maxValue;
            return;
        }
        int i = 1;
        while (i <= Residence.getInstance().getConfigManager().getMaxSubzoneDepthCount()) {
            if (this.player != null) {
                if (PermissionManager.ResPerm.max_subzonedepth_$1.hasSetPermission((CommandSender)this.player, String.valueOf(i))) {
                    this.maxSubzoneDepth = i;
                }
            } else if (this.ofPlayer != null && ResidenceVaultAdapter.hasPermission(this.ofPlayer, PermissionManager.ResPerm.max_subzonedepth_$1.getPermission(String.valueOf(i)), Residence.getInstance().getConfigManager().getDefaultWorld())) {
                this.maxSubzoneDepth = i;
            }
            ++i;
        }
        int m = this.getGroup().getMaxSubzoneDepth();
        int n = m = m == -1 ? this.maxValue : m;
        if (this.maxSubzoneDepth < m) {
            this.maxSubzoneDepth = m;
        }
    }

    public int getMaxSubzoneDepth() {
        this.recountMaxSubzoneDepth();
        return this.maxSubzoneDepth;
    }

    public int getMaxRes() {
        this.recountMaxRes();
        PermissionGroup g = this.getGroup();
        if (this.maxRes < g.getMaxZones()) {
            return g.getMaxZones();
        }
        return this.maxRes;
    }

    public PermissionGroup forceUpdateGroup() {
        this.updatePlayer();
        return this.getGroup(this.player != null ? this.player.getWorld().getName() : Residence.getInstance().getConfigManager().getDefaultWorld(), true);
    }

    public PermissionGroup getGroup() {
        this.updatePlayer();
        return this.getGroup(this.player != null ? this.player.getWorld().getName() : Residence.getInstance().getConfigManager().getDefaultWorld());
    }

    public PermissionGroup getGroup(String world) {
        return this.getGroup(world, false);
    }

    public PermissionGroup getGroup(String world, boolean force) {
        if (this.groups == null) {
            this.groups = new PlayerGroup(this);
        }
        this.groups.updateGroup(world, force);
        PermissionGroup group = this.groups.getGroup(world);
        if (group == null) {
            group = Residence.getInstance().getPermissionManager().getDefaultGroup();
        }
        return group;
    }

    public ResidencePlayer updatePlayer(Player player) {
        if (this.updated) {
            return this;
        }
        if (player.isOnline()) {
            this.updated = true;
        }
        this.player = player;
        this.uuid = player.getUniqueId();
        this.userName = player.getName();
        this.ofPlayer = player;
        return this;
    }

    public void onQuit() {
        this.ofPlayer = null;
        this.player = null;
        this.updated = false;
    }

    private void updatePlayer() {
        this.player = Bukkit.getPlayer((UUID)this.uuid);
        if (this.player != null) {
            this.updatePlayer(this.player);
        }
        if (this.player != null && this.player.isOnline()) {
            return;
        }
        if (this.uuid != null && Bukkit.getPlayer((UUID)this.uuid) != null) {
            this.player = Bukkit.getPlayer((UUID)this.uuid);
            this.userName = this.player.getName();
            return;
        }
        if (this.userName != null) {
            this.player = Bukkit.getPlayer((String)this.userName);
        }
        if (this.player != null) {
            this.userName = this.player.getName();
            this.uuid = this.player.getUniqueId();
            this.ofPlayer = this.player;
            return;
        }
        if (this.player == null && this.ofPlayer == null) {
            this.ofPlayer = Residence.getInstance().getOfflinePlayer(this.userName);
        }
        if (this.ofPlayer != null) {
            this.userName = this.ofPlayer.getName();
            this.uuid = this.ofPlayer.getUniqueId();
            return;
        }
    }

    public void addResidence(ClaimedResidence residence) {
        if (residence == null) {
            return;
        }
        if (residence.isSubzone()) {
            return;
        }
        residence.getPermissions().setOwnerUUID(this.uuid);
        if (this.userName != null) {
            residence.getPermissions().setOwnerLastKnownName(this.userName);
        }
        this.ResidenceList.add(residence);
    }

    public void removeResidence(ClaimedResidence residence) {
        if (residence == null) {
            return;
        }
        boolean rem = this.ResidenceList.remove(residence);
        if (!rem) {
            Iterator<ClaimedResidence> iter = this.ResidenceList.iterator();
            while (iter.hasNext()) {
                ClaimedResidence one = iter.next();
                if (!one.getName().equalsIgnoreCase(residence.getName())) continue;
                iter.remove();
                break;
            }
        }
    }

    public int getResAmount() {
        int i = 0;
        for (ClaimedResidence one : this.ResidenceList) {
            if (one.isSubzone()) continue;
            ++i;
        }
        return i;
    }

    public List<ClaimedResidence> getResList() {
        ArrayList<ClaimedResidence> ls = new ArrayList<ClaimedResidence>();
        ls.addAll(this.ResidenceList);
        return ls;
    }

    @Deprecated
    public String getPlayerName() {
        return this.getName();
    }

    public String getName() {
        this.updatePlayer();
        return this.userName;
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    @Deprecated
    public UUID getUuid() {
        return this.getUniqueId();
    }

    public Player getPlayer() {
        this.updatePlayer();
        return this.player;
    }

    public void removeBossBar(BossBarInfo bossBar) {
        if (bossBar == null) {
            return;
        }
        if (bossBar.getBar() != null) {
            bossBar.getBar().setVisible(false);
        }
        bossBar.cancelAutoScheduler();
        bossBar.cancelHideScheduler();
        this.barMap.remove(bossBar.getNameOfBar().toLowerCase());
    }

    public void addBossBar(BossBarInfo barInfo) {
        if (!this.barMap.containsKey(barInfo.getNameOfBar().toLowerCase())) {
            this.barMap.put(barInfo.getNameOfBar().toLowerCase(), barInfo);
            Residence.getInstance().getBossBarManager().Show(barInfo);
        } else {
            BossBarInfo old = this.getBossBar(barInfo.getNameOfBar().toLowerCase());
            if (old != null) {
                if (barInfo.getColor() != null) {
                    old.setColor(barInfo.getColor());
                }
                if (barInfo.getKeepFor() != null) {
                    old.setKeepForTicks(barInfo.getKeepFor());
                }
                if (barInfo.getPercentage() != null) {
                    old.setPercentage(barInfo.getPercentage());
                }
                if (barInfo.getUser() != null) {
                    old.setUser(barInfo.getUser());
                }
                if (barInfo.getAdjustPerc() != null) {
                    old.setAdjustPerc(barInfo.getAdjustPerc());
                }
                if (barInfo.getStyle() != null) {
                    old.setStyle(barInfo.getStyle());
                }
                if (!barInfo.getTitleOfBar().isEmpty()) {
                    old.setTitleOfBar(barInfo.getTitleOfBar());
                }
                if (barInfo.getBar() != null) {
                    old.setBar(barInfo.getBar());
                }
                if (barInfo.getId() != null) {
                    old.setId(barInfo.getId());
                }
                if (barInfo.getAuto() != null) {
                    old.setAuto(barInfo.getAuto());
                }
            }
            Residence.getInstance().getBossBarManager().Show(old);
        }
    }

    public BossBarInfo getBossBar(String name) {
        return this.barMap.get(name.toLowerCase());
    }

    public synchronized HashMap<String, BossBarInfo> getBossBarInfo() {
        return this.barMap;
    }

    public synchronized void hideBossBars() {
        for (Map.Entry<String, BossBarInfo> one : this.barMap.entrySet()) {
            one.getValue().getBar().setVisible(false);
        }
    }

    public void clearBossMaps() {
        for (Map.Entry<String, BossBarInfo> one : this.barMap.entrySet()) {
            one.getValue().cancelHideScheduler();
        }
        this.barMap.clear();
    }

    public ClaimedResidence getCurrentlyRaidedResidence() {
        for (ClaimedResidence one : this.getResList()) {
            if (!one.isUnderRaid() && !one.isInPreRaid()) continue;
            return one;
        }
        return null;
    }

    public Long getLastRaidAttackTimer() {
        return this.lastRaidAttackTimer;
    }

    public void setLastRaidAttackTimer(Long lastRaidAttackTimer) {
        this.lastRaidAttackTimer = lastRaidAttackTimer;
    }

    public Long getLastRaidDefendTimer() {
        return this.lastRaidDefendTimer;
    }

    public void setLastRaidDefendTimer(Long lastRaidDefendTimer) {
        this.lastRaidDefendTimer = lastRaidDefendTimer;
    }

    public ResidenceRaid getJoinedRaid() {
        return this.raid;
    }

    public void setJoinedRaid(ResidenceRaid raid2) {
        this.raid = raid2;
    }

    public PlayerGroup getGroups() {
        return this.groups;
    }
}

