/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.raid.RaidAttacker;
import com.bekvon.bukkit.residence.raid.RaidDefender;
import com.bekvon.bukkit.residence.raid.ResidenceRaid;
import com.bekvon.bukkit.residence.utils.Utils;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class raidstatus
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=3100)
    public Boolean perform(Residence plugin, CommandSender sender, String[] args, boolean resadmin2) {
        RawMessage rm;
        OfflinePlayer offp;
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length != 0 && args.length != 1) {
            return false;
        }
        if (!ConfigManager.RaidEnabled) {
            plugin.msg((CommandSender)player, lm.Raid_NotEnabled, new Object[0]);
            return true;
        }
        ClaimedResidence res = null;
        if (args.length > 0) {
            res = plugin.getResidenceManager().getByName(args[0]);
        }
        if (res == null) {
            res = plugin.getResidenceManager().getByLoc(player.getLocation());
        }
        if (res == null && (offp = plugin.getOfflinePlayer(args[0])) != null) {
            ResidencePlayer resp = plugin.getPlayerManager().getResidencePlayer(offp.getUniqueId());
            res = resp.getCurrentlyRaidedResidence();
        }
        if (res == null) {
            res = plugin.getResidenceManager().getByLoc(player.getLocation());
        }
        if (res == null) {
            plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return true;
        }
        ResidenceRaid raid2 = res.getRaid();
        plugin.msg(sender, "&7----------- &f" + res.getName() + "(" + res.getOwner() + ") &7-----------");
        if (res.getRaid().isImmune()) {
            plugin.msg(sender, "&eImmune to raids for next: " + Utils.to24hourShort(raid2.getImmunityUntil() - System.currentTimeMillis() + 1000L));
        } else if (res.isInPreRaid()) {
            plugin.msg(sender, "&7Raid starts in: " + Utils.to24hourShort(raid2.getStartsAt() - System.currentTimeMillis()));
            rm = new RawMessage();
            rm.add("&7Attackers: &4" + raid2.getAttackers().size(), this.getAttackers(raid2));
            rm.show(sender);
            rm = new RawMessage();
            rm.add("&7Defenders: &2" + raid2.getDefenders().size(), this.getDefenders(raid2));
            rm.show(sender);
        } else if (res.isUnderRaid()) {
            plugin.msg(sender, "&7Raid ends in: " + Utils.to24hourShort(raid2.getEndsAt() - System.currentTimeMillis()));
            rm = new RawMessage();
            rm.add("&7Attackers: &4" + raid2.getAttackers().size(), this.getAttackers(raid2));
            rm.show(sender);
            rm = new RawMessage();
            rm.add("&7Defenders: &2" + raid2.getDefenders().size(), this.getDefenders(raid2));
            rm.show(sender);
        } else {
            plugin.msg(sender, raid2.getCooldownEnd() < System.currentTimeMillis() ? "&2Can be raided" : "&ePosible raid in: " + Utils.to24hourShort(raid2.getCooldownEnd() - System.currentTimeMillis() + 1000L));
        }
        return true;
    }

    private String getAttackers(ResidenceRaid raid2) {
        String r = "";
        int i = 0;
        for (Map.Entry<UUID, RaidAttacker> one : raid2.getAttackers().entrySet()) {
            if (!one.getValue().getPlayer().isOnline()) continue;
            if (++i >= 5) {
                r = String.valueOf(r) + " \n";
            }
            if (!r.isEmpty()) {
                r = String.valueOf(r) + ", ";
            }
            if (!one.getValue().getPlayer().isOnline()) continue;
            r = String.valueOf(r) + one.getValue().getPlayer().getPlayer().getDisplayName();
        }
        return r;
    }

    private String getDefenders(ResidenceRaid raid2) {
        String r = "";
        int i = 0;
        for (Map.Entry<UUID, RaidDefender> one : raid2.getDefenders().entrySet()) {
            if (!one.getValue().getPlayer().isOnline()) continue;
            if (++i >= 5) {
                r = String.valueOf(r) + " \n";
            }
            if (!r.isEmpty()) {
                r = String.valueOf(r) + ", ";
            }
            if (!one.getValue().getPlayer().isOnline()) continue;
            r = String.valueOf(r) + one.getValue().getPlayer().getPlayer().getDisplayName();
        }
        return r;
    }

    @Override
    public void getLocale() {
        ConfigReader c = Residence.getInstance().getLocaleManager().getLocaleConfig();
        c.get("Description", "Check raid status for a residence");
        c.get("Info", Arrays.asList("&eUsage: &6/res raidstatus (resName/playerName)"));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName()), Arrays.asList("[cresidence]%%[playername]"));
    }
}

