/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class kick
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=2200)
    public Boolean perform(Residence plugin, CommandSender sender, String[] args, boolean resadmin2) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            return false;
        }
        Player targetplayer = Bukkit.getPlayer((String)args[0]);
        if (targetplayer == null || !player.canSee(targetplayer)) {
            plugin.msg((CommandSender)player, lm.General_NotOnline, new Object[0]);
            return true;
        }
        ResidencePlayer rPlayer = plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        if (!group.hasKickAccess() && !resadmin2) {
            plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return true;
        }
        ClaimedResidence res = plugin.getResidenceManager().getByLoc(targetplayer.getLocation());
        if (res == null || !res.isOwner(player) && !resadmin2) {
            plugin.msg((CommandSender)player, lm.Residence_PlayerNotIn, new Object[0]);
            return true;
        }
        if (!res.isOwner(player)) {
            return false;
        }
        if (res.isRaidInitialized()) {
            plugin.msg(sender, lm.Raid_cantDo, new Object[0]);
            return true;
        }
        if (res.getPlayersInResidence().contains(targetplayer)) {
            if (PermissionManager.ResPerm.command_kick_bypass.hasPermission((CommandSender)targetplayer)) {
                plugin.msg(sender, lm.Residence_CantKick, new Object[0]);
                return true;
            }
            Location loc = plugin.getConfigManager().getKickLocation();
            targetplayer.closeInventory();
            if (loc != null) {
                targetplayer.teleport(loc);
            } else {
                targetplayer.teleport(res.getOutsideFreeLoc(player.getLocation(), player));
            }
            plugin.msg((CommandSender)targetplayer, lm.Residence_Kicked, new Object[0]);
        }
        return true;
    }

    @Override
    public void getLocale() {
        ConfigReader c = Residence.getInstance().getLocaleManager().getLocaleConfig();
        c.get("Description", "Kicks player from residence.");
        c.get("Info", Arrays.asList("&eUsage: &6/res kick <player>", "You must be the owner or an admin to do this.", "Player should be online."));
        Residence.getInstance().getLocaleManager().CommandTab.put(Arrays.asList(this.getClass().getSimpleName()), Arrays.asList("[playername]"));
    }
}

