/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence;

import com.bekvon.bukkit.cmiLib.RawMessage;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.event.ResidenceCommandEvent;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResidenceCommandListener
implements CommandExecutor {
    private static List<String> AdminCommands = new ArrayList<String>();
    private static final String label = "res";
    private Residence plugin;

    public String getLabel() {
        return label;
    }

    public static List<String> getAdminCommands() {
        if (AdminCommands.size() == 0) {
            AdminCommands = Residence.getInstance().getCommandFiller().getCommands(false);
        }
        return AdminCommands;
    }

    public ResidenceCommandListener(Residence plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command2, String label, String[] args) {
        block64: {
            String cmd2;
            ResidenceCommandEvent cevent = new ResidenceCommandEvent(command2.getName(), args, sender);
            Bukkit.getPluginManager().callEvent((Event)cevent);
            if (cevent.isCancelled()) {
                return true;
            }
            if (sender instanceof Player && !this.plugin.getPermissionManager().isResidenceAdmin(sender) && this.plugin.isDisabledWorldCommand(((Player)sender).getWorld())) {
                this.plugin.msg(sender, lm.General_DisabledWorld, new Object[0]);
                return true;
            }
            if (command2.getName().equals("resreload") && args.length == 0) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player) && PermissionManager.ResPerm.topadmin.hasPermission((CommandSender)player)) {
                        this.plugin.reloadPlugin();
                        sender.sendMessage(ChatColor.GREEN + "[Residence] Reloaded config.");
                        System.out.println("[Residence] Reloaded by " + player.getName() + ".");
                    } else {
                        this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    }
                } else {
                    this.plugin.reloadPlugin();
                    System.out.println("[Residence] Reloaded by console.");
                }
                return true;
            }
            if (command2.getName().equals("resload")) {
                if (!(sender instanceof Player) || sender instanceof Player && this.plugin.getPermissionManager().isResidenceAdmin(sender) && PermissionManager.ResPerm.topadmin.hasPermission(sender)) {
                    try {
                        this.plugin.loadYml();
                        sender.sendMessage(ChatColor.GREEN + "[Residence] Reloaded save file...");
                    }
                    catch (Exception ex) {
                        sender.sendMessage(ChatColor.RED + "[Residence] Unable to reload the save file, exception occured!");
                        sender.sendMessage(ChatColor.RED + ex.getMessage());
                        Logger.getLogger(((Object)((Object)Residence.getInstance())).getClass().getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    this.plugin.msg(sender, lm.General_NoPermission, new Object[0]);
                }
                return true;
            }
            if (command2.getName().equals("rc")) {
                cmd cmdClass = ResidenceCommandListener.getCmdClass(new String[]{"rc"});
                if (cmdClass == null) {
                    this.sendUsage(sender, command2.getName());
                    return true;
                }
                boolean respond = cmdClass.perform(Residence.getInstance(), sender, ResidenceCommandListener.reduceArgs(args), false);
                if (!respond) {
                    this.sendUsage(sender, command2.getName());
                }
                return true;
            }
            if (!command2.getName().equals(label) && !command2.getName().equals("residence") && !command2.getName().equals("resadmin")) break block64;
            boolean resadmin2 = false;
            if (sender instanceof Player) {
                if (command2.getName().equals("resadmin") && this.plugin.getPermissionManager().isResidenceAdmin(sender)) {
                    resadmin2 = true;
                }
                if (command2.getName().equals("resadmin") && !this.plugin.getPermissionManager().isResidenceAdmin(sender)) {
                    ((Player)sender).sendMessage(this.plugin.msg(lm.Residence_NonAdmin, new Object[0]));
                    return true;
                }
                if (command2.getName().equals(label) && this.plugin.getPermissionManager().isResidenceAdmin(sender) && this.plugin.getConfigManager().getAdminFullAccess()) {
                    resadmin2 = true;
                }
            } else {
                resadmin2 = true;
            }
            if (args.length > 0 && args[args.length - 1].equalsIgnoreCase("?") || args.length > 1 && args[args.length - 2].equals("?")) {
                return this.commandHelp(args, resadmin2, sender, command2);
            }
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            } else {
                resadmin2 = true;
            }
            if (this.plugin.getConfigManager().allowAdminsOnly() && !resadmin2 && player != null) {
                this.plugin.msg((CommandSender)player, lm.General_AdminOnly, new Object[0]);
                return true;
            }
            if (args.length == 0) {
                args = new String[]{"?"};
            }
            switch (cmd2 = args[0].toLowerCase()) {
                case "delete": {
                    cmd2 = "remove";
                    break;
                }
                case "sz": {
                    cmd2 = "subzone";
                }
            }
            cmd cmdClass = ResidenceCommandListener.getCmdClass(args);
            if (cmdClass == null) {
                return this.commandHelp(new String[]{"?"}, resadmin2, sender, command2);
            }
            if (!resadmin2 && !PermissionManager.ResPerm.command_$1.hasPermission(sender, args[0].toLowerCase())) {
                RawMessage rm = new RawMessage();
                rm.add(this.plugin.msg(lm.General_NoPermission, new Object[0]), "&7" + PermissionManager.ResPerm.command_$1.getPermission(args[0].toLowerCase()));
                rm.show(sender);
                ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
                this.plugin.msg((CommandSender)console, String.valueOf(this.plugin.msg(lm.General_NoPermission, new Object[0])) + " " + PermissionManager.ResPerm.command_$1.getPermission(args[0].toLowerCase()));
                return true;
            }
            if (!resadmin2 && player != null && this.plugin.resadminToggle.contains(player.getName()) && !this.plugin.getPermissionManager().isResidenceAdmin((CommandSender)player)) {
                this.plugin.resadminToggle.remove(player.getName());
            }
            String[] targ = ResidenceCommandListener.reduceArgs(args);
            Method[] methodArray = cmdClass.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method met = methodArray[n2];
                if (met.isAnnotationPresent(CommandAnnotation.class)) {
                    int good;
                    int size;
                    int one;
                    boolean more;
                    ArrayList<Integer> list2;
                    CommandAnnotation cs = met.getAnnotation(CommandAnnotation.class);
                    if (sender instanceof Player) {
                        int[] regVar = cs.regVar();
                        list2 = new ArrayList<Integer>();
                        more = true;
                        int[] nArray = regVar;
                        int n3 = regVar.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            one = nArray[n4];
                            if (one < 0) {
                                more = false;
                            }
                            list2.add(one);
                            ++n4;
                        }
                        size = targ.length;
                        good = 1;
                        if (!list2.isEmpty()) {
                            if (list2.contains(666) || list2.contains(-666)) {
                                this.plugin.msg(sender, lm.Invalid_FromConsole, new Object[0]);
                                return false;
                            }
                            if (list2.contains(-size)) {
                                good = 0;
                            }
                            if (list2.contains(size)) {
                                good = 1;
                            }
                            if (list2.contains(-100) && size == 0) {
                                good = 0;
                            }
                            if (more && !list2.contains(size)) {
                                good = 0;
                            }
                            if (good == 0) {
                                String[] tempArray = new String[args.length + 1];
                                int i = 0;
                                while (i < args.length) {
                                    tempArray[i] = args[i];
                                    ++i;
                                }
                                tempArray[args.length] = "?";
                                args = tempArray;
                                return this.commandHelp(args, resadmin2, sender, command2);
                            }
                        }
                    } else {
                        int[] consoleVar = cs.consoleVar();
                        list2 = new ArrayList();
                        more = true;
                        int[] i = consoleVar;
                        int tempArray = consoleVar.length;
                        good = 0;
                        while (good < tempArray) {
                            one = i[good];
                            if (one < 0) {
                                more = false;
                            }
                            list2.add(one);
                            ++good;
                        }
                        size = targ.length;
                        good = 1;
                        if (!list2.isEmpty()) {
                            if (list2.contains(666) || list2.contains(-666)) {
                                this.plugin.msg(sender, lm.Invalid_Ingame, new Object[0]);
                                return false;
                            }
                            if (list2.contains(-size)) {
                                good = 0;
                            }
                            if (list2.contains(size)) {
                                good = 1;
                            }
                            if (list2.contains(-100) && size == 0) {
                                good = 0;
                            }
                            if (more && !list2.contains(size)) {
                                good = 0;
                            }
                            if (good == 0) {
                                String[] tempArray2 = new String[args.length + 1];
                                int i2 = 0;
                                while (i2 < args.length) {
                                    tempArray2[i2] = args[i2];
                                    ++i2;
                                }
                                tempArray2[args.length] = "?";
                                args = tempArray2;
                                return this.commandHelp(args, resadmin2, sender, command2);
                            }
                        }
                    }
                }
                ++n2;
            }
            Boolean respond = cmdClass.perform(Residence.getInstance(), sender, targ, resadmin2);
            if (respond != null && !respond.booleanValue()) {
                String[] tempArray = new String[args.length + 1];
                int i = 0;
                while (i < args.length) {
                    tempArray[i] = args[i];
                    ++i;
                }
                tempArray[args.length] = "?";
                args = tempArray;
                return this.commandHelp(args, resadmin2, sender, command2);
            }
            return respond != null && respond != false;
        }
        return this.onCommand(sender, command2, label, args);
    }

    private static String[] reduceArgs(String[] args) {
        if (args.length <= 1) {
            return new String[0];
        }
        return Arrays.copyOfRange(args, 1, args.length);
    }

    private static cmd getCmdClass(String[] args) {
        cmd cmdClass = null;
        try {
            Class<?> nmsClass = Class.forName("com.bekvon.bukkit.residence.commands." + args[0].toLowerCase());
            if (cmd.class.isAssignableFrom(nmsClass)) {
                cmdClass = (cmd)nmsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return cmdClass;
    }

    public void sendUsage(CommandSender sender, String command2) {
        this.plugin.msg(sender, lm.General_DefaultUsage, command2);
    }

    private boolean commandHelp(String[] args, boolean resadmin2, CommandSender sender, Command command2) {
        if (this.plugin.getHelpPages() == null) {
            return false;
        }
        String helppath = this.getHelpPath(args);
        int page = 1;
        if (!args[args.length - 1].equalsIgnoreCase("?")) {
            try {
                page = Integer.parseInt(args[args.length - 1]);
            }
            catch (Exception ex) {
                this.plugin.msg(sender, lm.General_InvalidHelp, new Object[0]);
            }
        }
        if (command2.getName().equalsIgnoreCase(label)) {
            resadmin2 = false;
        }
        if (this.plugin.getHelpPages().containesEntry(helppath)) {
            this.plugin.getHelpPages().printHelp(sender, page, helppath, resadmin2);
        }
        return true;
    }

    private String getHelpPath(String[] args) {
        String helppath = label;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("?")) break;
            helppath = String.valueOf(helppath) + "." + args[i];
            ++i;
        }
        if (!this.plugin.getHelpPages().containesEntry(helppath) && args.length > 0) {
            return this.getHelpPath(Arrays.copyOf(args, args.length - 1));
        }
        return helppath;
    }
}

