/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.Placeholders;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Placeholder {
    private Residence plugin;
    Pattern placeholderPatern = Pattern.compile("(%)([^\"^%]*)(%)");

    public Placeholder(Residence plugin) {
        this.plugin = plugin;
    }

    public List<String> updatePlaceHolders(Player player, List<String> messages) {
        ArrayList<String> ms = new ArrayList<String>(messages);
        int i = 0;
        int l = messages.size();
        while (i < l) {
            ms.set(i, this.updatePlaceHolders(player, messages.get(i)));
            ++i;
        }
        return ms;
    }

    public String updatePlaceHolders(Player player, String message2) {
        if (message2 == null) {
            return null;
        }
        if (message2.contains("%")) {
            message2 = this.translateOwnPlaceHolder(player, message2);
        }
        if (!this.plugin.isPlaceholderAPIEnabled()) {
            return message2;
        }
        if (message2.contains("%")) {
            message2 = PlaceholderAPI.setPlaceholders((Player)player, (String)message2);
        }
        return message2;
    }

    private String translateOwnPlaceHolder(Player player, String message2) {
        if (message2 == null) {
            return null;
        }
        if (message2.contains("%")) {
            Matcher match = this.placeholderPatern.matcher(message2);
            while (match.find()) {
                String cmd2 = match.group(2);
                if (!message2.contains("%")) break;
                CMIPlaceHolders place = CMIPlaceHolders.getByNameExact(cmd2);
                String with = this.getValue(player, place);
                if (with == null) continue;
                message2 = message2.replace(place.getFull(), with);
            }
        }
        return message2;
    }

    public String getValue(Player player, CMIPlaceHolders placeHolder) {
        ResidencePlayer user = this.plugin.getPlayerManager().getResidencePlayer(player);
        if (placeHolder == null) {
            return null;
        }
        if (user != null) {
            PermissionGroup group = user.getGroup();
            switch (placeHolder) {
                case residence_user_admin: {
                    return this.variable(Residence.getInstance().getPermissionManager().isResidenceAdmin((CommandSender)player));
                }
                case residence_user_amount: {
                    return String.valueOf(user.getResAmount());
                }
                case residence_user_blockcost: {
                    if (Residence.getInstance().getEconomyManager() == null) break;
                    return String.valueOf(group.getCostperarea());
                }
                case residence_user_blocksell: {
                    if (Residence.getInstance().getEconomyManager() == null) break;
                    return String.valueOf(group.getSellperarea());
                }
                case residence_user_cancreate: {
                    return this.variable(group.canCreateResidences());
                }
                case residence_user_group: {
                    return group.getGroupName();
                }
                case residence_user_maxew: {
                    return String.valueOf(group.getXmin()) + "-" + group.getXmax();
                }
                case residence_user_maxns: {
                    return String.valueOf(group.getZmin()) + "-" + group.getZmax();
                }
                case residence_user_maxrentdays: {
                    return String.valueOf(group.getMaxRentDays());
                }
                case residence_user_maxrents: {
                    return String.valueOf(user.getMaxRents());
                }
                case residence_user_maxres: {
                    return String.valueOf(user.getMaxRes());
                }
                case residence_user_maxsub: {
                    return String.valueOf(user.getMaxSubzones());
                }
                case residence_user_maxsubdepth: {
                    return String.valueOf(user.getMaxSubzoneDepth());
                }
                case residence_user_maxud: {
                    return String.valueOf(group.getYmin()) + "-" + group.getYmax();
                }
                case residence_user_current_owner: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null ? "" : res.getOwner();
                }
                case residence_user_current_res: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null ? "" : res.getName();
                }
                case residence_user_current_bank: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null ? "0" : res.getBank().getStoredMoneyFormated();
                }
                case residence_user_current_qsize: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null ? "0" : String.valueOf(res.getTotalSize());
                }
                case residence_user_current_ssize: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null ? "0" : String.valueOf(res.getXZSize());
                }
                case residence_user_current_forsale: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null ? "" : String.valueOf(res.isForSell());
                }
                case residence_user_current_saleprice: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null || !res.isForSell() ? "" : String.valueOf(res.getSellPrice());
                }
                case residence_user_current_rentprice: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null || !res.isForRent() ? "" : String.valueOf(res.getRentable().cost);
                }
                case residence_user_current_rentdays: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null || !res.isForRent() ? "" : String.valueOf(res.getRentable().days);
                }
                case residence_user_current_rentedby: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null || !res.isForRent() || res.getRentedLand() == null || res.getRentedLand().player == null ? "" : res.getRentedLand().player;
                }
                case residence_user_current_rentends: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null || !res.isForRent() || res.getRentedLand() == null || res.getRentedLand().player == null ? "" : GetTime.getTime(res.getRentedLand().endTime, true);
                }
                case residence_user_current_forrent: {
                    ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                    return res == null ? "" : String.valueOf(res.isForRent());
                }
            }
        }
        switch (placeHolder) {
            // Empty switch
        }
        return null;
    }

    private String variable(Boolean state) {
        return state != false ? this.plugin.getLM().getMessage(lm.General_True, new Object[0]) : this.plugin.getLM().getMessage(lm.General_False, new Object[0]);
    }

    public static enum CMIPlaceHolders {
        residence_user_amount,
        residence_user_group,
        residence_user_admin,
        residence_user_cancreate,
        residence_user_maxres,
        residence_user_maxew,
        residence_user_maxns,
        residence_user_maxud,
        residence_user_maxsub,
        residence_user_maxsubdepth,
        residence_user_maxrents,
        residence_user_maxrentdays,
        residence_user_blockcost,
        residence_user_blocksell,
        residence_user_current_owner,
        residence_user_current_res,
        residence_user_current_bank,
        residence_user_current_qsize,
        residence_user_current_ssize,
        residence_user_current_forsale,
        residence_user_current_saleprice,
        residence_user_current_forrent,
        residence_user_current_rentprice,
        residence_user_current_rentedby,
        residence_user_current_rentdays,
        residence_user_current_rentends;


        public static CMIPlaceHolders getByName(String name) {
            String n;
            CMIPlaceHolders one;
            name = name.replace("_", "");
            CMIPlaceHolders[] cMIPlaceHoldersArray = CMIPlaceHolders.values();
            int n2 = cMIPlaceHoldersArray.length;
            int n3 = 0;
            while (n3 < n2) {
                one = cMIPlaceHoldersArray[n3];
                n = one.name().replace("_", "");
                if (n.equalsIgnoreCase(name)) {
                    return one;
                }
                ++n3;
            }
            name = "residence" + name;
            cMIPlaceHoldersArray = CMIPlaceHolders.values();
            n2 = cMIPlaceHoldersArray.length;
            n3 = 0;
            while (n3 < n2) {
                one = cMIPlaceHoldersArray[n3];
                n = one.name().replace("_", "");
                if (n.equalsIgnoreCase(name)) {
                    return one;
                }
                ++n3;
            }
            return null;
        }

        public static CMIPlaceHolders getByNameExact(String name) {
            name = name.toLowerCase();
            CMIPlaceHolders[] cMIPlaceHoldersArray = CMIPlaceHolders.values();
            int n = cMIPlaceHoldersArray.length;
            int n2 = 0;
            while (n2 < n) {
                CMIPlaceHolders one = cMIPlaceHoldersArray[n2];
                String n3 = one.name();
                if (n3.equals(name)) {
                    return one;
                }
                ++n2;
            }
            return null;
        }

        public String getFull() {
            return "%" + this.name() + "%";
        }
    }
}

