/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence;

import com.bekvon.bukkit.cmiLib.CMIEffectManager;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.ConfigReader;
import com.bekvon.bukkit.cmiLib.VersionChecker;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ELMessageType;
import com.bekvon.bukkit.residence.containers.EconomyType;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.RandomTeleport;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.utils.YmlMaker;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class ConfigManager {
    protected String defaultGroup;
    protected boolean useLeases;
    protected boolean ResMoneyBack;
    protected boolean enableEconomy;
    private EconomyType VaultEconomy;
    protected boolean ExtraEnterMessage;
    protected boolean adminsOnly;
    protected boolean allowEmptyResidences;
    protected boolean NoLava;
    protected boolean NoWater;
    protected boolean NoLavaPlace;
    protected boolean useBlockFall;
    protected boolean NoWaterPlace;
    protected boolean AutoCleanUp;
    protected boolean SellSubzone;
    protected boolean LwcOnDelete;
    protected boolean LwcOnBuy;
    protected boolean LwcOnUnrent;
    protected List<Material> LwcMatList = new ArrayList<Material>();
    protected boolean UseClean;
    protected boolean PvPFlagPrevent;
    protected boolean OverridePvp;
    protected boolean BlockAnyTeleportation;
    protected CMIMaterial infoTool;
    protected int AutoCleanUpDays;
    protected boolean AutoCleanUpRegenerate;
    protected boolean CanTeleportIncludeOwner;
    protected CMIMaterial selectionTool;
    protected boolean adminOps;
    protected boolean AdminFullAccess;
    protected String multiworldPlugin;
    protected boolean enableRentSystem;
    protected boolean RentPreventRemoval;
    private boolean DeductFromBank;
    private boolean DeductFromBankThenPlayer;
    protected boolean RentInformOnEnding;
    protected boolean RentAllowRenewing;
    protected boolean RentStayInMarket;
    protected boolean RentAllowAutoPay;
    protected boolean RentPlayerAutoPay;
    protected boolean leaseAutoRenew;
    protected boolean ShortInfoUse;
    protected boolean OnlyLike;
    protected int RentInformBefore;
    protected int RentInformDelay;
    protected int rentCheckInterval;
    protected int chatPrefixLength;
    protected int leaseCheckInterval;
    protected int autoSaveInt;
    protected boolean NewSaveMechanic;
    private int ItemPickUpDelay;
    private boolean AutomaticResidenceCreationCheckCollision;
    private String AutomaticResidenceCreationIncrementFormat;
    private boolean ConsoleLogsShowFlagChanges = true;
    protected boolean BackupAutoCleanUpUse;
    protected int BackupAutoCleanUpDays;
    protected boolean UseZipBackup;
    protected boolean BackupWorldFiles;
    protected boolean BackupforsaleFile;
    protected boolean BackupleasesFile;
    protected boolean BackuppermlistsFile;
    protected boolean BackuprentFile;
    protected boolean BackupflagsFile;
    protected boolean BackupgroupsFile;
    protected boolean BackupconfigFile;
    protected int FlowLevel;
    protected int PlaceLevel;
    protected int BlockFallLevel;
    protected int CleanLevel;
    protected int NewPlayerRangeX;
    protected int NewPlayerRangeY;
    protected int NewPlayerRangeZ;
    protected int VisualizerRange;
    protected int VisualizerShowFor;
    protected int VisualizerUpdateInterval;
    protected int TeleportDelay;
    protected boolean TeleportTitleMessage;
    protected int VisualizerRowSpacing;
    protected int VisualizerCollumnSpacing;
    protected int VisualizerSkipBy;
    private int VisualizerFrameCap;
    private int VisualizerSidesCap;
    protected boolean flagsInherit;
    protected ChatColor chatColor;
    protected boolean chatEnable;
    private ELMessageType EnterLeaveMessageType;
    protected boolean ActionBarOnSelection;
    protected boolean visualizer;
    protected int minMoveUpdate;
    protected int MaxResCount;
    protected int MaxRentCount;
    protected int MaxSubzonesCount;
    protected int MaxSubzoneDepthCount;
    protected int VoteRangeFrom;
    protected int HealInterval;
    protected int FeedInterval;
    protected int VoteRangeTo;
    protected FlagPermissions globalCreatorDefaults;
    protected FlagPermissions globalRentedDefaults;
    protected FlagPermissions globalResidenceDefaults;
    protected Map<String, FlagPermissions> globalGroupDefaults;
    protected String language;
    protected String DefaultWorld;
    protected String DateFormat;
    protected String DateFormatShort;
    protected String TimeZone;
    protected boolean preventBuildInRent;
    protected boolean PreventSubZoneRemoval;
    protected boolean stopOnSaveError;
    protected boolean legacyperms;
    protected String namefix;
    protected boolean showIntervalMessages;
    protected boolean ShowNoobMessage;
    protected boolean NewPlayerUse;
    protected boolean NewPlayerFree;
    protected boolean spoutEnable;
    protected boolean AutoMobRemoval;
    protected boolean BounceAnimation;
    private boolean EnterAnimation;
    protected boolean useFlagGUI;
    protected int AutoMobRemovalInterval;
    protected boolean enableLeaseMoneyAccount;
    protected boolean Couldroncompatibility;
    protected boolean enableDebug = false;
    protected boolean versionCheck = true;
    protected boolean UUIDConvertion = true;
    protected boolean OfflineMode = false;
    protected boolean SelectionIgnoreY = false;
    protected boolean SelectionIgnoreYInSubzone = false;
    protected boolean NoCostForYBlocks = false;
    protected boolean useVisualizer;
    protected boolean DisableListeners;
    protected boolean DisableCommands;
    protected boolean TNTExplodeBelow;
    protected int TNTExplodeBelowLevel;
    protected boolean CreeperExplodeBelow;
    protected int CreeperExplodeBelowLevel;
    protected List<CMIMaterial> customContainers = new ArrayList<CMIMaterial>();
    protected List<CMIMaterial> customBothClick = new ArrayList<CMIMaterial>();
    protected List<CMIMaterial> customRightClick = new ArrayList<CMIMaterial>();
    protected List<Material> CleanBlocks = new ArrayList<Material>();
    protected List<String> NoFlowWorlds;
    protected List<String> AutoCleanUpWorlds;
    protected List<String> NoPlaceWorlds;
    protected List<String> BlockFallWorlds;
    protected List<String> CleanWorlds;
    protected List<String> FlagsList;
    protected List<String> NegativePotionEffects;
    protected List<String> NegativeLingeringPotionEffects;
    private Double WalkSpeed1;
    private Double WalkSpeed2;
    protected Location KickLocation;
    protected Location FlyLandLocation;
    protected List<RandomTeleport> RTeleport = new ArrayList<RandomTeleport>();
    protected List<String> DisabledWorldsList = new ArrayList<String>();
    protected int rtCooldown;
    protected int rtMaxTries;
    private HashMap<FlagPermissions.FlagState, ItemStack> guiBottonStates = new HashMap();
    private boolean enforceAreaInsideArea;
    protected CMIEffectManager.CMIParticle SelectedFrame;
    protected CMIEffectManager.CMIParticle SelectedSides;
    protected CMIEffectManager.CMIParticle OverlapFrame;
    protected CMIEffectManager.CMIParticle OverlapSides;
    public boolean DynMapUse;
    public boolean DynMapShowFlags;
    public boolean DynMapHideHidden;
    public boolean DynMapLayer3dRegions;
    public int DynMapLayerSubZoneDepth;
    public String DynMapBorderColor;
    public double DynMapBorderOpacity;
    public int DynMapBorderWeight;
    public String DynMapFillColor;
    public double DynMapFillOpacity;
    public String DynMapFillForRent;
    public String DynMapFillRented;
    public String DynMapFillForSale;
    public List<String> DynMapVisibleRegions;
    public List<String> DynMapHiddenRegions;
    public static boolean RaidEnabled = false;
    public static boolean RaidAttackerBlockBreak = false;
    public static boolean RaidAttackerBlockPlace = false;
    public static boolean RaidDefenderBlockBreak = false;
    public static boolean RaidDefenderBlockPlace = false;
    public static boolean RaidDefenderTeleport = false;
    public static boolean RaidDefenderContainerUsage = false;
    public static boolean RaidFriendlyFire = false;
    public static int PreRaidTimer = 120;
    public static int RaidTimer = 120;
    public static int RaidCooldown = 120;
    public static int RaidPlayerCooldown = 120;
    public boolean RestoreAfterRentEnds;
    public boolean SchematicsSaveOnFlagChange;
    public boolean GlobalChatEnabled;
    public boolean GlobalChatSelfModify;
    public String GlobalChatFormat;
    private Residence plugin;

    public ConfigManager(Residence plugin) {
        this.plugin = plugin;
        this.globalCreatorDefaults = new FlagPermissions();
        this.globalRentedDefaults = new FlagPermissions();
        this.globalResidenceDefaults = new FlagPermissions();
        this.globalGroupDefaults = new HashMap<String, FlagPermissions>();
        this.UpdateConfigFile();
        this.loadFlags();
    }

    public static String Colors(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static List<String> getClassesFromPackage(String pckgname, String cleaner) throws ClassNotFoundException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            URL[] uRLArray = ((URLClassLoader)Residence.class.getClassLoader()).getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL jarURL = uRLArray[n2];
                try {
                    result.addAll(ConfigManager.getClassesInSamePackageFromJar(pckgname, jarURL.toURI().getPath(), cleaner));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(String.valueOf(pckgname) + " does not appear to be a valid package (Null pointer exception)");
        }
        return result;
    }

    private static List<String> getClassesInSamePackageFromJar(String packageName, String jarPath, String cleaner) {
        ArrayList<String> listOfCommands;
        block15: {
            JarFile jarFile = null;
            listOfCommands = new ArrayList<String>();
            try {
                try {
                    jarFile = new JarFile(jarPath);
                    Enumeration<JarEntry> en = jarFile.entries();
                    while (en.hasMoreElements()) {
                        JarEntry entry = en.nextElement();
                        String entryName = entry.getName();
                        packageName = packageName.replace(".", "/");
                        if (entryName == null || !entryName.endsWith(".yml") || !entryName.startsWith(packageName)) continue;
                        String name = entryName.replace(packageName, "").replace(".yml", "").replace("/", "");
                        if (name.contains("$")) {
                            name = name.split("\\$")[0];
                        }
                        if (cleaner != null) {
                            name = name.replace(cleaner, "");
                        }
                        listOfCommands.add(name);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (jarFile == null) break block15;
                    try {
                        jarFile.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return listOfCommands;
    }

    public void copyOverTranslations() {
        ArrayList<String> languages = new ArrayList<String>();
        try {
            languages.addAll(ConfigManager.getClassesFromPackage("Language", null));
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        for (String one : languages) {
            File file = new File(this.plugin.getDataFolder(), "Language" + File.separator + one + ".yml");
            if (file.exists()) continue;
            YmlMaker f = new YmlMaker(this.plugin, "Language" + File.separator + one + ".yml");
            f.saveDefaultConfig();
            f.ConfigFile.renameTo(file);
        }
    }

    public void ChangeConfig(String path, Boolean stage) {
        File f = new File(this.plugin.getDataFolder(), "config.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        if (!conf.isBoolean(path)) {
            return;
        }
        conf.set(path, (Object)stage);
        try {
            conf.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.plugin.getConfigManager().UpdateConfigFile();
    }

    public static List<String> ColorsArray(List<String> text, Boolean colorize) {
        ArrayList<String> temp = new ArrayList<String>();
        for (String part : text) {
            if (colorize.booleanValue()) {
                part = ConfigManager.Colors(part);
            }
            temp.add(ConfigManager.Colors(part));
        }
        return temp;
    }

    void UpdateFlagFile() {
        File f = new File(this.plugin.getDataFolder(), "flags.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        if (!conf.isList("Global.TotalFlagDisabling")) {
            conf.set("Global.TotalFlagDisabling", Arrays.asList("Completely", "Disabled", "Particular", "Flags"));
        }
        Flags[] flagsArray = Flags.values();
        int n = flagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Flags fl = flagsArray[n2];
            if (!conf.isBoolean("Global.FlagPermission." + (Object)((Object)fl))) {
                conf.createSection("Global.FlagPermission." + (Object)((Object)fl));
                conf.set("Global.FlagPermission." + (Object)((Object)fl), (Object)fl.isEnabled());
            }
            ++n2;
        }
        if (!conf.isConfigurationSection("Global.FlagGui")) {
            conf.createSection("Global.FlagGui");
        }
        if (!conf.isConfigurationSection("Global.RentedDefault")) {
            for (Map.Entry<String, Boolean> one : this.getGlobalCreatorDefaultFlags().getFlags().entrySet()) {
                conf.set("Global.RentedDefault." + one.getKey(), (Object)one.getValue());
            }
            conf.set("Global.RentedDefault.admin", (Object)true);
        }
        ConfigurationSection guiSection = conf.getConfigurationSection("Global.FlagGui");
        Flags[] flagsArray2 = Flags.values();
        int n3 = flagsArray2.length;
        n = 0;
        while (n < n3) {
            Flags fl = flagsArray2[n];
            guiSection.set(fl.toString(), guiSection.get(fl.toString(), (Object)fl.getIcon().toString()));
            ++n;
        }
        try {
            conf.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ConfigReader cfg = null;
        try {
            cfg = new ConfigReader(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cfg == null) {
            return;
        }
        cfg.load();
        cfg.addComment("Global", "These are Global Settings for Residence.");
        cfg.addComment("Global.Flags", "These are world flags that are applied when the player is NOT within a residence.");
        cfg.addComment("Global.Flags.Global", "these are default for all worlds unless specified below, they can be overridden per group");
        cfg.addComment("Global.FlagPermission", "This gives permission to change certain flags to all groups, unless specifically denied to the group.");
        cfg.addComment("Global.FlagGui", "This sets GUI items to represent each flag, if not given, then gray wool will be used");
        cfg.addComment("Global.ResidenceDefault", "These are default flags applied to all residences from any user group.");
        cfg.addComment("Global.CreatorDefault", "These are default flags applied to the residence creator of any group.");
        cfg.addComment("Global.RentedDefault", "These are default flags applied to the residence renter of any group.");
        cfg.addComment("Global.GroupedFlags", "These are grouped flags, so when using /res pset nickname redstone true, player will get all flags in list, same when setting to false or removing them.");
        cfg.addComment("Global.TotalFlagDisabling", "Completely disables defined flag which will no longer be accesable even with resadmin command", "Can save some of the server processing resources if you dont want to utilize specific checks for specific flags");
        cfg.addComment("Global.GroupDefault", "These are default group flags applied to a residence made by a user of any group.");
        cfg.addComment("ItemList", "this is where you can create blacklists / whitelists");
        cfg.addComment("ItemList.DefaultList", "list name is not important, as long as it is unique. Its good to use a descripive name.");
        cfg.addComment("ItemList.DefaultList.Type", "type of the list, can be blacklist, whitelist, or ignorelist");
        cfg.addComment("ItemList.DefaultList.Items", "If you want, you can have this list only apply to one world, otherwise it applies to all worlds", "World: world", "You can also have the list apply only to one group, otherwise it applies for all groups", "Group: default", "this is the actual list of material names that this list allows or disallows", "You can look up the material name by item ID in game by typing /res material <id>", "Alternativly, you can simply use the item ID in the list, but its less descriptive and harder to see what the list allows or dissallows at a glance");
        cfg.save();
    }

    public void UpdateGroupedFlagsFile() {
        File f = new File(this.plugin.getDataFolder(), "flags.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        if (!conf.isConfigurationSection("Global.GroupedFlags")) {
            conf.createSection("Global.GroupedFlags");
            conf.set("Global.GroupedFlags.redstone", Arrays.asList(Flags.note.toString(), Flags.pressure.toString(), Flags.lever.toString(), Flags.button.toString(), Flags.diode.toString()));
            conf.set("Global.GroupedFlags.craft", Arrays.asList(Flags.brew.toString(), Flags.table.toString(), Flags.enchant.toString()));
            conf.set("Global.GroupedFlags.trusted", Arrays.asList(Flags.use.toString(), Flags.tp.toString(), Flags.build.toString(), Flags.container.toString(), Flags.move.toString(), Flags.leash.toString(), Flags.animalkilling.toString(), Flags.mobkilling.toString(), Flags.shear.toString(), Flags.chat.toString()));
            conf.set("Global.GroupedFlags.fire", Arrays.asList(Flags.ignite.toString(), Flags.firespread.toString()));
            try {
                conf.save(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String oneGroup : conf.getConfigurationSection("Global.GroupedFlags").getKeys(false)) {
            for (String OneFlag : conf.getStringList("Global.GroupedFlags." + oneGroup)) {
                FlagPermissions.addFlagToFlagGroup(oneGroup, OneFlag);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void UpdateConfigFile() {
        void var21_37;
        int CenterZ;
        int CenterX;
        int MinCoord;
        int MaxCoord;
        boolean enabled;
        String path;
        ConfigurationSection sec;
        World world;
        String defaultWorldName = Bukkit.getServer().getWorlds().size() > 0 ? ((World)Bukkit.getServer().getWorlds().get(0)).getName() : "World";
        ConfigReader c = null;
        try {
            c = new ConfigReader("config.yml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (c == null) {
            return;
        }
        c.copyDefaults(true);
        c.addComment("Global", "These are Global Settings for Residence.");
        c.addComment("Global.UUIDConvertion", "Starts UUID conversion on plugin startup", "DONT change this if you are not sure what you doing");
        this.UUIDConvertion = c.get("Global.UUIDConvertion", true);
        c.addComment("Global.OfflineMode", "If you running offline server, better to check this as true. This will help to solve issues with changing players UUID.");
        this.OfflineMode = c.get("Global.OfflineMode", false);
        c.addComment("Global.versionCheck", "Players with residence.versioncheck permission node will be noticed about new residence version on login");
        this.versionCheck = c.get("Global.versionCheck", true);
        c.addComment("Global.Language", "This loads the <language>.yml file in the Residence Language folder", "All Residence text comes from this file. (NOT DONE YET)");
        this.language = c.get("Global.Language", "English");
        c.addComment("Global.SelectionToolId", "Wooden Hoe is the default selection tool for Residence.", "You can change it to another item ID listed here: http://www.minecraftwiki.net/wiki/Data_values");
        this.selectionTool = CMIMaterial.get(c.get("Global.SelectionToolId", CMIMaterial.WOODEN_HOE.name()));
        c.addComment("Global.Selection.IgnoreY", "By setting this to true, all selections will be made from bedrock to sky ignoring Y coordinates");
        this.SelectionIgnoreY = c.get("Global.Selection.IgnoreY", false);
        c.addComment("Global.Selection.IgnoreYInSubzone", "When this set to true, selections inside existing residence will be from bottom to top of that residence", "When this set to false, selections inside existing residence will be exactly as they are");
        this.SelectionIgnoreYInSubzone = c.get("Global.Selection.IgnoreYInSubzone", false);
        c.addComment("Global.Selection.NoCostForYBlocks", "By setting this to true, player will only pay for x*z blocks ignoring height", "This will lower residence price by up to 256 times, so adjust block price BEFORE enabling this");
        this.NoCostForYBlocks = c.get("Global.Selection.NoCostForYBlocks", false);
        c.addComment("Global.InfoToolId", "This determins which tool you can use to see info on residences, default is String.", "Simply equip this tool and hit a location inside the residence and it will display the info for it.");
        this.infoTool = CMIMaterial.get(c.get("Global.InfoToolId", Material.STRING.toString()));
        c.addComment("Global.Optimizations.CanTeleportIncludeOwner", "This will slightly change behavior of groups file CanTeleport section which will include server owner into check", "When this is set to false and CanTeleport set to false, players will not have option to teleport to other player residences, only to their own", "When this is set to true and CanTeleport set to false, players will not have option to teleport to residences in general", "Keep in mind that this only applies for commands like /res tp");
        this.CanTeleportIncludeOwner = c.get("Global.Optimizations.CanTeleportIncludeOwner", false);
        c.addComment("Global.Optimizations.DefaultWorld", "Name of your main residence world. Usually normal starting world 'World'. Capitalization essential");
        this.DefaultWorld = c.get("Global.Optimizations.DefaultWorld", defaultWorldName);
        c.addComment("Global.Optimizations.DisabledWorlds.List", "List Of Worlds where this plugin is disabled");
        this.DisabledWorldsList = c.get("Global.Optimizations.DisabledWorlds.List", new ArrayList<String>());
        c.addComment("Global.Optimizations.DisabledWorlds.DisableListeners", "Disables all listeners in included worlds");
        this.DisableListeners = c.get("Global.Optimizations.DisabledWorlds.DisableListeners", true);
        c.addComment("Global.Optimizations.DisabledWorlds.DisableCommands", "Disabled any command usage in included worlds");
        this.DisableCommands = c.get("Global.Optimizations.DisabledWorlds.DisableCommands", true);
        c.addComment("Global.Optimizations.ItemPickUpDelay", "Delay in seconds between item pickups after residence flag prevents it", "Keep it at arround 10 sec to lower unesecery checks");
        this.ItemPickUpDelay = c.get("Global.Optimizations.ItemPickUpDelay", 10);
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.CheckCollision", "When set to true /res auto command will check for new area collision with other residences to avoid overlapping.", "Set it to false to gain some performace but new residence can often overlap with old ones");
        this.AutomaticResidenceCreationCheckCollision = c.get("Global.Optimizations.AutomaticResidenceCreation.CheckCollision", true);
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.IncrementFormat", "Defines new residence name increment when using automatic residence creation command if residence with that name already exist");
        this.AutomaticResidenceCreationIncrementFormat = c.get("Global.Optimizations.AutomaticResidenceCreation.IncrementFormat", "_[number]");
        c.addComment("Global.Optimizations.GlobalChat.Enabled", "Enables or disables chat modification by including players main residence name");
        this.GlobalChatEnabled = c.get("Global.Optimizations.GlobalChat.Enabled", false);
        c.addComment("Global.Optimizations.GlobalChat.SelfModify", "Modifys chat to add chat titles.  If you're using a chat manager, you may add the tag {residence} to your chat format and disable this.");
        this.GlobalChatSelfModify = c.get("Global.Optimizations.GlobalChat.SelfModify", true);
        this.GlobalChatFormat = c.get("Global.Optimizations.GlobalChat.Format", "&c[&e%1&c]");
        c.addComment("Global.Optimizations.BlockAnyTeleportation", "When this set to true, any teleportation to residence where player dont have tp flag, action will be denyied", "This can prevent from teleporting players to residence with 3rd party plugins like esentials /tpa");
        this.BlockAnyTeleportation = c.get("Global.Optimizations.BlockAnyTeleportation", true);
        c.addComment("Global.Optimizations.MaxResCount", "Set this as low as possible depending of residence.max.res.[number] permission you are using", "In example if you are giving max number of 10 for players, set it to 15, if its 30, set it to 35 just to have some small buffer in case");
        this.MaxResCount = c.get("Global.Optimizations.MaxResCount", 30);
        c.addComment("Global.Optimizations.MaxRentCount", "Set this as low as possible depending of residence.max.rents.[number] permission you are using", "In example if you are giving max number of 10 for players, set it to 15, if its 30, set it to 35 just to have some small buffer in case");
        this.MaxRentCount = c.get("Global.Optimizations.MaxRentCount", 10);
        c.addComment("Global.Optimizations.MaxSubzoneCount", "Set this as low as possible depending of residence.max.subzones.[number] permission you are using", "In example if you are giving max number of 10 for players, set it to 15, if its 30, set it to 35 just to have some small buffer in case");
        this.MaxSubzonesCount = c.get("Global.Optimizations.MaxSubzoneCount", 5);
        c.addComment("Global.Optimizations.MaxSubzoneDepthCount", "Set this as low as possible depending of residence.max.subzonedepth.[number] permission you are using", "In example if you are giving max number of 10 for players, set it to 15, if its 30, set it to 35 just to have some small buffer in case");
        this.MaxSubzoneDepthCount = c.get("Global.Optimizations.MaxSubzoneDepthCount", 5);
        c.addComment("Global.Optimizations.OverridePvp", "By setting this to true, regular pvp flag will be acting as overridepvp flag", "Overridepvp flag tries to ignore any pvp protection in that residence by any other plugin");
        this.OverridePvp = c.get("Global.Optimizations.OverridePvp", false);
        c.addComment("Global.Optimizations.KickLocation.Use", "By setting this to true, when player kicks another player from residence, he will be teleported to this location instead of getting outside residence");
        Boolean UseKick = c.get("Global.Optimizations.KickLocation.Use", false);
        String KickLocationWorld = c.get("Global.Optimizations.KickLocation.World", defaultWorldName);
        Double KickLocationX = c.get("Global.Optimizations.KickLocation.X", 0.5);
        Double KickLocationY = c.get("Global.Optimizations.KickLocation.Y", 63.0);
        Double KickLocationZ = c.get("Global.Optimizations.KickLocation.Z", 0.5);
        c.addComment("Global.Optimizations.KickLocation.Pitch", "Less than 0 - head up, more than 0 - head down. Range from -90 to 90");
        Double KickPitch = c.get("Global.Optimizations.KickLocation.Pitch", 0.0);
        c.addComment("Global.Optimizations.KickLocation.Yaw", "Head position to left and right. Range from -180 to 180");
        Double KickYaw = c.get("Global.Optimizations.KickLocation.Yaw", 0.0);
        if (UseKick.booleanValue() && (world = Bukkit.getWorld((String)KickLocationWorld)) != null) {
            this.KickLocation = new Location(world, KickLocationX.doubleValue(), KickLocationY.doubleValue(), KickLocationZ.doubleValue());
            this.KickLocation.setPitch(KickPitch.floatValue());
            this.KickLocation.setYaw(KickYaw.floatValue());
        }
        c.addComment("Global.Optimizations.FlyLandLocation.World", "Used when players fly state is being turned to false because of fly flag and there is no solid land where to land for player");
        String FlyLocationWorld = c.get("Global.Optimizations.FlyLandLocation.World", defaultWorldName);
        Double FlyLocationX = c.get("Global.Optimizations.FlyLandLocation.X", 0.5);
        Double FlyLocationY = c.get("Global.Optimizations.FlyLandLocation.Y", 63.0);
        Double FlyLocationZ = c.get("Global.Optimizations.FlyLandLocation.Z", 0.5);
        c.addComment("Global.Optimizations.FlyLandLocation.Pitch", "Less than 0 - head up, more than 0 - head down. Range from -90 to 90");
        Double FlyPitch = c.get("Global.Optimizations.FlyLandLocation.Pitch", 0.0);
        c.addComment("Global.Optimizations.FlyLandLocation.Yaw", "Head position to left and right. Range from -180 to 180");
        Double FlyYaw = c.get("Global.Optimizations.FlyLandLocation.Yaw", 0.0);
        World world2 = Bukkit.getWorld((String)FlyLocationWorld);
        if (world2 != null) {
            this.FlyLandLocation = new Location(world2, FlyLocationX.doubleValue(), FlyLocationY.doubleValue(), FlyLocationZ.doubleValue());
            this.FlyLandLocation.setPitch(FlyPitch.floatValue());
            this.FlyLandLocation.setYaw(FlyYaw.floatValue());
        }
        c.addComment("Global.Optimizations.ShortInfo.Use", "By setting this to true, when checking residence info with /res info, you will get only names in list, by hovering on them, you will get flag list");
        this.ShortInfoUse = c.get("Global.Optimizations.ShortInfo.Use", true);
        c.addComment("Global.Optimizations.Vote.RangeFrom", "Range players can vote to, by default its from 0 to 10 points");
        this.VoteRangeFrom = c.get("Global.Optimizations.Vote.RangeFrom", 0);
        this.VoteRangeTo = c.get("Global.Optimizations.Vote.RangeTo", 10);
        c.addComment("Global.Optimizations.Vote.OnlyLike", "If this true, players can only give like for shop instead of point voting");
        this.OnlyLike = c.get("Global.Optimizations.Vote.OnlyLike", false);
        c.addComment("Global.Optimizations.ConsoleLogs.ShowFlagChanges", "If this true, flag changes throw GUI will be recorded in console");
        this.ConsoleLogsShowFlagChanges = c.get("Global.Optimizations.ConsoleLogs.ShowFlagChanges", true);
        c.addComment("Global.Optimizations.Intervals.Heal", "How often in seconds to heal/feed players in residence with appropriate flag", "Bigger numbers can save some resources");
        this.HealInterval = c.get("Global.Optimizations.Intervals.Heal", 1);
        this.FeedInterval = c.get("Global.Optimizations.Intervals.Feed", 5);
        c.addComment("Global.Optimizations.NegativePotionEffects", "Potions containing one of thos effects will be ignored if residence dont have pvp true flag set");
        this.NegativePotionEffects = c.get("Global.Optimizations.NegativePotionEffects", Arrays.asList("blindness", "confusion", "harm", "hunger", "poison", "slow", "slow_digging", "weakness", "wither"));
        this.NegativeLingeringPotionEffects = c.get("Global.Optimizations.NegativeLingeringPotions", Arrays.asList("slowness", "instant_damage", "poison", "slowness"));
        c.addComment("Global.Optimizations.WalkSpeed", "Defines speed for particular wspeed1 and wspeed2 flags. It can be from 0 up to 5");
        this.WalkSpeed1 = c.get("Global.Optimizations.WalkSpeed.1", 0.5);
        this.WalkSpeed1 = this.WalkSpeed1 < 0.0 ? 0.0 : this.WalkSpeed1;
        this.WalkSpeed1 = this.WalkSpeed1 > 5.0 ? 5.0 : this.WalkSpeed1;
        this.WalkSpeed1 = this.WalkSpeed1 / 5.0;
        this.WalkSpeed2 = c.get("Global.Optimizations.WalkSpeed.2", 2.0);
        this.WalkSpeed2 = this.WalkSpeed2 < 0.0 ? 0.0 : this.WalkSpeed2;
        this.WalkSpeed2 = this.WalkSpeed2 > 5.0 ? 5.0 : this.WalkSpeed2;
        this.WalkSpeed2 = this.WalkSpeed2 / 5.0;
        c.addComment("Global.MoveCheckInterval", "The interval, in milliseconds, between movement checks.", "Reducing this will increase the load on the server.", "Increasing this will allow players to move further in movement restricted zones before they are teleported out.");
        this.minMoveUpdate = c.get("Global.MoveCheckInterval", 500);
        c.addComment("Global.Tp.TeleportDelay", "The interval, in seconds, for teleportation.", "Use 0 to disable");
        this.TeleportDelay = c.get("Global.Tp.TeleportDelay", 3);
        c.addComment("Global.Tp.TeleportTitleMessage", "Show aditional message in title message area when player is teleporting to residence");
        this.TeleportTitleMessage = c.get("Global.Tp.TeleportTitleMessage", true);
        HashSet worlds = new HashSet();
        worlds.addAll(Bukkit.getWorlds());
        boolean commented = false;
        if (c.getC().isConfigurationSection("Global.RandomTeleportation.Worlds") && (sec = c.getC().getConfigurationSection("Global.RandomTeleportation.Worlds")) != null) {
            for (String string : sec.getKeys(false)) {
                path = "Global.RandomTeleportation.Worlds." + string + ".";
                enabled = c.get("Enabled", true);
                if (!commented) {
                    c.addComment("Global.RandomTeleportation.Worlds." + string, "World name to use this feature. Add annother one with appropriate name to enable random teleportation");
                }
                if (!commented) {
                    c.addComment(String.valueOf(path) + "MaxCoord", "Max coordinate to teleport, setting to 1000, player can be teleported between -1000 and 1000 coordinates");
                }
                MaxCoord = c.get("MaxCoord", 1000);
                if (!commented) {
                    c.addComment(String.valueOf(path) + "MinCoord", "If maxcoord set to 1000 and mincoord to 500, then player can be teleported between -1000 to -500 and 1000 to 500 coordinates");
                }
                MinCoord = c.get("MinCoord", c.getC().getInt(String.valueOf(path) + "MinCord", 500));
                CenterX = c.get("CenterX", 0);
                CenterZ = c.get("CenterZ", 0);
                World w = this.getWorld(string);
                if (w == null) {
                    this.plugin.consoleMessage("&cCan't find world with (" + string + ") name");
                    continue;
                }
                commented = true;
                worlds.remove(w);
                if (!enabled) continue;
                this.RTeleport.add(new RandomTeleport(w, MaxCoord, MinCoord, CenterX, CenterZ));
            }
        }
        for (World one : worlds) {
            String string2 = one.getName();
            string2 = string2.replace(".", "_");
            path = "Global.RandomTeleportation.Worlds." + string2 + ".";
            enabled = c.get("Enabled", true);
            MaxCoord = c.get("MaxCoord", 1000);
            MinCoord = c.get("MinCoord", c.getC().getInt(String.valueOf(path) + "MinCord", 500));
            CenterX = c.get("CenterX", 0);
            CenterZ = c.get("CenterZ", 0);
            if (!enabled) continue;
            this.RTeleport.add(new RandomTeleport(one, MaxCoord, MinCoord, CenterX, CenterZ));
        }
        c.addComment("Global.RandomTeleportation.Cooldown", "How long force player to wait before using command again.");
        this.rtCooldown = c.get("Global.RandomTeleportation.Cooldown", 5);
        c.addComment("Global.RandomTeleportation.MaxTries", "How many times to try find correct location for teleportation.", "Keep it at low number, as player always can try again after delay");
        this.rtMaxTries = c.get("Global.RandomTeleportation.MaxTries", 20);
        c.addComment("Global.SaveInterval", "The interval, in minutes, between residence saves.");
        this.autoSaveInt = c.get("Global.SaveInterval", 10);
        c.addComment("Global.NewSaveMechanic", "New save mechanic can minimize save file couple times and speedup save/load time in general", "Bigger files have bigger impact");
        this.NewSaveMechanic = c.get("Global.NewSaveMechanic", true);
        c.addComment("Global.Backup.AutoCleanUp.Use", "Do you want to automatically remove backup files from main backup folder if they are older than defined day amount");
        this.BackupAutoCleanUpUse = c.get("Global.Backup.AutoCleanUp.Use", false);
        this.BackupAutoCleanUpDays = c.get("Global.Backup.AutoCleanUp.Days", 30);
        c.addComment("Global.Backup.UseZip", "Do you want to backup files by creating zip files in main residence folder in backup folder", "This wont have effect on regular backuped files made in save folder");
        this.UseZipBackup = c.get("Global.Backup.UseZip", true);
        this.BackupWorldFiles = c.get("Global.Backup.IncludeFiles.Worlds", true);
        this.BackupforsaleFile = c.get("Global.Backup.IncludeFiles.forsale", true);
        this.BackupleasesFile = c.get("Global.Backup.IncludeFiles.leases", true);
        this.BackuppermlistsFile = c.get("Global.Backup.IncludeFiles.permlists", true);
        this.BackuprentFile = c.get("Global.Backup.IncludeFiles.rent", true);
        this.BackupflagsFile = c.get("Global.Backup.IncludeFiles.flags", true);
        this.BackupgroupsFile = c.get("Global.Backup.IncludeFiles.groups", true);
        this.BackupconfigFile = c.get("Global.Backup.IncludeFiles.config", true);
        c.addComment("Global.AutoCleanUp.Use", "HIGHLY EXPERIMENTAL residence cleaning on server startup if player is offline for x days.", "Players can bypass this with residence.cleanbypass permission node");
        this.AutoCleanUp = c.get("Global.AutoCleanUp.Use", false);
        c.addComment("Global.AutoCleanUp.Days", "For how long player should be offline to delete hes residence");
        this.AutoCleanUpDays = c.get("Global.AutoCleanUp.Days", 60);
        c.addComment("Global.AutoCleanUp.Regenerate", "Do you want to regenerate old residence area", "This requires world edit to be present");
        this.AutoCleanUpRegenerate = c.get("Global.AutoCleanUp.Regenerate", false);
        c.addComment("Global.AutoCleanUp.Worlds", "Worlds to be included in check list");
        this.AutoCleanUpWorlds = c.get("Global.AutoCleanUp.Worlds", Arrays.asList(defaultWorldName));
        c.addComment("Global.Lwc.OnDelete", "Removes lwc protection from all defined objects when removing residence");
        this.LwcOnDelete = c.get("Global.Lwc.OnDelete", true);
        c.addComment("Global.Lwc.OnBuy", "Removes lwc protection from all defined objects when buying residence");
        this.LwcOnBuy = c.get("Global.Lwc.OnBuy", true);
        c.addComment("Global.Lwc.OnUnrent", "Removes lwc protection from all defined objects when unrenting residence");
        this.LwcOnUnrent = c.get("Global.Lwc.OnUnrent", true);
        c.addComment("Global.Lwc.MaterialList", "List of blocks you want to remove protection from");
        for (String oneName : c.get("Global.Lwc.MaterialList", Arrays.asList("CHEST", "TRAPPED_CHEST", "furnace", "dispenser"))) {
            Material material2 = Material.getMaterial((String)oneName.toUpperCase());
            if (material2 != null) {
                this.LwcMatList.add(material2);
                continue;
            }
            Bukkit.getConsoleSender().sendMessage("Incorrect Lwc material name for " + oneName);
        }
        c.addComment("Global.AntiGreef.TNT.ExplodeBelow", "When set to true will allow tnt and minecart with tnt to explode below 62 (default) level outside of residence", "This will allow mining with tnt and more vanilla play");
        this.TNTExplodeBelow = c.get("Global.AntiGreef.TNT.ExplodeBelow", false);
        this.TNTExplodeBelowLevel = c.get("Global.AntiGreef.TNT.level", 62);
        c.addComment("Global.AntiGreef.Creeper.ExplodeBelow", "When set to true will allow Creeper explode below 62 (default) level outside of residence", "This will give more realistic game play");
        this.CreeperExplodeBelow = c.get("Global.AntiGreef.Creeper.ExplodeBelow", false);
        this.CreeperExplodeBelowLevel = c.get("Global.AntiGreef.Creeper.level", 62);
        c.addComment("Global.AntiGreef.Flow.Level", "Level from which one to start lava and water flow blocking", "This dont have effect in residence area");
        this.FlowLevel = c.get("Global.AntiGreef.Flow.Level", 63);
        c.addComment("Global.AntiGreef.Flow.NoLavaFlow", "With this set to true, lava flow outside residence is blocked");
        this.NoLava = c.get("Global.AntiGreef.Flow.NoLavaFlow", true);
        c.addComment("Global.AntiGreef.Flow.NoWaterFlow", "With this set to true, water flow outside residence is blocked");
        this.NoWater = c.get("Global.AntiGreef.Flow.NoWaterFlow", true);
        this.NoFlowWorlds = c.get("Global.AntiGreef.Flow.Worlds", Arrays.asList(defaultWorldName));
        c.addComment("Global.AntiGreef.Place.Level", "Level from which one to start block lava and water place", "This don't have effect in residence area");
        this.PlaceLevel = c.get("Global.AntiGreef.Place.Level", 63);
        c.addComment("Global.AntiGreef.Place.NoLavaPlace", "With this set to true, playrs cant place lava outside residence");
        this.NoLavaPlace = c.get("Global.AntiGreef.Place.NoLavaPlace", true);
        c.addComment("Global.AntiGreef.Place.NoWaterPlace", "With this set to true, playrs cant place water outside residence");
        this.NoWaterPlace = c.get("Global.AntiGreef.Place.NoWaterPlace", true);
        this.NoPlaceWorlds = c.get("Global.AntiGreef.Place.Worlds", Arrays.asList(defaultWorldName));
        c.addComment("Global.AntiGreef.BlockFall.Use", "With this set to true, falling blocks will be deleted if they will land in different area");
        this.useBlockFall = c.get("Global.AntiGreef.BlockFall.Use", true);
        c.addComment("Global.AntiGreef.BlockFall.Level", "Level from which one to start block block's fall", "This don't have effect in residence area or outside");
        this.BlockFallLevel = c.get("Global.AntiGreef.BlockFall.Level", 62);
        this.BlockFallWorlds = c.get("Global.AntiGreef.BlockFall.Worlds", Arrays.asList(defaultWorldName));
        c.addComment("Global.AntiGreef.ResCleaning.Use", "With this set to true, after player removes its residence, all blocks listed below, will be replaced with air blocks", "Effective way to prevent residence creating near greefing target and then remove it", "ATTENTION! Bigger residence areas could want to create bigger loads on server when cleaning up areas. So dont use this if regular player have access to huge residences. 15 million blocks would be a max limit");
        this.UseClean = c.get("Global.AntiGreef.ResCleaning.Use", false);
        c.addComment("Global.AntiGreef.ResCleaning.Level", "Level from whichone you want to replace blocks");
        this.CleanLevel = c.get("Global.AntiGreef.ResCleaning.Level", 63);
        c.addComment("Global.AntiGreef.ResCleaning.Blocks", "Block list to be replaced", "By default only water and lava will be replaced");
        List<String> pls = c.get("Global.AntiGreef.ResCleaning.Blocks", Arrays.asList(CMIMaterial.WATER.toString(), CMIMaterial.LAVA.toString()));
        for (String string : pls) {
            Object mat = CMIMaterial.get(String.valueOf(string));
            if (mat == CMIMaterial.NONE || mat.getMaterial() == null) continue;
            this.CleanBlocks.add(mat.getMaterial());
        }
        this.CleanWorlds = c.get("Global.AntiGreef.ResCleaning.Worlds", Arrays.asList(defaultWorldName));
        c.addComment("Global.AntiGreef.Flags.Prevent", "By setting this to true flags from list will be protected from change while there is some one inside residence besides owner", "Protects in example from people inviting some one and changing pvp flag to true to kill them");
        this.PvPFlagPrevent = c.get("Global.AntiGreef.Flags.Prevent", true);
        this.FlagsList = c.get("Global.AntiGreef.Flags.list", Arrays.asList("pvp"));
        c.addComment("Global.DefaultGroup", "The default group to use if Permissions fails to attach or your not using Permissions.");
        this.defaultGroup = c.get("Global.DefaultGroup", "default");
        c.addComment("Global.UseLeaseSystem", "Enable / Disable the Lease System.");
        this.useLeases = c.get("Global.UseLeaseSystem", false);
        c.addComment("Global.DateFormat", "Sets date format when shown in example lease or rent expire date", "How to use it properly, more information can be found at http://www.tutorialspoint.com/java/java_date_time.htm");
        this.DateFormat = c.get("Global.DateFormat", "E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        c.addComment("Global.DateFormatShort", "Sets date format when shown in example lease or rent expire date", "How to use it properly, more information can be found at http://www.tutorialspoint.com/java/java_date_time.htm");
        this.DateFormatShort = c.get("Global.DateFormatShort", "MM.dd hh:mm");
        c.addComment("Global.TimeZone", "Sets time zone for showing date, useful when server is in different country then main server player base", "Full list of possible time zones can be found at http://www.mkyong.com/java/java-display-list-of-timezone-with-gmt/");
        this.TimeZone = c.get("Global.TimeZone", Calendar.getInstance().getTimeZone().getID());
        c.addComment("Global.ResMoneyBack", "Enable / Disable money returning on residence removal.");
        this.ResMoneyBack = c.get("Global.ResMoneyBack", false);
        c.addComment("Global.LeaseCheckInterval", "The interval, in minutes, between residence lease checks (if leases are enabled).");
        this.leaseCheckInterval = c.get("Global.LeaseCheckInterval", 10);
        c.addComment("Global.LeaseAutoRenew", "Allows leases to automatically renew so long as the player has the money, if economy is disabled, this setting does nothing.");
        this.leaseAutoRenew = c.get("Global.LeaseAutoRenew", true);
        c.addComment("Global.EnablePermissions", "Whether or not to use the Permissions system in conjunction with this config.");
        c.get("Global.EnablePermissions", true);
        c.addComment("Global.LegacyPermissions", "Set to true if NOT using Permissions or PermissionsBukkit, or using a really old version of Permissions");
        this.legacyperms = c.get("Global.LegacyPermissions", false);
        c.addComment("Global.EnableEconomy", "Enable / Disable Residence's Economy System (iConomy, MineConomy, Essentials, BOSEconomy, and RealEconomy supported).");
        this.enableEconomy = c.get("Global.EnableEconomy", true);
        c.addComment("Global.Type", "Defaults to None which will start by looking to default economy engine throw vault API and if it fails to any supported economy engine", "Custom economy engines can be defined to access economy directly", "Supported variables: " + EconomyType.toStringLine());
        this.VaultEconomy = EconomyType.getByName(c.get("Global.Type", "None"));
        if (this.VaultEconomy == null) {
            this.plugin.consoleMessage("&cCould not determine economy from " + c.get("Global.Type", "Vault"));
            this.plugin.consoleMessage("&cTrying to find suitable economy system");
            this.VaultEconomy = EconomyType.None;
        }
        c.addComment("Global.ExtraEnterMessage", "When enabled extra message will appear in chat if residence is for rent or for sell to inform how he can rent/buy residence with basic information.");
        this.ExtraEnterMessage = c.get("Global.ExtraEnterMessage", true);
        c.addComment("Global.Sell.Subzone", "If set to true, this will allow to sell subzones. Its recommended to keep it false tho");
        this.SellSubzone = c.get("Global.Sell.Subzone", false);
        c.addComment("Global.EnableRentSystem", "Enables or disables the Rent System");
        this.enableRentSystem = c.get("Global.EnableRentSystem", true);
        c.addComment("Global.Rent.PreventRemoval", "Prevents residence/subzone removal if its subzone is still rented by some one");
        this.RentPreventRemoval = c.get("Global.Rent.PreventRemoval", true);
        c.addComment("Global.Rent.DeductFromBank", "When set to true residence rent can be renewed from residence bank");
        this.DeductFromBank = c.get("Global.Rent.DeductFromBank", false);
        c.addComment("Global.Rent.DeductFromBankThenPlayer", "When set to true residence rent can be renewed from residence bank and if there is not enough money then we will deduct rest of it from player", "This will override behavior of DeductFromBank");
        this.DeductFromBankThenPlayer = c.get("Global.Rent.DeductFromBankThenPlayer", false);
        c.addComment("Global.Rent.Inform.OnEnding", "Informs players on rent time ending");
        this.RentInformOnEnding = c.get("Global.Rent.Inform.OnEnding", true);
        c.addComment("Global.Rent.Inform.Before", "Time range in minutes when to start informing about ending rent");
        this.RentInformBefore = c.get("Global.Rent.Inform.Before", 1440);
        c.addComment("Global.Rent.Inform.Delay", "Time range in seconds for how long to wait after player logs in to inform about ending rents");
        this.RentInformDelay = c.get("Global.Rent.Inform.Delay", 60);
        c.addComment("Global.Rent.DefaultValues.AllowRenewing", "Default values used when putting residence for rent");
        this.RentAllowRenewing = c.get("Global.Rent.DefaultValues.AllowRenewing", true);
        this.RentStayInMarket = c.get("Global.Rent.DefaultValues.StayInMarket", true);
        this.RentAllowAutoPay = c.get("Global.Rent.DefaultValues.AllowAutoPay", true);
        c.addComment("Global.Rent.DefaultValues.PlayerAutoPay", "If set to true, when player is not defining auto pay on renting, then this value will be used");
        this.RentPlayerAutoPay = c.get("Global.Rent.DefaultValues.PlayerAutoPay", true);
        c.addComment("Global.Rent.Schematics.RestoreAfterRentEnds", "EXPERIMENTAL!!! If set to true, residence will be restored to state it was when backup flag was set to true", "For securoty reassons only players with aditional residence.backup permission node can set backup flag");
        this.RestoreAfterRentEnds = c.get("Global.Rent.Schematics.RestoreAfterRentEnds", true);
        c.addComment("Global.Rent.Schematics.SaveOnFlagChange", "When set to true, area state will be saved only when setting backup to true value", "When set to false, area state will be saved before each renting to have always up to date area look", "Keep in mind that when its set to false, there is slightly bigger server load as it has to save area each time when some one rents it");
        this.SchematicsSaveOnFlagChange = c.get("Global.Rent.Schematics.SaveOnFlagChange", true);
        c.addComment("Global.RentCheckInterval", "The interval, in minutes, between residence rent expiration checks (if the rent system is enabled).");
        this.rentCheckInterval = c.get("Global.RentCheckInterval", 10);
        c.addComment("Global.ResidenceChatEnable", "Enable or disable residence chat channels.");
        this.chatEnable = c.get("Global.ResidenceChatEnable", true);
        ELMessageType eLMessageType2 = c.getC().isBoolean("Global.ActionBar.General") && c.getC().getBoolean("Global.ActionBar.General") ? ELMessageType.ActionBar : ELMessageType.ChatBox;
        eLMessageType2 = c.getC().isBoolean("Global.TitleBar.EnterLeave") && c.getC().getBoolean("Global.TitleBar.EnterLeave") ? ELMessageType.TitleBar : eLMessageType2;
        c.addComment("Global.Messages.GeneralMessages", "Defines where you want to send residence enter/leave/deny move and similar messages. Possible options: " + ELMessageType.getAllValuesAsString(), "TitleBar can have %subtitle% variable to define second line");
        this.EnterLeaveMessageType = ELMessageType.getByName(c.get("Global.Messages.GeneralMessages", eLMessageType2.toString()));
        if (this.EnterLeaveMessageType == null || VersionChecker.Version.isCurrentEqualOrLower(VersionChecker.Version.v1_7_R4)) {
            this.EnterLeaveMessageType = ELMessageType.ChatBox;
        }
        this.ActionBarOnSelection = c.get("Global.ActionBar.ShowOnSelection", true);
        c.addComment("Global.ResidenceChatColor", "Color of residence chat.");
        try {
            this.chatColor = ChatColor.valueOf((String)c.get("Global.ResidenceChatColor", "DARK_PURPLE"));
        }
        catch (Exception exception) {
            this.chatColor = ChatColor.DARK_PURPLE;
        }
        c.addComment("Global.ResidenceChatPrefixLenght", "Max lenght of residence chat prefix including color codes");
        this.chatPrefixLength = c.get("Global.ResidenceChatPrefixLength", 16);
        c.addComment("Global.AdminOnlyCommands", "Whether or not to ignore the usual Permission flags and only allow OPs and groups with 'residence.admin' to change residences.");
        this.adminsOnly = c.get("Global.AdminOnlyCommands", false);
        c.addComment("Global.AdminOPs", "Setting this to true makes server OPs admins.");
        this.adminOps = c.get("Global.AdminOPs", true);
        c.addComment("Global.AdminFullAccess", "Setting this to true server administration wont need to use /resadmin command to access admin command if they are op or have residence.admin permission node.");
        this.AdminFullAccess = c.get("Global.AdminFullAccess", false);
        c.addComment("Global.MultiWorldPlugin", "This is the name of the plugin you use for multiworld, if you dont have a multiworld plugin you can safely ignore this.", "The only thing this does is check to make sure the multiworld plugin is enabled BEFORE Residence, to ensure properly loading residences for other worlds.");
        this.multiworldPlugin = c.get("Global.MultiWorldPlugin", "Multiverse-Core");
        c.addComment("Global.ResidenceFlagsInherit", "Setting this to true causes subzones to inherit flags from their parent zones.");
        this.flagsInherit = c.get("Global.ResidenceFlagsInherit", true);
        c.addComment("Global.PreventRentModify", "Setting this to false will allow rented residences to be modified by the renting player.");
        this.preventBuildInRent = c.get("Global.PreventRentModify", true);
        c.addComment("Global.PreventSubZoneRemoval", "Setting this to true will prevent subzone deletion when subzone owner is not same as parent zone owner.");
        this.PreventSubZoneRemoval = c.get("Global.PreventSubZoneRemoval", true);
        c.addComment("Global.StopOnSaveFault", "Setting this to false will cause residence to continue to load even if a error is detected in the save file.");
        this.stopOnSaveError = c.get("Global.StopOnSaveFault", true);
        c.addComment("This is the residence name filter, that filters out invalid characters.  Google 'Java RegEx' or 'Java Regular Expressions' for more info on how they work.", new String[0]);
        this.namefix = c.get("Global.ResidenceNameRegex", "[^a-zA-Z0-9\\-\\_]");
        c.addComment("Global.ShowIntervalMessages", "Setting this to true sends a message to the console every time Residence does a rent expire check or a lease expire check.");
        this.showIntervalMessages = c.get("Global.ShowIntervalMessages", false);
        c.addComment("Global.ShowNoobMessage", "Setting this to true sends a tutorial message to the new player when he places chest on ground.");
        this.ShowNoobMessage = c.get("Global.ShowNoobMessage", true);
        c.addComment("Global.NewPlayer", "Setting this to true creates residence around players placed chest if he don't have any.", "Only once every server restart if he still don't have any residence");
        this.NewPlayerUse = c.get("Global.NewPlayer.Use", false);
        c.addComment("Global.NewPlayer.Free", "Setting this to true, residence will be created for free", "By setting to false, money will be taken from player, if he has them");
        this.NewPlayerFree = c.get("Global.NewPlayer.Free", true);
        c.addComment("Global.NewPlayer.Range", "Range from placed chest o both sides. By setting to 5, residence will be 5+5+1 = 11 blocks wide");
        this.NewPlayerRangeX = c.get("Global.NewPlayer.Range.X", 5);
        this.NewPlayerRangeY = c.get("Global.NewPlayer.Range.Y", 5);
        this.NewPlayerRangeZ = c.get("Global.NewPlayer.Range.Z", 5);
        c.addComment("Global.CustomContainers", "Experimental - The following settings are lists of block IDs to be used as part of the checks for the 'container' and 'use' flags when using mods.");
        pls = c.get("Global.CustomContainers", new ArrayList<String>());
        for (Object e : pls) {
            CMIMaterial mat = CMIMaterial.get(String.valueOf(e));
            if (mat == CMIMaterial.NONE) continue;
            this.customContainers.add(mat);
        }
        pls = c.get("Global.CustomBothClick", new ArrayList<String>());
        for (Object e : pls) {
            CMIMaterial mat = CMIMaterial.get(String.valueOf(e));
            if (mat == CMIMaterial.NONE) continue;
            this.customBothClick.add(mat);
        }
        pls = c.get("Global.CustomRightClick", new ArrayList<String>());
        for (Object e : pls) {
            CMIMaterial mat = CMIMaterial.get(String.valueOf(e));
            if (mat == CMIMaterial.NONE) continue;
            this.customRightClick.add(mat);
        }
        c.addComment("Global.Visualizer.Use", "With this enabled player will see particle effects to mark selection boundaries");
        this.useVisualizer = c.get("Global.Visualizer.Use", true);
        c.addComment("Global.Visualizer.Range", "Range in blocks to draw particle effects for player", "Keep it no more as 30, as player cant see more than 16 blocks");
        this.VisualizerRange = c.get("Global.Visualizer.Range", 16);
        c.addComment("Global.Visualizer.ShowFor", "For how long in miliseconds (5000 = 5sec) to show particle effects");
        this.VisualizerShowFor = c.get("Global.Visualizer.ShowFor", 5000);
        c.addComment("Global.Visualizer.updateInterval", "How often in ticks to update particles for player");
        this.VisualizerUpdateInterval = c.get("Global.Visualizer.updateInterval", 20);
        c.addComment("Global.Visualizer.RowSpacing", "Spacing in blocks between particle effects for rows");
        this.VisualizerRowSpacing = c.get("Global.Visualizer.RowSpacing", 2);
        if (this.VisualizerRowSpacing < 1) {
            this.VisualizerRowSpacing = 1;
        }
        c.addComment("Global.Visualizer.CollumnSpacing", "Spacing in blocks between particle effects for collums");
        this.VisualizerCollumnSpacing = c.get("Global.Visualizer.CollumnSpacing", 2);
        if (this.VisualizerCollumnSpacing < 1) {
            this.VisualizerCollumnSpacing = 1;
        }
        c.addComment("Global.Visualizer.SkipBy", "Defines by how many particles we need to skip", "This will create moving particle effect and will improve overall look of selection", "By increasing this number, you can decrease update interval");
        this.VisualizerSkipBy = c.get("Global.Visualizer.SkipBy", 5);
        if (this.VisualizerSkipBy < 1) {
            this.VisualizerSkipBy = 1;
        }
        c.addComment("Global.Visualizer.FrameCap", "Maximum amount of frame particles to show for one player");
        this.VisualizerFrameCap = c.get("Global.Visualizer.FrameCap", 500);
        if (this.VisualizerFrameCap < 1) {
            this.VisualizerFrameCap = 1;
        }
        c.addComment("Global.Visualizer.SidesCap", "Maximum amount of sides particles to show for one player");
        this.VisualizerSidesCap = c.get("Global.Visualizer.SidesCap", 2000);
        if (this.VisualizerSidesCap < 1) {
            this.VisualizerSidesCap = 1;
        }
        String string = "";
        Effect[] effectArray = Effect.values();
        int n = effectArray.length;
        int mat = 0;
        while (mat < n) {
            Effect one = effectArray[mat];
            if (one != null && one.name() != null) {
                String string3 = String.valueOf(var21_37) + one.name().toLowerCase() + ", ";
            }
            ++mat;
        }
        c.addComment("Global.Visualizer.Selected", new String[]{"Particle effect names. possible: explode, largeexplode, hugeexplosion, fireworksSpark, splash, wake, crit, magicCrit", " smoke, largesmoke, spell, instantSpell, mobSpell, mobSpellAmbient, witchMagic, dripWater, dripLava, angryVillager, happyVillager, townaura", " note, portal, enchantmenttable, flame, lava, footstep, cloud, reddust, snowballpoof, snowshovel, slime, heart, barrier", " droplet, take, mobappearance", "", "If using spigot based server different particles can be used:", var21_37});
        String efname = c.get("Global.Visualizer.Selected.Frame", "happyVillager");
        this.SelectedFrame = CMIEffectManager.CMIParticle.getCMIParticle(efname);
        if (this.SelectedFrame == null) {
            this.SelectedFrame = CMIEffectManager.CMIParticle.HAPPY_VILLAGER;
            Bukkit.getConsoleSender().sendMessage("Can't find effect for Selected Frame with this name, it was set to default");
        }
        efname = c.get("Global.Visualizer.Selected.Sides", "reddust");
        this.SelectedSides = CMIEffectManager.CMIParticle.getCMIParticle(efname);
        if (this.SelectedSides == null) {
            this.SelectedSides = CMIEffectManager.CMIParticle.COLOURED_DUST;
            Bukkit.getConsoleSender().sendMessage("Can't find effect for Selected Sides with this name, it was set to default");
        }
        efname = c.get("Global.Visualizer.Overlap.Frame", "FLAME");
        this.OverlapFrame = CMIEffectManager.CMIParticle.getCMIParticle(efname);
        if (this.OverlapFrame == null) {
            this.OverlapFrame = CMIEffectManager.CMIParticle.FLAME;
            Bukkit.getConsoleSender().sendMessage("Can't find effect for Overlap Frame with this name, it was set to default");
        }
        efname = c.get("Global.Visualizer.Overlap.Sides", "FLAME");
        this.OverlapSides = CMIEffectManager.CMIParticle.getCMIParticle(efname);
        if (this.OverlapSides == null) {
            this.OverlapSides = CMIEffectManager.CMIParticle.FLAME;
            Bukkit.getConsoleSender().sendMessage("Can't find effect for Selected Sides with this name, it was set to default");
        }
        c.addComment("Global.Visualizer.EnterAnimation", "Shows particle effect when player enters residence. Only applies to main residence area");
        this.EnterAnimation = c.get("Global.Visualizer.EnterAnimation", true);
        c.addComment("Global.BounceAnimation", "Shows particle effect when player are being pushed back");
        this.BounceAnimation = c.get("Global.BounceAnimation", true);
        c.addComment("Global.GUI.Enabled", "Enable or disable flag GUI");
        this.useFlagGUI = c.get("Global.GUI.Enabled", true);
        c.addComment("Global.GUI.setTrue", "Item id and data to use when flag is set to true");
        CMIMaterial Mat = CMIMaterial.get(c.get("Global.GUI.setTrue", "GREEN_WOOL"));
        if (Mat == null) {
            Mat = CMIMaterial.GREEN_WOOL;
        }
        this.guiBottonStates.put(FlagPermissions.FlagState.TRUE, Mat.newItemStack());
        c.addComment("Global.GUI.setFalse", "Item id and data to use when flag is set to false");
        Mat = CMIMaterial.get(c.get("Global.GUI.setFalse", "RED_WOOL"));
        if (Mat == null) {
            Mat = CMIMaterial.RED_WOOL;
        }
        this.guiBottonStates.put(FlagPermissions.FlagState.FALSE, Mat.newItemStack());
        c.addComment("Global.GUI.setRemove", "Item id and data to use when flag is set to remove");
        Mat = CMIMaterial.get(c.get("Global.GUI.setRemove", "LIGHT_GRAY_WOOL"));
        if (Mat == null) {
            Mat = CMIMaterial.LIGHT_GRAY_WOOL;
        }
        this.guiBottonStates.put(FlagPermissions.FlagState.NEITHER, Mat.newItemStack());
        c.addComment("Global.AutoMobRemoval", "Default = false. Enabling this, residences with flag nomobs will be cleared from monsters in regular intervals.", "This is quite heavy on server side, so enable only if you really need this feature");
        this.AutoMobRemoval = c.get("Global.AutoMobRemoval.Use", false);
        c.addComment("Global.AutoMobRemoval.Interval", "How often in seconds to check for monsters in residences. Keep it at reasonable amount");
        this.AutoMobRemovalInterval = c.get("Global.AutoMobRemoval.Interval", 3);
        this.enforceAreaInsideArea = c.get("Global.EnforceAreaInsideArea", false);
        this.spoutEnable = c.get("Global.EnableSpout", false);
        this.enableLeaseMoneyAccount = c.get("Global.EnableLeaseMoneyAccount", true);
        c.addComment("Global.Couldroncompatibility", "By setting this to true, partial compatibility for kCouldron servers will be enabled. Action bar messages and selection visualizer will be disabled automatically as off incorrect compatibility");
        this.Couldroncompatibility = c.get("Global.Couldroncompatibility", false);
        if (this.Couldroncompatibility) {
            this.useVisualizer = false;
            this.EnterLeaveMessageType = ELMessageType.ChatBox;
            this.ActionBarOnSelection = false;
        }
        c.addComment("DynMap.Use", "Enables or disable DynMap Support");
        this.DynMapUse = c.get("DynMap.Use", false);
        c.addComment("DynMap.ShowFlags", "Shows or hides residence flags");
        this.DynMapShowFlags = c.get("DynMap.ShowFlags", true);
        c.addComment("DynMap.HideHidden", "If set true, residence with hidden flag set to true will be hidden from dynmap");
        this.DynMapHideHidden = c.get("DynMap.HideHidden", true);
        c.addComment("DynMap.Layer.3dRegions", "Enables 3D zones");
        this.DynMapLayer3dRegions = c.get("DynMap.Layer.3dRegions", true);
        c.addComment("DynMap.Layer.SubZoneDepth", "How deep to go into subzones to show");
        this.DynMapLayerSubZoneDepth = c.get("DynMap.Layer.SubZoneDepth", 2);
        c.addComment("DynMap.Border.Color", "Color of border. Pick color from this page http://www.w3schools.com/colors/colors_picker.asp");
        this.DynMapBorderColor = c.get("DynMap.Border.Color", "#FF0000");
        c.addComment("DynMap.Border.Opacity", "Transparency. 0.3 means that only 30% of color will be visible");
        this.DynMapBorderOpacity = c.get("DynMap.Border.Opacity", 0.3);
        c.addComment("DynMap.Border.Weight", "Border thickness");
        this.DynMapBorderWeight = c.get("DynMap.Border.Weight", 3);
        this.DynMapFillOpacity = c.get("DynMap.Fill.Opacity", 0.3);
        this.DynMapFillColor = c.get("DynMap.Fill.Color", "#FFFF00");
        this.DynMapFillForRent = c.get("DynMap.Fill.ForRent", "#33cc33");
        this.DynMapFillRented = c.get("DynMap.Fill.Rented", "#99ff33");
        this.DynMapFillForSale = c.get("DynMap.Fill.ForSale", "#0066ff");
        c.addComment("DynMap.VisibleRegions", "Shows only regions on this list");
        this.DynMapVisibleRegions = c.get("DynMap.VisibleRegions", new ArrayList<String>());
        c.addComment("DynMap.HiddenRegions", "Hides region on map even if its not hidden in game");
        this.DynMapHiddenRegions = c.get("DynMap.HiddenRegions", new ArrayList<String>());
        c.addComment("Raid", "In development");
        c.addComment("Raid.Enabled", "Determines if you want to enable raid feature for your server", "When residence is under raid, attackers can move inside residence even if residence has move false flag");
        RaidEnabled = c.get("Raid.Enabled", false);
        c.addComment("Raid.PreTimer", "Time in seconds before raid starts", "This will allow defenders to get back to residence and prepare for attack");
        PreRaidTimer = c.get("Raid.PreTimer", 120);
        c.addComment("Raid.Timer", "Time in seconds raid should be", "During this time attackers can steal and kill defenders");
        RaidTimer = c.get("Raid.Timer", 120);
        c.addComment("Raid.Cooldown", "Time in seconds residence is immune for next raid", "Default is 79200 seconds which results into 22 hours, this might reset if you have server restart");
        RaidCooldown = c.get("Raid.Cooldown", 79200);
        c.addComment("Raid.PlayerCooldown", "Time in seconds player is immune for next raid", "In case player has more than one residence, this can prevent player from being attacked again", "Default is 79200 seconds which results into 22 hours, this might reset if you have server restart");
        RaidPlayerCooldown = c.get("Raid.PlayerCooldown", 79200);
        c.addComment("Raid.Allow.Attacker.blockBreak", "Allows to break blocks inside raided residence even if it has destroy false", "This only applies for attackers and for raid time");
        RaidAttackerBlockBreak = c.get("Raid.Allow.Attacker.blockBreak", true);
        c.addComment("Raid.Allow.Attacker.blockPlace", "Allows to place blocks inside raided residence even if it has place false", "This only applies for attackers and for raid time");
        RaidAttackerBlockPlace = c.get("Raid.Allow.Attacker.blockPlace", true);
        c.addComment("Raid.Allow.Defender.blockBreak", "Allows to break blocks inside raided residence even if it has destroy false", "This only applies for defenders and for raid time");
        RaidDefenderBlockBreak = c.get("Raid.Allow.Defender.blockBreak", true);
        c.addComment("Raid.Allow.Defender.blockPlace", "Allows to place blocks inside raided residence even if it has place false", "This only applies for defenders and for raid time");
        RaidDefenderBlockPlace = c.get("Raid.Allow.Defender.blockPlace", true);
        c.addComment("Raid.Allow.Defender.Teleport", "Allows to teleport into raided residence, includes /res tp and other 3rd party teleport commands", "This only applies for defenders and for raid time", "keep in mind that attackers will not have this option and will be prevented from teleporting inside raided residence");
        RaidDefenderTeleport = c.get("Raid.Allow.Defender.Teleport", false);
        c.addComment("Raid.Allow.Defender.containerUsage", "Allows to use containers, such as chests, during raid time", "This only applies for defenders and for raid time", "Keeping this at false might prevent from players moving their items to another residence which is not in raid", "Attackers will have access to any container in your residence during raid");
        RaidDefenderContainerUsage = c.get("Raid.Allow.Defender.containerUsage", false);
        c.addComment("Raid.FriendlyFire", "When set to false players in same teams (attackers or defenders) will not cause each other damage");
        RaidFriendlyFire = c.get("Raid.FriendlyFire", true);
        c.save();
    }

    public void loadFlags() {
        YamlConfiguration flags2 = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "flags.yml"));
        if (flags2.isList("Global.TotalFlagDisabling")) {
            List globalDisable = flags2.getStringList("Global.TotalFlagDisabling");
            for (String fl : globalDisable) {
                Flags flag = Flags.getFlag(fl);
                if (flag == null) continue;
                flag.setGlobalyEnabled(false);
            }
        }
        this.globalCreatorDefaults = FlagPermissions.parseFromConfigNode("CreatorDefault", flags2.getConfigurationSection("Global"));
        this.globalRentedDefaults = FlagPermissions.parseFromConfigNode("RentedDefault", flags2.getConfigurationSection("Global"));
        this.globalResidenceDefaults = FlagPermissions.parseFromConfigNode("ResidenceDefault", flags2.getConfigurationSection("Global"));
        this.loadGroups();
    }

    public void loadGroups() {
        Set keys;
        YamlConfiguration groups = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "groups.yml"));
        ConfigurationSection node = groups.getConfigurationSection("Global.GroupDefault");
        if (node != null && (keys = node.getConfigurationSection(this.defaultGroup).getKeys(false)) != null) {
            for (String key : keys) {
                this.globalGroupDefaults.put(key, FlagPermissions.parseFromConfigNodeAsList(this.defaultGroup, "false"));
            }
        }
    }

    public World getWorld(String name) {
        name = name.replace("_", "").replace(".", "");
        for (World one : Bukkit.getWorlds()) {
            if (!one.getName().replace("_", "").replace(".", "").equalsIgnoreCase(name)) continue;
            return one;
        }
        return null;
    }

    public boolean isGlobalChatEnabled() {
        return this.GlobalChatEnabled;
    }

    public boolean isGlobalChatSelfModify() {
        return this.GlobalChatSelfModify;
    }

    public String getGlobalChatFormat() {
        return this.GlobalChatFormat;
    }

    public int getRentInformDelay() {
        return this.RentInformDelay;
    }

    public int getRentInformBefore() {
        return this.RentInformBefore;
    }

    public boolean isRentAllowAutoPay() {
        return this.RentAllowAutoPay;
    }

    public boolean isRentPlayerAutoPay() {
        return this.RentPlayerAutoPay;
    }

    public boolean isRentStayInMarket() {
        return this.RentStayInMarket;
    }

    public boolean isSellSubzone() {
        return this.SellSubzone;
    }

    public boolean isRentAllowRenewing() {
        return this.RentAllowRenewing;
    }

    public boolean isRentPreventRemoval() {
        return this.RentPreventRemoval;
    }

    public boolean isRentInformOnEnding() {
        return this.RentInformOnEnding;
    }

    public boolean isTNTExplodeBelow() {
        return this.TNTExplodeBelow;
    }

    public int getTNTExplodeBelowLevel() {
        return this.TNTExplodeBelowLevel;
    }

    public boolean isCreeperExplodeBelow() {
        return this.CreeperExplodeBelow;
    }

    public int getCreeperExplodeBelowLevel() {
        return this.CreeperExplodeBelowLevel;
    }

    public boolean useVisualizer() {
        return this.useVisualizer;
    }

    public int getVisualizerRange() {
        return this.VisualizerRange;
    }

    public int getVisualizerShowFor() {
        return this.VisualizerShowFor;
    }

    public int getNewPlayerRangeX() {
        return this.NewPlayerRangeX;
    }

    public int getNewPlayerRangeY() {
        return this.NewPlayerRangeY;
    }

    public int getNewPlayerRangeZ() {
        return this.NewPlayerRangeZ;
    }

    public int getVisualizerRowSpacing() {
        return this.VisualizerRowSpacing;
    }

    public int getVisualizerCollumnSpacing() {
        return this.VisualizerCollumnSpacing;
    }

    public int getVisualizerSkipBy() {
        return this.VisualizerSkipBy;
    }

    public int getVisualizerUpdateInterval() {
        return this.VisualizerUpdateInterval;
    }

    public CMIEffectManager.CMIParticle getSelectedFrame() {
        return this.SelectedFrame;
    }

    public CMIEffectManager.CMIParticle getSelectedSides() {
        return this.SelectedSides;
    }

    public CMIEffectManager.CMIParticle getOverlapFrame() {
        return this.OverlapFrame;
    }

    public CMIEffectManager.CMIParticle getOverlapSides() {
        return this.OverlapSides;
    }

    @Deprecated
    public CMIEffectManager.CMIParticle getSelectedSpigotFrame() {
        return this.SelectedFrame;
    }

    @Deprecated
    public CMIEffectManager.CMIParticle getSelectedSpigotSides() {
        return this.SelectedSides;
    }

    @Deprecated
    public CMIEffectManager.CMIParticle getOverlapSpigotFrame() {
        return this.OverlapFrame;
    }

    @Deprecated
    public CMIEffectManager.CMIParticle getOverlapSpigotSides() {
        return this.OverlapSides;
    }

    public int getTeleportDelay() {
        return this.TeleportDelay;
    }

    public boolean isTeleportTitleMessage() {
        return this.TeleportTitleMessage;
    }

    public boolean useLegacyPermissions() {
        return this.legacyperms;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public String getResidenceNameRegex() {
        return this.namefix;
    }

    public boolean isExtraEnterMessage() {
        return this.ExtraEnterMessage;
    }

    public boolean enableEconomy() {
        return this.enableEconomy && this.plugin.getEconomyManager() != null;
    }

    public boolean enabledRentSystem() {
        return this.enableRentSystem && this.enableEconomy();
    }

    public boolean useLeases() {
        return this.useLeases;
    }

    public boolean useResMoneyBack() {
        return this.ResMoneyBack;
    }

    public boolean allowAdminsOnly() {
        return this.adminsOnly;
    }

    public boolean allowEmptyResidences() {
        return this.allowEmptyResidences;
    }

    public boolean isNoLava() {
        return this.NoLava;
    }

    public boolean isNoWater() {
        return this.NoWater;
    }

    public boolean isNoLavaPlace() {
        return this.NoLavaPlace;
    }

    public boolean isBlockFall() {
        return this.useBlockFall;
    }

    public boolean isNoWaterPlace() {
        return this.NoWaterPlace;
    }

    public List<Material> getLwcMatList() {
        return this.LwcMatList;
    }

    public boolean isRemoveLwcOnUnrent() {
        return this.LwcOnUnrent;
    }

    public boolean isRemoveLwcOnBuy() {
        return this.LwcOnBuy;
    }

    public boolean isRemoveLwcOnDelete() {
        return this.LwcOnDelete;
    }

    public boolean isUseResidenceFileClean() {
        return this.AutoCleanUp;
    }

    public int getResidenceFileCleanDays() {
        return this.AutoCleanUpDays;
    }

    public boolean isAutoCleanUpRegenerate() {
        return this.AutoCleanUpRegenerate;
    }

    public boolean isUseClean() {
        return this.UseClean;
    }

    public boolean isPvPFlagPrevent() {
        return this.PvPFlagPrevent;
    }

    public boolean isOverridePvp() {
        return this.OverridePvp;
    }

    public boolean isBlockAnyTeleportation() {
        return this.BlockAnyTeleportation;
    }

    @Deprecated
    public int getInfoToolID() {
        return this.infoTool.getId();
    }

    public CMIMaterial getInfoTool() {
        return this.infoTool;
    }

    public CMIMaterial getSelectionTool() {
        return this.selectionTool;
    }

    @Deprecated
    public int getSelectionTooldID() {
        return this.selectionTool.getId();
    }

    public boolean getOpsAreAdmins() {
        return this.adminOps;
    }

    public boolean getAdminFullAccess() {
        return this.AdminFullAccess;
    }

    public String getMultiworldPlugin() {
        return this.multiworldPlugin;
    }

    public boolean autoRenewLeases() {
        return this.leaseAutoRenew;
    }

    public boolean isShortInfoUse() {
        return this.ShortInfoUse;
    }

    public boolean isOnlyLike() {
        return this.OnlyLike;
    }

    public int getRentCheckInterval() {
        return this.rentCheckInterval;
    }

    public int getChatPrefixLength() {
        return this.chatPrefixLength;
    }

    public int getLeaseCheckInterval() {
        return this.leaseCheckInterval;
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInt;
    }

    public boolean isNewSaveMechanic() {
        return this.NewSaveMechanic;
    }

    public boolean BackupAutoCleanUpUse() {
        return this.BackupAutoCleanUpUse;
    }

    public int BackupAutoCleanUpDays() {
        return this.BackupAutoCleanUpDays;
    }

    public boolean UseZipBackup() {
        return this.UseZipBackup;
    }

    public boolean BackupWorldFiles() {
        return this.BackupWorldFiles;
    }

    public boolean BackupforsaleFile() {
        return this.BackupforsaleFile;
    }

    public boolean BackupleasesFile() {
        return this.BackupleasesFile;
    }

    public boolean BackuppermlistsFile() {
        return this.BackuppermlistsFile;
    }

    public boolean BackuprentFile() {
        return this.BackuprentFile;
    }

    public boolean BackupflagsFile() {
        return this.BackupflagsFile;
    }

    public boolean BackupgroupsFile() {
        return this.BackupgroupsFile;
    }

    public boolean BackupconfigFile() {
        return this.BackupconfigFile;
    }

    public int getFlowLevel() {
        return this.FlowLevel;
    }

    public int getPlaceLevel() {
        return this.PlaceLevel;
    }

    public int getBlockFallLevel() {
        return this.BlockFallLevel;
    }

    public int getCleanLevel() {
        return this.CleanLevel;
    }

    public boolean flagsInherit() {
        return this.flagsInherit;
    }

    public boolean chatEnabled() {
        return this.chatEnable;
    }

    public boolean useActionBarOnSelection() {
        return this.ActionBarOnSelection;
    }

    public ChatColor getChatColor() {
        return this.chatColor;
    }

    public int getMinMoveUpdateInterval() {
        return this.minMoveUpdate;
    }

    public int getMaxResCount() {
        return this.MaxResCount;
    }

    public int getMaxRentCount() {
        return this.MaxRentCount;
    }

    public int getMaxSubzonesCount() {
        return this.MaxSubzonesCount;
    }

    public int getMaxSubzoneDepthCount() {
        return this.MaxSubzoneDepthCount;
    }

    public int getVoteRangeFrom() {
        return this.VoteRangeFrom;
    }

    public int getHealInterval() {
        return this.HealInterval;
    }

    public int getFeedInterval() {
        return this.FeedInterval;
    }

    public int getVoteRangeTo() {
        return this.VoteRangeTo;
    }

    public FlagPermissions getGlobalCreatorDefaultFlags() {
        return this.globalCreatorDefaults;
    }

    public FlagPermissions getGlobalRentedDefaultFlags() {
        return this.globalRentedDefaults;
    }

    public FlagPermissions getGlobalResidenceDefaultFlags() {
        return this.globalResidenceDefaults;
    }

    public Map<String, FlagPermissions> getGlobalGroupDefaultFlags() {
        return this.globalGroupDefaults;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDefaultWorld() {
        return this.DefaultWorld;
    }

    public String getDateFormat() {
        return this.DateFormat;
    }

    public String getDateFormatShort() {
        return this.DateFormatShort;
    }

    public String getTimeZone() {
        return this.TimeZone;
    }

    public boolean preventRentModify() {
        return this.preventBuildInRent;
    }

    public boolean isPreventSubZoneRemoval() {
        return this.PreventSubZoneRemoval;
    }

    public boolean stopOnSaveError() {
        return this.stopOnSaveError;
    }

    public boolean showIntervalMessages() {
        return this.showIntervalMessages;
    }

    public boolean ShowNoobMessage() {
        return this.ShowNoobMessage;
    }

    public boolean isNewPlayerUse() {
        return this.NewPlayerUse;
    }

    public boolean isNewPlayerFree() {
        return this.NewPlayerFree;
    }

    public boolean enableSpout() {
        return this.spoutEnable;
    }

    public boolean AutoMobRemoval() {
        return this.AutoMobRemoval;
    }

    public int AutoMobRemovalInterval() {
        return this.AutoMobRemovalInterval;
    }

    public boolean enableLeaseMoneyAccount() {
        return this.enableLeaseMoneyAccount;
    }

    public boolean CouldronCompatibility() {
        return this.Couldroncompatibility;
    }

    public boolean debugEnabled() {
        return this.enableDebug;
    }

    public boolean isSelectionIgnoreY() {
        return this.SelectionIgnoreY;
    }

    public boolean isSelectionIgnoreYInSubzone() {
        return this.SelectionIgnoreYInSubzone;
    }

    public boolean isNoCostForYBlocks() {
        return this.NoCostForYBlocks;
    }

    public boolean versionCheck() {
        return this.versionCheck;
    }

    public boolean isUUIDConvertion() {
        return this.UUIDConvertion;
    }

    public boolean isOfflineMode() {
        return this.OfflineMode;
    }

    public List<CMIMaterial> getCustomContainers() {
        return this.customContainers;
    }

    public List<CMIMaterial> getCustomBothClick() {
        return this.customBothClick;
    }

    public List<CMIMaterial> getCustomRightClick() {
        return this.customRightClick;
    }

    public List<Material> getCleanBlocks() {
        return this.CleanBlocks;
    }

    public List<String> getNoFlowWorlds() {
        return this.NoFlowWorlds;
    }

    public List<String> getAutoCleanUpWorlds() {
        return this.AutoCleanUpWorlds;
    }

    public List<String> getNoPlaceWorlds() {
        return this.NoPlaceWorlds;
    }

    public List<String> getBlockFallWorlds() {
        return this.BlockFallWorlds;
    }

    public List<String> getNegativePotionEffects() {
        return this.NegativePotionEffects;
    }

    public List<String> getNegativeLingeringPotionEffects() {
        return this.NegativeLingeringPotionEffects;
    }

    public List<String> getCleanWorlds() {
        return this.CleanWorlds;
    }

    public List<String> getProtectedFlagsList() {
        return this.FlagsList;
    }

    public boolean getEnforceAreaInsideArea() {
        return this.enforceAreaInsideArea;
    }

    public List<RandomTeleport> getRandomTeleport() {
        return this.RTeleport;
    }

    public int getrtCooldown() {
        return this.rtCooldown;
    }

    public Location getKickLocation() {
        return this.KickLocation;
    }

    public Location getFlyLandLocation() {
        return this.FlyLandLocation;
    }

    public int getrtMaxTries() {
        return this.rtMaxTries;
    }

    public boolean useFlagGUI() {
        return this.useFlagGUI;
    }

    public boolean BounceAnimation() {
        return this.BounceAnimation;
    }

    public int getVisualizerFrameCap() {
        return this.VisualizerFrameCap;
    }

    public int getVisualizerSidesCap() {
        return this.VisualizerSidesCap;
    }

    public Double getWalkSpeed1() {
        return this.WalkSpeed1;
    }

    public Double getWalkSpeed2() {
        return this.WalkSpeed2;
    }

    public int getItemPickUpDelay() {
        return this.ItemPickUpDelay;
    }

    public boolean isAutomaticResidenceCreationCheckCollision() {
        return this.AutomaticResidenceCreationCheckCollision;
    }

    public String AutomaticResidenceCreationIncrementFormat() {
        return this.AutomaticResidenceCreationIncrementFormat;
    }

    public boolean isConsoleLogsShowFlagChanges() {
        return this.ConsoleLogsShowFlagChanges;
    }

    public EconomyType getEconomyType() {
        return this.VaultEconomy;
    }

    public boolean isCanTeleportIncludeOwner() {
        return this.CanTeleportIncludeOwner;
    }

    public ELMessageType getEnterLeaveMessageType() {
        return this.EnterLeaveMessageType;
    }

    public boolean isEnterAnimation() {
        return this.EnterAnimation;
    }

    public boolean isDeductFromBank() {
        return this.DeductFromBank;
    }

    public boolean isDeductFromBankThenPlayer() {
        return this.DeductFromBankThenPlayer;
    }

    public ItemStack getGuiBottonStates(FlagPermissions.FlagState state) {
        return this.guiBottonStates.get((Object)state);
    }
}

