/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.BossBar;

import com.bekvon.bukkit.cmiLib.VersionChecker;
import com.bekvon.bukkit.residence.BossBar.BossBarInfo;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BossBarManager {
    Residence plugin;

    public BossBarManager(Residence plugin) {
        this.plugin = plugin;
    }

    public synchronized void updateBossBars(ResidencePlayer player) {
        if (VersionChecker.Version.isCurrentLower(VersionChecker.Version.v1_9_R1)) {
            return;
        }
        if (player == null) {
            return;
        }
        HashMap<String, BossBarInfo> temp = new HashMap<String, BossBarInfo>(player.getBossBarInfo());
        for (Map.Entry<String, BossBarInfo> one : temp.entrySet()) {
            this.Show(one.getValue());
        }
    }

    public synchronized void Show(final BossBarInfo barInfo) {
        if (VersionChecker.Version.isCurrentLower(VersionChecker.Version.v1_9_R1)) {
            return;
        }
        ResidencePlayer user = barInfo.getUser();
        if (user == null || !user.isOnline()) {
            return;
        }
        barInfo.updateCycle();
        BossBar bar = barInfo.getBar();
        String name = barInfo.getTitleOfBar();
        boolean isNew = true;
        if (bar == null) {
            BarColor color = barInfo.getColor();
            if (color == null) {
                switch (user.getBossBarInfo().size()) {
                    case 1: {
                        color = BarColor.GREEN;
                        break;
                    }
                    case 2: {
                        color = BarColor.RED;
                        break;
                    }
                    case 3: {
                        color = BarColor.WHITE;
                        break;
                    }
                    case 4: {
                        color = BarColor.YELLOW;
                        break;
                    }
                    case 5: {
                        color = BarColor.PINK;
                        break;
                    }
                    case 6: {
                        color = BarColor.PURPLE;
                        break;
                    }
                    default: {
                        color = BarColor.BLUE;
                    }
                }
            }
            bar = Bukkit.createBossBar((String)name, (BarColor)color, (BarStyle)(barInfo.getStyle() != null ? barInfo.getStyle() : BarStyle.SEGMENTED_10), (BarFlag[])new BarFlag[0]);
        } else {
            bar.setTitle(name);
            if (barInfo.getStyle() != null) {
                bar.setStyle(barInfo.getStyle());
            }
            if (barInfo.getColor() != null) {
                bar.setColor(barInfo.getColor());
            }
            isNew = false;
        }
        Double percentage = barInfo.getPercentage();
        if (percentage == null) {
            percentage = 1.0;
        }
        if (barInfo.getAdjustPerc() != null) {
            Double curP = barInfo.getPercentage();
            if (curP != null && curP <= 0.0 && barInfo.getAdjustPerc() < 0.0) {
                barInfo.cancelAutoScheduler();
                return;
            }
            if (curP != null && curP >= 1.0 && barInfo.getAdjustPerc() > 0.0) {
                barInfo.cancelAutoScheduler();
                return;
            }
            if (curP == null) {
                curP = barInfo.getAdjustPerc() > 0.0 ? Double.valueOf(0.0) : Double.valueOf(1.0);
            }
            curP = curP + barInfo.getAdjustPerc();
            barInfo.setPercentage(curP);
        } else {
            barInfo.setPercentage(percentage);
        }
        try {
            bar.setProgress(barInfo.getPercentage().doubleValue());
            if (isNew) {
                Player target = user.getPlayer();
                if (target == null) {
                    return;
                }
                bar.addPlayer(target);
                bar.setVisible(true);
            }
        }
        catch (NoSuchMethodError e) {
            e.printStackTrace();
        }
        barInfo.setBar(bar);
        barInfo.cancelHideScheduler();
        barInfo.cancelAutoScheduler();
        if (barInfo.getAuto() != null && barInfo.getAuto() > 0) {
            barInfo.setAutoId(Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    BossBarManager.this.Show(barInfo);
                }
            }, (long)barInfo.getAuto().intValue()));
        }
        if (barInfo.getKeepFor() > 0) {
            barInfo.setId(Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    barInfo.getBar().setVisible(false);
                    barInfo.remove();
                }
            }, (long)barInfo.getKeepFor().intValue()));
        }
    }
}

