/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.BossBar;

import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.utils.Utils;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;

public class BossBarInfo {
    private ResidencePlayer user;
    private Double percentage = null;
    private Double adjustPerc = null;
    private Integer keepFor = 60;
    private Integer auto = null;
    private BossBar bar;
    private BarColor startingColor = null;
    private BarStyle style = null;
    private Integer autoId = null;
    private Integer id = null;
    private String nameOfBar;
    private String titleOfBar = "Title";
    private List<String> cmds = null;

    public BossBarInfo(ResidencePlayer user, String nameOfBar) {
        this.user = user;
        this.nameOfBar = nameOfBar;
    }

    public BossBarInfo(ResidencePlayer user, String nameOfBar, BossBar bar) {
        this.user = user;
        this.nameOfBar = nameOfBar;
        this.bar = bar;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void cancelAutoScheduler() {
        if (this.autoId != null) {
            Bukkit.getScheduler().cancelTask(this.autoId.intValue());
            this.autoId = null;
        }
    }

    public void cancelHideScheduler() {
        if (this.id != null) {
            Bukkit.getScheduler().cancelTask(this.id.intValue());
            this.id = null;
        }
    }

    public void remove() {
        this.cancelAutoScheduler();
        this.cancelHideScheduler();
        if (this.bar != null) {
            this.bar.setVisible(false);
        }
        this.user.removeBossBar(this);
    }

    public ResidencePlayer getUser() {
        return this.user;
    }

    public BossBar getBar() {
        return this.bar;
    }

    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double max, Double current2) {
        current2 = current2 * 100.0 / max / 100.0;
        this.setPercentage(current2);
    }

    public void setPercentage(Double percentage) {
        if (percentage != null) {
            if (percentage < 0.0) {
                percentage = 0.0;
            }
            if (percentage > 1.0) {
                percentage = 1.0;
            }
        }
        this.percentage = percentage;
    }

    public String getNameOfBar() {
        if (this.nameOfBar == null) {
            this.nameOfBar = "CmiBossbar" + new Random().nextInt(100);
        }
        return this.nameOfBar;
    }

    public void setNameOfBar(String nameOfBar) {
        this.nameOfBar = nameOfBar;
    }

    public Integer getKeepFor() {
        return this.keepFor;
    }

    public void setKeepForTicks(Integer keepFor) {
        if (keepFor != null) {
            this.keepFor = keepFor;
        }
    }

    public String getTitleOfBar() {
        if (this.titleOfBar != null && this.titleOfBar.contains("[autoTimeLeft]") && this.percentage != null && this.adjustPerc != null && this.auto != null) {
            double leftTicks = this.percentage / (this.adjustPerc < 0.0 ? -this.adjustPerc.doubleValue() : this.adjustPerc);
            Long totalTicks = (long)(leftTicks * (double)(this.auto < 0 ? -this.auto.intValue() : this.auto));
            Long mili = totalTicks * 50L;
            return this.titleOfBar.replace("[autoTimeLeft]", Utils.to24hourShort(mili + 1000L));
        }
        return this.titleOfBar == null ? "" : this.titleOfBar;
    }

    public void setTitleOfBar(String titleOfBar) {
        this.titleOfBar = titleOfBar == null || titleOfBar.isEmpty() ? null : ChatColor.translateAlternateColorCodes((char)'&', (String)titleOfBar);
    }

    public void setBar(BossBar bar) {
        this.bar = bar;
    }

    public BarColor getColor() {
        return this.startingColor;
    }

    public void setColor(BarColor startingColor) {
        this.startingColor = startingColor;
    }

    public Double getAdjustPerc() {
        return this.adjustPerc;
    }

    public void setAdjustPerc(Double adjustPerc) {
        this.adjustPerc = adjustPerc;
    }

    public BarStyle getStyle() {
        return this.style;
    }

    public void setStyle(BarStyle style) {
        this.style = style;
    }

    public void setUser(ResidencePlayer user) {
        this.user = user;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getAuto() {
        return this.auto;
    }

    public void setAuto(Integer auto2) {
        this.auto = auto2;
    }

    public Integer getAutoId() {
        return this.autoId;
    }

    public void setAutoId(Integer autoId) {
        this.autoId = autoId;
    }

    public void updateCycle() {
    }
}

