/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.residence.Residence;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class VersionChecker {
    Residence plugin;
    private static int resource = 11480;

    public VersionChecker(Residence plugin) {
        this.plugin = plugin;
    }

    public Version getVersion() {
        return Version.getCurrent();
    }

    public Integer convertVersion(String v) {
        v = v.replaceAll("[^\\d.]", "");
        Integer version2 = 0;
        if (v.contains(".")) {
            String lVersion = "";
            String[] stringArray = v.split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String one = stringArray[n2];
                String s = one;
                if (s.length() == 1) {
                    s = "0" + s;
                }
                lVersion = String.valueOf(lVersion) + s;
                ++n2;
            }
            try {
                version2 = Integer.parseInt(lVersion);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                version2 = Integer.parseInt(v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return version2;
    }

    public void VersionCheck(final Player player) {
        if (!this.plugin.getConfigManager().versionCheck()) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                String currentVersion = VersionChecker.this.plugin.getDescription().getVersion();
                String newVersion = VersionChecker.this.getNewVersion();
                if (newVersion == null || newVersion.equalsIgnoreCase(currentVersion)) {
                    return;
                }
                List<String> msg = Arrays.asList(ChatColor.GREEN + "*********************** " + VersionChecker.this.plugin.getDescription().getName() + " **************************", ChatColor.GREEN + "* " + newVersion + " is now available! Your version: " + currentVersion, ChatColor.GREEN + "* " + ChatColor.DARK_GREEN + VersionChecker.this.plugin.getDescription().getWebsite(), ChatColor.GREEN + "************************************************************");
                for (String one : msg) {
                    if (player != null) {
                        player.sendMessage(one);
                        continue;
                    }
                    Bukkit.getConsoleSender().sendMessage(one);
                }
            }
        });
    }

    public String getNewVersion() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + resource).openConnection();
            String version2 = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if (version2.length() <= 8) {
                return version2;
            }
        }
        catch (Exception ex) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "Failed to check for " + this.plugin.getDescription().getName() + " update on spigot web page.");
        }
        return null;
    }

    public static enum Version {
        v1_7_R1,
        v1_7_R2,
        v1_7_R3,
        v1_7_R4,
        v1_8_R1,
        v1_8_R2,
        v1_8_R3,
        v1_9_R1,
        v1_9_R2,
        v1_10_R1,
        v1_11_R1,
        v1_12_R1,
        v1_13_R1,
        v1_13_R2,
        v1_13_R3,
        v1_14_R1,
        v1_14_R2,
        v1_15_R1,
        v1_15_R2,
        v1_16_R1,
        v1_16_R2,
        v1_17_R1,
        v1_17_R2;

        private Integer value;
        private String shortVersion;
        private static Version current;

        static {
            current = null;
        }

        private Version() {
            try {
                this.value = Integer.valueOf(this.name().replaceAll("[^\\d.]", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.shortVersion = this.name().substring(0, this.name().length() - 3);
        }

        public Integer getValue() {
            return this.value;
        }

        public String getShortVersion() {
            return this.shortVersion;
        }

        public static Version getCurrent() {
            if (current != null) {
                return current;
            }
            String[] v = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
            String vv = v[v.length - 1];
            Version[] versionArray = Version.values();
            int n = versionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Version one = versionArray[n2];
                if (one.name().equalsIgnoreCase(vv)) {
                    current = one;
                    break;
                }
                ++n2;
            }
            return current;
        }

        public boolean isLower(Version version2) {
            return this.getValue() < version2.getValue();
        }

        public boolean isHigher(Version version2) {
            return this.getValue() > version2.getValue();
        }

        public boolean isEqualOrLower(Version version2) {
            return this.getValue() <= version2.getValue();
        }

        public boolean isEqualOrHigher(Version version2) {
            return this.getValue() >= version2.getValue();
        }

        public static boolean isCurrentEqualOrHigher(Version v) {
            return Version.getCurrent().getValue() >= v.getValue();
        }

        public static boolean isCurrentHigher(Version v) {
            return Version.getCurrent().getValue() > v.getValue();
        }

        public static boolean isCurrentLower(Version v) {
            return Version.getCurrent().getValue() < v.getValue();
        }

        public static boolean isCurrentEqualOrLower(Version v) {
            return Version.getCurrent().getValue() <= v.getValue();
        }
    }
}

