/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.ActionBarTitleMessages;
import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.CMIItemStack;
import com.bekvon.bukkit.cmiLib.ItemManager;
import com.bekvon.bukkit.cmiLib.VersionChecker;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RawMessage {
    List<String> parts = new ArrayList<String>();
    List<String> cleanParts = new ArrayList<String>();
    String colorReplacerPlaceholder = "%#%";
    private String unfinished = "";
    private String unfinishedClean = "";
    private String combined = "";
    String combinedClean = "";
    private boolean dontBreakLine = false;
    Set<CMIChatColor> formats = new HashSet<CMIChatColor>();
    CMIChatColor lastColor = null;
    Set<CMIChatColor> savedFormats = new HashSet<CMIChatColor>();
    CMIChatColor savedLastColor = null;
    CMIChatColor firstBlockColor = null;

    public void clear() {
        this.parts = new ArrayList<String>();
        this.cleanParts = new ArrayList<String>();
        this.combined = "";
        this.combinedClean = "";
    }

    public RawMessage add(String text) {
        return this.add(text, null, null, null, null);
    }

    public RawMessage add(String text, String hoverText) {
        return this.add(text, hoverText, null, null, null);
    }

    public RawMessage add(String text, List<String> hoverText) {
        String hover = "";
        if (hoverText != null) {
            for (String one : hoverText) {
                if (!hover.isEmpty()) {
                    hover = String.valueOf(hover) + "\n";
                }
                hover = String.valueOf(hover) + one;
            }
        }
        return this.add(text, hover.isEmpty() ? null : hover, null, null, null);
    }

    public RawMessage add(String text, String hoverText, String command2) {
        return this.add(text, hoverText, command2, null, null);
    }

    public RawMessage add(String text, String hoverText, String command2, String suggestion) {
        return this.add(text, hoverText, command2, suggestion, null);
    }

    private String makeMessyText(String text) {
        if (text.equalsIgnoreCase(" ")) {
            return text;
        }
        text = CMIChatColor.deColorize(text);
        ArrayList<String> splited = new ArrayList<String>();
        if (text.contains(" ")) {
            String[] stringArray = text.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String one = stringArray[n2];
                splited.add(one);
                splited.add(" ");
                ++n2;
            }
            if (text.length() > 1 && text.endsWith(" ")) {
                splited.add(" ");
            }
            if (text.startsWith(" ")) {
                splited.add(" ");
            }
            if (!splited.isEmpty()) {
                splited.remove(splited.size() - 1);
            }
        } else {
            splited.add(text);
        }
        String newText = "";
        for (String one : splited) {
            String colorString = "";
            colorString = this.lastColor != null ? String.valueOf(colorString) + this.lastColor.getColorCode() : String.valueOf(colorString) + CMIChatColor.WHITE.getColorCode();
            for (CMIChatColor oneC : this.formats) {
                colorString = String.valueOf(colorString) + oneC.getColorCode();
            }
            if (one.contains("&")) {
                Pattern pattern = Pattern.compile("(&[0123456789abcdefklmnor])");
                Matcher match = pattern.matcher(one);
                while (match.find()) {
                    String color = CMIChatColor.getLastColors(match.group(0));
                    CMIChatColor c = CMIChatColor.getColor(color);
                    if (c == null) continue;
                    if (c.isFormat().booleanValue()) {
                        this.formats.add(c);
                    } else if (c.isReset().booleanValue()) {
                        this.formats.clear();
                        this.lastColor = null;
                        this.firstBlockColor = null;
                    } else if (c.isColor().booleanValue()) {
                        this.lastColor = c;
                        this.formats.clear();
                        this.firstBlockColor = c;
                    }
                    if (c.isFormat().booleanValue() || c.isReset().booleanValue() || !c.isColor().booleanValue()) continue;
                    String form = "";
                    for (CMIChatColor oneC : this.formats) {
                        form = String.valueOf(form) + oneC.getColorCode();
                    }
                    one = one.replace(c.getColorCode(), String.valueOf(c.getColorCode()) + form);
                }
            }
            newText = String.valueOf(newText) + colorString + one;
        }
        return newText;
    }

    public RawMessage addText(String text) {
        if (text == null) {
            return this;
        }
        text = this.provessText(text);
        if (this.dontBreakLine) {
            text = text.replace("\\\\\\n", "\\\\n");
        }
        this.unfinishedClean = text;
        this.unfinished = String.valueOf(this.unfinished) + "\"text\":\"" + ChatColor.translateAlternateColorCodes((char)'&', (String)this.makeMessyText(text)).replace(this.colorReplacerPlaceholder, "&") + "\"";
        return this;
    }

    public RawMessage addHoverText(List<String> hoverText) {
        String hover = "";
        if (hoverText != null) {
            for (String one : hoverText) {
                if (!hover.isEmpty()) {
                    hover = String.valueOf(hover) + "\n";
                }
                hover = String.valueOf(hover) + one;
            }
        }
        return this.addHoverText(hover);
    }

    public RawMessage addHoverText(String hoverText) {
        if (hoverText != null && !hoverText.isEmpty()) {
            hoverText = hoverText.replace(" \n", " \\n");
            hoverText = hoverText.replace("\n", "\\n");
            this.unfinished = String.valueOf(this.unfinished) + ",\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + ChatColor.translateAlternateColorCodes((char)'&', (String)hoverText) + "\"}]}}";
        }
        return this;
    }

    public RawMessage addCommand(String command2) {
        if (command2 != null) {
            if (!command2.startsWith("/")) {
                command2 = "/" + command2;
            }
            this.unfinished = String.valueOf(this.unfinished) + ",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + command2 + "\"}";
        }
        return this;
    }

    public RawMessage addSuggestion(String suggestion) {
        if (suggestion != null) {
            this.unfinished = String.valueOf(this.unfinished) + ",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"" + CMIChatColor.deColorize(suggestion) + "\"}";
        }
        return this;
    }

    public RawMessage addUrl(String url) {
        if (url != null) {
            if (!url.toLowerCase().startsWith("http://") || !url.toLowerCase().startsWith("https://")) {
                url = "http://" + url;
            }
            this.unfinished = String.valueOf(this.unfinished) + ",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + url + "\"}";
        }
        return this;
    }

    public RawMessage build() {
        if (this.unfinished.isEmpty()) {
            return this;
        }
        this.unfinished = this.unfinished.startsWith("{") ? this.unfinished : "{" + this.unfinished + "}";
        this.parts.add(this.unfinished);
        this.cleanParts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)this.unfinishedClean));
        this.unfinished = "";
        this.unfinishedClean = "";
        return this;
    }

    private String provessText(String text) {
        Random rand = new Random();
        String breakLine0 = String.valueOf(rand.nextInt(Integer.MAX_VALUE));
        text = text.replace("\\n", breakLine0);
        String breakLine3 = String.valueOf(rand.nextInt(Integer.MAX_VALUE));
        text = text.replace("\\", breakLine3);
        String breakLine2 = String.valueOf(rand.nextInt(Integer.MAX_VALUE));
        text = text.replace("\\\"", breakLine2);
        String breakLine1 = String.valueOf(rand.nextInt(Integer.MAX_VALUE));
        text = text.replace("\"", breakLine1);
        text = text.replace(breakLine3, "\\\\");
        text = text.replace(breakLine0, "\\n");
        text = text.replace(breakLine1, "\\\"");
        text = text.replace(breakLine2, "\\\"");
        return text;
    }

    public RawMessage add(String text, String hoverText, String command2, String suggestion, String url) {
        if (text == null) {
            return this;
        }
        text = this.provessText(text);
        if (this.dontBreakLine) {
            text = text.replace("\\\\\\n", "\\\\n");
        }
        String f = "{\"text\":\"" + ChatColor.translateAlternateColorCodes((char)'&', (String)this.makeMessyText(text)).replace(this.colorReplacerPlaceholder, "&") + "\"";
        if (hoverText != null && !hoverText.isEmpty()) {
            hoverText = this.provessText(hoverText);
            hoverText = hoverText.replace(" \n", " \\n");
            hoverText = hoverText.replace("\n", "\\n");
            f = String.valueOf(f) + ",\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + ChatColor.translateAlternateColorCodes((char)'&', (String)hoverText) + "\"}]}}";
        }
        if (suggestion != null) {
            suggestion = this.provessText(suggestion);
            suggestion = suggestion.replace("\\n", "\\\\n");
            suggestion = suggestion.replace(" \\n", " \\\\n");
            suggestion = suggestion.replace(" \n", " \\\\n");
            f = String.valueOf(f) + ",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"" + CMIChatColor.deColorize(suggestion) + "\"}";
        }
        if (url != null) {
            if (!(url = this.provessText(url)).toLowerCase().startsWith("http://") || !url.toLowerCase().startsWith("https://")) {
                url = "http://" + url;
            }
            f = String.valueOf(f) + ",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + url + "\"}";
        }
        if (command2 != null) {
            if (!command2.startsWith("/")) {
                command2 = "/" + command2;
            }
            command2 = this.provessText(command2);
            f = String.valueOf(f) + ",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + command2 + "\"}";
        }
        f = String.valueOf(f) + "}";
        this.parts.add(f);
        this.cleanParts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)text));
        return this;
    }

    public RawMessage addUrl(String text, String url) {
        return this.addUrl(text, url, null);
    }

    public RawMessage addUrl(String text, String url, String hoverText) {
        if (text == null) {
            return this;
        }
        text = text.replace("\\", "\\\\");
        text = text.replace("\"", "\\\"");
        String f = "{\"text\":\"" + CMIChatColor.colorize(text).replace(this.colorReplacerPlaceholder, "&") + "\"";
        if (this.firstBlockColor != null) {
            f = String.valueOf(f) + ",\"color\":\"" + this.firstBlockColor.name().toLowerCase() + "\"";
        }
        if (hoverText != null && !hoverText.isEmpty()) {
            hoverText = hoverText.startsWith(" ") ? hoverText.substring(1) : hoverText;
            f = String.valueOf(f) + ",\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + ChatColor.translateAlternateColorCodes((char)'&', (String)hoverText).replace(this.colorReplacerPlaceholder, "&") + "\"}]}}";
        }
        url = url.endsWith(" ") ? url.substring(0, url.length() - 1) : url;
        String string = url = url.startsWith(" ") ? url.substring(1) : url;
        if (url != null && !url.isEmpty()) {
            if (!url.toLowerCase().startsWith("http://") && !url.toLowerCase().startsWith("https://")) {
                url = "http://" + url;
            }
            f = String.valueOf(f) + ",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + url + "\"}";
        }
        f = String.valueOf(f) + "}";
        this.parts.add(f);
        this.cleanParts.add(ChatColor.translateAlternateColorCodes((char)'&', (String)text));
        return this;
    }

    public RawMessage addItem(String text, ItemStack item, List<String> extraLore, String command2, String suggestion) {
        if (text == null) {
            return this;
        }
        if (item == null) {
            return this;
        }
        item = item.clone();
        text = this.makeMessyText(text);
        String f = "{\"text\":\"" + ChatColor.translateAlternateColorCodes((char)'&', (String)text) + "\"";
        CMIItemStack cm = ItemManager.getItem(item);
        String ItemDisplayName = "&r&f" + cm.getDisplayName();
        String Enchants = RawMessage.getItemEnchants(item);
        if (!Enchants.isEmpty()) {
            Enchants = VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1) ? ",Enchantments:" + Enchants : ",ench:" + Enchants;
        }
        ArrayList<String> Lore = new ArrayList<String>();
        if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
            Lore.addAll(item.getItemMeta().getLore());
        }
        if (extraLore != null) {
            Lore.addAll(extraLore);
        }
        String itemName = cm.getBukkitName();
        if (cm.getMojangName() != null) {
            itemName = cm.getMojangName();
        }
        if (itemName.equalsIgnoreCase("Air")) {
            itemName = "Stone";
            ItemDisplayName = "Hand";
        }
        if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1)) {
            itemName = NamespacedKey.minecraft((String)cm.getType().name().toLowerCase()).getKey();
        }
        String loreS = RawMessage.convertLore(Lore);
        if (!Lore.isEmpty()) {
            loreS = ",Lore:[" + loreS + "]";
        }
        f = String.valueOf(f) + ",\"hoverEvent\":{\"action\":\"show_item\",\"value\":\"{id:" + itemName + ",Count:1b,tag:{display:{Name:\\\"" + CMIChatColor.translateAlternateColorCodes(ItemDisplayName) + "\\\"" + loreS + "}" + Enchants + "}}\"}";
        if (suggestion != null) {
            f = String.valueOf(f) + ",\"clickEvent\":{\"action\":\"suggest_command\",\"value\":\"" + suggestion + "\"}";
        }
        if (command2 != null) {
            if (!command2.startsWith("/")) {
                command2 = "/" + command2;
            }
            f = String.valueOf(f) + ",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + command2 + "\"}";
        }
        f = String.valueOf(f) + "}";
        this.parts.add(f);
        return this;
    }

    private static String getItemEnchants(ItemStack item) {
        String Enchants = "";
        if (item.getEnchantments().isEmpty()) {
            return Enchants;
        }
        Enchants = "";
        for (Map.Entry one : item.getEnchantments().entrySet()) {
            if (!Enchants.isEmpty()) {
                Enchants = String.valueOf(Enchants) + ",";
            }
            if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1)) {
                Enchants = String.valueOf(Enchants) + "{id:" + ((Enchantment)one.getKey()).getKey().getKey() + ",lvl:" + one.getValue() + "s}";
                continue;
            }
            try {
                Enchants = String.valueOf(Enchants) + "{id:" + String.valueOf(((Enchantment)one.getKey()).getClass().getMethod("getId", new Class[0]).invoke(one.getKey(), new Object[0])) + ",lvl:" + one.getValue() + "}";
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (!Enchants.isEmpty()) {
            Enchants = "[" + Enchants;
            Enchants = String.valueOf(Enchants) + "]";
        }
        return Enchants;
    }

    private static String convertLore(List<String> lore) {
        String lr = "";
        for (String one : lore) {
            if (!lr.isEmpty()) {
                lr = String.valueOf(lr) + ",";
            }
            lr = String.valueOf(lr) + "\\\"" + one + "\\\"";
        }
        return lr;
    }

    public List<String> softCombine() {
        ArrayList<String> ls = new ArrayList<String>();
        String f = "";
        for (String part : this.parts) {
            if (f.isEmpty()) {
                f = "[\"\",";
            } else {
                if (f.length() > 30000) {
                    ls.add(String.valueOf(f) + "]");
                    f = "[\"\"," + part;
                    continue;
                }
                f = String.valueOf(f) + ",";
            }
            f = String.valueOf(f) + part;
        }
        if (!f.isEmpty()) {
            f = String.valueOf(f) + "]";
        }
        ls.add(f);
        return ls;
    }

    public RawMessage combine() {
        String f = "";
        for (String part : this.parts) {
            f = f.isEmpty() ? "[\"\"," : String.valueOf(f) + ",";
            f = String.valueOf(f) + part;
        }
        if (!f.isEmpty()) {
            f = String.valueOf(f) + "]";
        }
        this.combined = f;
        return this;
    }

    public RawMessage combineClean() {
        String f = "";
        for (String part : this.cleanParts) {
            f = String.valueOf(f) + part.replace("\\\"", "\"");
        }
        this.combinedClean = f;
        return this;
    }

    public RawMessage show(Player player) {
        return this.show(player, true);
    }

    public RawMessage show(Player player, boolean softCombined) {
        if (player == null) {
            return this;
        }
        if (this.combined.isEmpty()) {
            this.combine();
        }
        if (!player.isOnline()) {
            return this;
        }
        if (softCombined) {
            for (String one : this.softCombine()) {
                if (one.isEmpty()) continue;
                ActionBarTitleMessages.sendRaw(player, one);
            }
        } else {
            ActionBarTitleMessages.sendRaw(player, this.combined);
        }
        return this;
    }

    public int getFinalLenght() {
        String f = "";
        for (String part : this.parts) {
            f = f.isEmpty() ? "[\"\"," : String.valueOf(f) + ",";
            f = String.valueOf(f) + part;
        }
        if (!f.isEmpty()) {
            f = String.valueOf(f) + "]";
        }
        return f.length();
    }

    public RawMessage show(CommandSender sender) {
        if (this.combined.isEmpty()) {
            this.combine();
        }
        if (sender instanceof Player) {
            this.show((Player)sender);
        } else {
            sender.sendMessage(this.combineClean().combinedClean);
        }
        return this;
    }

    public String getRaw() {
        if (this.combined.isEmpty()) {
            this.combine();
        }
        return this.combined;
    }

    public String getShortRaw() {
        String f = "";
        for (String part : this.parts) {
            if (!f.isEmpty()) {
                f = String.valueOf(f) + ",";
            }
            f = String.valueOf(f) + part;
        }
        return f;
    }

    public boolean isDontBreakLine() {
        return this.dontBreakLine;
    }

    public void setDontBreakLine(boolean dontBreakLine) {
        this.dontBreakLine = dontBreakLine;
    }

    public void setCombined(String combined) {
        this.combined = combined;
    }

    public void resetColorFormats() {
        this.formats.clear();
        this.lastColor = null;
    }

    public void saveColorFormats() {
        this.savedFormats.clear();
        this.savedFormats.addAll(this.formats);
        this.savedLastColor = this.lastColor;
    }

    public void loadColorFormats() {
        this.formats.clear();
        this.formats.addAll(this.savedFormats);
        this.lastColor = this.savedLastColor;
    }
}

