/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.CMIEntityType;
import com.bekvon.bukkit.cmiLib.CMIItemStack;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemManager {
    static HashMap<Material, CMIMaterial> byRealMaterial = new HashMap();
    static HashMap<Integer, CMIMaterial> byId = new HashMap();
    static HashMap<String, CMIMaterial> byName = new HashMap();
    HashMap<String, ItemStack> headCache = new HashMap();

    static {
        CMIMaterial[] cMIMaterialArray = CMIMaterial.values();
        int n = cMIMaterialArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIMaterial one = cMIMaterialArray[n2];
            if (one != null) {
                one.updateMaterial();
                Material mat = one.getMaterial();
                if (mat != null) {
                    Integer id = one.getId();
                    short data = one.getLegacyData();
                    Integer legacyId = one.getLegacyId();
                    String cmiName = one.getName().replace("_", "").replace(" ", "").toLowerCase();
                    String materialName = one.toString().replace("_", "").replace(" ", "").toLowerCase();
                    String mojangName = null;
                    try {
                        mojangName = CMIReflections.getItemMinecraftName(new ItemStack(mat));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    String string = mojangName = mojangName == null ? mat.toString().replace("_", "").replace(" ", "").toLowerCase() : mojangName.replace("_", "").replace(" ", "").toLowerCase();
                    if (byName.containsKey(cmiName)) {
                        byName.put(String.valueOf(cmiName) + ":" + data, one);
                    } else {
                        byName.put(cmiName, one);
                    }
                    if (byName.containsKey(materialName)) {
                        byName.put(String.valueOf(materialName) + ":" + data, one);
                    } else {
                        byName.put(materialName, one);
                    }
                    if (!one.getLegacyNames().isEmpty()) {
                        for (String oneL : one.getLegacyNames()) {
                            String legacyName = oneL.replace("_", "").replace(" ", "").toLowerCase();
                            if (byName.containsKey(legacyName) || data > 0) {
                                byName.put(String.valueOf(legacyName) + ":" + data, one);
                                continue;
                            }
                            byName.put(legacyName, one);
                        }
                    }
                    if (byName.containsKey(mojangName)) {
                        byName.put(String.valueOf(mojangName) + ":" + data, one);
                    } else {
                        byName.put(mojangName, one);
                    }
                    if (byName.containsKey(String.valueOf(id)) || data > 0) {
                        byName.put(id + ":" + data, one);
                    } else {
                        byName.put(String.valueOf(id), one);
                    }
                    if (byName.containsKey(String.valueOf(legacyId)) || data > 0) {
                        byName.put(legacyId + ":" + data, one);
                    } else {
                        byName.put(String.valueOf(legacyId), one);
                    }
                    if (!byId.containsKey(id)) {
                        byId.put(id, one);
                    }
                    if (!byId.containsKey(one.getLegacyId())) {
                        byId.put(one.getLegacyId(), one);
                    }
                    if (one.getLegacyData() == 0) {
                        byId.put(one.getLegacyId(), one);
                    }
                    byRealMaterial.put(mat, one);
                }
            }
            ++n2;
        }
    }

    public HashMap<Integer, CMIMaterial> idMap() {
        return byId;
    }

    public HashMap<String, CMIMaterial> NameMap() {
        return byName;
    }

    @Deprecated
    public CMIItemStack getItem(Material mat) {
        CMIMaterial cmat = CMIMaterial.get(mat);
        if (cmat == null || cmat.equals((Object)CMIMaterial.NONE)) {
            return null;
        }
        return new CMIItemStack(cmat);
    }

    public static CMIItemStack getItem(CMIMaterial mat) {
        if (mat == null || mat.equals((Object)CMIMaterial.NONE)) {
            return null;
        }
        return new CMIItemStack(mat);
    }

    public static CMIItemStack getItem(ItemStack item) {
        CMIItemStack cm;
        if (item == null) {
            item = new ItemStack(Material.AIR);
        }
        if ((cm = ItemManager.getItem(CMIMaterial.get(item))) == null) {
            return new CMIItemStack(Material.AIR);
        }
        cm.setItemStack(item);
        return cm;
    }

    public CMIItemStack getItem(String name) {
        String a;
        CMIItemStack cm = null;
        String original = name = name.toLowerCase().replace("minecraft:", "");
        name = name.replace("_", "");
        Integer amount = null;
        String subdata = null;
        if (name.contains(":")) {
            CMIMaterial mat = byName.get(name);
            if (mat != null) {
                return new CMIItemStack(mat);
            }
            subdata = name.split(":")[1];
        }
        if (name.contains("-")) {
            a = name.split("-")[1];
            try {
                amount = Integer.parseInt(a);
            }
            catch (Exception exception) {
                // empty catch block
            }
            name = name.split("-")[0];
        }
        if (name.contains(">")) {
            a = name.split(">")[1];
            try {
                amount = Integer.parseInt(a);
            }
            catch (Exception exception) {
                // empty catch block
            }
            name = name.split(">")[0];
        }
        short data = -999;
        if (name.contains(":")) {
            try {
                data = (short)Integer.parseInt(name.split(":")[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                CMIEntityType e = CMIEntityType.getByName(name.split(":")[1]);
                if (e != null) {
                    data = (short)e.getId();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            name = name.split(":")[0];
        }
        switch (name.toLowerCase()) {
            case "skull": {
                cm = CMIMaterial.SKELETON_SKULL.newCMIItemStack();
                break;
            }
            case "door": {
                cm = CMIMaterial.SPRUCE_DOOR.newCMIItemStack();
                break;
            }
            case "head": {
                cm = CMIMaterial.PLAYER_HEAD.newCMIItemStack();
                data = 3;
                if (!original.contains(":")) break;
                ItemStack old = this.headCache.get(original);
                if (old != null) {
                    cm.setItemStack(old);
                    break;
                }
                String d = original.split(":")[1];
                ItemStack skull = CMIMaterial.PLAYER_HEAD.newItemStack();
                SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
                if (d.length() == 36) {
                    try {
                        OfflinePlayer offPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(d));
                        skullMeta.setOwningPlayer(offPlayer);
                    }
                    catch (Exception e) {
                        break;
                    }
                    skull.setItemMeta((ItemMeta)skullMeta);
                } else {
                    skullMeta.setOwner(d);
                    skull.setItemMeta((ItemMeta)skullMeta);
                }
                this.headCache.put(original, skull);
                cm.setItemStack(skull);
            }
        }
        CMIMaterial cmat = CMIMaterial.get(subdata == null ? name : String.valueOf(name) + ":" + subdata);
        if (cmat == null || cmat.equals((Object)CMIMaterial.NONE)) {
            cmat = CMIMaterial.get(name);
        }
        if (cmat != null && !cmat.equals((Object)CMIMaterial.NONE)) {
            cm = cmat.newCMIItemStack();
        } else {
            cmat = CMIMaterial.get(subdata == null ? original : String.valueOf(original) + ":" + subdata);
        }
        if (cmat != null && !cmat.equals((Object)CMIMaterial.NONE)) {
            cm = cmat.newCMIItemStack();
        }
        CMIItemStack ncm = null;
        if (cm != null) {
            ncm = cm.clone();
        }
        if (ncm != null && data != -999) {
            if (ncm.getMaxDurability() > 15) {
                ncm.setData((short)0);
            } else {
                ncm.setData(data);
            }
        }
        if (ncm != null && amount != null) {
            ncm.setAmount(amount);
        }
        if (ncm != null && subdata != null && (ncm.getCMIType().isPotion() || ncm.getCMIType().equals((Object)CMIMaterial.SPLASH_POTION) || ncm.getCMIType().equals((Object)CMIMaterial.TIPPED_ARROW))) {
            Integer d = null;
            PotionEffectType type = null;
            Boolean upgraded = false;
            Boolean extended = false;
            String[] split = subdata.split("-");
            try {
                d = Integer.parseInt(split.length > 0 ? split[0] : subdata);
                type = PotionEffectType.getById((int)d);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String n = (split.length > 0 ? split[0] : subdata).replace("_", "");
                PotionEffectType[] potionEffectTypeArray = PotionEffectType.values();
                int n2 = potionEffectTypeArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    PotionEffectType one = potionEffectTypeArray[n3];
                    if (one != null && n.equalsIgnoreCase(one.getName().replace("_", ""))) {
                        type = one;
                        break;
                    }
                    ++n3;
                }
                if (split.length > 1) {
                    try {
                        upgraded = Boolean.parseBoolean(split[1]);
                    }
                    catch (Exception one) {
                        // empty catch block
                    }
                }
                if (split.length > 2) {
                    try {
                        extended = Boolean.parseBoolean(split[2]);
                    }
                    catch (Exception one) {
                        // empty catch block
                    }
                }
                ItemStack item = ncm.getItemStack();
                if (extended.booleanValue() && upgraded.booleanValue()) {
                    extended = false;
                }
                PotionMeta meta = (PotionMeta)item.getItemMeta();
                meta.setBasePotionData(new PotionData(PotionType.getByEffect((PotionEffectType)type), extended.booleanValue(), upgraded.booleanValue()));
                item.setItemMeta((ItemMeta)meta);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ncm;
    }

    public List<Recipe> getAllRecipes() {
        ArrayList<Recipe> results = new ArrayList<Recipe>();
        Iterator iter = Bukkit.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = (Recipe)iter.next();
            results.add(recipe);
        }
        return results;
    }

    public List<Recipe> getRecipesFor(ItemStack result) {
        ArrayList<Recipe> results = new ArrayList<Recipe>();
        Iterator iter = Bukkit.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = (Recipe)iter.next();
            ItemStack stack = recipe.getResult();
            if (stack.getType() != result.getType() || result.getDurability() != -1 && result.getDurability() != stack.getDurability()) continue;
            results.add(recipe);
        }
        return results;
    }

    public Material getMaterial(String name) {
        CMIItemStack cm = this.getItem(name);
        if (cm == null) {
            return Material.AIR;
        }
        return cm.getType();
    }

    public static enum SlabType {
        TOP,
        BOTTOM,
        DOUBLE,
        NOTSLAB;

    }
}

