/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.residence.Residence;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigReader
extends YamlConfiguration {
    private HashMap<String, String> comments = new HashMap();
    private HashMap<String, Object> contents = new HashMap();
    YamlConfiguration config;
    private String p = null;
    private File file = null;
    private boolean recordContents = false;
    String[] waitingComment = null;

    public ConfigReader(String fileName) throws Exception {
        this(new File(Residence.getInstance().getDataFolder(), fileName));
    }

    public ConfigReader(File file) throws Exception {
        this.file = file;
        this.config = this.getyml(file);
    }

    public void load() {
        try {
            this.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void save(String file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.save(new File(file));
    }

    public void save(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        Files.createParentDirs((File)file);
        String data = this.insertComments(this.saveToString());
        try (PrintWriter writer = new PrintWriter(file, "UTF-8");){
            writer.write(data);
        }
    }

    private String insertComments(String yaml) {
        block34: {
            if (this.comments.isEmpty()) break block34;
            String[] yamlContents = yaml.split("[" + System.getProperty("line.separator") + "]");
            StringBuilder newContents = new StringBuilder();
            StringBuilder currentPath = new StringBuilder();
            boolean commentedPath = false;
            boolean node = false;
            int depth = 0;
            boolean firstLine = true;
            String[] stringArray = yamlContents;
            int n = yamlContents.length;
            int n2 = 0;
            while (n2 < n) {
                block36: {
                    int whiteSpace;
                    int index;
                    String line;
                    block35: {
                        line = stringArray[n2];
                        if (!firstLine) break block35;
                        firstLine = false;
                        if (line.startsWith("#")) break block36;
                    }
                    boolean keyOk = true;
                    if (line.contains(": ")) {
                        String key;
                        index = 0;
                        index = line.indexOf(": ");
                        if (index < 0) {
                            index = line.length() - 1;
                        }
                        whiteSpace = 0;
                        int n3 = 0;
                        while (n3 < line.length()) {
                            if (line.charAt(n3) != ' ') break;
                            ++whiteSpace;
                            ++n3;
                        }
                        if ((key = line.substring(whiteSpace, index)).contains(" ")) {
                            keyOk = false;
                        } else if (key.contains("&")) {
                            keyOk = false;
                        } else if (key.contains(".")) {
                            keyOk = false;
                        } else if (key.contains("'")) {
                            keyOk = false;
                        } else if (key.contains("\"")) {
                            keyOk = false;
                        }
                    }
                    if (line.contains(": ") && keyOk || line.length() > 1 && line.charAt(line.length() - 1) == ':') {
                        commentedPath = false;
                        node = true;
                        index = 0;
                        index = line.indexOf(": ");
                        if (index < 0) {
                            index = line.length() - 1;
                        }
                        if (currentPath.toString().isEmpty()) {
                            currentPath = new StringBuilder(line.substring(0, index));
                        } else {
                            whiteSpace = 0;
                            int n4 = 0;
                            while (n4 < line.length()) {
                                if (line.charAt(n4) != ' ') break;
                                ++whiteSpace;
                                ++n4;
                            }
                            if (whiteSpace / 2 > depth) {
                                currentPath.append(".").append(line.substring(whiteSpace, index));
                                ++depth;
                            } else if (whiteSpace / 2 < depth) {
                                int newDepth = whiteSpace / 2;
                                int i = 0;
                                while (i < depth - newDepth) {
                                    currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "");
                                    ++i;
                                }
                                int lastIndex = currentPath.lastIndexOf(".");
                                if (lastIndex < 0) {
                                    currentPath = new StringBuilder();
                                } else {
                                    currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "").append(".");
                                }
                                currentPath.append(line.substring(whiteSpace, index));
                                depth = newDepth;
                            } else {
                                int lastIndex = currentPath.lastIndexOf(".");
                                if (lastIndex < 0) {
                                    currentPath = new StringBuilder();
                                } else {
                                    currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "").append(".");
                                }
                                currentPath.append(line.substring(whiteSpace, index));
                            }
                        }
                    } else {
                        node = false;
                    }
                    StringBuilder newLine = new StringBuilder(line);
                    if (node) {
                        String comment = null;
                        if (!commentedPath) {
                            comment = this.comments.get(currentPath.toString());
                        }
                        if (comment != null && !comment.isEmpty()) {
                            newLine.insert(0, System.getProperty("line.separator")).insert(0, comment);
                            comment = null;
                            commentedPath = true;
                        }
                    }
                    newLine.append(System.getProperty("line.separator"));
                    newContents.append(newLine.toString());
                }
                ++n2;
            }
            return newContents.toString();
        }
        return yaml;
    }

    public void addComment(String path, String ... commentLines) {
        if (this.p != null) {
            path = String.valueOf(this.p) + path;
        }
        StringBuilder commentstring = new StringBuilder();
        String leadingSpaces = "";
        int n = 0;
        while (n < path.length()) {
            if (path.charAt(n) == '.') {
                leadingSpaces = String.valueOf(leadingSpaces) + "  ";
            }
            ++n;
        }
        String[] stringArray = commentLines;
        int n2 = commentLines.length;
        int n3 = 0;
        while (n3 < n2) {
            String line = stringArray[n3];
            if (!line.isEmpty()) {
                line = String.valueOf(leadingSpaces) + "# " + line;
            }
            if (commentstring.length() > 0) {
                commentstring.append(System.getProperty("line.separator"));
            }
            commentstring.append(line);
            ++n3;
        }
        this.comments.put(path, commentstring.toString());
    }

    public YamlConfiguration getyml(File file) throws Exception {
        YamlConfiguration config = new YamlConfiguration();
        FileInputStream fileinputstream = null;
        try {
            try {
                fileinputstream = new FileInputStream(file);
                InputStreamReader str = new InputStreamReader((InputStream)fileinputstream, Charset.forName("UTF-8"));
                config.load((Reader)str);
                str.close();
            }
            catch (FileNotFoundException str) {
                if (fileinputstream != null) {
                    try {
                        fileinputstream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
                this.saveToBackup();
                throw e;
            }
        }
        finally {
            if (fileinputstream != null) {
                try {
                    fileinputstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return config;
    }

    public void saveToBackup() {
        File cc = new File(Residence.getInstance().getDataFolder(), "FileBackups");
        if (!cc.isDirectory()) {
            cc.mkdir();
        }
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss ");
        String newFileName = String.valueOf(dateFormat.format(date)) + this.file.getName();
        Residence.getInstance().consoleMessage("&cFailed to load " + this.file.getName() + "! Backup have been saved into " + Residence.getInstance().getDataFolder().getPath() + File.separator + "FileBackups" + File.separator + newFileName);
        File f = new File(Residence.getInstance().getDataFolder(), "FileBackups" + File.separator + newFileName);
        try {
            Files.copy((File)this.file, (File)f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            this.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void newLn(StringBuilder header) {
        header.append(System.lineSeparator());
    }

    private static StringBuilder formStringBuilder(List<String> list2) {
        StringBuilder header = new StringBuilder();
        for (String one : list2) {
            header.append(one);
            ConfigReader.newLn(header);
        }
        return header;
    }

    public void header(List<String> list2) {
        this.options().header(ConfigReader.formStringBuilder(list2).toString());
    }

    private void checkWaitingComment(String path) {
        if (this.waitingComment == null) {
            return;
        }
        this.addComment(path, this.waitingComment);
        this.waitingComment = null;
    }

    public YamlConfiguration getC() {
        return this.config;
    }

    public void copyDefaults(boolean value) {
        this.getC().options().copyDefaults(value);
    }

    public Boolean get(String path, Boolean boo) {
        path = this.process(path, boo);
        return this.config.getBoolean(path);
    }

    private String process(String path, Object value) {
        if (this.p != null) {
            path = String.valueOf(this.p) + path;
        }
        this.checkWaitingComment(path);
        this.config.addDefault(path, value);
        this.copySetting(path);
        return path;
    }

    public Object get(String path, Location boo) {
        path = this.process(path, boo);
        return this.config.get(path);
    }

    public int get(String path, int boo) {
        path = this.process(path, boo);
        return this.config.getInt(path);
    }

    public List<Integer> getIntList(String path, List<Integer> list2) {
        path = this.process(path, list2);
        return this.config.getIntegerList(path);
    }

    private static String convertUnicode(String st) {
        try {
            if (!st.contains("\\u")) {
                return st;
            }
            StringBuilder sb = new StringBuilder(st.length());
            int i = 0;
            while (i < st.length()) {
                block12: {
                    int ch;
                    block13: {
                        char nextChar;
                        block14: {
                            ch = st.charAt(i);
                            if (ch != 92) break block13;
                            char c = nextChar = i == st.length() - 1 ? (char)'\\' : (char)st.charAt(i + 1);
                            if (nextChar < 48 || nextChar > 55) break block14;
                            String code = "" + nextChar;
                            if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                                code = String.valueOf(code) + st.charAt(i + 1);
                                if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                                    code = String.valueOf(code) + st.charAt(i + 1);
                                    ++i;
                                }
                            }
                            sb.append((char)Integer.parseInt(code, 8));
                            break block12;
                        }
                        switch (nextChar) {
                            case 'u': {
                                if (i >= st.length() - 5) {
                                    ch = 117;
                                    break;
                                }
                                try {
                                    int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5), 16);
                                    sb.append(Character.toChars(code));
                                }
                                catch (NumberFormatException e) {
                                    sb.append("\\");
                                    break block12;
                                }
                                i += 5;
                                break block12;
                            }
                            default: {
                                sb.append("\\");
                                break block12;
                            }
                        }
                        ++i;
                    }
                    sb.append((char)ch);
                }
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return st;
        }
    }

    public List<String> get(String path, List<String> list2) {
        path = this.process(path, list2);
        if (this.recordContents) {
            this.contents.put(path, this.config.isList(path) ? this.config.getStringList(path) : list2);
        }
        List ls = this.config.getStringList(path);
        int p = 0;
        while (p < ls.size()) {
            String st = ConfigReader.convertUnicode((String)ls.get(p));
            ls.set(p, st);
            ++p;
        }
        return ls;
    }

    public String get(String path, String boo) {
        path = this.process(path, boo);
        if (this.recordContents) {
            this.contents.put(path, this.config.isString(path) ? this.config.getString(path) : boo);
        }
        return ConfigReader.convertUnicode(this.config.getString(path));
    }

    public Double get(String path, Double boo) {
        path = this.process(path, boo);
        return this.config.getDouble(path);
    }

    private synchronized void copySetting(String path) {
        this.set(path, this.config.get(path));
    }

    public void resetP() {
        this.p = null;
    }

    public void setP(String cmd2) {
        this.p = cmd2;
    }

    public String getPath() {
        return this.p;
    }

    public void setRecordContents(boolean recordContents) {
        this.recordContents = recordContents;
    }

    public HashMap<String, Object> getContents() {
        return this.contents;
    }
}

