/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.VersionChecker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CMIReflections {
    private static Class<?> CraftServerClass;
    private static Object CraftServer;
    private static Class<?> CraftItemStack;
    private static Class<?> Item;
    private static Class<?> IStack;
    private static Class<?> NBTTagCompound;
    private static Class<?> CraftContainer;
    private static Class<?> CraftContainers;
    private static Class<?> PacketPlayOutOpenWindow;
    private static Class<?> CraftPlayer;
    public static Class<?> nmsChatSerializer;

    static {
        CMIReflections.initialize();
    }

    private static void initialize() {
        try {
            nmsChatSerializer = !VersionChecker.Version.isCurrentHigher(VersionChecker.Version.v1_8_R2) ? CMIReflections.getMinecraftClass("ChatSerializer") : CMIReflections.getMinecraftClass("IChatBaseComponent$ChatSerializer");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            CraftPlayer = CMIReflections.getBukkitClass("entity.CraftPlayer");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            CraftContainer = CMIReflections.getMinecraftClass("Container");
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            CraftContainers = CMIReflections.getMinecraftClass("Containers");
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            PacketPlayOutOpenWindow = CMIReflections.getMinecraftClass("PacketPlayOutOpenWindow");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            NBTTagCompound = CMIReflections.getMinecraftClass("NBTTagCompound");
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            CraftServerClass = CMIReflections.getBukkitClass("CraftServer");
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            CraftServer = CraftServerClass.cast(Bukkit.getServer());
        }
        catch (IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            CraftItemStack = CMIReflections.getBukkitClass("inventory.CraftItemStack");
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            Item = CMIReflections.getMinecraftClass("Item");
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            IStack = CMIReflections.getMinecraftClass("ItemStack");
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack HideFlag(ItemStack item, int state) {
        Object nmsStack = CMIReflections.asNMSCopy(item);
        try {
            Method methTag = nmsStack.getClass().getMethod("getTag", new Class[0]);
            Object tag = methTag.invoke(nmsStack, new Object[0]);
            if (tag == null) {
                tag = NBTTagCompound.newInstance();
            }
            Method meth = tag.getClass().getMethod("setInt", String.class, Integer.TYPE);
            meth.invoke(tag, "HideFlags", state);
            Method meth2 = nmsStack.getClass().getMethod("setTag", NBTTagCompound);
            meth2.invoke(nmsStack, tag);
            return (ItemStack)CMIReflections.asBukkitCopy(nmsStack);
        }
        catch (Exception exception) {
            return item;
        }
    }

    private static Integer getActiveContainerId(Object entityplayer) {
        try {
            Field field = entityplayer.getClass().getField("activeContainer");
            Object container = CraftContainer.cast(field.get(entityplayer));
            Field field2 = container.getClass().getField("windowId");
            Object ids = field2.get(container);
            return (int)((Integer)ids);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getContainer(String name) {
        try {
            Field field = CraftContainers.getDeclaredField(name);
            return field.get(CraftContainers);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateInventoryTitle(Player p, String title) {
        if (title.length() > 32) {
            title = String.valueOf(title.substring(0, 31)) + "~";
        }
        try {
            if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_14_R1)) {
                Object entityplayer = CraftPlayer.getMethod("getHandle", new Class[0]).invoke((Object)p, new Object[0]);
                Object s = CMIReflections.getContainer("GENERIC_9X1");
                switch (p.getOpenInventory().getTopInventory().getSize()) {
                    case 9: {
                        break;
                    }
                    case 18: {
                        s = CMIReflections.getContainer("GENERIC_9X2");
                        break;
                    }
                    case 27: {
                        s = CMIReflections.getContainer("GENERIC_9X3");
                        break;
                    }
                    case 36: {
                        s = CMIReflections.getContainer("GENERIC_9X4");
                        break;
                    }
                    case 45: {
                        s = CMIReflections.getContainer("GENERIC_9X5");
                        break;
                    }
                    case 54: {
                        s = CMIReflections.getContainer("GENERIC_9X6");
                    }
                }
                Constructor<?> packet = PacketPlayOutOpenWindow.getConstructor(Integer.TYPE, CraftContainers, CMIReflections.getMinecraftClass("IChatBaseComponent"));
                Object newPack = packet.newInstance(CMIReflections.getActiveContainerId(entityplayer), s, CMIReflections.textToIChatBaseComponent("{\"text\": \"" + title + "\"}"));
                CMIReflections.sendPlayerPacket(p, newPack);
                Field field = entityplayer.getClass().getField("activeContainer");
                Object container = CraftContainer.cast(field.get(entityplayer));
                Method meth = entityplayer.getClass().getMethod("updateInventory", CraftContainer);
                meth.invoke(entityplayer, container);
            } else if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_8_R2)) {
                Object entityplayer = CraftPlayer.getMethod("getHandle", new Class[0]).invoke((Object)p, new Object[0]);
                Constructor<?> packet = PacketPlayOutOpenWindow.getConstructor(Integer.TYPE, String.class, CMIReflections.getMinecraftClass("IChatBaseComponent"), Integer.TYPE);
                Object newPack = packet.newInstance(CMIReflections.getActiveContainerId(entityplayer), "minecraft:chest", CMIReflections.textToIChatBaseComponent("{\"text\": \"" + title + "\"}"), p.getOpenInventory().getTopInventory().getSize());
                CMIReflections.sendPlayerPacket(p, newPack);
                Field field = entityplayer.getClass().getField("activeContainer");
                Object container = CraftContainer.cast(field.get(entityplayer));
                Method meth = entityplayer.getClass().getMethod("updateInventory", CraftContainer);
                meth.invoke(entityplayer, container);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Object textToIChatBaseComponent(String text) {
        try {
            Object serialized = nmsChatSerializer.getMethod("a", String.class).invoke(null, ChatColor.translateAlternateColorCodes((char)'&', (String)text));
            return serialized;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return text;
        }
    }

    public static Object getPlayerHandle(Player player) {
        Object handle = null;
        try {
            handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handle;
    }

    private static Object getPlayerConnection(Player player) {
        Object connection = null;
        try {
            Object handle = CMIReflections.getPlayerHandle(player);
            connection = handle.getClass().getField("playerConnection").get(handle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return connection;
    }

    public static Class<?> getClass(String classname) {
        try {
            String version2 = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            String path = classname.replace("{nms}", "net.minecraft.server." + version2).replace("{nm}", "net.minecraft." + version2).replace("{cb}", "org.bukkit.craftbukkit.." + version2);
            return Class.forName(path);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void sendPlayerPacket(Player player, Object packet) throws Exception {
        Object connection = CMIReflections.getPlayerConnection(player);
        connection.getClass().getMethod("sendPacket", CMIReflections.getClass("{nms}.Packet")).invoke(connection, packet);
    }

    private static Class<?> getBukkitClass(String nmsClassString) throws ClassNotFoundException {
        return Class.forName("org.bukkit.craftbukkit." + (Object)((Object)VersionChecker.Version.getCurrent()) + "." + nmsClassString);
    }

    public static Class<?> getMinecraftClass(String nmsClassString) throws ClassNotFoundException {
        return Class.forName("net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + "." + nmsClassString);
    }

    public static ItemStack setNbt(ItemStack item, String path, String value) {
        if (item == null) {
            return null;
        }
        try {
            Object nmsStack = CMIReflections.asNMSCopy(item);
            if (nmsStack == null) {
                return item;
            }
            Method methTag = nmsStack.getClass().getMethod("getTag", new Class[0]);
            Object tag = methTag.invoke(nmsStack, new Object[0]);
            if (tag == null) {
                tag = NBTTagCompound.newInstance();
            }
            Method meth = tag.getClass().getMethod("setString", String.class, String.class);
            meth.invoke(tag, path, value);
            Method meth2 = nmsStack.getClass().getMethod("setTag", NBTTagCompound);
            meth2.invoke(nmsStack, tag);
            return (ItemStack)CMIReflections.asBukkitCopy(nmsStack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getItemMinecraftName(ItemStack item) {
        try {
            Object nmsStack = CMIReflections.asNMSCopy(item);
            if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1)) {
                Object pre = nmsStack.getClass().getMethod("getItem", new Class[0]).invoke(nmsStack, new Object[0]);
                Object n = pre.getClass().getMethod("getName", new Class[0]).invoke(pre, new Object[0]);
                Class<?> ll = Class.forName("net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".LocaleLanguage");
                Object lla = ll.getMethod("a", new Class[0]).invoke(ll, new Object[0]);
                return (String)lla.getClass().getMethod("a", String.class).invoke(lla, (String)n);
            }
            Field field = Item.getField("REGISTRY");
            Object reg = field.get(field);
            Method meth = reg.getClass().getMethod("b", Object.class);
            meth.setAccessible(true);
            Method secmeth = nmsStack.getClass().getMethod("getItem", new Class[0]);
            Object res2 = secmeth.invoke(nmsStack, new Object[0]);
            Object res = meth.invoke(reg, res2);
            return res.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getItemMinecraftNamePath(ItemStack item) {
        try {
            Object nmsStack = CMIReflections.asNMSCopy(item);
            Method itemMeth = Item.getMethod("getById", Integer.TYPE);
            Object res = itemMeth.invoke(Item, item.getType().getId());
            Method nameThingy = Item.getMethod("j", IStack);
            Object resThingy = nameThingy.invoke(res, nmsStack);
            return resThingy.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object asNMSCopy(ItemStack item) {
        try {
            Method meth = CraftItemStack.getMethod("asNMSCopy", ItemStack.class);
            return meth.invoke(CraftItemStack, item);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object asBukkitCopy(Object item) {
        try {
            Method meth = CraftItemStack.getMethod("asBukkitCopy", IStack);
            return meth.invoke(CraftItemStack, item);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getCraftServer() {
        return CraftServer;
    }

    public static Object getNbt(ItemStack item, String path) {
        if (item == null) {
            return null;
        }
        try {
            Object nbt = CMIReflections.getNbt(item);
            if (nbt == null) {
            }
            Method meth = nbt.getClass().getMethod("getString", String.class);
            Object res = meth.invoke(nbt, path);
            return res;
        }
        finally {
            return null;
        }
    }

    public static Object getNbt(ItemStack item) {
        if (item == null) {
            return null;
        }
        try {
            Object nmsStack = CMIReflections.asNMSCopy(item);
            Method methTag = nmsStack.getClass().getMethod("getTag", new Class[0]);
            Object tag = methTag.invoke(nmsStack, new Object[0]);
            return tag;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ItemStack getItemInOffHand(Player player) {
        if (VersionChecker.Version.getCurrent().isLower(VersionChecker.Version.v1_9_R1)) {
            return null;
        }
        return player.getInventory().getItemInOffHand();
    }

    public void setEndermiteActive(Entity ent, boolean state) {
    }
}

