/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.CMIEntityType;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.ItemManager;
import com.bekvon.bukkit.cmiLib.VersionChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CMIItemStack {
    private int id = 0;
    private short data = 0;
    private short durability = 0;
    private int amount = 0;
    private String bukkitName = null;
    private String mojangName = null;
    private CMIMaterial cmiMaterial = null;
    private Material material = null;
    private ItemStack item;

    public CMIItemStack(Material material2) {
        this.material = material2;
        this.cmiMaterial = CMIMaterial.get(material2);
    }

    public CMIItemStack(CMIMaterial cmiMaterial) {
        this.cmiMaterial = cmiMaterial;
        if (cmiMaterial != null) {
            this.material = cmiMaterial.getMaterial();
        }
    }

    public CMIItemStack(ItemStack item) {
        this.setItemStack(item);
    }

    public CMIItemStack clone() {
        CMIItemStack cm = new CMIItemStack(this.material);
        cm.setId(this.id);
        cm.setData(this.data);
        cm.setAmount(this.amount);
        cm.setDurability(this.durability);
        cm.setBukkitName(this.bukkitName);
        cm.setMojangName(this.mojangName);
        cm.setCMIMaterial(this.cmiMaterial);
        cm.setMaterial(this.material);
        cm.setItemStack(this.item != null ? this.item.clone() : null);
        return cm;
    }

    public int getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public short getData() {
        return this.data;
    }

    public boolean isTool() {
        return this.getMaxDurability() > 0;
    }

    public short getDurability() {
        return this.getItemStack().getDurability();
    }

    public short getMaxDurability() {
        return this.material.getMaxDurability();
    }

    public void setData(short data) {
        this.data = data;
    }

    public CMIItemStack setDisplayName(String name) {
        ItemMeta meta = this.getItemStack().getItemMeta();
        if (meta != null) {
            if (name == null) {
                meta.setDisplayName(null);
            } else {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
        }
        this.getItemStack().setItemMeta(meta);
        return this;
    }

    public String getDisplayName() {
        ItemMeta meta = this.getItemStack().getItemMeta();
        return meta == null || meta.getDisplayName() == null || meta.getDisplayName().isEmpty() ? this.getRealName() : meta.getDisplayName();
    }

    public CMIItemStack addLore(String string) {
        if (string == null) {
            return this;
        }
        ItemMeta meta = this.getItemStack().getItemMeta();
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        meta.setLore(lore);
        this.getItemStack().setItemMeta(meta);
        return this;
    }

    public CMIItemStack clearLore() {
        ItemMeta meta = this.getItemStack().getItemMeta();
        ArrayList t = new ArrayList();
        meta.setLore(t);
        this.getItemStack().setItemMeta(meta);
        return this;
    }

    public CMIItemStack setLore(List<String> lore) {
        if (lore == null || lore.isEmpty()) {
            return this;
        }
        ItemMeta meta = this.getItemStack().getItemMeta();
        ArrayList<String> t = new ArrayList<String>();
        for (String one : lore) {
            t.add(ChatColor.translateAlternateColorCodes((char)'&', (String)one));
        }
        meta.setLore(t);
        this.getItemStack().setItemMeta(meta);
        return this;
    }

    public CMIItemStack addEnchant(Enchantment enchant, Integer level) {
        if (enchant == null) {
            return this;
        }
        if (this.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.getItemStack().getItemMeta();
            meta.addStoredEnchant(enchant, level.intValue(), true);
            this.getItemStack().setItemMeta((ItemMeta)meta);
        } else {
            ItemMeta meta = this.getItemStack().getItemMeta();
            meta.addEnchant(enchant, level.intValue(), true);
            this.getItemStack().setItemMeta(meta);
        }
        return this;
    }

    public CMIItemStack addEnchant(HashMap<Enchantment, Integer> enchants) {
        if (enchants == null || enchants.isEmpty()) {
            return this;
        }
        for (Map.Entry<Enchantment, Integer> oneEnch : enchants.entrySet()) {
            this.addEnchant(oneEnch.getKey(), oneEnch.getValue());
        }
        return this;
    }

    public CMIItemStack clearEnchants() {
        ItemMeta meta = this.getItemStack().getItemMeta();
        meta.getEnchants().clear();
        this.getItemStack().setItemMeta(meta);
        return this;
    }

    public List<String> getLore() {
        ItemMeta meta = this.getItemStack().getItemMeta();
        if (meta != null) {
            ArrayList lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList();
                meta.setLore(lore);
            }
            return meta.getLore() == null ? new ArrayList() : meta.getLore();
        }
        return new ArrayList<String>();
    }

    public String getRealName() {
        return this.getCMIType() == null || this.getCMIType() == CMIMaterial.NONE ? this.getType().name() : this.getCMIType().getName();
    }

    public String getBukkitName() {
        return this.bukkitName == null || this.bukkitName.isEmpty() ? null : this.bukkitName;
    }

    public void setBukkitName(String bukkitName) {
        this.bukkitName = bukkitName;
    }

    public String getMojangName() {
        return this.mojangName == null || this.mojangName.isEmpty() ? this.getCMIType().getMaterial().name() : this.mojangName;
    }

    public void setMojangName(String mojangName) {
        if (mojangName != null) {
            this.mojangName = mojangName.replace("minecraft:", "");
        }
    }

    public Material getType() {
        if (this.material == null && this.cmiMaterial != null) {
            return this.cmiMaterial.getMaterial();
        }
        return this.material;
    }

    public CMIMaterial getCMIType() {
        return this.cmiMaterial == null ? CMIMaterial.get(this.material) : this.cmiMaterial;
    }

    @Deprecated
    public Material getMaterial() {
        return this.getType();
    }

    public void setMaterial(Material material2) {
        this.cmiMaterial = CMIMaterial.get(material2);
        this.material = material2;
    }

    public void setCMIMaterial(CMIMaterial material2) {
        this.cmiMaterial = material2;
        this.material = material2 == null ? null : material2.getMaterial();
    }

    public ItemStack getItemStack() {
        if (this.item == null) {
            if (this.cmiMaterial.isMonsterEgg()) {
                if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1)) {
                    this.item = new ItemStack(this.getType());
                    this.item.setAmount(this.getAmount());
                } else {
                    this.item = new ItemStack(this.getType(), this.amount == 0 ? 1 : this.amount, this.data == 0 ? (short)90 : (short)this.data);
                }
                CMIEntityType cMIEntityType = CMIEntityType.getById(this.data);
            } else if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1)) {
                this.item = new ItemStack(this.getType());
                this.item.setAmount(this.getAmount());
            } else {
                this.item = new ItemStack(this.getType(), this.amount == 0 ? 1 : this.amount, this.data);
            }
            if (this.getCMIType().isPotion() || this.item.getType().name().contains("SPLASH_POTION") || this.item.getType().name().contains("TIPPED_ARROW")) {
                PotionMeta potion = (PotionMeta)this.item.getItemMeta();
                PotionEffectType effect = PotionEffectType.getById((int)this.data);
                if (effect != null) {
                    potion.addCustomEffect(new PotionEffect(effect, 60, 0), true);
                }
                this.item.setItemMeta((ItemMeta)potion);
                this.item.setDurability((short)0);
                potion = (PotionMeta)this.item.getItemMeta();
                potion.setDisplayName(this.getRealName());
                this.item.setItemMeta((ItemMeta)potion);
            }
        }
        return this.item;
    }

    public CMIItemStack setItemStack(ItemStack item) {
        ItemStack itemStack = this.item = item == null ? null : item;
        if (item != null) {
            this.amount = item.getAmount();
            this.material = item.getType();
            this.cmiMaterial = CMIMaterial.get(this.material);
            if (VersionChecker.Version.isCurrentEqualOrLower(VersionChecker.Version.v1_13_R2)) {
                this.id = item.getType().getId();
            } else if (this.cmiMaterial != null) {
                this.id = this.cmiMaterial.getId();
            }
            if (this.getType().isBlock() || this.getType().isSolid()) {
                this.data = item.getData().getData();
            }
            if (item.getType().getMaxDurability() - item.getDurability() < 0) {
                this.data = item.getData().getData();
            }
            if (item.getType().getMaxDurability() > 15) {
                this.data = 0;
            }
            if (item.getType() == Material.POTION || item.getType().name().contains("SPLASH_POTION") || item.getType().name().contains("TIPPED_ARROW")) {
                PotionMeta potion = (PotionMeta)item.getItemMeta();
                try {
                    if (potion != null && potion.getBasePotionData() != null && potion.getBasePotionData().getType() != null && potion.getBasePotionData().getType().getEffectType() != null) {
                        this.data = (short)potion.getBasePotionData().getType().getEffectType().getId();
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public int getAmount() {
        return this.amount <= 0 ? 1 : this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        if (this.item != null) {
            this.item.setAmount(this.amount == 0 ? this.item.getAmount() : this.amount);
        }
    }

    public boolean isSimilar(ItemStack item) {
        return this.isSimilar(ItemManager.getItem(item));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSimilar(CMIItemStack item) {
        if (item == null) {
            return false;
        }
        try {
            if ((item.getCMIType().isPotion() || item.getCMIType().equals((Object)CMIMaterial.TIPPED_ARROW)) && (this.getCMIType().isPotion() || this.getCMIType().equals((Object)CMIMaterial.TIPPED_ARROW)) && this.getType().equals((Object)item.getType())) {
                PotionMeta potion = (PotionMeta)item.getItemStack().getItemMeta();
                PotionMeta potion2 = (PotionMeta)this.getItemStack().getItemMeta();
                try {
                    PotionData base2;
                    PotionData base1;
                    return potion != null && potion.getBasePotionData() != null && (base1 = potion.getBasePotionData()).getType() != null && potion2 != null && potion2.getBasePotionData() != null && (base2 = potion2.getBasePotionData()).getType() != null && base1.getType().equals((Object)base2.getType()) && base1.isExtended() == base2.isExtended() && base1.isUpgraded() == base2.isUpgraded();
                }
                catch (NoSuchMethodError base1) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta && item.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta meta1 = (EnchantmentStorageMeta)this.getItemStack().getItemMeta();
                EnchantmentStorageMeta meta2 = (EnchantmentStorageMeta)item.getItemStack().getItemMeta();
                for (Map.Entry one : meta1.getEnchants().entrySet()) {
                    if (meta2.getEnchants().containsKey(one.getKey()) && meta2.getEnchants().get(one.getKey()) == one.getValue()) continue;
                    return false;
                }
                for (Map.Entry one : meta1.getStoredEnchants().entrySet()) {
                    if (meta2.getStoredEnchants().containsKey(one.getKey()) && meta2.getStoredEnchants().get(one.getKey()) == one.getValue()) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((item.getCMIType() == CMIMaterial.SPAWNER || item.getCMIType().isMonsterEgg()) && (this.getCMIType() == CMIMaterial.SPAWNER || this.getCMIType().isMonsterEgg())) {
            return this.cmiMaterial == item.cmiMaterial;
        }
        if (VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_13_R1)) {
            return this.cmiMaterial == item.cmiMaterial;
        }
        return this.cmiMaterial == item.cmiMaterial && this.getData() == item.getData();
    }

    public void setDurability(short durability) {
        this.durability = durability;
    }

    public String toOneLiner() {
        String liner = this.getType().toString();
        if (this.getCMIType().isPotion() || this.getType().name().contains("TIPPED_ARROW")) {
            PotionMeta potion = (PotionMeta)this.item.getItemMeta();
            try {
                if (potion != null && potion.getBasePotionData() != null && potion.getBasePotionData().getType() != null && potion.getBasePotionData().getType().getEffectType() != null) {
                    liner = String.valueOf(liner) + ":" + potion.getBasePotionData().getType().getEffectType().getName() + "-" + potion.getBasePotionData().isUpgraded() + "-" + potion.getBasePotionData().isExtended();
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {}
        } else if (VersionChecker.Version.isCurrentLower(VersionChecker.Version.v1_13_R1)) {
            liner = String.valueOf(liner) + ":" + this.getData();
        }
        if (this.getItemStack().getItemMeta() instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.getItemStack().getItemMeta();
            String s = "";
            for (Map.Entry one : meta.getStoredEnchants().entrySet()) {
                if (!s.isEmpty()) {
                    s = String.valueOf(s) + ";";
                }
                s = String.valueOf(s) + ((Enchantment)one.getKey()).getName() + "x" + one.getValue();
            }
            for (Map.Entry one : meta.getEnchants().entrySet()) {
                if (!s.isEmpty()) {
                    s = String.valueOf(s) + ";";
                }
                s = String.valueOf(s) + ((Enchantment)one.getKey()).getName() + "x" + one.getValue();
            }
            if (!s.isEmpty()) {
                liner = String.valueOf(liner) + ":" + s;
            }
        }
        return liner;
    }
}

