/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.VersionChecker;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Particle;

public class CMIEffectManager {

    public static enum CMIParticle {
        CLICK2("null", 0, CMIParticleType.SOUND, null),
        CLICK1("null", 1, CMIParticleType.SOUND, null),
        BOW_FIRE("null", 2, CMIParticleType.SOUND, null),
        DOOR_TOGGLE("null", 3, CMIParticleType.SOUND, null),
        IRON_DOOR_TOGGLE("null", 4, CMIParticleType.SOUND, null),
        TRAPDOOR_TOGGLE("null", 5, CMIParticleType.SOUND, null),
        IRON_TRAPDOOR_TOGGLE("null", 6, CMIParticleType.SOUND, null),
        FENCE_GATE_TOGGLE("null", 7, CMIParticleType.SOUND, null),
        DOOR_CLOSE("null", 8, CMIParticleType.SOUND, null),
        IRON_DOOR_CLOSE("null", 9, CMIParticleType.SOUND, null),
        TRAPDOOR_CLOSE("null", 10, CMIParticleType.SOUND, null),
        IRON_TRAPDOOR_CLOSE("null", 11, CMIParticleType.SOUND, null),
        FENCE_GATE_CLOSE("null", 12, CMIParticleType.SOUND, null),
        EXTINGUISH("null", 13, CMIParticleType.SOUND, null),
        RECORD_PLAY("null", 14, CMIParticleType.SOUND, null),
        GHAST_SHRIEK("null", 15, CMIParticleType.SOUND, null),
        GHAST_SHOOT("null", 16, CMIParticleType.SOUND, null),
        BLAZE_SHOOT("null", 17, CMIParticleType.SOUND, null),
        ZOMBIE_CHEW_WOODEN_DOOR("null", 18, CMIParticleType.SOUND, null),
        ZOMBIE_CHEW_IRON_DOOR("null", 19, CMIParticleType.SOUND, null),
        ZOMBIE_DESTROY_DOOR("null", 20, CMIParticleType.SOUND, null),
        SMOKE("null", 21, CMIParticleType.VISUAL, null),
        STEP_SOUND("null", 22, CMIParticleType.SOUND, null),
        POTION_BREAK("null", 23, CMIParticleType.VISUAL, null),
        ENDER_SIGNAL("null", 24, CMIParticleType.VISUAL, null),
        MOBSPAWNER_FLAMES("null", 25, CMIParticleType.VISUAL, null),
        BREWING_STAND_BREW("null", 26, CMIParticleType.SOUND, null),
        CHORUS_FLOWER_GROW("null", 27, CMIParticleType.SOUND, null),
        CHORUS_FLOWER_DEATH("null", 28, CMIParticleType.SOUND, null),
        PORTAL_TRAVEL("null", 29, CMIParticleType.SOUND, null),
        ENDEREYE_LAUNCH("null", 30, CMIParticleType.SOUND, null),
        FIREWORK_SHOOT("null", 31, CMIParticleType.SOUND, null),
        VILLAGER_PLANT_GROW("null", 32, CMIParticleType.VISUAL, null),
        DRAGON_BREATH("null", 33, CMIParticleType.VISUAL, null),
        ANVIL_BREAK("null", 34, CMIParticleType.SOUND, null),
        ANVIL_USE("null", 35, CMIParticleType.SOUND, null),
        ANVIL_LAND("null", 36, CMIParticleType.SOUND, null),
        ENDERDRAGON_SHOOT("null", 37, CMIParticleType.SOUND, null),
        WITHER_BREAK_BLOCK("null", 38, CMIParticleType.SOUND, null),
        WITHER_SHOOT("null", 39, CMIParticleType.SOUND, null),
        ZOMBIE_INFECT("null", 40, CMIParticleType.SOUND, null),
        ZOMBIE_CONVERTED_VILLAGER("null", 41, CMIParticleType.SOUND, null),
        BAT_TAKEOFF("null", 42, CMIParticleType.SOUND, null),
        END_GATEWAY_SPAWN("null", 43, CMIParticleType.VISUAL, null),
        ENDERDRAGON_GROWL("null", 44, CMIParticleType.SOUND, null),
        FIREWORKS_SPARK("fireworksSpark", 45, CMIParticleType.PARTICLE, CMIMaterial.FIRE_CHARGE.getMaterial()),
        CRIT("crit", 46, CMIParticleType.PARTICLE, Material.IRON_SWORD),
        MAGIC_CRIT("CRIT_MAGIC", 47, CMIParticleType.PARTICLE, Material.POTION),
        POTION_SWIRL("mobSpell", "SPELL_MOB", 48, CMIParticleType.PARTICLE, Material.BLAZE_ROD),
        POTION_SWIRL_TRANSPARENT("mobSpellAmbient", "SPELL_MOB_AMBIENT", 49, CMIParticleType.PARTICLE, Material.BLAZE_POWDER),
        SPELL("spell", 50, CMIParticleType.PARTICLE, Material.MILK_BUCKET),
        INSTANT_SPELL("instantSpell", "SPELL_INSTANT", 51, CMIParticleType.PARTICLE, Material.GLASS_BOTTLE),
        WITCH_MAGIC("witchMagic", "SPELL_WITCH", 52, CMIParticleType.PARTICLE, Material.SPIDER_EYE),
        NOTE("note", 53, CMIParticleType.PARTICLE, Material.NOTE_BLOCK),
        PORTAL("portal", 54, CMIParticleType.PARTICLE, Material.OBSIDIAN),
        FLYING_GLYPH("enchantmenttable", 55, CMIParticleType.PARTICLE, CMIMaterial.ENCHANTING_TABLE.getMaterial()),
        FLAME("flame", 56, CMIParticleType.PARTICLE, CMIMaterial.FIRE_CHARGE.getMaterial()),
        LAVA_POP("lava", 57, CMIParticleType.PARTICLE, Material.FLINT_AND_STEEL),
        FOOTSTEP("footstep", 58, CMIParticleType.PARTICLE, Material.IRON_BOOTS),
        SPLASH("splash", "water splash", 59, CMIParticleType.PARTICLE, Material.STICK),
        PARTICLE_SMOKE("smoke", "SMOKE_NORMAL", 60, CMIParticleType.PARTICLE, Material.ANVIL),
        EXPLOSION_HUGE("hugeexplosion", 61, CMIParticleType.PARTICLE, Material.FURNACE),
        EXPLOSION_LARGE("largeexplode", 62, CMIParticleType.PARTICLE, Material.FURNACE),
        EXPLOSION("explode", "EXPLOSION_NORMAL", 63, CMIParticleType.PARTICLE, Material.TNT),
        VOID_FOG("depthsuspend", "SUSPENDED_DEPTH", 64, CMIParticleType.PARTICLE, CMIMaterial.SALMON.getMaterial()),
        SMALL_SMOKE("townaura", 65, CMIParticleType.PARTICLE, CMIMaterial.MYCELIUM.getMaterial()),
        CLOUD("cloud", 66, CMIParticleType.PARTICLE, CMIMaterial.COBWEB.getMaterial()),
        COLOURED_DUST("reddust", "redstone", 67, CMIParticleType.PARTICLE, Material.REDSTONE, CMIParticleDataType.DustOptions),
        SNOWBALL_BREAK("snowballpoof", "SNOWBALL", 68, CMIParticleType.PARTICLE, CMIMaterial.SNOWBALL.getMaterial()),
        WATERDRIP("dripWater", "WATER_DROP", 69, CMIParticleType.PARTICLE, Material.WATER_BUCKET),
        LAVADRIP("dripLava", 70, CMIParticleType.PARTICLE, Material.LAVA_BUCKET),
        SNOW_SHOVEL("snowshovel", 71, CMIParticleType.PARTICLE, CMIMaterial.DIAMOND_SHOVEL.getMaterial()),
        SLIME("slime", 72, CMIParticleType.PARTICLE, Material.SLIME_BALL),
        HEART("heart", 73, CMIParticleType.PARTICLE, CMIMaterial.ROSE_RED.getMaterial()),
        VILLAGER_THUNDERCLOUD("angryVillager", "VILLAGER_ANGRY", 74, CMIParticleType.PARTICLE, Material.EMERALD),
        HAPPY_VILLAGER("VILLAGER_HAPPY", 75, CMIParticleType.PARTICLE, Material.BOOK),
        LARGE_SMOKE("largesmoke", "SMOKE_LARGE", 76, CMIParticleType.PARTICLE, Material.FURNACE),
        ITEM_BREAK("iconcrack", 77, CMIParticleType.NONE, Material.DIAMOND_BOOTS),
        WATER_BUBBLE("WATER_BUBBLE", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        WATER_WAKE("WATER_WAKE", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        SUSPENDED("SUSPENDED", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        BARRIER("BARRIER", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        MOB_APPEARANCE("MOB_APPEARANCE", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        END_ROD("END_ROD", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        DAMAGE_INDICATOR("DAMAGE_INDICATOR", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        SWEEP_ATTACK("SWEEP_ATTACK", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        TOTEM("TOTEM", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        SPIT("SPIT", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        SQUID_INK("SQUID_INK", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        BUBBLE_POP("BUBBLE_POP", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        CURRENT_DOWN("CURRENT_DOWN", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        BUBBLE_COLUMN_UP("BUBBLE_COLUMN_UP", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        NAUTILUS("NAUTILUS", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void),
        DOLPHIN("DOLPHIN", -1, CMIParticleType.PARTICLE, Material.STONE, CMIParticleDataType.Void);

        private String name;
        private String secondaryName = "";
        private int id;
        private CMIParticleType type;
        private Material icon;
        private Object particle;
        private Effect effect;
        private Object EnumParticle;
        private int[] extra;
        private CMIParticleDataType dataType = CMIParticleDataType.Void;

        private CMIParticle(String name, int id, CMIParticleType type) {
            this(name, null, id, type, null);
        }

        private CMIParticle(String name, int id, CMIParticleType type, Material icon) {
            this(name, null, id, type, icon);
        }

        private CMIParticle(String name, String secondaryName, int id, CMIParticleType type, Material icon) {
            this(name, secondaryName, id, type, icon, CMIParticleDataType.Void);
        }

        private CMIParticle(String name, int id, CMIParticleType type, Material icon, CMIParticleDataType dataType) {
            this(name, null, id, type, icon, dataType);
        }

        private CMIParticle(String name, String secondaryName, int id, CMIParticleType type, Material icon, CMIParticleDataType dataType) {
            this.name = name;
            this.secondaryName = secondaryName;
            this.id = id;
            this.type = type;
            this.icon = icon;
            this.dataType = dataType;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public CMIParticleType getType() {
            return this.type;
        }

        public boolean isParticle() {
            return this.type == CMIParticleType.PARTICLE;
        }

        public boolean isColored() {
            return this.equals((Object)COLOURED_DUST) || this.equals((Object)NOTE);
        }

        public static boolean isParticle(Effect effect) {
            if (effect == null) {
                return false;
            }
            CMIParticle cmiEffect = CMIParticle.getCMIParticle(effect.toString());
            if (cmiEffect == null) {
                return false;
            }
            return cmiEffect.isParticle();
        }

        public static Material getSafeIcon(Effect effect) {
            CMIParticle cmiEffect = CMIParticle.getCMIParticle(effect.toString());
            if (cmiEffect == null) {
                return Material.STONE;
            }
            return cmiEffect.getIcon() == null ? Material.STONE : cmiEffect.getIcon();
        }

        public Material getSafeIcon() {
            return this.getIcon() == null ? Material.STONE : this.getIcon();
        }

        public static CMIParticle getCMIParticle(String name) {
            CMIParticle cmiEffect = null;
            if (name == null) {
                return null;
            }
            name = name.replace("_", "").toLowerCase();
            CMIParticle[] cMIParticleArray = CMIParticle.values();
            int n = cMIParticleArray.length;
            int n2 = 0;
            while (n2 < n) {
                CMIParticle one = cMIParticleArray[n2];
                if (one.getName() != null && one.getName().equalsIgnoreCase(name)) {
                    cmiEffect = one;
                    break;
                }
                if (!one.getSecondaryName().isEmpty() && one.getSecondaryName().replace("_", "").equalsIgnoreCase(name)) {
                    cmiEffect = one;
                    break;
                }
                if (one.name().replace("_", "").equalsIgnoreCase(name)) {
                    cmiEffect = one;
                    break;
                }
                ++n2;
            }
            if (cmiEffect != null && VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1) && cmiEffect.getParticle() == null) {
                return null;
            }
            if (VersionChecker.Version.isCurrentLower(VersionChecker.Version.v1_13_R1) && cmiEffect != null && cmiEffect.getEffect() == null) {
                return null;
            }
            return cmiEffect;
        }

        public Effect getEffect() {
            Effect one;
            if (this.effect != null) {
                return this.effect;
            }
            if (!this.isParticle()) {
                return null;
            }
            Effect[] effectArray = Effect.values();
            int n = effectArray.length;
            int n2 = 0;
            while (n2 < n) {
                one = effectArray[n2];
                if (one.toString().replace("_", "").equalsIgnoreCase(this.name().replace("_", ""))) {
                    this.effect = one;
                    return one;
                }
                if (one.toString().replace("_", "").equalsIgnoreCase(this.getName())) {
                    this.effect = one;
                    return one;
                }
                ++n2;
            }
            effectArray = Effect.values();
            n = effectArray.length;
            n2 = 0;
            while (n2 < n) {
                one = effectArray[n2];
                if (one.toString().replace("_", "").equalsIgnoreCase(this.name.replace("_", ""))) {
                    try {
                        if (one.getType() != Effect.Type.VISUAL) {
                            return null;
                        }
                    }
                    catch (Exception | NoSuchMethodError e) {
                        return null;
                    }
                    this.effect = one;
                    return one;
                }
                ++n2;
            }
            return null;
        }

        public Material getIcon() {
            return this.icon == null ? Material.STONE : this.icon;
        }

        public static List<CMIParticle> getParticleList() {
            ArrayList<CMIParticle> ls = new ArrayList<CMIParticle>();
            CMIParticle[] cMIParticleArray = CMIParticle.values();
            int n = cMIParticleArray.length;
            int n2 = 0;
            while (n2 < n) {
                CMIParticle one = cMIParticleArray[n2];
                if (!(!one.isParticle() || VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1) && one.getParticle() == null || VersionChecker.Version.isCurrentLower(VersionChecker.Version.v1_13_R1) && one.getEffect() == null)) {
                    ls.add(one);
                }
                ++n2;
            }
            return ls;
        }

        public CMIParticle getNextPartcileEffect() {
            List<CMIParticle> ls = CMIParticle.getParticleList();
            int i = 0;
            while (i < ls.size()) {
                CMIParticle next = ls.get(i);
                if (next != null && next.isParticle() && (!VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1) || next.getParticle() != null) && next.equals((Object)this)) {
                    if (i == ls.size() - 1) {
                        return ls.get(0);
                    }
                    return ls.get(i + 1);
                }
                ++i;
            }
            return this;
        }

        public CMIParticle getPrevParticleEffect() {
            List<CMIParticle> ls = CMIParticle.getParticleList();
            int i = 0;
            while (i < ls.size()) {
                CMIParticle next = ls.get(i);
                if (next != null && (!VersionChecker.Version.isCurrentEqualOrHigher(VersionChecker.Version.v1_9_R1) || next.getParticle() != null) && next.isParticle() && next.equals((Object)this)) {
                    if (i == 0) {
                        return ls.get(ls.size() - 1);
                    }
                    return ls.get(i - 1);
                }
                ++i;
            }
            return this;
        }

        public String getSecondaryName() {
            return this.secondaryName == null ? "" : this.secondaryName;
        }

        public void setSecondaryName(String secondaryName) {
            this.secondaryName = secondaryName;
        }

        public Particle getParticle() {
            String name;
            Particle one;
            int n;
            int n2;
            Particle[] particleArray;
            String n3;
            if (VersionChecker.Version.isCurrentEqualOrLower(VersionChecker.Version.v1_8_R3)) {
                return null;
            }
            if (this.particle == null) {
                n3 = this.toString().replace("_", "").toLowerCase();
                particleArray = Particle.values();
                n2 = particleArray.length;
                n = 0;
                while (n < n2) {
                    one = particleArray[n];
                    name = one.toString().toLowerCase().replace("_", "");
                    if (name.equalsIgnoreCase(n3)) {
                        this.particle = one;
                        break;
                    }
                    ++n;
                }
            }
            if (this.particle == null) {
                n3 = this.name().replace("_", "").toLowerCase();
                particleArray = Particle.values();
                n2 = particleArray.length;
                n = 0;
                while (n < n2) {
                    one = particleArray[n];
                    name = one.toString().toLowerCase().replace("_", "");
                    if (name.equalsIgnoreCase(n3)) {
                        this.particle = one;
                        break;
                    }
                    ++n;
                }
            }
            if (this.particle == null) {
                n3 = this.getName().replace("_", "").toLowerCase();
                particleArray = Particle.values();
                n2 = particleArray.length;
                n = 0;
                while (n < n2) {
                    one = particleArray[n];
                    name = one.toString().toLowerCase().replace("_", "");
                    if (name.equalsIgnoreCase(n3)) {
                        this.particle = one;
                        break;
                    }
                    ++n;
                }
            }
            if (this.particle == null && !(n3 = this.getSecondaryName().replace("_", "").toLowerCase()).isEmpty()) {
                particleArray = Particle.values();
                n2 = particleArray.length;
                n = 0;
                while (n < n2) {
                    one = particleArray[n];
                    name = one.toString().toLowerCase().replace("_", "");
                    if (name.equalsIgnoreCase(n3)) {
                        this.particle = one;
                        break;
                    }
                    ++n;
                }
                if (this.particle == null) {
                    particleArray = Particle.values();
                    n2 = particleArray.length;
                    n = 0;
                    while (n < n2) {
                        one = particleArray[n];
                        name = one.toString().toLowerCase().replace("_", "");
                        if (name.contains(n3)) {
                            this.particle = one;
                            break;
                        }
                        ++n;
                    }
                }
            }
            return this.particle == null ? null : (Particle)this.particle;
        }

        public Object getEnumParticle() {
            return this.EnumParticle;
        }

        public void setEnumParticle(Object enumParticle) {
            this.EnumParticle = enumParticle;
        }

        public int[] getExtra() {
            return this.extra;
        }

        public void setExtra(int[] extra) {
            this.extra = extra;
        }
    }

    public static enum CMIParticleDataType {
        Void,
        DustOptions,
        ItemStack,
        BlockData,
        MaterialData;

    }

    public static enum CMIParticleType {
        SOUND,
        VISUAL,
        PARTICLE,
        NONE;

    }
}

