/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;

public enum CMIChatColor {
    BLACK('0'),
    DARK_BLUE('1'),
    DARK_GREEN('2'),
    DARK_AQUA('3'),
    DARK_RED('4'),
    DARK_PURPLE('5'),
    GOLD('6'),
    GRAY('7'),
    DARK_GRAY('8'),
    BLUE('9'),
    GREEN('a'),
    AQUA('b'),
    RED('c'),
    LIGHT_PURPLE('d'),
    YELLOW('e'),
    WHITE('f'),
    MAGIC('k', false),
    BOLD('l', false),
    STRIKETHROUGH('m', false),
    UNDERLINE('n', false),
    ITALIC('o', false),
    RESET('r', false, true);

    private char c;
    private Boolean color = true;
    private Boolean reset = false;
    private Pattern pattern = null;

    private CMIChatColor(char c) {
        this(c, true);
    }

    private CMIChatColor(char c, Boolean color) {
        this(c, color, false);
    }

    private CMIChatColor(char c, Boolean color, Boolean reset2) {
        this.c = c;
        this.color = color;
        this.reset = reset2;
        this.pattern = Pattern.compile("(?i)(&[" + c + "])");
    }

    public static String translateAlternateColorCodes(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static String colorize(String text) {
        if (text == null) {
            return null;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static String deColorize(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\u00a7", "&");
    }

    public static String stripColor(String text) {
        if (text == null) {
            return null;
        }
        text = ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        return ChatColor.stripColor((String)text);
    }

    public static String getLastColors(String text) {
        if (text == null) {
            return null;
        }
        text = CMIChatColor.translateAlternateColorCodes(text);
        return ChatColor.getLastColors((String)text);
    }

    public String getColorCode() {
        return "&" + this.c;
    }

    public String getBukkitColorCode() {
        return "\u00a7" + this.c;
    }

    public char getChar() {
        return this.c;
    }

    public void setChar(char c) {
        this.c = c;
    }

    public Boolean isColor() {
        return this.color;
    }

    public Boolean isFormat() {
        if (!this.color.booleanValue() && !this.reset.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean isReset() {
        return this.reset;
    }

    public ChatColor getColor() {
        return ChatColor.getByChar((char)this.getChar());
    }

    public static CMIChatColor getColor(String text) {
        int n;
        String or = CMIChatColor.deColorize(text);
        if ((text = CMIChatColor.deColorize(text).replace("&", "")).length() > 1) {
            String formated = text.toLowerCase().replace("_", "");
            CMIChatColor[] cMIChatColorArray = CMIChatColor.values();
            int n2 = cMIChatColorArray.length;
            n = 0;
            while (n < n2) {
                CMIChatColor one = cMIChatColorArray[n];
                if (one.name().replace("_", "").equalsIgnoreCase(formated)) {
                    return one;
                }
                ++n;
            }
        }
        if (or.length() > 1 && String.valueOf(or.charAt(or.length() - 2)).equalsIgnoreCase("&")) {
            text = text.substring(text.length() - 1, text.length());
            CMIChatColor[] cMIChatColorArray = CMIChatColor.values();
            n = cMIChatColorArray.length;
            int n3 = 0;
            while (n3 < n) {
                CMIChatColor one = cMIChatColorArray[n3];
                if (String.valueOf(one.getChar()).equalsIgnoreCase(text)) {
                    return one;
                }
                ++n3;
            }
        }
        return null;
    }

    public static CMIChatColor getRandomColor() {
        ArrayList<CMIChatColor> ls = new ArrayList<CMIChatColor>();
        CMIChatColor[] cMIChatColorArray = CMIChatColor.values();
        int n = cMIChatColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIChatColor one = cMIChatColorArray[n2];
            if (one.isColor().booleanValue()) {
                ls.add(one);
            }
            ++n2;
        }
        Collections.shuffle(ls);
        return (CMIChatColor)((Object)ls.get(0));
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

