/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.cmiLib;

import com.bekvon.bukkit.cmiLib.CMIChatColor;
import com.bekvon.bukkit.cmiLib.VersionChecker;
import com.bekvon.bukkit.residence.Residence;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ActionBarTitleMessages {
    private static Object packet;
    private static Method getHandle;
    private static Method sendPacket;
    private static Field playerConnection;
    private static Class<?> nmsChatSerializer;
    private static Class<?> nmsIChatBaseComponent;
    private static Class<?> packetType;
    private static Constructor<?> nmsPacketPlayOutTitle;
    private static Class<?> enumTitleAction;
    private static Method fromString;
    private static boolean simpleTitleMessages;
    private static Class<?> ChatMessageclz;
    private static Class<?> sub;
    private static Object[] consts;

    static {
        simpleTitleMessages = false;
        try {
            packetType = Class.forName(ActionBarTitleMessages.getPacketPlayOutChat());
            Class<?> typeCraftPlayer = Class.forName(ActionBarTitleMessages.getCraftPlayerClasspath());
            Class<?> typeNMSPlayer = Class.forName(ActionBarTitleMessages.getNMSPlayerClasspath());
            Class<?> typePlayerConnection = Class.forName(ActionBarTitleMessages.getPlayerConnectionClasspath());
            nmsChatSerializer = Class.forName(ActionBarTitleMessages.getChatSerializerClasspath());
            nmsIChatBaseComponent = Class.forName(ActionBarTitleMessages.getIChatBaseComponentClasspath());
            getHandle = typeCraftPlayer.getMethod("getHandle", new Class[0]);
            playerConnection = typeNMSPlayer.getField("playerConnection");
            sendPacket = typePlayerConnection.getMethod("sendPacket", Class.forName(ActionBarTitleMessages.getPacketClasspath()));
            if (VersionChecker.Version.isCurrentHigher(VersionChecker.Version.v1_11_R1)) {
                ChatMessageclz = Class.forName(ActionBarTitleMessages.getChatMessageTypeClasspath());
                consts = ChatMessageclz.getEnumConstants();
                sub = consts[2].getClass();
            }
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Error {0}", ex);
        }
        try {
            Class<?> typePacketPlayOutTitle = Class.forName(ActionBarTitleMessages.getPacketPlayOutTitleClasspath());
            enumTitleAction = Class.forName(ActionBarTitleMessages.getEnumTitleActionClasspath());
            nmsPacketPlayOutTitle = typePacketPlayOutTitle.getConstructor(enumTitleAction, nmsIChatBaseComponent);
            fromString = Class.forName(ActionBarTitleMessages.getClassMessageClasspath()).getMethod("fromString", String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
            simpleTitleMessages = true;
        }
    }

    public static void send(CommandSender receivingPacket, String msg) {
        if (receivingPacket instanceof Player) {
            ActionBarTitleMessages.send((Player)receivingPacket, msg);
        } else {
            receivingPacket.sendMessage(msg);
        }
    }

    public static void send(Player receivingPacket, String msg) {
        if (receivingPacket == null) {
            return;
        }
        if (!receivingPacket.isOnline()) {
            return;
        }
        if (msg == null) {
            return;
        }
        try {
            if (!VersionChecker.Version.getCurrent().isHigher(VersionChecker.Version.v1_7_R4) || nmsChatSerializer == null) {
                receivingPacket.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
                return;
            }
            Object serialized = nmsChatSerializer.getMethod("a", String.class).invoke(null, "{\"text\": \"" + ChatColor.translateAlternateColorCodes((char)'&', (String)msg) + "\"}");
            packet = VersionChecker.Version.isCurrentHigher(VersionChecker.Version.v1_11_R1) ? packetType.getConstructor(nmsIChatBaseComponent, sub).newInstance(serialized, consts[2]) : (VersionChecker.Version.isCurrentHigher(VersionChecker.Version.v1_7_R4) ? packetType.getConstructor(nmsIChatBaseComponent, Byte.TYPE).newInstance(serialized, (byte)2) : packetType.getConstructor(nmsIChatBaseComponent, Integer.TYPE).newInstance(serialized, 2));
            Object player = getHandle.invoke((Object)receivingPacket, new Object[0]);
            Object connection = playerConnection.get(player);
            sendPacket.invoke(connection, packet);
        }
        catch (Exception serialized) {
            // empty catch block
        }
        try {
            Object player = getHandle.invoke((Object)receivingPacket, new Object[0]);
            Object connection = playerConnection.get(player);
            sendPacket.invoke(connection, packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendRaw(Player receivingPacket, String msg) {
        if (receivingPacket == null) {
            return;
        }
        if (!receivingPacket.isOnline()) {
            return;
        }
        if (msg == null) {
            return;
        }
        try {
            Method meth = nmsChatSerializer.getMethod("a", String.class);
            Object serialized = meth.invoke(null, ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
            packet = VersionChecker.Version.isCurrentHigher(VersionChecker.Version.v1_11_R1) ? packetType.getConstructor(nmsIChatBaseComponent, sub).newInstance(serialized, consts[1]) : (VersionChecker.Version.isCurrentHigher(VersionChecker.Version.v1_7_R4) ? packetType.getConstructor(nmsIChatBaseComponent, Byte.TYPE).newInstance(serialized, (byte)1) : packetType.getConstructor(nmsIChatBaseComponent, Boolean.TYPE).newInstance(serialized, true));
            Object player = getHandle.invoke((Object)receivingPacket, new Object[0]);
            Object connection = playerConnection.get(player);
            sendPacket.invoke(connection, packet);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Error {0}", ex);
        }
    }

    public static void sendTitle(Player receivingPacket, Object title) {
        ActionBarTitleMessages.sendTitle(receivingPacket, title, null, 0, 20, 20);
    }

    public static void sendTitle(Player receivingPacket, Object title, Object subtitle) {
        ActionBarTitleMessages.sendTitle(receivingPacket, title, subtitle, 0, 20, 20);
    }

    public static void sendTitle(final Player receivingPacket, final Object title, final Object subtitle, final int fadeIn, final int keep, final int fadeOut) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Residence.getInstance(), new Runnable(){

            @Override
            public void run() {
                String s;
                String t = title == null ? null : CMIChatColor.translateAlternateColorCodes((String)title);
                String string = s = subtitle == null ? null : CMIChatColor.translateAlternateColorCodes((String)subtitle);
                if (t != null && s == null && t.contains("%subtitle%")) {
                    s = t.split("%subtitle%")[1];
                    t = (t = t.split("%subtitle%")[0]) == null ? null : CMIChatColor.translateAlternateColorCodes(t);
                    String string2 = s = s == null ? null : CMIChatColor.translateAlternateColorCodes(s);
                }
                if (simpleTitleMessages) {
                    receivingPacket.sendMessage(t);
                    receivingPacket.sendMessage(s);
                    return;
                }
                try {
                    switch (VersionChecker.Version.getCurrent()) {
                        case v1_9_R1: 
                        case v1_9_R2: 
                        case v1_10_R1: 
                        case v1_11_R1: {
                            receivingPacket.sendTitle(t, s);
                            break;
                        }
                        case v1_12_R1: 
                        case v1_13_R1: 
                        case v1_13_R2: 
                        case v1_14_R1: 
                        case v1_14_R2: 
                        case v1_15_R1: 
                        case v1_15_R2: {
                            receivingPacket.sendTitle(t, s, fadeIn, keep, fadeOut);
                            break;
                        }
                        case v1_7_R1: 
                        case v1_7_R2: 
                        case v1_7_R3: 
                        case v1_7_R4: 
                        case v1_8_R1: 
                        case v1_8_R2: 
                        case v1_8_R3: {
                            Object packetTitle;
                            if (title != null) {
                                packetTitle = nmsPacketPlayOutTitle.newInstance(enumTitleAction.getField("TITLE").get(null), ((Object[])fromString.invoke(null, t))[0]);
                                ActionBarTitleMessages.sendPacket(receivingPacket, packetTitle);
                            }
                            if (subtitle != null) {
                                if (title == null) {
                                    packetTitle = nmsPacketPlayOutTitle.newInstance(enumTitleAction.getField("TITLE").get(null), ((Object[])fromString.invoke(null, ""))[0]);
                                    ActionBarTitleMessages.sendPacket(receivingPacket, packetTitle);
                                }
                                Object packetSubtitle = nmsPacketPlayOutTitle.newInstance(enumTitleAction.getField("SUBTITLE").get(null), ((Object[])fromString.invoke(null, s))[0]);
                                ActionBarTitleMessages.sendPacket(receivingPacket, packetSubtitle);
                            }
                            break;
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException ex) {
                    simpleTitleMessages = true;
                    Bukkit.getLogger().log(Level.SEVERE, "Your server can't fully support title messages. They will be shown in chat instead.");
                }
            }
        });
    }

    private static void sendPacket(Player player, Object packet) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object handle = getHandle.invoke((Object)player, new Object[0]);
        Object connection = playerConnection.get(handle);
        sendPacket.invoke(connection, packet);
    }

    private static String getCraftPlayerClasspath() {
        return "org.bukkit.craftbukkit." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".entity.CraftPlayer";
    }

    private static String getPlayerConnectionClasspath() {
        return "net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".PlayerConnection";
    }

    private static String getNMSPlayerClasspath() {
        return "net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".EntityPlayer";
    }

    private static String getPacketClasspath() {
        return "net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".Packet";
    }

    private static String getIChatBaseComponentClasspath() {
        return "net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".IChatBaseComponent";
    }

    private static String getChatSerializerClasspath() {
        if (!VersionChecker.Version.isCurrentHigher(VersionChecker.Version.v1_8_R2)) {
            return "net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".ChatSerializer";
        }
        return "net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".IChatBaseComponent$ChatSerializer";
    }

    private static String getPacketPlayOutChat() {
        return "net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".PacketPlayOutChat";
    }

    private static String getPacketPlayOutTitleClasspath() {
        return "net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".PacketPlayOutTitle";
    }

    private static String getEnumTitleActionClasspath() {
        return String.valueOf(ActionBarTitleMessages.getPacketPlayOutTitleClasspath()) + "$EnumTitleAction";
    }

    private static String getClassMessageClasspath() {
        return "org.bukkit.craftbukkit." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".util.CraftChatMessage";
    }

    private static String getChatMessageTypeClasspath() {
        return "net.minecraft.server." + (Object)((Object)VersionChecker.Version.getCurrent()) + ".ChatMessageType";
    }
}

