/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.CMIGUI;

import com.bekvon.bukkit.CMIGUI.CMIGui;
import com.bekvon.bukkit.CMIGUI.CMIGuiButton;
import com.bekvon.bukkit.CMIGUI.CommandType;
import com.bekvon.bukkit.CMIGUI.GUIButtonCommand;
import com.bekvon.bukkit.CMIGUI.GUIListener;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import com.bekvon.bukkit.residence.Residence;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GUIManager {
    private static HashMap<UUID, CMIGui> map = new HashMap();
    public static final String CMIGUIIcon = "CMIGUIIcon";
    public static final String LIProtection = "LIProtection";

    static {
        GUIManager.registerListener();
    }

    public static void registerListener() {
        Residence.getInstance().getServer().getPluginManager().registerEvents((Listener)new GUIListener(Residence.getInstance()), (Plugin)Residence.getInstance());
    }

    public void closeAll() {
        for (Map.Entry<UUID, CMIGui> one : map.entrySet()) {
            Player player = Bukkit.getPlayer((UUID)one.getKey());
            if (player == null) continue;
            player.closeInventory();
        }
    }

    public static GUIClickType getClickType(boolean left, boolean shift, InventoryAction action) {
        if (!left && !shift && (action.equals((Object)InventoryAction.NOTHING) || action.equals((Object)InventoryAction.CLONE_STACK))) {
            return GUIClickType.MiddleMouse;
        }
        if (left && !shift) {
            return GUIClickType.Left;
        }
        if (left && shift) {
            return GUIClickType.LeftShift;
        }
        if (!left && !shift) {
            return GUIClickType.Right;
        }
        return GUIClickType.RightShift;
    }

    public static boolean processClick(final Player player, List<Integer> buttons, final GUIClickType clickType) {
        CMIGui gui = map.get(player.getUniqueId());
        if (gui == null) {
            return false;
        }
        int clicks = 0;
        for (Integer one : buttons) {
            final CMIGuiButton button = gui.getButtons().get(one);
            if (button == null) continue;
            ++clicks;
            boolean canClick = true;
            if (canClick) {
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Residence.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        for (GUIButtonCommand oneC : button.getCommands(clickType)) {
                            GUIManager.performCommand(player, oneC.getCommand(), oneC.getVis());
                        }
                    }
                }, 1L);
            }
            button.click();
            button.click(clickType);
            if (button.isCloseInv()) {
                player.closeInventory();
            }
            if (!button.getCommands(clickType).isEmpty()) break;
        }
        if (clicks == 0) {
            gui.outsideClick(clickType);
        }
        return false;
    }

    public static void performCommand(CommandSender sender, String command2, CommandType type) {
        if (sender instanceof Player) {
            GUIManager.performCommand((Player)sender, command2, type);
        } else {
            ServerCommandEvent event = new ServerCommandEvent(sender, command2.startsWith("/") ? command2 : "/" + command2);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)(event.getCommand().startsWith("/") ? event.getCommand().substring(1, event.getCommand().length()) : event.getCommand()));
            }
            if (!type.equals((Object)CommandType.silent)) {
                Bukkit.getLogger().log(Level.INFO, String.valueOf(sender.getName()) + " issued " + type.name() + " command: /" + command2);
            }
        }
    }

    public static void performCommand(Player player, String command2, CommandType type) {
        if (player == null) {
            Residence.getInstance().consoleMessage("&cCant perform command (" + command2 + "). Player is NULL");
            return;
        }
        if (command2 == null) {
            Residence.getInstance().consoleMessage("&cCant perform command (" + command2 + "). Command is NULL");
            return;
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent(player, command2.startsWith("/") ? command2 : "/" + command2);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            player.performCommand(event.getMessage().startsWith("/") ? event.getMessage().substring(1, event.getMessage().length()) : event.getMessage());
        }
        if (!type.equals((Object)CommandType.silent)) {
            Bukkit.getLogger().log(Level.INFO, String.valueOf(player.getName()) + " issued " + type.name() + " command: /" + command2);
        }
    }

    public static boolean isLockedPart(Player player, List<Integer> buttons) {
        CMIGui gui = map.get(player.getUniqueId());
        if (gui == null) {
            return false;
        }
        int size = gui.getInv().getSize();
        int mainInvMax = size + 36 - 9;
        int quickbar = size + 36;
        for (Integer one : buttons) {
            if (one > quickbar || quickbar < 0) continue;
            if (one < size && gui.isLocked(InvType.Gui) && gui.isPermLocked(InvType.Gui)) {
                return true;
            }
            if (one >= size && one < mainInvMax && gui.isLocked(InvType.Main) && gui.isPermLocked(InvType.Main)) {
                return true;
            }
            if (one < mainInvMax || one >= quickbar || (!gui.isLocked(InvType.Quickbar) || !gui.isPermLocked(InvType.Quickbar)) && (!gui.isLocked(InvType.Main) || !gui.isPermLocked(InvType.Main))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canClick(Player player, List<Integer> buttons) {
        try {
            Integer one;
            CMIGuiButton button;
            CMIGui gui = map.get(player.getUniqueId());
            if (gui == null) {
                return true;
            }
            Iterator<Integer> iterator = buttons.iterator();
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                one = iterator.next();
            } while ((button = gui.getButtons().get(one)) == null || button.getFieldType() != GUIFieldType.Locked);
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static CMIGui getGui(Player player) {
        return map.get(player.getUniqueId());
    }

    public static boolean isOpenedGui(Player player) {
        CMIGui gui = map.get(player.getUniqueId());
        if (gui == null) {
            return false;
        }
        return player.getOpenInventory() != null;
    }

    public static boolean removePlayer(Player player) {
        CMIGui removed = map.remove(player.getUniqueId());
        if (removed == null) {
            return false;
        }
        if (player.getOpenInventory() != null && player.getOpenInventory().getTopInventory().equals(removed.getInv())) {
            player.closeInventory();
        }
        removed.processClose();
        removed.onClose();
        return true;
    }

    public static void generateInventory(CMIGui gui) {
        Inventory GuiInv = null;
        GuiInv = gui.getInvSize() != null ? Bukkit.createInventory(null, (int)gui.getInvSize().getFields(), (String)gui.getTitle()) : Bukkit.createInventory(null, (InventoryType)gui.getInvType(), (String)gui.getTitle());
        if (GuiInv == null) {
            return;
        }
        for (Map.Entry<Integer, CMIGuiButton> one : gui.getButtons().entrySet()) {
            if (one.getKey() > GuiInv.getSize()) continue;
            try {
                ItemStack item = one.getValue().getItem(gui.getPlayer());
                ItemStack itemStack = item = item == null ? null : item.clone();
                if (item != null && one.getValue().isLocked()) {
                    item = CMIReflections.setNbt(item, CMIGUIIcon, LIProtection);
                }
                GuiInv.setItem(one.getKey().intValue(), item);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
        }
        gui.setInv(GuiInv);
    }

    public static void openGui(CMIGui gui) {
        Player player = gui.getPlayer();
        CMIGui oldGui = null;
        if (GUIManager.isOpenedGui(player) && !gui.isSimilar(oldGui = GUIManager.getGui(player))) {
            oldGui = null;
        }
        if (oldGui == null) {
            GUIManager.generateInventory(gui);
            player.closeInventory();
            player.openInventory(gui.getInv());
            gui.onOpen();
            map.put(player.getUniqueId(), gui);
        } else {
            GUIManager.updateContent(gui);
        }
    }

    public static void updateContent(CMIGui gui) {
        Player player = gui.getPlayer();
        if (player.getOpenInventory() == null || player.getOpenInventory().getTopInventory() == null) {
            player.closeInventory();
        }
        CMIReflections.updateInventoryTitle(player, gui.getTitle());
        player.getOpenInventory().getTopInventory().setContents(gui.getInv().getContents());
        gui.setInv(player.getOpenInventory().getTopInventory());
        map.put(player.getUniqueId(), gui);
    }

    public static enum CmiInventoryType {
        regular,
        SavedInv,
        EditableInv,
        RecipeCreator,
        ArmorStandEditor,
        ArmorStandCopy,
        EntityInventoryEditor,
        Recipes,
        SellHand;

    }

    public static enum GUIButtonLocation {
        topLeft(0, 0),
        topRight(0, 1),
        bottomLeft(1, 0),
        bottomRight(1, 1);

        private Integer row;
        private Integer collumn;

        private GUIButtonLocation(Integer row, Integer collumn) {
            this.collumn = collumn;
            this.row = row;
        }

        public Integer getRow() {
            return this.row;
        }

        public Integer getCollumn() {
            return this.collumn;
        }
    }

    public static enum GUIClickType {
        Left,
        LeftShift,
        Right,
        RightShift,
        MiddleMouse;

    }

    public static enum GUIFieldType {
        Free,
        Locked;

    }

    public static enum GUIRows {
        r1(1),
        r2(2),
        r3(3),
        r4(4),
        r5(5),
        r6(6);

        private int rows;

        private GUIRows(int rows) {
            this.rows = rows;
        }

        public Integer getFields() {
            return this.rows * 9;
        }

        public Integer getRows() {
            return this.rows;
        }

        public static GUIRows getByRows(Integer rows) {
            if (rows > 9) {
                rows = rows / 9;
            }
            GUIRows[] gUIRowsArray = GUIRows.values();
            int n = gUIRowsArray.length;
            int n2 = 0;
            while (n2 < n) {
                GUIRows one = gUIRowsArray[n2];
                if (one.getRows().equals(rows)) {
                    return one;
                }
                ++n2;
            }
            return r6;
        }
    }

    public static enum InvType {
        Gui,
        Main,
        Quickbar;

    }
}

