/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.CMIGUI;

import com.bekvon.bukkit.CMIGUI.CMIGui;
import com.bekvon.bukkit.CMIGUI.GUIManager;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import com.bekvon.bukkit.residence.Residence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;

public class GUIListener
implements Listener {
    Residence plugin;
    private HashMap<UUID, Long> LastClick = new HashMap();

    public GUIListener(Residence plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onNormalInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (GUIManager.isOpenedGui(player) && GUIManager.removePlayer(player)) {
            player.updateInventory();
            this.clearIconItems(player);
        }
    }

    private void clearIconItems(Player player) {
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack one = itemStackArray[n2];
            Object res = CMIReflections.getNbt(one, "CMIGUIIcon");
            if (res != null && res instanceof String && ((String)res).equalsIgnoreCase("LIProtection")) {
                player.getInventory().remove(one);
            }
            ++n2;
        }
    }

    private boolean canClickByTimer(UUID uuid) {
        Long time = this.LastClick.get(uuid);
        if (time == null) {
            this.LastClick.put(uuid, System.currentTimeMillis());
            return true;
        }
        if (time + 51L > System.currentTimeMillis()) {
            this.LastClick.put(uuid, System.currentTimeMillis());
            return false;
        }
        this.LastClick.put(uuid, System.currentTimeMillis());
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.isCancelled() && !event.getWhoClicked().getGameMode().toString().equalsIgnoreCase("Spectator")) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!GUIManager.isOpenedGui(player)) {
            return;
        }
        CMIGui gui = GUIManager.getGui(player);
        if (event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() != -1) {
            event.setCancelled(true);
            return;
        }
        if (!gui.isAllowShift() && event.isShiftClick()) {
            event.setCancelled(true);
        }
        if (!(event.getAction().equals((Object)InventoryAction.PICKUP_ALL) || event.getAction().equals((Object)InventoryAction.PICKUP_ONE) || event.getAction().equals((Object)InventoryAction.PICKUP_HALF) || event.getAction().equals((Object)InventoryAction.PICKUP_SOME) || event.getAction().equals((Object)InventoryAction.PLACE_ALL) || event.getAction().equals((Object)InventoryAction.PLACE_ONE) || event.getAction().equals((Object)InventoryAction.PLACE_SOME) || gui.isAllowShift() || event.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY))) {
            event.setCancelled(true);
        }
        if (!gui.isAllowPickUpAll() && !this.canClickByTimer(player.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        ArrayList<Integer> buttons = new ArrayList<Integer>();
        buttons.add(event.getRawSlot());
        if (!GUIManager.canClick(player, buttons)) {
            event.setCancelled(true);
        }
        if (GUIManager.isLockedPart(player, buttons)) {
            event.setCancelled(true);
        }
        InventoryAction action = event.getAction();
        GUIManager.processClick(player, buttons, GUIManager.getClickType(event.isLeftClick(), event.isShiftClick(), action));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInventoryMove(InventoryDragEvent event) {
        if (event.isCancelled() && !event.getWhoClicked().getGameMode().toString().equalsIgnoreCase("Spectator")) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!GUIManager.isOpenedGui(player)) {
            return;
        }
        CMIGui gui = GUIManager.getGui(player);
        if (!gui.isAllowPickUpAll() && !this.canClickByTimer(player.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        ArrayList<Integer> buttons = new ArrayList<Integer>();
        buttons.addAll(event.getRawSlots());
        if (!GUIManager.canClick(player, buttons)) {
            event.setCancelled(true);
        }
        if (GUIManager.isLockedPart(player, buttons)) {
            event.setCancelled(true);
        }
        GUIManager.processClick(player, buttons, GUIManager.getClickType(true, false, null));
    }
}

