/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.CMIGUI;

import com.bekvon.bukkit.CMIGUI.CMIGui;
import com.bekvon.bukkit.CMIGUI.CommandType;
import com.bekvon.bukkit.CMIGUI.GUIButtonCommand;
import com.bekvon.bukkit.CMIGUI.GUIManager;
import com.bekvon.bukkit.cmiLib.CMIItemStack;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import com.bekvon.bukkit.residence.Residence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CMIGuiButton {
    private Integer slot = null;
    private GUIManager.GUIFieldType fieldType = GUIManager.GUIFieldType.Locked;
    private boolean closeInv = false;
    private HashMap<GUIManager.GUIClickType, List<GUIButtonCommand>> commandMap = new HashMap();
    private List<String> permissions = new ArrayList<String>();
    private ItemStack item = null;
    private int schedId = -1;
    private int updateInterval = 20;
    private int ticks = 0;
    private CMIGui sgui;

    public CMIGuiButton clone() {
        CMIGuiButton b = new CMIGuiButton(this.slot, this.fieldType, this.item);
        b.setPermissions(new ArrayList<String>(this.permissions));
        b.setCommandMap(new HashMap<GUIManager.GUIClickType, List<GUIButtonCommand>>(this.commandMap));
        return b;
    }

    public CMIGuiButton(Integer slot, GUIManager.GUIFieldType fieldType, ItemStack item) {
        this.slot = slot;
        this.fieldType = fieldType;
        this.item = item == null ? null : item.clone();
    }

    public CMIGuiButton(Integer slot) {
        this.slot = slot;
    }

    public void hideItemFlags() {
        if (this.item != null) {
            this.item = CMIReflections.HideFlag(this.item, 63);
        }
    }

    public CMIGuiButton(ItemStack item) {
        this.item = item == null ? null : item.clone();
    }

    public CMIGuiButton(CMIMaterial mat) {
        this.item = mat == null ? null : mat.newItemStack();
    }

    public CMIGuiButton(Integer slot, CMIItemStack item) {
        this(slot, item.getItemStack());
    }

    public CMIGuiButton(Integer slot, Material material2) {
        this(slot, CMIMaterial.get(material2), null);
    }

    public CMIGuiButton(Integer slot, CMIMaterial material2) {
        this(slot, material2, null);
    }

    @Deprecated
    public CMIGuiButton(Integer slot, Material material2, int data) {
        this(slot, material2, data, null);
    }

    public CMIGuiButton(Integer slot, Material material2, String name) {
        this(slot, CMIMaterial.get(material2), name);
    }

    public CMIGuiButton(Integer slot, CMIMaterial material2, String name) {
        this.slot = slot;
        ItemStack itemStack = this.item = material2 == null ? null : material2.newItemStack();
        if (name != null) {
            ItemMeta meta = this.item.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            this.item.setItemMeta(meta);
        }
    }

    @Deprecated
    public CMIGuiButton(Integer slot, Material material2, int data, String name) {
        this.slot = slot;
        this.item = new ItemStack(material2, 1, (short)data);
        if (name != null) {
            ItemMeta meta = this.item.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            this.item.setItemMeta(meta);
        }
    }

    public CMIGuiButton(Integer slot, ItemStack item) {
        CMIMaterial d;
        this.slot = slot;
        ItemStack itemStack = this.item = item == null ? null : item.clone();
        if (this.item != null && this.item.getDurability() == Short.MAX_VALUE && (d = CMIMaterial.getRandom(CMIMaterial.get(this.item))) != null && d.getLegacyData() != -1) {
            this.item.setDurability(d.getLegacyData());
        }
    }

    public void setGui(CMIGui sgui) {
        this.sgui = sgui;
    }

    public void startAutoUpdate(int intervalTicks) {
        this.updateInterval = intervalTicks;
        this.tasker();
    }

    @Deprecated
    public void startAutoUpdate(CMIGui sgui, int intervalTicks) {
        this.updateInterval = intervalTicks;
        this.sgui = sgui;
        this.tasker();
    }

    private void tasker() {
        if (this.schedId != -1) {
            Bukkit.getScheduler().cancelTask(this.schedId);
            this.schedId = -1;
        }
        final CMIGuiButton b = this;
        this.schedId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Residence.getInstance(), new Runnable(){

            @Override
            public void run() {
                CMIGuiButton cMIGuiButton = CMIGuiButton.this;
                cMIGuiButton.ticks = cMIGuiButton.ticks + 1;
                if (CMIGuiButton.this.sgui != null && GUIManager.getGui(CMIGuiButton.this.sgui.getPlayer()) != CMIGuiButton.this.sgui && CMIGuiButton.this.schedId != -1) {
                    Bukkit.getScheduler().cancelTask(CMIGuiButton.this.schedId);
                    CMIGuiButton.this.schedId = -1;
                    return;
                }
                CMIGuiButton.this.updateLooks();
                CMIGuiButton.this.update(CMIGuiButton.this.sgui);
                if (CMIGuiButton.this.sgui != null) {
                    CMIGuiButton.this.sgui.updateButton(b);
                }
            }
        }, 20L, (long)this.updateInterval);
    }

    public void updateLooks() {
    }

    public void update() {
        if (this.sgui != null) {
            this.sgui.updateButton(this);
        }
    }

    public void update(CMIGui gui) {
        if (gui != null) {
            gui.updateButton(this);
        }
    }

    public Integer getSlot() {
        return this.slot;
    }

    public CMIGuiButton setSlot(Integer slot) {
        this.slot = slot;
        return this;
    }

    public GUIManager.GUIFieldType getFieldType() {
        return this.fieldType;
    }

    public CMIGuiButton setFieldType(GUIManager.GUIFieldType fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public CMIGuiButton lockField() {
        this.fieldType = GUIManager.GUIFieldType.Locked;
        return this;
    }

    public CMIGuiButton unlockField() {
        this.fieldType = GUIManager.GUIFieldType.Free;
        return this;
    }

    public boolean isLocked() {
        return this.fieldType.equals((Object)GUIManager.GUIFieldType.Locked);
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public CMIGuiButton addPermission(String perm) {
        this.permissions.add(perm);
        return this;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public List<GUIButtonCommand> getCommands(GUIManager.GUIClickType type) {
        List<GUIButtonCommand> list2 = this.commandMap.get((Object)type);
        if (list2 == null) {
            list2 = new ArrayList<GUIButtonCommand>();
        }
        return list2;
    }

    public CMIGuiButton setName(String name) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public CMIGuiButton addLore(List<String> l) {
        l = this.spreadList(l);
        for (String one : l) {
            this.addLore(one);
        }
        return this;
    }

    public List<String> spreadList(List<String> ls) {
        ArrayList<String> s = new ArrayList<String>();
        int i = 0;
        while (i < ls.size()) {
            if (ls.get(i).contains(" \\n")) {
                s.addAll(Arrays.asList(ls.get(i).split(" \\\\n")));
            } else if (ls.get(i).contains(" \n")) {
                s.addAll(Arrays.asList(ls.get(i).split(" \\n")));
            } else {
                s.add(ls.get(i));
            }
            ++i;
        }
        return s;
    }

    public CMIGuiButton addLore(String l) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            ArrayList<String> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            if (l.contains("\\n")) {
                String[] split;
                String[] stringArray = split = l.split("\\\\n");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String one = stringArray[n2];
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)one));
                    ++n2;
                }
            } else if (l.contains("\n")) {
                String[] split;
                String[] stringArray = split = l.split("\\n");
                int n = split.length;
                int n3 = 0;
                while (n3 < n) {
                    String one = stringArray[n3];
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)one));
                    ++n3;
                }
            } else {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)l));
            }
            meta.setLore(lore);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public CMIGuiButton clearLore() {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.setLore(new ArrayList());
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public CMIGuiButton addItemName(String name) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        this.item.setItemMeta(meta);
        return this;
    }

    public CMIGuiButton addCommand(String command2) {
        return this.addCommand(null, command2);
    }

    public CMIGuiButton addCommand(String command2, CommandType vis) {
        return this.addCommand(null, command2, vis);
    }

    public CMIGuiButton addCommand(GUIManager.GUIClickType type, String command2) {
        return this.addCommand(type, command2, CommandType.gui);
    }

    public CMIGuiButton addCommand(GUIManager.GUIClickType type, String command2, CommandType vis) {
        if (type == null) {
            GUIManager.GUIClickType[] gUIClickTypeArray = GUIManager.GUIClickType.values();
            int n = gUIClickTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GUIManager.GUIClickType one = gUIClickTypeArray[n2];
                List<GUIButtonCommand> list2 = this.commandMap.get((Object)one);
                if (list2 == null) {
                    list2 = new ArrayList<GUIButtonCommand>();
                }
                list2.add(new GUIButtonCommand(command2, vis));
                this.commandMap.put(one, list2);
                ++n2;
            }
        } else {
            List<GUIButtonCommand> list3 = this.commandMap.get((Object)type);
            if (list3 == null) {
                list3 = new ArrayList<GUIButtonCommand>();
            }
            list3.add(new GUIButtonCommand(command2, vis));
            this.commandMap.put(type, list3);
        }
        return this;
    }

    public void click() {
    }

    public void click(GUIManager.GUIClickType type) {
    }

    public CMIGuiButton addCommand(Location loc) {
        if (loc == null) {
            return this;
        }
        this.addCommand("cmi tppos " + loc.getWorld().getName() + " " + loc.getX() + " " + loc.getY() + " " + loc.getBlockZ() + " " + loc.getPitch() + " " + loc.getYaw());
        return this;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getItem(Player player) {
        if (this.item != null) {
            ItemMeta meta;
            ItemStack i = this.item.clone();
            if (this.isLocked()) {
                i = CMIReflections.setNbt(i, "CMIGUIIcon", "LIProtection");
            }
            ItemMeta itemMeta = meta = i.hasItemMeta() ? i.getItemMeta() : null;
            if (meta != null) {
                i.setItemMeta(meta);
            }
            return i;
        }
        return this.item;
    }

    public CMIGuiButton setItem(ItemStack item) {
        this.item = item == null ? null : item.clone();
        return this;
    }

    public void setCommandMap(HashMap<GUIManager.GUIClickType, List<GUIButtonCommand>> commandMap) {
        this.commandMap = commandMap;
    }

    public boolean isCloseInv() {
        return this.closeInv;
    }

    public void setCloseInv(boolean closeInv) {
        this.closeInv = closeInv;
    }

    public CMIGui getGui() {
        return this.sgui;
    }

    public int getTicks() {
        return this.ticks;
    }
}

