/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.CMIGUI;

import com.bekvon.bukkit.CMIGUI.CMIGuiButton;
import com.bekvon.bukkit.CMIGUI.GUIManager;
import com.bekvon.bukkit.cmiLib.CMIMaterial;
import com.bekvon.bukkit.cmiLib.CMIReflections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CMIGui {
    private InventoryType invType;
    private GUIManager.GUIRows gUIRows;
    private Player player;
    private Inventory inv;
    private String title;
    private HashMap<Integer, CMIGuiButton> buttons = new HashMap();
    private LinkedHashSet<CMIGuiButton> noSlotButtons = new LinkedHashSet();
    private HashMap<GUIManager.InvType, GUIManager.GUIFieldType> lock = new HashMap();
    private HashMap<GUIManager.InvType, String> permLock = new HashMap();
    private GUIManager.CmiInventoryType type = GUIManager.CmiInventoryType.regular;
    private Object whatShows;
    private Object tempData;
    private boolean allowShift = false;
    private boolean allowPickUpAll = false;

    public CMIGui(Player player) {
        this.player = player;
    }

    public CMIGui clone() {
        CMIGui g = new CMIGui(this.player);
        g.setInvSize(this.gUIRows);
        g.setButtons(this.buttons);
        g.setInv(this.inv);
        g.setInvType(this.invType);
        g.setTitle(this.title);
        g.setCmiInventoryType(this.type);
        g.setWhatShows(this.whatShows);
        return g;
    }

    public boolean isOpened() {
        return GUIManager.isOpenedGui(this.getPlayer());
    }

    public boolean isSimilar(CMIGui gui) {
        if (this.getInvSize() != gui.getInvSize()) {
            return false;
        }
        return this.getInvType() == gui.getInvType();
    }

    public CMIGui open() {
        GUIManager.openGui(this);
        return this;
    }

    public void outsideClick(GUIManager.GUIClickType type) {
    }

    public InventoryType getInvType() {
        if (this.invType == null) {
            this.invType = InventoryType.CHEST;
        }
        return this.invType;
    }

    public void setInvType(InventoryType invType) {
        this.invType = invType;
    }

    public GUIManager.GUIRows getInvSize() {
        if (this.gUIRows == null) {
            this.autoResize();
        }
        return this.gUIRows;
    }

    public void setInvSize(GUIManager.GUIRows GUIRows2) {
        this.gUIRows = GUIRows2;
    }

    public void setInvSize(int rows) {
        this.gUIRows = GUIManager.GUIRows.getByRows(rows);
    }

    public void autoResize() {
        this.combineButtons();
        int max = 0;
        for (Map.Entry<Integer, CMIGuiButton> one : this.buttons.entrySet()) {
            if (one.getKey() <= max) continue;
            max = one.getKey();
        }
        this.gUIRows = max < 9 ? GUIManager.GUIRows.r1 : (max < 18 ? GUIManager.GUIRows.r2 : (max < 27 ? GUIManager.GUIRows.r3 : (max < 36 ? GUIManager.GUIRows.r4 : (max < 45 ? GUIManager.GUIRows.r5 : GUIManager.GUIRows.r6))));
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public Inventory getInv() {
        if (this.inv == null) {
            GUIManager.generateInventory(this);
        }
        return this.inv;
    }

    public void setInv(Inventory inv) {
        this.inv = inv;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.title);
    }

    public void updateTitle(String title) {
        this.setTitle(title);
        CMIReflections.updateInventoryTitle(this.player, this.title);
    }

    public void setTitle(String title) {
        if (title.length() > 32) {
            title = String.valueOf(title.substring(0, 31)) + "~";
        }
        this.title = title;
    }

    public HashMap<Integer, CMIGuiButton> getButtons() {
        this.combineButtons();
        return this.buttons;
    }

    public void clearButtons() {
        for (Map.Entry<Integer, CMIGuiButton> one : this.getButtons().entrySet()) {
            this.inv.setItem(one.getKey().intValue(), null);
        }
        if (this.inv != null) {
            this.inv.clear();
        }
        this.buttons.clear();
        this.noSlotButtons.clear();
    }

    public CMIGui replaceButton(CMIGuiButton button) {
        button.updateLooks();
        if (button.getSlot() != null) {
            this.buttons.remove(button.getSlot());
        }
        if (this.getInv() != null) {
            this.getInv().setItem(button.getSlot().intValue(), button.getItem(this.getPlayer()));
        }
        return this.addButton(button, 54);
    }

    public CMIGui addButton(CMIGuiButton button) {
        button.updateLooks();
        return this.addButton(button, 54);
    }

    public CMIGui addButton(CMIGuiButton button, int maxSlot) {
        button.setGui(this);
        if (button.getSlot() != null && this.buttons.get(button.getSlot()) != null) {
            int ii = button.getSlot();
            while (ii < maxSlot) {
                CMIGuiButton b = this.buttons.get(ii);
                if (b == null) {
                    this.buttons.put(ii, button);
                    break;
                }
                ++ii;
            }
            return this;
        }
        if (button.getSlot() == null) {
            this.noSlotButtons.add(button);
            return this;
        }
        this.buttons.put(button.getSlot(), button);
        return this;
    }

    private void combineButtons() {
        block0: for (CMIGuiButton button : this.noSlotButtons) {
            int ii = 0;
            while (ii < 54) {
                CMIGuiButton b = this.buttons.get(ii);
                if (b == null) {
                    this.buttons.put(ii, button);
                    continue block0;
                }
                ++ii;
            }
        }
        this.noSlotButtons.clear();
    }

    public void fillEmptyButtons() {
        this.fillEmptyButtons(null);
    }

    public void fillEmptyButtons(ItemStack item) {
        this.combineButtons();
        int i = 0;
        while (i < this.getInvSize().getFields()) {
            if (!this.buttons.containsKey(i)) {
                this.addEmptyButton(item, i);
            }
            ++i;
        }
    }

    public void updateButton(CMIGuiButton button) {
        if (this.inv == null || button.getSlot() == null || this.inv.getSize() < button.getSlot()) {
            return;
        }
        this.inv.setItem(button.getSlot().intValue(), button.getItem(this.getPlayer()));
        this.buttons.put(button.getSlot(), button);
    }

    public void addEmptyButton(int slot) {
        this.addEmptyButton(null, slot);
    }

    public void addEmptyButton(ItemStack item, int slot) {
        ItemStack MiscInfo = item == null ? CMIMaterial.BLACK_STAINED_GLASS_PANE.newItemStack() : item.clone();
        ItemMeta MiscInfoMeta = MiscInfo.getItemMeta();
        MiscInfoMeta.setDisplayName(" ");
        MiscInfo.setItemMeta(MiscInfoMeta);
        CMIGuiButton button = new CMIGuiButton((Integer)slot, GUIManager.GUIFieldType.Locked, MiscInfo);
        this.addButton(button);
        this.updateButton(button);
    }

    public void setButtons(HashMap<Integer, CMIGuiButton> buttons) {
        this.buttons = buttons;
    }

    public boolean isLocked(GUIManager.InvType type) {
        return this.lock.containsKey((Object)type) ? this.lock.get((Object)type) == GUIManager.GUIFieldType.Locked : false;
    }

    public void addLock(GUIManager.InvType type) {
        this.addLock(type, GUIManager.GUIFieldType.Locked);
    }

    public void addLock(GUIManager.InvType type, GUIManager.GUIFieldType lock) {
        this.lock.put(type, lock);
    }

    public boolean isPermLocked(GUIManager.InvType type) {
        return this.permLock.containsKey((Object)type) ? !this.player.hasPermission(this.permLock.get((Object)type)) : true;
    }

    public void addPermLock(GUIManager.InvType type, String perm) {
        this.permLock.put(type, perm);
    }

    public GUIManager.CmiInventoryType getType() {
        return this.type;
    }

    public void setCmiInventoryType(GUIManager.CmiInventoryType type) {
        this.type = type;
    }

    public Object getWhatShows() {
        return this.whatShows;
    }

    public void setWhatShows(Object whatShows) {
        this.whatShows = whatShows;
    }

    public Integer getSlot(GUIManager.GUIButtonLocation place) {
        GUIManager.GUIRows size = this.getInvSize();
        int v = place.getCollumn() * 9;
        v = place.getCollumn() > 0 ? v - 1 : v;
        Integer value = place.getRow() * size.getRows() * 9 - 8 + v;
        value = place.getRow() > 0 ? value : value + 9;
        return value - 1;
    }

    public void onClose() {
    }

    public void onOpen() {
    }

    public void processClose() {
    }

    public boolean isAllowShift() {
        return this.allowShift;
    }

    public void setAllowShift(boolean allowShift) {
        this.allowShift = allowShift;
    }

    public Object getTempData() {
        return this.tempData;
    }

    public void setTempData(Object tempData) {
        this.tempData = tempData;
    }

    public boolean isAllowPickUpAll() {
        return this.allowPickUpAll;
    }

    public void setAllowPickUpAll(boolean allowPickUpAll) {
        this.allowPickUpAll = allowPickUpAll;
    }
}

