/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.server;

import java.net.InetAddress;
import java.util.Iterator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.apache.commons.lang.Validate;
import org.bukkit.UndefinedNullability;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.server.ServerEvent;
import org.bukkit.util.CachedServerIcon;
import org.jetbrains.annotations.NotNull;

public class ServerListPingEvent
extends ServerEvent
implements Iterable<Player> {
    private static final int MAGIC_PLAYER_COUNT = Integer.MIN_VALUE;
    private static final HandlerList handlers = new HandlerList();
    private final InetAddress address;
    private Component motd;
    private final int numPlayers;
    private int maxPlayers;

    @Deprecated
    public ServerListPingEvent(@NotNull InetAddress address, @NotNull String motd, int numPlayers, int maxPlayers) {
        super(true);
        Validate.isTrue((numPlayers >= 0 ? 1 : 0) != 0, (String)"Cannot have negative number of players online", (long)numPlayers);
        this.address = address;
        this.motd = LegacyComponentSerializer.legacySection().deserialize(motd);
        this.numPlayers = numPlayers;
        this.maxPlayers = maxPlayers;
    }

    @Deprecated
    protected ServerListPingEvent(@NotNull InetAddress address, @NotNull String motd, int maxPlayers) {
        super(true);
        this.numPlayers = Integer.MIN_VALUE;
        this.address = address;
        this.motd = LegacyComponentSerializer.legacySection().deserialize(motd);
        this.maxPlayers = maxPlayers;
    }

    public ServerListPingEvent(@NotNull InetAddress address, @NotNull Component motd, int numPlayers, int maxPlayers) {
        super(true);
        Validate.isTrue((numPlayers >= 0 ? 1 : 0) != 0, (String)"Cannot have negative number of players online", (long)numPlayers);
        this.address = address;
        this.motd = motd;
        this.numPlayers = numPlayers;
        this.maxPlayers = maxPlayers;
    }

    protected ServerListPingEvent(@NotNull InetAddress address, @NotNull Component motd, int maxPlayers) {
        super(true);
        this.numPlayers = Integer.MIN_VALUE;
        this.address = address;
        this.motd = motd;
        this.maxPlayers = maxPlayers;
    }

    @NotNull
    public Component motd() {
        return this.motd;
    }

    public void motd(@NotNull Component motd) {
        this.motd = motd;
    }

    @NotNull
    public InetAddress getAddress() {
        return this.address;
    }

    @Deprecated
    @NotNull
    public String getMotd() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    @Deprecated
    public void setMotd(@NotNull String motd) {
        this.motd = LegacyComponentSerializer.legacySection().deserialize(motd);
    }

    public int getNumPlayers() {
        int numPlayers = this.numPlayers;
        if (numPlayers == Integer.MIN_VALUE) {
            numPlayers = 0;
            for (Player player : this) {
                ++numPlayers;
            }
        }
        return numPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setServerIcon(@UndefinedNullability(value="implementation dependent") CachedServerIcon icon) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    @NotNull
    public Iterator<Player> iterator() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

