/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.queues.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.scheduling.RepeatingSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.Schedulable;

public class TimedQueue
extends ScriptQueue {
    private Schedulable schedulable;
    private long ticks;
    protected boolean paused = false;
    public DelayTracker delay;

    public void delayFor(DurationTag duration) {
        this.delay = new DeltaTimeDelayTracker(duration.getMillis());
    }

    public boolean isDelayed() {
        return this.delay != null && this.delay.isDelayed();
    }

    public TimedQueue(String id) {
        this(id, DurationTag.valueOf(DenizenCore.getImplementation().scriptQueueSpeed(), CoreUtilities.basicContext));
    }

    public TimedQueue(String id, long ticks) {
        super(id);
        this.ticks = ticks;
    }

    public TimedQueue(String id, DurationTag timing) {
        super(id);
        this.ticks = timing.getTicks();
    }

    public boolean isInstantSpeed() {
        return this.ticks <= 0L;
    }

    public DurationTag getSpeed() {
        return new DurationTag(this.ticks);
    }

    public TimedQueue setPaused(boolean paused) {
        this.paused = paused;
        return this;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public TimedQueue setSpeed(long ticks) {
        this.ticks = ticks;
        return this;
    }

    @Override
    public void onStart() {
        this.revolve();
        if (this.script_entries.isEmpty()) {
            return;
        }
        if (this.schedulable == null) {
            RepeatingSchedulable schedulable = new RepeatingSchedulable(this::revolve, (float)(this.ticks <= 0L ? 1L : this.ticks) / 20.0f);
            this.schedulable = schedulable;
            DenizenCore.schedule(schedulable);
        }
    }

    @Override
    public String getName() {
        return "TimedQueue";
    }

    @Override
    protected void onStop() {
        if (this.schedulable != null) {
            this.schedulable.cancel();
            this.schedulable = null;
        }
    }

    @Override
    public boolean shouldRevolve() {
        if (this.paused) {
            return false;
        }
        return !this.isDelayed();
    }

    public static class DeltaTimeDelayTracker
    implements DelayTracker {
        public long serverTimeEnd;

        public DeltaTimeDelayTracker(long millis) {
            this.serverTimeEnd = DenizenCore.serverTimeMillis + millis;
        }

        @Override
        public boolean isDelayed() {
            return this.serverTimeEnd > DenizenCore.serverTimeMillis;
        }
    }

    @FunctionalInterface
    public static interface DelayTracker {
        public boolean isDelayed();
    }
}

