/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class Comparable {
    public Logic logic = Logic.REGULAR;
    public Object comparable = null;
    public Operator operator = Operator.EQUALS;
    public Object comparedto = "true";
    public Boolean outcome = null;
    public TagContext context = null;

    public void setNegativeLogic() {
        this.logic = Logic.NEGATIVE;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public void setComparable(String arg) {
        this.comparable = arg.length() == 0 ? arg : (ArgumentHelper.matchesDouble(arg) ? Double.valueOf(Double.parseDouble(arg)) : (ListTag.matches(arg) ? ListTag.valueOf(arg, this.context) : arg));
    }

    public void setComparedto(String arg) {
        if (this.operator == Operator.MATCHES) {
            this.comparable = String.valueOf(this.comparable);
        }
        if (this.comparable instanceof String) {
            this.comparedto = arg;
        } else if (this.comparable instanceof Double || this.comparable instanceof Long) {
            if (ArgumentHelper.matchesDouble(arg)) {
                this.comparedto = Double.parseDouble(arg);
            } else {
                this.comparable = String.valueOf(this.comparable);
                this.comparedto = arg;
            }
        } else {
            this.comparedto = this.comparable instanceof Boolean ? Boolean.valueOf(CoreUtilities.equalsIgnoreCase(arg, "true")) : (this.comparable instanceof ListTag ? (ListTag.matches(arg) ? ListTag.valueOf(arg, this.context) : arg) : arg);
        }
    }

    public boolean determineOutcome() {
        this.outcome = false;
        if (this.comparable instanceof String) {
            this.compare_as_strings();
        } else if (this.comparable instanceof ListTag) {
            this.compare_as_list();
        } else if (this.comparable instanceof Double || this.comparable instanceof Long) {
            if (this.comparedto instanceof Double || this.comparedto instanceof Long) {
                this.compare_as_numbers();
            }
        } else if (this.comparable instanceof Boolean && this.comparedto instanceof Boolean) {
            this.outcome = this.comparable.equals(this.comparedto);
        }
        if (this.logic == Logic.NEGATIVE) {
            this.outcome = this.outcome == false;
        }
        return this.outcome;
    }

    private void compare_as_numbers() {
        this.outcome = false;
        Double comparable = this.comparable instanceof Double ? (Double)this.comparable : Double.valueOf(((Long)this.comparable).doubleValue());
        Double comparedto = this.comparedto instanceof Double ? (Double)this.comparedto : Double.valueOf(((Long)this.comparedto).doubleValue());
        switch (this.operator) {
            case EQUALS: {
                if (comparable.doubleValue() != comparedto.doubleValue()) break;
                this.outcome = true;
                break;
            }
            case OR_MORE: {
                if (comparable.compareTo(comparedto) < 0) break;
                this.outcome = true;
                break;
            }
            case OR_LESS: {
                if (comparable.compareTo(comparedto) > 0) break;
                this.outcome = true;
                break;
            }
            case MORE: {
                if (comparable.compareTo(comparedto) <= 0) break;
                this.outcome = true;
                break;
            }
            case LESS: {
                if (comparable.compareTo(comparedto) >= 0) break;
                this.outcome = true;
            }
        }
    }

    private void compare_as_list() {
        this.outcome = false;
        ListTag comparable = (ListTag)this.comparable;
        block0 : switch (this.operator) {
            case CONTAINS: {
                for (String string : comparable) {
                    if (this.comparedto instanceof Long) {
                        if (!ArgumentHelper.matchesInteger(string) || Long.parseLong(string) != (Long)this.comparedto) continue;
                        this.outcome = true;
                        break block0;
                    }
                    if (this.comparedto instanceof Double) {
                        if (!ArgumentHelper.matchesDouble(string) || Double.parseDouble(string) != (Double)this.comparedto) continue;
                        this.outcome = true;
                        break block0;
                    }
                    if (!(this.comparedto instanceof String) || !CoreUtilities.equalsIgnoreCase(string, (String)this.comparedto)) continue;
                    this.outcome = true;
                    break block0;
                }
                break;
            }
            case OR_MORE: {
                if (!(this.comparedto instanceof Double)) break;
                this.outcome = comparable.size() >= ((Double)this.comparedto).intValue();
                break;
            }
            case OR_LESS: {
                if (!(this.comparedto instanceof Double)) break;
                this.outcome = comparable.size() <= ((Double)this.comparedto).intValue();
                break;
            }
            case MORE: {
                if (!(this.comparedto instanceof Double)) break;
                this.outcome = comparable.size() > ((Double)this.comparedto).intValue();
                break;
            }
            case LESS: {
                if (!(this.comparedto instanceof Double)) break;
                this.outcome = comparable.size() < ((Double)this.comparedto).intValue();
                break;
            }
            case EQUALS: {
                if (!(this.comparedto instanceof ListTag)) break;
                ListTag list2 = (ListTag)this.comparedto;
                this.outcome = CoreUtilities.equalsIgnoreCase(list2.identify(), comparable.identify());
            }
        }
    }

    private void compare_as_strings() {
        this.outcome = false;
        String comparable = String.valueOf(this.comparable);
        String comparedto = String.valueOf(this.comparedto);
        if (comparable == null || comparedto == null) {
            return;
        }
        switch (this.operator) {
            case IS_EMPTY: {
                Deprecations.oldMatchesOperator.warn();
                this.outcome = comparable.length() == 0;
                break;
            }
            case EQUALS: {
                this.outcome = CoreUtilities.equalsIgnoreCase(comparable, comparedto);
                break;
            }
            case CONTAINS: {
                Deprecations.oldMatchesOperator.warn();
                this.outcome = CoreUtilities.toLowerCase(comparable).contains(CoreUtilities.toLowerCase(comparedto));
                break;
            }
            case OR_MORE: 
            case OR_LESS: 
            case MORE: 
            case LESS: {
                Debug.echoError("Comparing text as if it were a number - comparison automatically false");
                this.outcome = false;
                break;
            }
            case MATCHES: {
                Deprecations.oldMatchesOperator.warn();
                comparedto = comparedto.replace("_", "");
                this.outcome = comparedto.equalsIgnoreCase("script") ? Boolean.valueOf(ScriptTag.matches(comparable)) : (comparedto.equalsIgnoreCase("duration") ? Boolean.valueOf(DurationTag.matches(comparable)) : (comparedto.equalsIgnoreCase("double") || comparedto.equalsIgnoreCase("decimal") ? Boolean.valueOf(ArgumentHelper.matchesDouble(comparable)) : (comparedto.equalsIgnoreCase("integer") || comparedto.equalsIgnoreCase("number") ? Boolean.valueOf(ArgumentHelper.matchesInteger(comparable)) : (comparedto.equalsIgnoreCase("even integer") || comparedto.equalsIgnoreCase("even number") ? Boolean.valueOf(ArgumentHelper.matchesInteger(comparable) && Long.parseLong(comparable) % 2L == 0L) : (comparedto.equalsIgnoreCase("odd integer") || comparedto.equalsIgnoreCase("odd number") ? Boolean.valueOf(ArgumentHelper.matchesInteger(comparable) && Long.parseLong(comparable) % 2L == 1L) : (comparedto.equalsIgnoreCase("boolean") ? Boolean.valueOf(comparable.equalsIgnoreCase("true") || comparable.equalsIgnoreCase("false")) : Boolean.valueOf(DenizenCore.getImplementation().matchesType(comparable, comparedto))))))));
            }
        }
    }

    public String log(String str) {
        Debug.echoError("Warning: Unknown comparable type: " + str);
        return str;
    }

    public String toString() {
        return (this.logic != Logic.REGULAR ? "<G>Logic='<A>" + this.logic.toString() + "<G>', " : "") + "<G>Comparable='" + (this.comparable == null ? "null'" : (this.comparable instanceof Double ? "Decimal" : (this.comparable instanceof String ? "Element" : (this.comparable instanceof Long ? "Number" : (this.comparable instanceof ListTag ? "ListTag" : this.log(this.comparable.getClass().getSimpleName()))))) + "<G>(<A>" + this.comparable + "<G>)'") + "<G>, Operator='<A>" + this.operator.toString() + "<G>', ComparedTo='" + (this.comparedto == null ? "null'" : (this.comparedto instanceof Double ? "Decimal" : (this.comparedto instanceof String ? "Element" : (this.comparedto instanceof Long ? "Number" : (this.comparedto instanceof ListTag ? "ListTag" : this.log(this.comparedto.getClass().getSimpleName()))))) + "<G>(<A>" + this.comparedto + "<G>)' ") + "<Y>--> OUTCOME='" + this.outcome + "'";
    }

    public static enum Logic {
        REGULAR,
        NEGATIVE;

    }

    public static enum Operator {
        EQUALS,
        MATCHES,
        OR_MORE,
        OR_LESS,
        MORE,
        LESS,
        CONTAINS,
        IS_EMPTY;

    }
}

