/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.packets;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.player.PlayerHoldsShieldEvent;
import com.denizenscript.denizen.events.player.PlayerReceivesMessageScriptEvent;
import com.denizenscript.denizen.events.player.PlayerSteersEntityScriptEvent;
import com.denizenscript.denizen.events.player.ResourcePackStatusScriptEvent;
import com.denizenscript.denizen.nms.interfaces.packets.PacketInResourcePackStatus;
import com.denizenscript.denizen.nms.interfaces.packets.PacketInSteerVehicle;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutChat;
import com.denizenscript.denizen.nms.interfaces.packets.PacketOutEntityMetadata;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.GlowCommand;
import com.denizenscript.denizen.scripts.commands.server.ExecuteCommand;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.implementation.DenizenCoreImplementation;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DenizenPacketHandler {
    public static DenizenPacketHandler instance;
    public static HashSet<UUID> forceNoclip;

    public void receivePacket(Player player, PacketInResourcePackStatus resourcePackStatus) {
        if (!ResourcePackStatusScriptEvent.instance.enabled) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), () -> {
            ResourcePackStatusScriptEvent event = ResourcePackStatusScriptEvent.instance;
            event.status = new ElementTag(resourcePackStatus.getStatus());
            event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
            event.fire();
        });
    }

    public boolean receivePacket(Player player, PacketInSteerVehicle steerVehicle) {
        if (PlayerSteersEntityScriptEvent.instance.enabled) {
            Future future = Bukkit.getScheduler().callSyncMethod((Plugin)Denizen.getInstance(), () -> {
                PlayerSteersEntityScriptEvent event = PlayerSteersEntityScriptEvent.instance;
                event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
                event.entity = player.isInsideVehicle() ? new EntityTag(player.getVehicle()) : null;
                event.sideways = new ElementTag(steerVehicle.getLeftwardInput());
                event.forward = new ElementTag(steerVehicle.getForwardInput());
                event.jump = new ElementTag(steerVehicle.getJumpInput());
                event.dismount = new ElementTag(steerVehicle.getDismountInput());
                event.cancelled = false;
                event.modifyCancellation = c -> {
                    event.cancelled = c;
                };
                event.fire();
                return event.cancelled;
            });
            try {
                return (Boolean)future.get();
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
        return false;
    }

    public static boolean isHoldingShield(Player player) {
        return player.getEquipment().getItemInMainHand().getType() == Material.SHIELD || player.getEquipment().getItemInOffHand().getType() == Material.SHIELD;
    }

    public void receivePlacePacket(Player player) {
        if (!PlayerHoldsShieldEvent.instance.enabled) {
            return;
        }
        if (DenizenPacketHandler.isHoldingShield(player)) {
            Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), () -> PlayerHoldsShieldEvent.signalDidRaise(player));
        }
    }

    public void receiveDigPacket(Player player) {
        if (!PlayerHoldsShieldEvent.instance.enabled) {
            return;
        }
        if (DenizenPacketHandler.isHoldingShield(player)) {
            Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), () -> PlayerHoldsShieldEvent.signalDidLower(player));
        }
    }

    public boolean shouldInterceptChatPacket() {
        return !ExecuteCommand.silencedPlayers.isEmpty() || PlayerReceivesMessageScriptEvent.instance.loaded;
    }

    public boolean sendPacket(Player player, PacketOutChat chat) {
        if (ExecuteCommand.silencedPlayers.contains(player.getUniqueId())) {
            return true;
        }
        if (chat.getMessage() == null) {
            return false;
        }
        PlayerReceivesMessageScriptEvent event = PlayerReceivesMessageScriptEvent.instance;
        if (event.loaded) {
            Callable<Boolean> eventCall = () -> {
                int pos = chat.getPosition();
                if (pos != 2) {
                    event.message = new ElementTag(chat.getMessage());
                    event.rawJson = new ElementTag(chat.getRawJson());
                    event.system = new ElementTag(pos == 1);
                    event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player);
                    event.modifyMessage = chat::setMessage;
                    event.modifyRawJson = chat::setRawJson;
                    event.cancelled = false;
                    event.modifyCancellation = c -> {
                        event.cancelled = c;
                    };
                    event.fire();
                    return event.cancelled;
                }
                return false;
            };
            try {
                if (DenizenCoreImplementation.isSafeThread()) {
                    return eventCall.call();
                }
                FutureTask<Boolean> futureTask = new FutureTask<Boolean>(eventCall);
                Bukkit.getScheduler().runTask((Plugin)Denizen.getInstance(), futureTask);
                return futureTask.get();
            }
            catch (Exception e) {
                Debug.echoError(e);
                return false;
            }
        }
        return false;
    }

    public boolean shouldInterceptMetadata() {
        return !GlowCommand.glowViewers.isEmpty();
    }

    public boolean sendPacket(Player player, PacketOutEntityMetadata entityMetadata) {
        HashSet<UUID> players = GlowCommand.glowViewers.get(entityMetadata.getEntityId());
        return players != null && entityMetadata.checkForGlow() && !players.contains(player.getUniqueId());
    }

    static {
        forceNoclip = new HashSet();
    }
}

