/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.blocks.FullBlockData;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Jukebox;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.inventory.InventoryHolder;

public class CopyBlockCommand
extends AbstractCommand {
    public CopyBlockCommand() {
        this.setName("copyblock");
        this.setSyntax("copyblock [<location>] [to:<location>] (remove_original)");
        this.setRequiredArguments(2, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (arg.matchesArgumentType(LocationTag.class) && !scriptEntry.hasObject("location") && !arg.matchesPrefix("t", "to")) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (arg.matchesArgumentType(LocationTag.class) && arg.matchesPrefix("t", "to")) {
                scriptEntry.addObject("destination", arg.asType(LocationTag.class));
                continue;
            }
            if (arg.matches("remove_original")) {
                scriptEntry.addObject("remove", new ElementTag(true));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a source location.");
        }
        if (!scriptEntry.hasObject("destination")) {
            throw new InvalidArgumentsException("Must specify a destination location.");
        }
        scriptEntry.defaultObject("remove", new ElementTag(false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag copy_location = (LocationTag)scriptEntry.getObjectTag("location");
        LocationTag destination = (LocationTag)scriptEntry.getObjectTag("destination");
        ElementTag remove_original = scriptEntry.getElement("remove");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), (copy_location != null ? copy_location.debug() : "") + destination.debug() + remove_original.debug());
        }
        ArrayList<LocationTag> locations = new ArrayList<LocationTag>();
        if (copy_location != null) {
            locations.add(copy_location);
        }
        for (Location location : locations) {
            Block source = location.getBlock();
            BlockState sourceState = source.getState();
            Block update = destination.getBlock();
            FullBlockData block = new FullBlockData(source);
            block.set(update, false);
            BlockState updateState = update.getState();
            if (sourceState instanceof InventoryHolder) {
                ((InventoryHolder)updateState).getInventory().setContents(((InventoryHolder)sourceState).getInventory().getContents());
            } else if (sourceState instanceof Sign) {
                int n = 0;
                for (String line : ((Sign)sourceState).getLines()) {
                    ((Sign)updateState).setLine(n, line);
                    ++n;
                }
            } else if (sourceState instanceof Skull) {
                ((Skull)updateState).setSkullType(((Skull)sourceState).getSkullType());
                ((Skull)updateState).setOwner(((Skull)sourceState).getOwner());
                ((Skull)updateState).setRotation(((Skull)sourceState).getRotation());
            } else if (sourceState instanceof Jukebox) {
                ((Jukebox)updateState).setPlaying(((Jukebox)sourceState).getPlaying());
            } else if (sourceState instanceof Banner) {
                ((Banner)updateState).setBaseColor(((Banner)sourceState).getBaseColor());
                ((Banner)updateState).setPatterns(((Banner)sourceState).getPatterns());
            } else if (sourceState instanceof CommandBlock) {
                ((CommandBlock)updateState).setName(((CommandBlock)sourceState).getName());
                ((CommandBlock)updateState).setCommand(((CommandBlock)sourceState).getCommand());
            } else if (sourceState instanceof CreatureSpawner) {
                ((CreatureSpawner)updateState).setSpawnedType(((CreatureSpawner)sourceState).getSpawnedType());
                ((CreatureSpawner)updateState).setDelay(((CreatureSpawner)sourceState).getDelay());
            }
            updateState.update();
            if (!remove_original.asBoolean()) continue;
            location.getBlock().setType(Material.AIR);
        }
    }
}

