/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.TargetType;

public class AttackCommand
extends AbstractCommand {
    public AttackCommand() {
        this.setName("attack");
        this.setSyntax("attack [<entity>|...] (target:<entity>/cancel)");
        this.setRequiredArguments(0, 2);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry.getProcessedArgs()) {
            if (!scriptEntry.hasObject("cancel") && arg.matches("cancel", "stop")) {
                scriptEntry.addObject("cancel", "true");
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentType(EntityTag.class) && arg.matchesPrefix("target", "t")) {
                scriptEntry.addObject("target", arg.asType(EntityTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class) && !arg.matchesPrefix("target", "t")) {
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("target")) {
            scriptEntry.addObject("target", Utilities.entryHasPlayer(scriptEntry) ? Utilities.getEntryPlayer(scriptEntry).getDenizenEntity() : null);
        }
        if (!scriptEntry.hasObject("entities")) {
            scriptEntry.defaultObject("entities", Utilities.entryHasNPC(scriptEntry) ? Collections.singletonList(Utilities.getEntryNPC(scriptEntry).getDenizenEntity()) : null);
            if (!scriptEntry.hasObject("entities")) {
                throw new InvalidArgumentsException("Must specify entity/entities!");
            }
        }
        if (!scriptEntry.hasObject("target") && !scriptEntry.hasObject("cancel")) {
            throw new InvalidArgumentsException("Must specify a target!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        EntityTag target = (EntityTag)scriptEntry.getObjectTag("target");
        boolean cancel = scriptEntry.hasObject("cancel");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), (cancel ? ArgumentHelper.debugObj("cancel", "true") : "") + ArgumentHelper.debugObj("entities", entities.toString()) + (target != null ? ArgumentHelper.debugObj("target", target) : ""));
        }
        for (EntityTag entity : entities) {
            if (entity.isCitizensNPC()) {
                Navigator nav = entity.getDenizenNPC().getCitizen().getNavigator();
                if (!cancel) {
                    nav.setTarget(target.getBukkitEntity(), true);
                    continue;
                }
                if (!nav.isNavigating() || !nav.getTargetType().equals((Object)TargetType.ENTITY) || !nav.getEntityTarget().isAggressive()) continue;
                nav.cancelNavigation();
                continue;
            }
            if (!cancel) {
                entity.target(target.getLivingEntity());
                continue;
            }
            entity.target(null);
        }
    }
}

