/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.notable.NotableManager;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.flags.LocationFlagSearchHelper;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.SavableMapFlagTracker;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.Note;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class EllipsoidTag
implements ObjectTag,
Notable,
Cloneable,
AreaContainmentObject,
FlaggableObject {
    public LocationTag center;
    public LocationTag size;
    public String noteName = null;
    public AbstractFlagTracker flagTracker = null;
    String prefix = "ellipsoid";
    public static ObjectTagProcessor<EllipsoidTag> tagProcessor = new ObjectTagProcessor();

    public static List<EllipsoidTag> getNotableEllipsoidsContaining(Location location) {
        ArrayList<EllipsoidTag> ellipsoids = new ArrayList<EllipsoidTag>();
        for (EllipsoidTag ellipsoid : NotableManager.getAllType(EllipsoidTag.class)) {
            if (!ellipsoid.contains(location)) continue;
            ellipsoids.add(ellipsoid);
        }
        return ellipsoids;
    }

    @Deprecated
    public static EllipsoidTag valueOf(String string) {
        return EllipsoidTag.valueOf(string, null);
    }

    @Fetchable(value="ellipsoid")
    public static EllipsoidTag valueOf(String string, TagContext context) {
        if (string.startsWith("ellipsoid@")) {
            string = string.substring(10);
        }
        if (string.contains("@")) {
            return null;
        }
        Notable noted = NotableManager.getSavedObject(string);
        if (noted instanceof EllipsoidTag) {
            return (EllipsoidTag)noted;
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() != 7) {
            return null;
        }
        WorldTag world = WorldTag.valueOf(split.get(3), false);
        if (world == null) {
            return null;
        }
        for (int i = 0; i < 7; ++i) {
            if (i == 3 || ArgumentHelper.matchesDouble(split.get(i)) || context != null && !context.showErrors()) continue;
            Debug.echoError("EllipsoidTag input is not a valid decimal number: " + split.get(i));
            return null;
        }
        LocationTag location = new LocationTag(world.getWorld(), Double.parseDouble(split.get(0)), Double.parseDouble(split.get(1)), Double.parseDouble(split.get(2)));
        LocationTag size = new LocationTag(null, Double.parseDouble(split.get(4)), Double.parseDouble(split.get(5)), Double.parseDouble(split.get(6)));
        return new EllipsoidTag(location, size);
    }

    public static boolean matches(String arg) {
        try {
            return EllipsoidTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public EllipsoidTag clone() {
        return new EllipsoidTag(this.center.clone(), this.size.clone());
    }

    @Override
    public ObjectTag duplicate() {
        if (this.noteName != null) {
            return this;
        }
        return this.clone();
    }

    public EllipsoidTag(LocationTag center, LocationTag size) {
        this.center = center;
        this.size = size;
    }

    public ListTag getBlocks(Attribute attribute) {
        return this.getBlocks(null, attribute);
    }

    public ListTag getBlocks(String matcher, Attribute attribute) {
        List<LocationTag> initial = new CuboidTag(new Location(this.center.getWorld(), this.center.getX() - this.size.getX(), this.center.getY() - this.size.getY(), this.center.getZ() - this.size.getZ()), new Location(this.center.getWorld(), this.center.getX() + this.size.getX(), this.center.getY() + this.size.getY(), this.center.getZ() + this.size.getZ())).getBlocks_internal(matcher, attribute);
        ListTag list = new ListTag();
        for (LocationTag loc : initial) {
            if (!this.contains(loc)) continue;
            list.addObject(loc);
        }
        return list;
    }

    public List<LocationTag> getBlockLocationsUnfiltered(boolean doMax) {
        List<LocationTag> initial = new CuboidTag(new Location(this.center.getWorld(), this.center.getX() - this.size.getX(), this.center.getY() - this.size.getY(), this.center.getZ() - this.size.getZ()), new Location(this.center.getWorld(), this.center.getX() + this.size.getX(), this.center.getY() + this.size.getY(), this.center.getZ() + this.size.getZ())).getBlockLocationsUnfiltered(doMax);
        ArrayList<LocationTag> locations = new ArrayList<LocationTag>();
        for (LocationTag loc : initial) {
            if (!this.contains(loc)) continue;
            locations.add(loc);
        }
        return locations;
    }

    public ListTag getShell() {
        ListTag output = new ListTag();
        double yScale = this.size.getY();
        int maxY = (int)Math.floor(yScale);
        output.addObject(new LocationTag(this.center.getBlockX(), (double)(this.center.getBlockY() - maxY), (double)this.center.getBlockZ(), this.center.getWorldName()));
        if (maxY != 0) {
            output.addObject(new LocationTag(this.center.getBlockX(), (double)(this.center.getBlockY() + maxY), (double)this.center.getBlockZ(), this.center.getWorldName()));
        }
        for (int y = -maxY; y <= maxY; ++y) {
            double yProgMin = Math.min(1.0, (double)(Math.abs(y) + 1) / yScale);
            double yProgMax = (double)Math.abs(y) / yScale;
            double minSubWidth = Math.sqrt(1.0 - yProgMin * yProgMin);
            double maxSubWidth = Math.sqrt(1.0 - yProgMax * yProgMax);
            double minX = this.size.getX() * minSubWidth - 1.0;
            double minZ = this.size.getZ() * minSubWidth - 1.0;
            double maxX = this.size.getX() * maxSubWidth;
            double maxZ = this.size.getZ() * maxSubWidth;
            int x = 0;
            while ((double)x < maxX) {
                int z = 0;
                while ((double)z < maxZ) {
                    double scaleTestMin = (double)(x * x) / (minX * minX) + (double)(z * z) / (minZ * minZ);
                    double scaleTestMax = (double)(x * x) / (maxX * maxX) + (double)(z * z) / (maxZ * maxZ);
                    if (scaleTestMin >= 1.0 && scaleTestMax <= 1.0) {
                        output.addObject(new LocationTag(this.center.getBlockX() + x, (double)(this.center.getBlockY() + y), (double)(this.center.getBlockZ() + z), this.center.getWorldName()));
                        if (x != 0) {
                            output.addObject(new LocationTag(this.center.getBlockX() - x, (double)(this.center.getBlockY() + y), (double)(this.center.getBlockZ() + z), this.center.getWorldName()));
                        }
                        if (z != 0) {
                            output.addObject(new LocationTag(this.center.getBlockX() + x, (double)(this.center.getBlockY() + y), (double)(this.center.getBlockZ() - z), this.center.getWorldName()));
                        }
                        if (x != 0 && z != 0) {
                            output.addObject(new LocationTag(this.center.getBlockX() - x, (double)(this.center.getBlockY() + y), (double)(this.center.getBlockZ() - z), this.center.getWorldName()));
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
        return output;
    }

    public boolean contains(Location test) {
        if (test.getWorld() == null || !test.getWorld().getName().equals(this.center.getWorld().getName())) {
            return false;
        }
        double xbase = test.getX() - this.center.getX();
        double ybase = test.getY() - this.center.getY();
        double zbase = test.getZ() - this.center.getZ();
        return xbase * xbase / (this.size.getX() * this.size.getX()) + ybase * ybase / (this.size.getY() * this.size.getY()) + zbase * zbase / (this.size.getZ() * this.size.getZ()) <= 1.0;
    }

    public boolean intersects(ChunkTag chunk) {
        int xMin = chunk.getX() * 16;
        int zMin = chunk.getZ() * 16;
        LocationTag locTest = chunk.getCenter();
        locTest.setY(this.center.getY());
        if (this.center.getX() > (double)xMin) {
            if (this.center.getX() < (double)(xMin + 16)) {
                locTest.setX(this.center.getX());
            } else {
                locTest.setX(this.center.getX());
            }
        }
        if (this.center.getZ() > (double)zMin) {
            if (this.center.getZ() < (double)(zMin + 16)) {
                locTest.setZ(this.center.getZ());
            } else {
                locTest.setZ(this.center.getZ());
            }
        }
        return this.contains(locTest);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debuggable() {
        if (this.isUnique()) {
            return "ellipsoid@" + this.noteName + "<GR> (" + this.identifyFull() + ")";
        }
        return this.identifyFull();
    }

    @Override
    public boolean isUnique() {
        return this.noteName != null;
    }

    @Override
    @Note(value="Ellipsoids")
    public Object getSaveObject() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("object", (Object)this.identifyFull());
        section.set("flags", (Object)this.flagTracker.toString());
        return section;
    }

    @Override
    public void makeUnique(String id) {
        EllipsoidTag toNote = this.clone();
        toNote.noteName = id;
        toNote.flagTracker = new SavableMapFlagTracker();
        NotableManager.saveAs(toNote, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
        this.noteName = null;
        this.flagTracker = null;
    }

    public int hashCode() {
        if (this.noteName != null) {
            return this.noteName.hashCode();
        }
        return this.center.hashCode() + this.size.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof EllipsoidTag)) {
            return false;
        }
        EllipsoidTag ellipsoid2 = (EllipsoidTag)other;
        if (this.noteName == null != (ellipsoid2.noteName == null)) {
            return false;
        }
        if (this.noteName != null && !this.noteName.equals(ellipsoid2.noteName)) {
            return false;
        }
        if (!this.center.getWorldName().equals(ellipsoid2.center.getWorldName())) {
            return false;
        }
        if (this.center.distanceSquaredNoWorld(ellipsoid2.center) >= 0.25) {
            return false;
        }
        return !(this.size.distanceSquaredNoWorld(ellipsoid2.size) >= 0.25);
    }

    @Override
    public String getObjectType() {
        return "Ellipsoid";
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "ellipsoid@" + this.noteName;
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        return "ellipsoid@" + this.center.getX() + "," + this.center.getY() + "," + this.center.getZ() + "," + this.center.getWorldName() + "," + this.size.getX() + "," + this.size.getY() + "," + this.size.getZ();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        return this.flagTracker;
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
        if (this.noteName != null) {
            this.flagTracker = tracker;
        }
    }

    @Override
    public String getReasonNotFlaggable() {
        if (this.noteName == null) {
            return "the area is not noted - only noted areas can hold flags";
        }
        return "unknown reason - something went wrong";
    }

    public static void registerTags() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        EllipsoidTag.registerTag("random", (attribute, object) -> {
            double y = (Math.sqrt(CoreUtilities.getRandom().nextDouble()) * 2.0 - 1.0) * object.size.getY();
            Vector result = new Vector();
            result.setY(y);
            double yProg = Math.abs(y) / object.size.getY();
            double subWidth = Math.sqrt(1.0 - yProg * yProg);
            double maxX = object.size.getX() * subWidth;
            double maxZ = object.size.getZ() * subWidth;
            result.setX(maxX * (CoreUtilities.getRandom().nextDouble() * 2.0 - 1.0));
            result.setZ(maxZ * (CoreUtilities.getRandom().nextDouble() * 2.0 - 1.0));
            LocationTag out = object.center.clone();
            out.add(result);
            return out;
        }, new String[0]);
        EllipsoidTag.registerTag("blocks", (attribute, object) -> {
            if (attribute.hasContext(1)) {
                return new ListTag(object.getBlocks(attribute.getContext(1), attribute));
            }
            return new ListTag(object.getBlocks(attribute));
        }, "get_blocks");
        EllipsoidTag.registerTag("blocks_flagged", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("EllipsoidTag.blocks_flagged[...] must have an input value.");
                return null;
            }
            String flagName = CoreUtilities.toLowerCase(attribute.getContext(1));
            ListTag blocks = new ListTag();
            double minPossibleX = object.center.getX() - object.size.getX();
            double minPossibleZ = object.center.getZ() - object.size.getZ();
            double maxPossibleX = object.center.getX() + object.size.getX();
            double maxPossibleZ = object.center.getZ() + object.size.getZ();
            int minChunkX = (int)Math.floor(minPossibleX / 16.0);
            int minChunkZ = (int)Math.floor(minPossibleZ / 16.0);
            int maxChunkX = (int)Math.ceil(maxPossibleX / 16.0);
            int maxChunkZ = (int)Math.ceil(maxPossibleZ / 16.0);
            ChunkTag testChunk = new ChunkTag(object.center);
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                testChunk.chunkX = x;
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    testChunk.chunkZ = z;
                    testChunk.cachedChunk = null;
                    if (!object.intersects(testChunk) || !testChunk.isLoadedSafe()) continue;
                    LocationFlagSearchHelper.getFlaggedLocations(testChunk.getChunkForTag(attribute), flagName, loc -> {
                        if (object.doesContainLocation((Location)loc)) {
                            blocks.addObject(new LocationTag((Location)loc));
                        }
                    });
                }
            }
            return blocks;
        }, new String[0]);
        EllipsoidTag.registerTag("shell", (attribute, object) -> object.getShell(), new String[0]);
        EllipsoidTag.registerTag("location", (attribute, object) -> object.center, new String[0]);
        EllipsoidTag.registerTag("size", (attribute, object) -> object.size, new String[0]);
        EllipsoidTag.registerTag("add", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("ellipsoid.add[...] tag must have an input.");
                return null;
            }
            return new EllipsoidTag(object.center.clone().add(attribute.contextAsType(1, LocationTag.class)), object.size.clone());
        }, new String[0]);
        EllipsoidTag.registerTag("contains", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("ellipsoid.contains[...] tag must have an input.");
                return null;
            }
            return new ElementTag(object.contains(attribute.contextAsType(1, LocationTag.class)));
        }, new String[0]);
        EllipsoidTag.registerTag("include", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("ellipsoid.include[...] tag must have an input.");
                return null;
            }
            LocationTag target = attribute.contextAsType(1, LocationTag.class);
            if (object.contains(target)) {
                return object;
            }
            LocationTag size = object.size.clone();
            Vector relative = target.toVector().subtract(object.center.toVector());
            size.setX(Math.max(size.getX(), Math.abs(relative.getX())));
            size.setY(Math.max(size.getY(), Math.abs(relative.getY())));
            size.setZ(Math.max(size.getZ(), Math.abs(relative.getZ())));
            EllipsoidTag result = new EllipsoidTag(object.center.clone(), new LocationTag(size));
            if (result.contains(target)) {
                return result;
            }
            double sizeLen = size.length();
            while (!result.contains(target)) {
                double projX = relative.getX() * relative.getX() / (size.getX() * size.getX());
                double projY = relative.getY() * relative.getY() / (size.getY() * size.getY());
                double projZ = relative.getZ() * relative.getZ() / (size.getZ() * size.getZ());
                double scale = Math.max(projX + projY + projZ, sizeLen * 0.01);
                if (projX >= projY && projX >= projZ) {
                    size.setX(size.getX() + scale);
                } else if (projY >= projX && projY >= projZ) {
                    size.setY(size.getY() + scale);
                } else if (projZ >= projX && projZ >= projY) {
                    size.setZ(size.getZ() + scale);
                } else {
                    size = size.add(scale, scale, scale);
                }
                result.size = size;
            }
            return result;
        }, new String[0]);
        EllipsoidTag.registerTag("with_location", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("ellipsoid.with_location[...] tag must have an input.");
                return null;
            }
            return new EllipsoidTag(attribute.contextAsType(1, LocationTag.class), object.size.clone());
        }, new String[0]);
        EllipsoidTag.registerTag("with_size", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("ellipsoid.with_size[...] tag must have an input.");
                return null;
            }
            return new EllipsoidTag(object.center.clone(), attribute.contextAsType(1, LocationTag.class));
        }, new String[0]);
        EllipsoidTag.registerTag("with_world", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("ellipsoid.with_world[...] tag must have an input.");
                return null;
            }
            LocationTag loc = object.center.clone();
            loc.setWorld(attribute.contextAsType(1, WorldTag.class).getWorld());
            return new EllipsoidTag(loc, object.size.clone());
        }, new String[0]);
        EllipsoidTag.registerTag("players", (attribute, object) -> {
            ArrayList<PlayerTag> players = new ArrayList<PlayerTag>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!object.contains(player.getLocation())) continue;
                players.add(PlayerTag.mirrorBukkitPlayer((OfflinePlayer)player));
            }
            return new ListTag((Collection<? extends ObjectTag>)players);
        }, new String[0]);
        if (Depends.citizens != null) {
            EllipsoidTag.registerTag("npcs", (attribute, object) -> {
                ArrayList<NPCTag> npcs = new ArrayList<NPCTag>();
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    NPCTag dnpc = new NPCTag(npc);
                    if (!object.contains(dnpc.getLocation())) continue;
                    npcs.add(dnpc);
                }
                return new ListTag((Collection<? extends ObjectTag>)npcs);
            }, new String[0]);
        }
        EllipsoidTag.registerTag("entities", (attribute, object) -> {
            String matcher = attribute.hasContext(1) ? attribute.getContext(1) : null;
            ListTag entities = new ListTag();
            for (Entity ent : new WorldTag(object.center.getWorld()).getEntitiesForTag()) {
                EntityTag current = new EntityTag(ent);
                if (!object.contains(ent.getLocation()) || matcher != null && !BukkitScriptEvent.tryEntity(current, matcher)) continue;
                entities.addObject(new EntityTag(ent).getDenizenObject());
            }
            return entities;
        }, new String[0]);
        EllipsoidTag.registerTag("chunks", (attribute, object) -> {
            ListTag chunks = new ListTag();
            double minPossibleX = object.center.getX() - object.size.getX();
            double minPossibleZ = object.center.getZ() - object.size.getZ();
            double maxPossibleX = object.center.getX() + object.size.getX();
            double maxPossibleZ = object.center.getZ() + object.size.getZ();
            int minChunkX = (int)Math.floor(minPossibleX / 16.0);
            int minChunkZ = (int)Math.floor(minPossibleZ / 16.0);
            int maxChunkX = (int)Math.ceil(maxPossibleX / 16.0);
            int maxChunkZ = (int)Math.ceil(maxPossibleZ / 16.0);
            ChunkTag testChunk = new ChunkTag(object.center);
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                testChunk.chunkX = x;
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    testChunk.chunkZ = z;
                    if (!object.intersects(testChunk)) continue;
                    chunks.addObject(new ChunkTag(testChunk.world, testChunk.chunkX, testChunk.chunkZ));
                }
            }
            return chunks;
        }, new String[0]);
        EllipsoidTag.registerTag("note_name", (attribute, ellipsoid) -> {
            String noteName = NotableManager.getSavedId(ellipsoid);
            if (noteName == null) {
                return null;
            }
            return new ElementTag(noteName);
        }, new String[0]);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<EllipsoidTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public String getNoteName() {
        return this.noteName;
    }

    @Override
    public boolean doesContainLocation(Location loc) {
        return this.contains(loc);
    }
}

