/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trhologram.module.internal.boot;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import me.arasple.mc.trhologram.module.internal.boot.PluginBoot;
import me.arasple.mc.trhologram.module.internal.boot.PluginLocale;
import me.arasple.mc.trhologram.module.internal.boot.util.ILoader;
import me.arasple.mc.trhologram.module.internal.boot.util.IO;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.util.NumberConversions;

public class PluginHandle {
    private static File pluginModeFile;
    private static File pluginOriginFile;
    private static PluginDescriptionFile pluginModeDescriptionFile;
    private static PluginDescriptionFile pluginOriginDescriptionFile;
    private static final List<String> legacy;
    private static double tabooLibVersion;
    public static final String[][] URL;

    public static boolean downloadFile() {
        tabooLibVersion = -1.0;
        PluginLocale.LOAD_DOWNLOAD.info(new Object[0]);
        String[] newVersion = PluginHandle.getCurrentVersion();
        return newVersion != null && IO.downloadFile(newVersion[2], IO.file(PluginBoot.getTabooLibFile()));
    }

    public static boolean isLoaded() {
        return ILoader.forName("io.izzel.taboolib.TabooLib", false, Bukkit.class.getClassLoader()) != null;
    }

    public static double getVersion() {
        if (tabooLibVersion != -1.0) {
            return tabooLibVersion;
        }
        try (ZipFile zipFile = new ZipFile(PluginBoot.getTabooLibFile());){
            tabooLibVersion = NumberConversions.toDouble((Object)IO.readFully(zipFile.getInputStream(zipFile.getEntry("__resources__/version"))));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return tabooLibVersion;
    }

    public static String[] getCurrentVersion() {
        for (String[] url : URL) {
            String read = IO.readFromURL(url[0], "{}");
            try {
                JsonObject jsonObject = new JsonParser().parse(read).getAsJsonObject();
                if (!jsonObject.has("tag_name")) continue;
                return new String[]{jsonObject.get("tag_name").getAsString(), url[0], url[1]};
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static FileConfiguration getPluginDescription() {
        File file = IO.file(new File("plugins/TabooLib/temp/" + UUID.randomUUID()));
        try {
            Throwable throwable = null;
            try (ZipFile zipFile = new ZipFile(IO.toFile(PluginBoot.class.getProtectionDomain().getCodeSource().getLocation().openStream(), file));){
                YamlConfiguration yamlConfiguration;
                Throwable throwable2;
                InputStream inputStream;
                block30: {
                    block31: {
                        inputStream = zipFile.getInputStream(zipFile.getEntry("plugin.yml"));
                        throwable2 = null;
                        yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream));
                        if (inputStream == null) break block30;
                        if (throwable2 == null) break block31;
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block30;
                    }
                    inputStream.close();
                }
                return yamlConfiguration;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (inputStream != null) {
                                    if (throwable2 != null) {
                                        try {
                                            inputStream.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        inputStream.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PluginDescriptionFile getPluginDescriptionFile(File file) {
        PluginDescriptionFile descriptionFile = null;
        try (JarFile jar = new JarFile(file);){
            JarEntry entry = jar.getJarEntry("plugin.yml");
            if (entry == null) {
                PluginDescriptionFile pluginDescriptionFile = null;
                return pluginDescriptionFile;
            }
            try (InputStream stream = jar.getInputStream(entry);){
                descriptionFile = new PluginDescriptionFile(stream);
                return descriptionFile;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return descriptionFile;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return descriptionFile;
    }

    public static void LoadPluginMode() {
        try {
            Plugin plugin = Bukkit.getPluginManager().loadPlugin(PluginBoot.getTabooLibFile());
            if (plugin != null) {
                plugin.onLoad();
                Bukkit.getPluginManager().enablePlugin(plugin);
            }
        }
        catch (Throwable t) {
            PluginBoot.setDisabled(true);
            t.printStackTrace();
        }
    }

    public static void checkPlugins() {
        for (File file : new File("plugins").listFiles()) {
            PluginDescriptionFile desc;
            if (!file.getName().endsWith(".jar") || (desc = PluginHandle.getPluginDescriptionFile(file)) == null) continue;
            switch (desc.getName()) {
                case "TabooLib": {
                    pluginOriginFile = file;
                    pluginOriginDescriptionFile = desc;
                    break;
                }
                case "TabooLib5": {
                    pluginModeFile = file;
                    pluginModeDescriptionFile = desc;
                }
            }
            if (!desc.getDepend().contains("TabooLib")) continue;
            legacy.add(desc.getName());
        }
    }

    public static Class<?> getMainClass(String node) {
        try {
            return Class.forName(Objects.requireNonNull(PluginHandle.getPluginDescription()).getString(node));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public static void sleep(long time) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            try {
                Thread.sleep(time);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static File getPluginModeFile() {
        return pluginModeFile;
    }

    public static File getPluginOriginFile() {
        return pluginOriginFile;
    }

    public static PluginDescriptionFile getPluginModeDescriptionFile() {
        return pluginModeDescriptionFile;
    }

    public static PluginDescriptionFile getPluginOriginDescriptionFile() {
        return pluginOriginDescriptionFile;
    }

    public static List<String> getLegacy() {
        return legacy;
    }

    static {
        legacy = new ArrayList<String>();
        tabooLibVersion = -1.0;
        URL = new String[][]{{"https://skymc.oss-cn-shanghai.aliyuncs.com/plugins/latest.json", "https://skymc.oss-cn-shanghai.aliyuncs.com/plugins/TabooLib.jar"}, {"https://api.github.com/repos/TabooLib/TabooLib/releases/latest", "https://github.com/TabooLib/TabooLib/releases/latest/download/TabooLib.jar"}};
    }
}

