/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trhologram.module.internal.boot;

import io.izzel.taboolib.PluginLoader;
import io.izzel.taboolib.util.Reflection;
import java.io.File;
import me.arasple.mc.trhologram.module.internal.boot.Plugin;
import me.arasple.mc.trhologram.module.internal.boot.PluginHandle;
import me.arasple.mc.trhologram.module.internal.boot.PluginLocale;
import me.arasple.mc.trhologram.module.internal.boot.util.ILoader;
import me.arasple.mc.trhologram.module.internal.boot.util.IO;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginBoot
extends JavaPlugin {
    protected static File tabooLibFile = new File("libs/TabooLib.jar");
    protected static Class<?> mainClass;
    protected static PluginBoot pluginBoot;
    protected static Plugin pluginInstance;
    protected static boolean isDisabled;
    protected static boolean isForge;

    public final void onLoad() {
        if (isDisabled) {
            this.setEnabled(false);
            return;
        }
        pluginBoot = this;
        try {
            pluginInstance = (Plugin)Reflection.getValue(mainClass, mainClass, (boolean)true, (String)"INSTANCE");
        }
        catch (NoSuchFieldException ignored) {
            try {
                pluginInstance = (Plugin)Reflection.instantiateObject(mainClass, (Object[])new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (pluginInstance != null) {
            PluginLoader.redefine((org.bukkit.plugin.Plugin)this, (Object)pluginInstance);
        }
        PluginLoader.addPlugin((org.bukkit.plugin.Plugin)this);
        PluginLoader.load((org.bukkit.plugin.Plugin)this);
        try {
            if (pluginInstance != null) {
                pluginInstance.onLoad();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public final void onEnable() {
        if (isDisabled) {
            return;
        }
        PluginLoader.start((org.bukkit.plugin.Plugin)this);
        try {
            if (pluginInstance != null) {
                pluginInstance.onEnable();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Bukkit.getScheduler().runTask((org.bukkit.plugin.Plugin)this, () -> PluginLoader.active((org.bukkit.plugin.Plugin)this));
    }

    public final void onDisable() {
        if (isDisabled) {
            return;
        }
        try {
            if (pluginInstance != null) {
                pluginInstance.onDisable();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        PluginLoader.stop((org.bukkit.plugin.Plugin)this);
    }

    @Nullable
    public final ChunkGenerator getDefaultWorldGenerator(@NotNull String worldName, @Nullable String id) {
        if (pluginInstance != null) {
            return pluginInstance.getDefaultWorldGenerator(worldName, id);
        }
        return super.getDefaultWorldGenerator(worldName, id);
    }

    @Deprecated
    public final FileConfiguration getConfig() {
        return super.getConfig();
    }

    @NotNull
    public final File getFile() {
        return super.getFile();
    }

    public static File getTabooLibFile() {
        return tabooLibFile;
    }

    public static PluginBoot getPluginBase() {
        return pluginBoot;
    }

    public static Plugin getPluginInstance() {
        return pluginInstance;
    }

    public static boolean isForge() {
        return isForge;
    }

    public static boolean isDisabled() {
        return isDisabled;
    }

    public static void setDisabled(boolean disabled) {
        isDisabled = disabled;
    }

    private static void init() {
        double version;
        FileConfiguration description = PluginHandle.getPluginDescription();
        if (description == null) {
            File file = new File(PluginBoot.class.getProtectionDomain().getCodeSource().getLocation().getFile());
            PluginLocale.LOAD_FAILED.warn(file.getName() + " (JVM)");
            return;
        }
        String name = description.getString("name");
        if (!tabooLibFile.exists()) {
            File wrong = new File("TabooLib.jar");
            if (wrong.exists()) {
                IO.copy(wrong, IO.file(tabooLibFile));
                wrong.delete();
            } else {
                if (!description.getBoolean("lib-download", true)) {
                    isDisabled = true;
                    PluginLocale.LOAD_OFFLINE.warn(name);
                    return;
                }
                if (!PluginHandle.downloadFile()) {
                    isDisabled = true;
                    PluginLocale.LOAD_NO_INTERNAL.warn(name);
                    return;
                }
            }
        }
        if ((version = PluginHandle.getVersion()) == -1.0 && !PluginHandle.downloadFile()) {
            isDisabled = true;
            PluginLocale.LOAD_NO_INTERNAL.warn(name);
            return;
        }
        double requireVersion = description.getDouble("lib-version", 5.35);
        if (requireVersion > version) {
            isDisabled = true;
            String[] newVersion = PluginHandle.getCurrentVersion();
            if (newVersion == null) {
                PluginLocale.LOAD_NO_INTERNAL.warn(name);
                return;
            }
            if (requireVersion > NumberConversions.toDouble((Object)newVersion[0])) {
                PluginLocale.LOAD_INVALID_VERSION.warn(name, requireVersion, newVersion[0]);
                return;
            }
            PluginLocale.LOAD_DOWNLOAD.info(new Object[0]);
            if (IO.downloadFile(newVersion[2], IO.file(tabooLibFile))) {
                if (Bukkit.getOnlinePlayers().isEmpty()) {
                    PluginLocale.LOAD_OUTDATED.warn(new Object[0]);
                    PluginHandle.sleep(5000L);
                    Bukkit.shutdown();
                } else {
                    PluginLocale.LOAD_OUTDATED_NO_RESTART.warn(name);
                }
            }
        }
        if (isForge) {
            if (Bukkit.getPluginManager().getPlugin("TabooLib5") == null) {
                PluginLocale.LOAD_FORGE_MODE.warn(new Object[0]);
                PluginHandle.LoadPluginMode();
            }
        } else if (!PluginHandle.isLoaded()) {
            if (!description.getBoolean("lib-download", true)) {
                PluginHandle.checkPlugins();
                if (PluginHandle.getPluginModeFile() != null) {
                    isDisabled = true;
                    PluginLocale.LOAD_IN_PLUGINS.warn(PluginHandle.getPluginModeFile().getName());
                    PluginHandle.getPluginModeFile().delete();
                    PluginHandle.sleep(5000L);
                    Bukkit.shutdown();
                    return;
                }
                if (PluginHandle.getPluginOriginFile() != null && !new File("plugins/TabooLib/check").exists()) {
                    double legacyVersion = NumberConversions.toDouble((Object)PluginHandle.getPluginOriginDescriptionFile().getVersion());
                    if (legacyVersion > 3.0 && legacyVersion < 4.92) {
                        isDisabled = true;
                        IO.file(new File("plugins/TabooLib/check"));
                        IO.downloadFile("https://skymc.oss-cn-shanghai.aliyuncs.com/plugins/TabooLib-4.92.jar", PluginHandle.getPluginOriginFile());
                        PluginLocale.LOAD_COMPAT_MODE_UPDATE.warn(PluginHandle.getPluginOriginFile().getName());
                        PluginHandle.sleep(5000L);
                        Bukkit.shutdown();
                        return;
                    }
                    PluginLocale.LOAD_COMPAT_MODE.warn(PluginHandle.getPluginOriginFile().getName(), PluginHandle.getLegacy());
                }
            }
            ILoader.addPath(tabooLibFile);
            if (ILoader.forName("io.izzel.taboolib.TabooLib", true, Bukkit.class.getClassLoader()) != null) {
                PluginLocale.LOAD_SUCCESS.info(PluginHandle.getVersion(), name);
            } else {
                isDisabled = true;
                PluginLocale.LOAD_FAILED.warn(name);
            }
        }
        IO.deepDelete(new File("plugins/TabooLib/temp"));
    }

    static {
        isForge = ILoader.forName("net.minecraftforge.classloading.FMLForgePlugin", false, PluginBoot.class.getClassLoader()) != null || ILoader.forName("net.minecraftforge.common.MinecraftForge", false, PluginBoot.class.getClassLoader()) != null;
        try {
            for (Class<?> c : IO.getClasses(PluginBoot.class)) {
                if (!Plugin.class.isAssignableFrom(c) || Plugin.class.equals(c)) continue;
                mainClass = c;
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            PluginBoot.init();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

