/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trhologram.module.conf;

import io.izzel.taboolib.module.locale.TLocale;
import io.izzel.taboolib.util.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import me.arasple.mc.trhologram.TrHologram;
import me.arasple.mc.trhologram.api.Position;
import me.arasple.mc.trhologram.api.Settings;
import me.arasple.mc.trhologram.api.TrHologramAPI;
import me.arasple.mc.trhologram.api.base.ItemTexture;
import me.arasple.mc.trhologram.api.event.HologramInteractEvent;
import me.arasple.mc.trhologram.api.hologram.HologramComponent;
import me.arasple.mc.trhologram.api.hologram.ItemHologram;
import me.arasple.mc.trhologram.api.hologram.TextHologram;
import me.arasple.mc.trhologram.module.action.ClickReaction;
import me.arasple.mc.trhologram.module.action.Reaction;
import me.arasple.mc.trhologram.module.condition.Condition;
import me.arasple.mc.trhologram.module.conf.Property;
import me.arasple.mc.trhologram.module.display.Hologram;
import me.arasple.mc.trhologram.module.display.texture.Texture;
import me.arasple.mc.trhologram.module.display.texture.TrMenuTexture;
import me.arasple.mc.trhologram.module.hook.HookPlugin;
import me.arasple.mc.trhologram.module.internal.boot.PluginBoot;
import me.arasple.mc.trhologram.util.ParserKt;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\r*\u0004\u0018\u00010\u0001H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lme/arasple/mc/trhologram/module/conf/HologramLoader;", "", "()V", "folder", "Ljava/io/File;", "Lorg/jetbrains/annotations/NotNull;", "create", "Lme/arasple/mc/trhologram/module/display/Hologram;", "id", "", "location", "Lorg/bukkit/Location;", "filterHologramFiles", "", "file", "load", "", "", "sender", "Lorg/bukkit/command/CommandSender;", "toStringList", "TrHologram"})
public final class HologramLoader {
    private static final File folder;
    @NotNull
    public static final HologramLoader INSTANCE;

    @NotNull
    public final Hologram create(@NotNull String id, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        String hologram2 = StringsKt.trimIndent((String)("\n            Location: " + ParserKt.parseString(location) + "\n\n            Contents:\n              - '&7Hello, &2Tr&aHologram&7!'\n              - '{item: emerald}'\n              - '&3Nice to meet you, &a{{player name}}'\n              - '&3Author: &aArasple{offset=0.35}'\n\n            Actions:\n              All: 'tell color *\"&bHi, you just clicked this hologram\"'\n            "));
        File file = Files.file((File)folder, (String)(id + ".yml"));
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        File file2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it");
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        FilesKt.writeText((File)file2, (String)hologram2, (Charset)charset);
        return INSTANCE.load(it);
    }

    public final void load(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        boolean $i$f$measureNanoTime = false;
        boolean bl = false;
        long start$iv = System.nanoTime();
        boolean bl2 = false;
        INSTANCE.load();
        double d = (double)(System.nanoTime() - start$iv) / 1000000.0;
        bl = false;
        boolean bl3 = false;
        double it = d;
        boolean bl4 = false;
        TLocale.sendTo((CommandSender)sender, (String)"Hologram.Loaded", (Object[])new Object[]{Hologram.Companion.getHolograms$TrHologram().size(), it});
    }

    /*
     * WARNING - void declaration
     */
    public final int load() {
        void $this$flatMapTo$iv$iv;
        Hologram.Companion.clear();
        TrHologramAPI.INSTANCE.resetIndex$TrHologram();
        Iterable $this$forEach$iv = this.filterHologramFiles(folder);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            INSTANCE.load(it);
        }
        Iterable $this$flatMap$iv = Settings.Companion.getINSTANCE$TrHologram().getLoadPaths();
        boolean $i$f$flatMap = false;
        Iterator iterator = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.filterHologramFiles(new File(it));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            INSTANCE.load(it);
        }
        return Hologram.Companion.getHolograms$TrHologram().size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Hologram load(@NotNull File file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String id = FilesKt.getNameWithoutExtension((File)file);
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"YamlConfiguration.loadConfiguration(file)");
        YamlConfiguration conf = yamlConfiguration;
        String string = conf.getString("Location");
        if (string == null || (string = ParserKt.parseLocation(string)) == null) {
            throw (Throwable)new Exception("No valid location");
        }
        String location = string;
        double lineSpacing2 = conf.getDouble("Options.Line-Spacing", Settings.Companion.getINSTANCE$TrHologram().getLineSpacing());
        double viewDistance2 = RangesKt.coerceAtMost((double)conf.getDouble("Options.View-Distance", Settings.Companion.getINSTANCE$TrHologram().getViewDistance()), (double)50.0);
        String string2 = conf.getString("Options.View-Condition", Settings.Companion.getINSTANCE$TrHologram().getViewCondition());
        boolean bl = false;
        boolean bl2 = false;
        Object it = string2;
        boolean bl3 = false;
        String string3 = it == null || StringsKt.isBlank((CharSequence)((CharSequence)it)) ? null : Condition.constructor-impl((String)it);
        Condition condition = string3 != null ? Condition.box-impl(string3) : null;
        String viewCondition2 = condition != null ? condition.unbox-impl() : null;
        long refreshCondition2 = conf.getLong("Options.Refresh-Condition", Settings.Companion.getINSTANCE$TrHologram().getRefershCondition());
        it = conf.getStringList("Contents");
        bl3 = false;
        if (it.isEmpty()) {
            boolean bl4 = false;
            object = CollectionsKt.listOf((Object)"TrHologram");
        } else {
            object = it;
        }
        List contents = (List)object;
        bl3 = false;
        Map actions = new LinkedHashMap();
        List<String> all = this.toStringList(conf.get("Actions.All"));
        List<String> left = this.toStringList(conf.get("Actions.Left"));
        List<String> shiftLeft = this.toStringList(conf.get("Actions.Shift_Left"));
        List<String> right = this.toStringList(conf.get("Actions.Right"));
        List<String> shiftRight = this.toStringList(conf.get("Actions.Shift_Right"));
        Collection collection = all;
        boolean bl5 = false;
        if (!collection.isEmpty()) {
            actions.put(HologramInteractEvent.Type.ALL, Reaction.box-impl(Reaction.constructor-impl(all)));
        }
        collection = left;
        bl5 = false;
        if (!collection.isEmpty()) {
            actions.put(HologramInteractEvent.Type.LEFT, Reaction.box-impl(Reaction.constructor-impl(left)));
        }
        collection = shiftLeft;
        bl5 = false;
        if (!collection.isEmpty()) {
            actions.put(HologramInteractEvent.Type.SHIFT_LEFT, Reaction.box-impl(Reaction.constructor-impl(shiftLeft)));
        }
        collection = right;
        bl5 = false;
        if (!collection.isEmpty()) {
            actions.put(HologramInteractEvent.Type.RIGHT, Reaction.box-impl(Reaction.constructor-impl(right)));
        }
        collection = shiftRight;
        bl5 = false;
        if (!collection.isEmpty()) {
            actions.put(HologramInteractEvent.Type.SHIFT_RIGHT, Reaction.box-impl(Reaction.constructor-impl(shiftRight)));
        }
        bl5 = false;
        List holograms = new ArrayList();
        Position position = Position.clone$default(Position.Companion.fromLocation((Location)location), 0.0, -1.25, 0.0, 5, null);
        Iterable $this$forEach$iv = contents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HologramComponent hologram2;
            HologramComponent hologramComponent;
            String it2 = (String)element$iv;
            boolean bl6 = false;
            String string4 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
            Pair<String, Map<Property, String>> pair = Property.Companion.from(string4);
            String string5 = (String)pair.component1();
            Map options = (Map)pair.component2();
            String itemDisplay = (String)options.get((Object)Property.ITEM);
            Object object2 = (String)options.get((Object)Property.UPDATE);
            long update = object2 != null && (object2 = StringsKt.toLongOrNull((String)object2)) != null ? (Long)object2 : -1L;
            Object object3 = (String)options.get((Object)Property.OFFSET);
            double offset = object3 != null && (object3 = StringsKt.toDoubleOrNull((String)object3)) != null ? (Double)object3 : lineSpacing2;
            boolean isItem = itemDisplay != null;
            double fix = isItem ? 0.5 : 0.0;
            position = Position.clone$default(position, 0.0, -(fix + offset), 0.0, 5, null);
            if (isItem) {
                ItemTexture itemTexture;
                if (!HookPlugin.INSTANCE.getTRMENU()) {
                    String string6 = itemDisplay;
                    Intrinsics.checkNotNull((Object)string6);
                    itemTexture = Texture.Companion.createTexture(string6);
                } else {
                    String string7 = itemDisplay;
                    Intrinsics.checkNotNull((Object)string7);
                    itemTexture = new TrMenuTexture(string7);
                }
                ItemTexture texture = itemTexture;
                hologramComponent = new ItemHologram(texture, position, update, null, 8, null);
            } else {
                void line;
                hologramComponent = StringsKt.isBlank((CharSequence)((CharSequence)line)) ? null : (HologramComponent)new TextHologram((String)line, position, update, null, 8, null);
            }
            if ((hologram2 = hologramComponent) == null) continue;
            holograms.add(hologram2);
        }
        String string8 = viewCondition2;
        Hologram hologram3 = new Hologram(id, Position.Companion.fromLocation((Location)location), viewDistance2, string8 != null ? Condition.box-impl(string8) : null, refreshCondition2, holograms, ClickReaction.box-impl(ClickReaction.constructor-impl(actions)), file.getAbsolutePath());
        Hologram.Companion.getHolograms$TrHologram().add(hologram3);
        return hologram3;
    }

    private final List<File> filterHologramFiles(File file) {
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$run = list;
        boolean bl4 = false;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl5 = false;
                    File file2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it");
                    $this$run.addAll((Collection)INSTANCE.filterHologramFiles(file2));
                }
            }
        } else {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (!StringsKt.startsWith$default((String)string, (String)"#", (boolean)false, (int)2, null) && StringsKt.equals((String)FilesKt.getExtension((File)file), (String)"yml", (boolean)true)) {
                $this$run.add(file);
            }
        }
        return $this$run;
    }

    private final List<String> toStringList(Object $this$toStringList) {
        List list;
        Object object = $this$toStringList;
        if (object instanceof List) {
            Object object2 = $this$toStringList;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            }
            list = (List)object2;
        } else {
            list = CollectionsKt.listOf((Object)String.valueOf($this$toStringList));
        }
        return list;
    }

    private HologramLoader() {
    }

    static {
        HologramLoader hologramLoader;
        INSTANCE = hologramLoader = new HologramLoader();
        PluginBoot pluginBoot = TrHologram.INSTANCE.getPlugin();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)pluginBoot), (String)"TrHologram.plugin");
        File file = Files.folder((File)pluginBoot.getDataFolder(), (String)"holograms");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"Files.folder(TrHologram.\u2026.dataFolder, \"holograms\")");
        folder = file;
    }
}

