/*
 * Decompiled with CFR 0.152.
 */
package net.brcdev.shopgui;

import net.brcdev.shopgui.ShopGuiPlugin;
import net.brcdev.shopgui.exception.api.ExternalSpawnerProviderNameConflictException;
import net.brcdev.shopgui.exception.player.PlayerDataNotLoadedException;
import net.brcdev.shopgui.modifier.PriceModifier;
import net.brcdev.shopgui.modifier.PriceModifierActionType;
import net.brcdev.shopgui.provider.economy.EconomyProvider;
import net.brcdev.shopgui.provider.item.ItemProvider;
import net.brcdev.shopgui.shop.Shop;
import net.brcdev.shopgui.shop.item.ShopItem;
import net.brcdev.shopgui.spawner.external.provider.ExternalSpawnerProvider;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ShopGuiPlusApi {
    private static ShopGuiPlugin shopGuiPlugin;

    public static Shop getShop(String shopId) {
        return shopGuiPlugin.getShopManager().getShopById(shopId);
    }

    public static void openMainMenu(Player player) throws PlayerDataNotLoadedException {
        if (!shopGuiPlugin.getPlayerManager().isPlayerLoaded((OfflinePlayer)player)) {
            throw new PlayerDataNotLoadedException((OfflinePlayer)player);
        }
        shopGuiPlugin.getShopManager().openMainMenu(player);
    }

    public static void openShop(Player player, String shopId, int page) throws PlayerDataNotLoadedException {
        if (!shopGuiPlugin.getPlayerManager().isPlayerLoaded((OfflinePlayer)player)) {
            throw new PlayerDataNotLoadedException((OfflinePlayer)player);
        }
        shopGuiPlugin.getShopManager().openShopMenu(player, shopId, page, false);
    }

    public static Shop getItemStackShop(Player player, ItemStack itemStack) {
        ShopItem shopItem = ShopGuiPlusApi.getShopItem(player, itemStack);
        return shopItem != null ? shopItem.getShop() : null;
    }

    public static Shop getItemStackShop(ItemStack itemStack) {
        ShopItem shopItem = ShopGuiPlusApi.getShopItem(itemStack);
        return shopItem != null ? shopItem.getShop() : null;
    }

    public static ShopItem getItemStackShopItem(Player player, ItemStack itemStack) {
        return ShopGuiPlusApi.getShopItem(player, itemStack);
    }

    public static ShopItem getItemStackShopItem(ItemStack itemStack) {
        return ShopGuiPlusApi.getShopItem(itemStack);
    }

    public static double getItemStackPriceBuy(Player player, ItemStack itemStack) {
        ShopItem shopItem = ShopGuiPlusApi.getShopItem(player, itemStack);
        if (shopItem == null) {
            return -1.0;
        }
        return shopItem.getBuyPriceForAmount(player, itemStack.getAmount());
    }

    public static double getItemStackPriceBuy(ItemStack itemStack) {
        ShopItem shopItem = ShopGuiPlusApi.getShopItem(itemStack);
        if (shopItem == null) {
            return -1.0;
        }
        return shopItem.getBuyPriceForAmount(itemStack.getAmount());
    }

    public static double getItemStackPriceSell(Player player, ItemStack itemStack) {
        ShopItem shopItem = ShopGuiPlusApi.getShopItem(player, itemStack);
        if (shopItem == null) {
            return -1.0;
        }
        return shopItem.getSellPriceForAmount(player, itemStack.getAmount());
    }

    public static double getItemStackPriceSell(ItemStack itemStack) {
        ShopItem shopItem = ShopGuiPlusApi.getShopItem(itemStack);
        if (shopItem == null) {
            return -1.0;
        }
        return shopItem.getSellPriceForAmount(itemStack.getAmount());
    }

    public static PriceModifier getPriceModifier(Player player, ShopItem shopItem, PriceModifierActionType type) throws PlayerDataNotLoadedException {
        return shopGuiPlugin.getPriceModifierManager().getPriceModifier(player, shopItem, type);
    }

    public static void setPriceModifier(Player player, ShopItem shopItem, PriceModifierActionType type, double modifier) throws PlayerDataNotLoadedException {
        shopGuiPlugin.getPriceModifierManager().setPriceModifier(player, shopItem, type, modifier);
    }

    public static void resetPriceModifier(Player player, ShopItem shopItem, PriceModifierActionType type) throws PlayerDataNotLoadedException {
        shopGuiPlugin.getPriceModifierManager().resetPriceModifier((OfflinePlayer)player, shopItem, type);
    }

    public static PriceModifier getPriceModifier(Player player, Shop shop, PriceModifierActionType type) throws PlayerDataNotLoadedException {
        return shopGuiPlugin.getPriceModifierManager().getPriceModifier(player, shop, type);
    }

    public static void setPriceModifier(Player player, Shop shop, PriceModifierActionType type, double modifier) throws PlayerDataNotLoadedException {
        shopGuiPlugin.getPriceModifierManager().setPriceModifier(player, shop, type, modifier);
    }

    public static void resetPriceModifier(Player player, Shop shop, PriceModifierActionType type) throws PlayerDataNotLoadedException {
        shopGuiPlugin.getPriceModifierManager().resetPriceModifier((OfflinePlayer)player, shop, type);
    }

    public static PriceModifier getPriceModifier(Player player, PriceModifierActionType type) throws PlayerDataNotLoadedException {
        return shopGuiPlugin.getPriceModifierManager().getPriceModifier(player, type);
    }

    public static void setPriceModifier(Player player, PriceModifierActionType type, double modifier) throws PlayerDataNotLoadedException {
        shopGuiPlugin.getPriceModifierManager().setPriceModifier(player, type, modifier);
    }

    public static void resetPriceModifier(Player player, PriceModifierActionType type) throws PlayerDataNotLoadedException {
        shopGuiPlugin.getPriceModifierManager().resetPriceModifier((OfflinePlayer)player, type);
    }

    public static void registerSpawnerProvider(ExternalSpawnerProvider spawnerProvider) throws ExternalSpawnerProviderNameConflictException {
        shopGuiPlugin.getSpawnerManager().registerExternalSpawnerProvider(spawnerProvider);
    }

    public static void registerEconomyProvider(EconomyProvider economyProvider) {
        shopGuiPlugin.getEconomyManager().registerCustomEconomyProvider(economyProvider);
    }

    public static void registerItemProvider(ItemProvider itemProvider) {
        shopGuiPlugin.getItemManager().registerItemProvider(itemProvider);
    }

    public static ShopGuiPlugin getPlugin() {
        return shopGuiPlugin;
    }

    static void setPlugin(ShopGuiPlugin instance) {
        shopGuiPlugin = instance;
    }

    private static ShopItem getShopItem(Player player, ItemStack itemStack) {
        return shopGuiPlugin.getShopManager().findShopItemByItemStack(player, itemStack, false);
    }

    private static ShopItem getShopItem(ItemStack itemStack) {
        return shopGuiPlugin.getShopManager().findShopItemByItemStack(itemStack, false);
    }
}

