/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.epicspawners.api.utils;

import com.craftaro.core.utils.HeadType;
import com.craftaro.core.utils.SkullItemCreator;
import com.craftaro.epicspawners.api.spawners.spawner.SpawnerData;
import com.craftaro.epicspawners.api.spawners.spawner.SpawnerTier;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class HeadUtils {
    private static final Map<HeadType, String> TEXTURE_HASHES = new EnumMap<HeadType, String>(HeadType.class);

    public static ItemStack getTexturedSkull(SpawnerTier spawnerTier) {
        return HeadUtils.getTexturedSkull(spawnerTier.getSpawnerData());
    }

    public static ItemStack getTexturedSkull(SpawnerData spawnerData) {
        HeadType headType = HeadUtils.getHeadTypeOrDefault(spawnerData.getIdentifyingName().toUpperCase().replace(" ", "_"));
        return HeadUtils.createSkullForSkinHash(TEXTURE_HASHES.get(headType));
    }

    public static ItemStack getTexturedSkull(HeadType headType) {
        return HeadUtils.createSkullForSkinHash(headType.getUrlHash());
    }

    private static ItemStack createSkullForSkinHash(String textureUrlHash) {
        return SkullItemCreator.byTextureUrlHash((String)textureUrlHash);
    }

    private static HeadType getHeadTypeOrDefault(String name) {
        try {
            return HeadType.valueOf((String)name);
        }
        catch (IllegalArgumentException ex) {
            return HeadType.DROPPED_ITEM;
        }
    }

    static {
        for (HeadType type : HeadType.values()) {
            TEXTURE_HASHES.put(type, type.getUrlHash());
        }
    }
}

