/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.epicspawners.api.events;

import com.craftaro.epicspawners.api.events.SpawnerEvent;
import com.craftaro.epicspawners.api.spawners.spawner.PlacedSpawner;
import com.craftaro.epicspawners.api.spawners.spawner.SpawnerTier;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;

public class SpawnerChangeEvent
extends SpawnerEvent
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    private boolean canceled = false;
    private final int stackSize;
    private final int oldStackSize;
    private final SpawnerTier spawnerTier;
    private final SpawnerTier oldSpawnerTier;
    private final ChangeType type;

    public SpawnerChangeEvent(Player who, PlacedSpawner spawner, int stackSize, int oldStackSize) {
        super(who, spawner);
        this.stackSize = stackSize;
        this.oldStackSize = oldStackSize;
        this.oldSpawnerTier = null;
        this.spawnerTier = null;
        this.type = ChangeType.STACK_SIZE;
    }

    public SpawnerChangeEvent(Player who, PlacedSpawner spawner, SpawnerTier data, SpawnerTier oldSpawnerTier) {
        super(who, spawner);
        this.spawnerTier = data;
        this.oldSpawnerTier = oldSpawnerTier;
        this.stackSize = this.oldStackSize = spawner.getStackSize();
        this.type = ChangeType.SPAWNER_DATA;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public int getOldStackSize() {
        return this.oldStackSize;
    }

    public SpawnerTier getSpawnerTier() {
        return this.spawnerTier;
    }

    public SpawnerTier getOldSpawnerTier() {
        return this.oldSpawnerTier;
    }

    public ChangeType getChange() {
        return this.type;
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public boolean isCancelled() {
        return this.canceled;
    }

    public void setCancelled(boolean cancel) {
        this.canceled = cancel;
    }

    @Deprecated
    public int getCurrentMulti() {
        return this.stackSize;
    }

    @Deprecated
    public int getOldMulti() {
        return this.oldStackSize;
    }

    @Deprecated
    public String getType() {
        return this.spawnerTier.getIdentifyingName();
    }

    @Deprecated
    public String getOldType() {
        return this.oldSpawnerTier.getIdentifyingName();
    }

    public static enum ChangeType {
        STACK_SIZE,
        SPAWNER_DATA;

    }
}

