/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.expansion.cloud;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.cloud.CloudExpansion;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ExpansionCloudManager {
    private final String API = "http://api.extendedclip.com/v2/";
    private final File dir;
    private final TreeMap<Integer, CloudExpansion> remote = new TreeMap();
    private final List<String> downloading = new ArrayList<String>();
    private PlaceholderAPIPlugin plugin;
    private Gson gson;

    public ExpansionCloudManager(PlaceholderAPIPlugin instance) {
        this.plugin = instance;
        this.gson = new Gson();
        this.dir = new File(instance.getDataFolder() + File.separator + "expansions");
        if (!this.dir.exists()) {
            try {
                this.dir.mkdirs();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void clean() {
        this.remote.clear();
        this.downloading.clear();
    }

    public boolean isDownloading(String expansion) {
        return this.downloading.contains(expansion);
    }

    public Map<Integer, CloudExpansion> getCloudExpansions() {
        return this.remote;
    }

    public CloudExpansion getCloudExpansion(String name) {
        return this.remote.values().stream().filter(ex -> ex.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public int getCloudAuthorCount() {
        return this.remote.values().stream().collect(Collectors.groupingBy(CloudExpansion::getAuthor, Collectors.counting())).size();
    }

    public long getToUpdateCount() {
        return PlaceholderAPI.getExpansions().stream().filter(ex -> this.getCloudExpansion(ex.getName()) != null && this.getCloudExpansion(ex.getName()).shouldUpdate()).count();
    }

    public Map<Integer, CloudExpansion> getAllByAuthor(String author) {
        if (this.remote.isEmpty()) {
            return null;
        }
        TreeMap<Integer, CloudExpansion> byAuthor = new TreeMap<Integer, CloudExpansion>();
        boolean first = true;
        for (CloudExpansion ex : this.remote.values()) {
            if (!ex.getAuthor().equalsIgnoreCase(author)) continue;
            if (first) {
                first = false;
                byAuthor.put(0, ex);
                continue;
            }
            byAuthor.put(byAuthor.lastKey() + 1, ex);
        }
        if (byAuthor.isEmpty()) {
            return null;
        }
        return byAuthor;
    }

    public Map<Integer, CloudExpansion> getAllInstalled() {
        if (this.remote.isEmpty()) {
            return null;
        }
        TreeMap<Integer, CloudExpansion> has = new TreeMap<Integer, CloudExpansion>();
        boolean first = true;
        for (CloudExpansion ex : this.remote.values()) {
            if (!ex.hasExpansion()) continue;
            if (first) {
                first = false;
                has.put(1, ex);
                continue;
            }
            has.put(has.lastKey() + 1, ex);
        }
        if (has.isEmpty()) {
            return null;
        }
        return has;
    }

    public int getPagesAvailable(Map<Integer, CloudExpansion> map, int amount) {
        int pages;
        if (map == null) {
            return 0;
        }
        int n = pages = map.size() > 0 ? 1 : 0;
        if (pages == 0) {
            return pages;
        }
        if (map.size() > amount) {
            pages = map.size() / amount;
            if (map.size() % amount > 0) {
                ++pages;
            }
        }
        return pages;
    }

    public Map<Integer, CloudExpansion> getPage(Map<Integer, CloudExpansion> map, int page, int size) {
        if (map == null || map.size() == 0 || page > this.getPagesAvailable(map, size)) {
            return null;
        }
        int end = size * page;
        int start = end - size;
        TreeMap<Integer, CloudExpansion> ex = new TreeMap<Integer, CloudExpansion>();
        IntStream.range(start, end).forEach(n -> {
            CloudExpansion cfr_ignored_0 = (CloudExpansion)ex.put(n, (CloudExpansion)map.get(n));
        });
        return ex;
    }

    public void fetch(final boolean allowUnverified) {
        this.plugin.getLogger().info("Fetching available expansion information...");
        new BukkitRunnable(){

            public void run() {
                StringBuilder sb;
                try {
                    String line;
                    URL site = new URL("http://api.extendedclip.com/v2/");
                    HttpURLConnection connection = (HttpURLConnection)site.openConnection();
                    connection.setRequestMethod("GET");
                    connection.connect();
                    BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    br.close();
                    connection.disconnect();
                }
                catch (Exception e) {
                    return;
                }
                String json = sb.toString();
                JSONParser parser = new JSONParser();
                Object obj = null;
                try {
                    obj = parser.parse(json);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (obj == null) {
                    return;
                }
                ArrayList<CloudExpansion> unsorted = new ArrayList<CloudExpansion>();
                if (obj instanceof JSONObject) {
                    JSONObject jo = (JSONObject)obj;
                    for (Object o : jo.keySet()) {
                        JSONObject sub = (JSONObject)jo.get(o);
                        CloudExpansion ce = ExpansionCloudManager.this.gson.fromJson(sub.toJSONString(), CloudExpansion.class);
                        if (!allowUnverified && !ce.isVerified() || ce.getLatestVersion() == null || ce.getVersion(ce.getLatestVersion()) == null) continue;
                        ce.setName(o.toString());
                        PlaceholderExpansion ex = ExpansionCloudManager.this.plugin.getExpansionManager().getRegisteredExpansion(ce.getName());
                        if (ex != null && ex.isRegistered()) {
                            ce.setHasExpansion(true);
                            if (!ex.getVersion().equals(ce.getLatestVersion())) {
                                ce.setShouldUpdate(true);
                            }
                        }
                        unsorted.add(ce);
                    }
                    int count = 0;
                    unsorted.sort(Comparator.comparing(CloudExpansion::getLastUpdate).reversed());
                    for (CloudExpansion e : unsorted) {
                        ExpansionCloudManager.this.remote.put(count, e);
                        ++count;
                    }
                    ExpansionCloudManager.this.plugin.getLogger().info(count + " placeholder expansions are available on the cloud.");
                    long updates = ExpansionCloudManager.this.getToUpdateCount();
                    if (updates > 0L) {
                        ExpansionCloudManager.this.plugin.getLogger().info(updates + " installed expansions have updates available.");
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(URL url, String name) throws IOException {
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int l;
            URLConnection urlConn = url.openConnection();
            is = urlConn.getInputStream();
            fos = new FileOutputStream(this.dir.getAbsolutePath() + File.separator + "Expansion-" + name + ".jar");
            byte[] buffer = new byte[is.available()];
            while ((l = is.read(buffer)) > 0) {
                fos.write(buffer, 0, l);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
    }

    public void downloadExpansion(String player, CloudExpansion ex) {
        this.downloadExpansion(player, ex, ex.getLatestVersion());
    }

    public void downloadExpansion(String player, CloudExpansion ex, String version) {
        if (this.downloading.contains(ex.getName())) {
            return;
        }
        CloudExpansion.Version ver = ex.getVersions().stream().filter(v -> v.getVersion().equals(version)).findFirst().orElse(null);
        if (ver == null) {
            return;
        }
        this.downloading.add(ex.getName());
        this.plugin.getLogger().info("Attempting download of expansion: " + ex.getName() + (player != null ? " by user: " + player : "") + " from url: " + ver.getUrl());
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.download(new URL(ver.getUrl()), ex.getName());
                this.plugin.getLogger().info("Download of expansion: " + ex.getName() + " complete!");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to download expansion: " + ex.getName() + " from: " + ver.getUrl());
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    Player p;
                    this.downloading.remove(ex.getName());
                    if (player != null && (p = Bukkit.getPlayer((String)player)) != null) {
                        Msg.msg((CommandSender)p, "&cThere was a problem downloading expansion: &f" + ex.getName());
                    }
                });
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Player p;
                this.downloading.remove(ex.getName());
                if (player != null && (p = Bukkit.getPlayer((String)player)) != null) {
                    Msg.msg((CommandSender)p, "&aExpansion &f" + ex.getName() + " &adownload complete!");
                }
            });
        });
    }
}

