/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.expansion;

import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;

public abstract class PlaceholderExpansion
extends PlaceholderHook {
    public String getName() {
        return this.getIdentifier();
    }

    public abstract String getIdentifier();

    public abstract String getAuthor();

    public abstract String getVersion();

    public String getRequiredPlugin() {
        return this.getPlugin();
    }

    public List<String> getPlaceholders() {
        return null;
    }

    public boolean persist() {
        return false;
    }

    public boolean isRegistered() {
        Validate.notNull((Object)this.getIdentifier(), (String)"Placeholder identifier can not be null!");
        return PlaceholderAPI.getRegisteredIdentifiers().contains(this.getIdentifier());
    }

    public boolean canRegister() {
        return this.getRequiredPlugin() == null || Bukkit.getPluginManager().getPlugin(this.getRequiredPlugin()) != null;
    }

    public boolean register() {
        Validate.notNull((Object)this.getIdentifier(), (String)"Placeholder identifier can not be null!");
        return PlaceholderAPI.registerExpansion(this);
    }

    public PlaceholderAPIPlugin getPlaceholderAPI() {
        return PlaceholderAPIPlugin.getInstance();
    }

    public String getString(String path, String def) {
        return this.getPlaceholderAPI().getConfig().getString("expansions." + this.getIdentifier() + "." + path, def);
    }

    public int getInt(String path, int def) {
        return this.getPlaceholderAPI().getConfig().getInt("expansions." + this.getIdentifier() + "." + path, def);
    }

    public long getLong(String path, long def) {
        return this.getPlaceholderAPI().getConfig().getLong("expansions." + this.getIdentifier() + "." + path, def);
    }

    public double getDouble(String path, double def) {
        return this.getPlaceholderAPI().getConfig().getDouble("expansions." + this.getIdentifier() + "." + path, def);
    }

    public List<String> getStringList(String path) {
        return this.getPlaceholderAPI().getConfig().getStringList("expansions." + this.getIdentifier() + "." + path);
    }

    public Object get(String path, Object def) {
        return this.getPlaceholderAPI().getConfig().get("expansions." + this.getIdentifier() + "." + path, def);
    }

    public ConfigurationSection getConfigSection(String path) {
        return this.getPlaceholderAPI().getConfig().getConfigurationSection("expansions." + this.getIdentifier() + "." + path);
    }

    public ConfigurationSection getConfigSection() {
        return this.getPlaceholderAPI().getConfig().getConfigurationSection("expansions." + this.getIdentifier());
    }

    public boolean configurationContains(String path) {
        return this.getPlaceholderAPI().getConfig().contains("expansions." + this.getIdentifier() + "." + path);
    }

    @Deprecated
    public String getPlugin() {
        return null;
    }

    @Deprecated
    public String getDescription() {
        return null;
    }

    @Deprecated
    public String getLink() {
        return null;
    }
}

