/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.commands;

import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.cloud.CloudExpansion;
import me.clip.placeholderapi.util.Msg;
import me.clip.placeholderapi.util.jsonmessage.JSONMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ExpansionCloudCommands
implements CommandExecutor {
    private PlaceholderAPIPlugin plugin;

    public ExpansionCloudCommands(PlaceholderAPIPlugin instance) {
        this.plugin = instance;
    }

    public boolean onCommand(CommandSender s, Command c, String label, String[] args) {
        if (args.length == 1) {
            Msg.msg(s, "&bExpansion cloud commands", " ", "&b/papi ecloud status", "&fView status of the ecloud", "&b/papi ecloud list <all/author> (page)", "&fList all/author specific available expansions", "&b/papi ecloud info <expansion name>", "&fView information about a specific expansion available on the cloud", "&b/papi ecloud versioninfo <expansion name> <version>", "&fView information about a specific version of an expansion", "&b/papi ecloud placeholders <expansion name>", "&fView placeholders for an expansion", "&b/papi ecloud download <expansion name> (version)", "&fDownload an expansion from the ecloud", "&b/papi ecloud refresh", "&fFetch the most up to date list of expansions available.", "&b/papi ecloud clear", "&fClear the expansion cloud cache.");
            return true;
        }
        if (args[1].equalsIgnoreCase("refresh") || args[1].equalsIgnoreCase("update") || args[1].equalsIgnoreCase("fetch")) {
            Msg.msg(s, "&aRefresh task started. Use &f/papi ecloud list all &ain a few!!");
            this.plugin.getExpansionCloud().clean();
            this.plugin.getExpansionCloud().fetch(this.plugin.getPlaceholderAPIConfig().cloudAllowUnverifiedExpansions());
            return true;
        }
        if (this.plugin.getExpansionCloud().getCloudExpansions().isEmpty()) {
            Msg.msg(s, "&7No cloud expansions are available at this time.");
            return true;
        }
        if (args[1].equalsIgnoreCase("clear")) {
            this.plugin.getExpansionCloud().clean();
            Msg.msg(s, "&aThe cache has been cleared!!");
            return true;
        }
        if (args[1].equalsIgnoreCase("status")) {
            Msg.msg(s, "&bThere are &f" + this.plugin.getExpansionCloud().getCloudExpansions().size() + " &bexpansions available on the cloud.", "&7A total of &f" + this.plugin.getExpansionCloud().getCloudAuthorCount() + " &7authors have contributed to the expansion cloud.");
            if (this.plugin.getExpansionCloud().getToUpdateCount() > 0L) {
                Msg.msg(s, "&eYou have &f" + this.plugin.getExpansionCloud().getToUpdateCount() + " &eexpansions installed that have updates available.");
            }
            return true;
        }
        if (args[1].equalsIgnoreCase("info")) {
            if (args.length < 3) {
                Msg.msg(s, "&cAn expansion name must be specified!");
                return true;
            }
            CloudExpansion expansion = this.plugin.getExpansionCloud().getCloudExpansion(args[2]);
            if (expansion == null) {
                Msg.msg(s, "&cNo expansion found by the name: &f" + args[2]);
                return true;
            }
            if (!(s instanceof Player)) {
                Msg.msg(s, (expansion.shouldUpdate() ? "&e" : "") + expansion.getName() + " &8&m-- &r" + expansion.getVersion().getUrl());
                return true;
            }
            Player p = (Player)s;
            Msg.msg(s, "&bExpansion&7: &f" + expansion.getName(), "&bAuthor: &f" + expansion.getAuthor(), "&bVerified: &f" + expansion.isVerified());
            JSONMessage latestVersion = JSONMessage.create(Msg.color("&bLatest version: &f" + expansion.getLatestVersion()));
            latestVersion.tooltip(Msg.color("&bReleased: &f" + expansion.getTimeSinceLastUpdate() + "\n&bUpdate information: &f" + expansion.getVersion().getReleaseNotes()));
            latestVersion.send(p);
            JSONMessage versions = JSONMessage.create(Msg.color("&bVersions available: &f" + expansion.getVersions().size()));
            versions.tooltip(Msg.color(String.join((CharSequence)"&b, &f", expansion.getAvailableVersions())));
            versions.suggestCommand("/papi ecloud versioninfo " + expansion.getName() + " " + expansion.getLatestVersion());
            versions.send(p);
            if (expansion.getPlaceholders() != null) {
                JSONMessage placeholders = JSONMessage.create(Msg.color("&bPlaceholders: &f" + expansion.getPlaceholders().size()));
                placeholders.tooltip(Msg.color(String.join((CharSequence)"&b, &f", expansion.getPlaceholders())));
                placeholders.suggestCommand("/papi ecloud placeholders " + expansion.getName());
                placeholders.send(p);
            }
            return true;
        }
        if (args[1].equalsIgnoreCase("versioninfo")) {
            if (args.length < 4) {
                Msg.msg(s, "&cAn expansion name and version must be specified!");
                return true;
            }
            CloudExpansion expansion = this.plugin.getExpansionCloud().getCloudExpansion(args[2]);
            if (expansion == null) {
                Msg.msg(s, "&cNo expansion found by the name: &f" + args[2]);
                return true;
            }
            CloudExpansion.Version version = expansion.getVersion(args[3]);
            if (version == null) {
                Msg.msg(s, "&cThe version specified does not exist for expansion: &f" + expansion.getName());
                return true;
            }
            Msg.msg(s, "&bExpansion: " + (expansion.shouldUpdate() ? "&e" : "&f") + expansion.getName(), "&bVersion: &f" + version.getVersion(), "&bVersion info: &f" + version.getReleaseNotes());
            if (!(s instanceof Player)) {
                Msg.msg(s, "&bDownload url: " + version.getUrl());
                return true;
            }
            Player p = (Player)s;
            JSONMessage download = JSONMessage.create(Msg.color("&7Click to download this version"));
            download.suggestCommand("/papi ecloud download " + expansion.getName() + " " + version.getVersion());
            download.send(p);
            return true;
        }
        if (args[1].equalsIgnoreCase("placeholders")) {
            if (args.length < 3) {
                Msg.msg(s, "&cAn expansion name must be specified!");
                return true;
            }
            CloudExpansion expansion = this.plugin.getExpansionCloud().getCloudExpansion(args[2]);
            if (expansion == null) {
                Msg.msg(s, "&cNo expansion found by the name: &f" + args[2]);
                return true;
            }
            List<String> placeholders = expansion.getPlaceholders();
            if (placeholders == null) {
                Msg.msg(s, "&cThe expansion: &f" + expansion.getName() + " &cdoes not have any placeholders listed.", "&7You should contact &f" + expansion.getAuthor() + " &7and ask for them to be added.");
                return true;
            }
            if (!(s instanceof Player) || this.plugin.getExpansionManager().getRegisteredExpansion(expansion.getName()) == null) {
                Msg.msg(s, "&bPlaceholders: &f" + placeholders.size(), String.join((CharSequence)"&a, &f", placeholders));
                return true;
            }
            Player p = (Player)s;
            JSONMessage message = JSONMessage.create(Msg.color("&bPlaceholders: &f" + placeholders.size()));
            message.then("\n");
            for (int i = 0; i < placeholders.size(); ++i) {
                if (i == placeholders.size() - 1) {
                    message.then(placeholders.get(i));
                } else {
                    message.then(Msg.color(placeholders.get(i) + "&b, &f"));
                }
                message.tooltip(PlaceholderAPI.setPlaceholders(p, placeholders.get(i)));
            }
            message.send(p);
            return true;
        }
        if (args[1].equalsIgnoreCase("list")) {
            int page = 1;
            boolean installed = false;
            if (args.length < 3) {
                Msg.msg(s, "&cIncorrect usage! &7/papi ecloud list <all/author/installed> (page)");
                return true;
            }
            String author = args[2];
            if (author.equalsIgnoreCase("all")) {
                author = null;
            } else if (author.equalsIgnoreCase("installed")) {
                author = null;
                installed = true;
            }
            if (args.length >= 4) {
                try {
                    page = Integer.parseInt(args[3]);
                }
                catch (NumberFormatException ex) {
                    Msg.msg(s, "&cPage number must be an integer!");
                    return true;
                }
            }
            if (page < 1) {
                Msg.msg(s, "&cPage must be greater than or equal to 1!");
                return true;
            }
            Map<Integer, CloudExpansion> ex = installed ? this.plugin.getExpansionCloud().getAllInstalled() : (author == null ? this.plugin.getExpansionCloud().getCloudExpansions() : this.plugin.getExpansionCloud().getAllByAuthor(author));
            if (ex == null || ex.isEmpty()) {
                Msg.msg(s, "&cNo expansions available" + (author != null ? " for author &f" + author : ""));
                return true;
            }
            int avail = this.plugin.getExpansionCloud().getPagesAvailable(ex, 10);
            if (page > avail) {
                Msg.msg(s, "&cThere " + (avail == 1 ? " is only &f" + avail + " &cpage available!" : "are only &f" + avail + " &cpages available!"));
                return true;
            }
            Msg.msg(s, "&bShowing expansions for&7: &f" + (author != null ? author : (installed ? "all installed" : "all available")) + " &8&m--&r &bamount&7: &f" + ex.size() + " &bpage&7: &f" + page + "&7/&f" + avail);
            ex = this.plugin.getExpansionCloud().getPage(ex, page, 10);
            if (ex == null) {
                Msg.msg(s, "&cThere was a problem getting the requested page...");
                return true;
            }
            Msg.msg(s, "&aGreen = Expansions you have");
            Msg.msg(s, "&6Gold = Expansions which need updated");
            if (!(s instanceof Player)) {
                for (Map.Entry<Integer, CloudExpansion> expansion : ex.entrySet()) {
                    if (expansion == null || expansion.getValue() == null) continue;
                    Msg.msg(s, "&b" + (expansion.getKey() + 1) + "&7: " + (expansion.getValue().shouldUpdate() ? "&6" : (expansion.getValue().hasExpansion() ? "&a" : "&7")) + expansion.getValue().getName() + " &8&m-- &r" + expansion.getValue().getVersion().getUrl());
                }
                return true;
            }
            Player p = (Player)s;
            for (Map.Entry<Integer, CloudExpansion> expansion : ex.entrySet()) {
                if (expansion == null || expansion.getValue() == null) continue;
                StringBuilder sb = new StringBuilder();
                if (expansion.getValue().shouldUpdate()) {
                    sb.append("&6Click to update to the latest version of this expansion\n\n");
                } else if (!expansion.getValue().hasExpansion()) {
                    sb.append("&bClick to download this expansion\n\n");
                } else {
                    sb.append("&aYou have the latest version of this expansion\n\n");
                }
                sb.append("&bAuthor&7: &f" + expansion.getValue().getAuthor() + "\n");
                sb.append("&bVerified&7: &f" + expansion.getValue().isVerified() + "\n");
                sb.append("&bLatest version&7: &f" + expansion.getValue().getVersion().getVersion() + "\n");
                sb.append("&bLast updated&7: &f" + expansion.getValue().getTimeSinceLastUpdate() + " ago\n");
                sb.append("\n" + expansion.getValue().getDescription());
                String msg = Msg.color("&b" + (expansion.getKey() + 1) + "&7: " + (expansion.getValue().shouldUpdate() ? "&6" : (expansion.getValue().hasExpansion() ? "&a" : "")) + expansion.getValue().getName());
                String hover = Msg.color(sb.toString());
                JSONMessage line = JSONMessage.create(msg);
                line.tooltip(hover);
                line.suggestCommand("/papi ecloud info " + expansion.getValue().getName());
                line.send(p);
            }
            return true;
        }
        if (args[1].equalsIgnoreCase("download")) {
            if (args.length < 3) {
                Msg.msg(s, "&cAn expansion name must be specified!");
                return true;
            }
            CloudExpansion expansion = this.plugin.getExpansionCloud().getCloudExpansion(args[2]);
            if (expansion == null) {
                Msg.msg(s, "&cNo expansion found with the name: &f" + args[2]);
                return true;
            }
            PlaceholderExpansion loaded = this.plugin.getExpansionManager().getRegisteredExpansion(args[2]);
            if (loaded != null && loaded.isRegistered()) {
                PlaceholderAPI.unregisterPlaceholderHook(loaded.getIdentifier());
            }
            String version = expansion.getLatestVersion();
            if (args.length == 4 && expansion.getVersion(version = args[3]) == null) {
                Msg.msg(s, "&cThe version you specified does not exist for &f" + expansion.getName());
                Msg.msg(s, "&7Available versions: &f" + expansion.getVersions().size());
                Msg.msg(s, String.join((CharSequence)"&a, &f", expansion.getAvailableVersions()));
                return true;
            }
            Msg.msg(s, "&aDownload starting for expansion: &f" + expansion.getName() + " &aversion: &f" + version);
            String player = s instanceof Player ? s.getName() : null;
            this.plugin.getExpansionCloud().downloadExpansion(player, expansion, version);
            return true;
        }
        Msg.msg(s, "&cIncorrect usage! &b/papi ecloud");
        return true;
    }
}

