/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi;

import java.util.Map;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.PlaceholderHook;
import me.clip.placeholderapi.events.ExpansionUnregisterEvent;
import me.clip.placeholderapi.expansion.Cacheable;
import me.clip.placeholderapi.expansion.Cleanable;
import me.clip.placeholderapi.expansion.ExpansionManager;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Taskable;
import me.clip.placeholderapi.expansion.cloud.CloudExpansion;
import me.clip.placeholderapi.external.EZPlaceholderHook;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class PlaceholderListener
implements Listener {
    private PlaceholderAPIPlugin plugin;

    public PlaceholderListener(PlaceholderAPIPlugin instance) {
        this.plugin = instance;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)instance);
    }

    @EventHandler
    public void onExpansionUnregister(ExpansionUnregisterEvent event) {
        CloudExpansion ex;
        if (event.getExpansion() instanceof Listener) {
            HandlerList.unregisterAll((Listener)((Listener)event.getExpansion()));
        }
        if (event.getExpansion() instanceof Taskable) {
            ((Taskable)((Object)event.getExpansion())).stop();
        }
        if (event.getExpansion() instanceof Cacheable) {
            ((Cacheable)((Object)event.getExpansion())).clear();
        }
        if (this.plugin.getExpansionCloud() != null && (ex = this.plugin.getExpansionCloud().getCloudExpansion(event.getExpansion().getName())) != null) {
            ex.setHasExpansion(false);
            ex.setShouldUpdate(false);
        }
    }

    @EventHandler
    public void onEnable(PluginEnableEvent event) {
        ExpansionManager m = this.plugin.getExpansionManager();
        PlaceholderExpansion e = m.getCachedExpansion(event.getPlugin().getName().toLowerCase());
        if (e != null && e.canRegister() && (e.isRegistered() || m.registerExpansion(e))) {
            m.removeCachedExpansion(e.getRequiredPlugin());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPluginUnload(PluginDisableEvent e) {
        String n = e.getPlugin().getName();
        if (n == null) {
            return;
        }
        if (n.equals(this.plugin.getName())) {
            return;
        }
        Map<String, PlaceholderHook> hooks = PlaceholderAPI.getPlaceholders();
        for (Map.Entry<String, PlaceholderHook> hook : hooks.entrySet()) {
            PlaceholderExpansion ex;
            PlaceholderHook i = hook.getValue();
            if (i instanceof EZPlaceholderHook) {
                EZPlaceholderHook h = (EZPlaceholderHook)i;
                if (h.getPluginName() == null || !h.getPluginName().equalsIgnoreCase(n) || !PlaceholderAPI.unregisterPlaceholderHook(hook.getKey())) continue;
                this.plugin.getLogger().info("Unregistered placeholder hook for placeholder: " + h.getPlaceholderName());
                break;
            }
            if (!(i instanceof PlaceholderExpansion) || (ex = (PlaceholderExpansion)i).getRequiredPlugin() == null || !ex.getRequiredPlugin().equalsIgnoreCase(n) || !PlaceholderAPI.unregisterExpansion(ex)) continue;
            this.plugin.getLogger().info("Unregistered placeholder expansion: " + ex.getIdentifier());
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Set<PlaceholderExpansion> expansions = PlaceholderAPI.getExpansions();
        if (expansions.isEmpty()) {
            return;
        }
        for (PlaceholderExpansion ex : expansions) {
            if (!(ex instanceof Cleanable)) continue;
            ((Cleanable)((Object)ex)).cleanup(e.getPlayer());
        }
    }
}

