/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Locale;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.MinecraftExperimental;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.util.OldEnum;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface Biome
extends OldEnum<Biome>,
Keyed,
Translatable {
    public static final Biome OCEAN = Biome.getBiome("ocean");
    public static final Biome PLAINS = Biome.getBiome("plains");
    public static final Biome DESERT = Biome.getBiome("desert");
    public static final Biome WINDSWEPT_HILLS = Biome.getBiome("windswept_hills");
    public static final Biome FOREST = Biome.getBiome("forest");
    public static final Biome TAIGA = Biome.getBiome("taiga");
    public static final Biome SWAMP = Biome.getBiome("swamp");
    public static final Biome MANGROVE_SWAMP = Biome.getBiome("mangrove_swamp");
    public static final Biome RIVER = Biome.getBiome("river");
    public static final Biome NETHER_WASTES = Biome.getBiome("nether_wastes");
    public static final Biome THE_END = Biome.getBiome("the_end");
    public static final Biome FROZEN_OCEAN = Biome.getBiome("frozen_ocean");
    public static final Biome FROZEN_RIVER = Biome.getBiome("frozen_river");
    public static final Biome SNOWY_PLAINS = Biome.getBiome("snowy_plains");
    public static final Biome MUSHROOM_FIELDS = Biome.getBiome("mushroom_fields");
    public static final Biome BEACH = Biome.getBiome("beach");
    public static final Biome JUNGLE = Biome.getBiome("jungle");
    public static final Biome SPARSE_JUNGLE = Biome.getBiome("sparse_jungle");
    public static final Biome DEEP_OCEAN = Biome.getBiome("deep_ocean");
    public static final Biome STONY_SHORE = Biome.getBiome("stony_shore");
    public static final Biome SNOWY_BEACH = Biome.getBiome("snowy_beach");
    public static final Biome BIRCH_FOREST = Biome.getBiome("birch_forest");
    public static final Biome DARK_FOREST = Biome.getBiome("dark_forest");
    public static final Biome SNOWY_TAIGA = Biome.getBiome("snowy_taiga");
    public static final Biome OLD_GROWTH_PINE_TAIGA = Biome.getBiome("old_growth_pine_taiga");
    public static final Biome WINDSWEPT_FOREST = Biome.getBiome("windswept_forest");
    public static final Biome SAVANNA = Biome.getBiome("savanna");
    public static final Biome SAVANNA_PLATEAU = Biome.getBiome("savanna_plateau");
    public static final Biome BADLANDS = Biome.getBiome("badlands");
    public static final Biome WOODED_BADLANDS = Biome.getBiome("wooded_badlands");
    public static final Biome SMALL_END_ISLANDS = Biome.getBiome("small_end_islands");
    public static final Biome END_MIDLANDS = Biome.getBiome("end_midlands");
    public static final Biome END_HIGHLANDS = Biome.getBiome("end_highlands");
    public static final Biome END_BARRENS = Biome.getBiome("end_barrens");
    public static final Biome WARM_OCEAN = Biome.getBiome("warm_ocean");
    public static final Biome LUKEWARM_OCEAN = Biome.getBiome("lukewarm_ocean");
    public static final Biome COLD_OCEAN = Biome.getBiome("cold_ocean");
    public static final Biome DEEP_LUKEWARM_OCEAN = Biome.getBiome("deep_lukewarm_ocean");
    public static final Biome DEEP_COLD_OCEAN = Biome.getBiome("deep_cold_ocean");
    public static final Biome DEEP_FROZEN_OCEAN = Biome.getBiome("deep_frozen_ocean");
    public static final Biome THE_VOID = Biome.getBiome("the_void");
    public static final Biome SUNFLOWER_PLAINS = Biome.getBiome("sunflower_plains");
    public static final Biome WINDSWEPT_GRAVELLY_HILLS = Biome.getBiome("windswept_gravelly_hills");
    public static final Biome FLOWER_FOREST = Biome.getBiome("flower_forest");
    public static final Biome ICE_SPIKES = Biome.getBiome("ice_spikes");
    public static final Biome OLD_GROWTH_BIRCH_FOREST = Biome.getBiome("old_growth_birch_forest");
    public static final Biome OLD_GROWTH_SPRUCE_TAIGA = Biome.getBiome("old_growth_spruce_taiga");
    public static final Biome WINDSWEPT_SAVANNA = Biome.getBiome("windswept_savanna");
    public static final Biome ERODED_BADLANDS = Biome.getBiome("eroded_badlands");
    public static final Biome BAMBOO_JUNGLE = Biome.getBiome("bamboo_jungle");
    public static final Biome SOUL_SAND_VALLEY = Biome.getBiome("soul_sand_valley");
    public static final Biome CRIMSON_FOREST = Biome.getBiome("crimson_forest");
    public static final Biome WARPED_FOREST = Biome.getBiome("warped_forest");
    public static final Biome BASALT_DELTAS = Biome.getBiome("basalt_deltas");
    public static final Biome DRIPSTONE_CAVES = Biome.getBiome("dripstone_caves");
    public static final Biome LUSH_CAVES = Biome.getBiome("lush_caves");
    public static final Biome DEEP_DARK = Biome.getBiome("deep_dark");
    public static final Biome MEADOW = Biome.getBiome("meadow");
    public static final Biome GROVE = Biome.getBiome("grove");
    public static final Biome SNOWY_SLOPES = Biome.getBiome("snowy_slopes");
    public static final Biome FROZEN_PEAKS = Biome.getBiome("frozen_peaks");
    public static final Biome JAGGED_PEAKS = Biome.getBiome("jagged_peaks");
    public static final Biome STONY_PEAKS = Biome.getBiome("stony_peaks");
    public static final Biome CHERRY_GROVE = Biome.getBiome("cherry_grove");
    @ApiStatus.Experimental
    @MinecraftExperimental(value=MinecraftExperimental.Requires.WINTER_DROP)
    public static final Biome PALE_GARDEN = Registry.BIOME.get(NamespacedKey.minecraft("pale_garden"));
    @Deprecated(since="1.21.3", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static final Biome CUSTOM = Bukkit.getUnsafe().getCustomBiome();

    @NotNull
    private static Biome getBiome(@NotNull String key) {
        return Registry.BIOME.getOrThrow(NamespacedKey.minecraft(key));
    }

    @Deprecated(since="1.21.3", forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static Biome valueOf(@NotNull String name) {
        if ("CUSTOM".equals(name)) {
            return CUSTOM;
        }
        Biome biome = Bukkit.getUnsafe().get(Registry.BIOME, NamespacedKey.fromString(name.toLowerCase(Locale.ROOT)));
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (String)"No biome found with the name %s", (Object)name);
        return biome;
    }

    @Deprecated(since="1.21.3", forRemoval=true)
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static Biome[] values() {
        return Lists.newArrayList(Registry.BIOME).toArray(new Biome[0]);
    }

    @NotNull
    default public String translationKey() {
        return "biome.minecraft." + this.getKey().getKey();
    }
}

