/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.skyblock.world.generator;

import com.craftaro.skyblock.SkyBlock;
import com.craftaro.skyblock.core.compatibility.CompatibleBiome;
import com.craftaro.skyblock.core.compatibility.MajorServerVersion;
import com.craftaro.skyblock.island.IslandWorld;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;

public class VoidGenerator
extends ChunkGenerator {
    private final IslandWorld islandWorld;
    private final SkyBlock plugin;

    public VoidGenerator(IslandWorld islandWorld, SkyBlock plugin) {
        this.islandWorld = islandWorld;
        this.plugin = plugin;
    }

    @Nonnull
    public ChunkGenerator.ChunkData generateChunkData(@Nonnull World world, @Nonnull Random random, int chunkX, int chunkZ, @Nonnull ChunkGenerator.BiomeGrid biomeGrid) {
        Biome biome;
        ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
        FileConfiguration configLoad = this.plugin.getConfiguration();
        ConfigurationSection worldSection = configLoad.getConfigurationSection("Island.World");
        switch (world.getEnvironment()) {
            case NORMAL: {
                biome = Arrays.stream(CompatibleBiome.values()).filter(arg_0 -> VoidGenerator.lambda$generateChunkData$0((Configuration)configLoad, arg_0)).findFirst().orElse(CompatibleBiome.PLAINS).getBiome();
                break;
            }
            case NETHER: {
                biome = CompatibleBiome.NETHER_WASTES.getBiome();
                break;
            }
            case THE_END: {
                biome = CompatibleBiome.THE_END.getBiome();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + world.getEnvironment());
            }
        }
        if (MajorServerVersion.isServerVersionAtLeast(MajorServerVersion.V1_16)) {
            this.setChunkBiome3D(biome, biomeGrid, world);
        } else {
            this.setChunkBiome2D(biome, biomeGrid);
        }
        ConfigurationSection section = worldSection.getConfigurationSection(this.islandWorld.getFriendlyName());
        if (section.getBoolean("Liquid.Enable")) {
            if (section.getBoolean("Liquid.Lava")) {
                this.setBlock(chunkData, XMaterial.LAVA.parseMaterial(), section.getInt("Liquid.Height"));
            } else {
                this.setBlock(chunkData, XMaterial.WATER.parseMaterial(), section.getInt("Liquid.Height"));
            }
        }
        return chunkData;
    }

    @NotNull
    public List<BlockPopulator> getDefaultPopulators(@NotNull World world) {
        return Collections.emptyList();
    }

    public boolean canSpawn(@NotNull World world, int x, int z) {
        return true;
    }

    public byte[][] generateBlockSections(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biomeGrid) {
        return new byte[world.getMaxHeight() / 16][];
    }

    private void setBlock(ChunkGenerator.ChunkData chunkData, Material material, int height) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < height; ++y) {
                    chunkData.setBlock(x, y, z, material);
                }
            }
        }
    }

    private void setChunkBiome3D(Biome biome, ChunkGenerator.BiomeGrid grid, World world) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < world.getMaxHeight(); ++y) {
                    grid.setBiome(z, y, z, biome);
                }
            }
        }
    }

    private void setChunkBiome2D(Biome biome, ChunkGenerator.BiomeGrid grid) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (grid.getBiome(x, z).equals((Object)biome)) continue;
                grid.setBiome(x, z, biome);
            }
        }
    }

    private static /* synthetic */ boolean lambda$generateChunkData$0(Configuration configLoad, CompatibleBiome compatibleBiome) {
        return compatibleBiome.name().equals(configLoad.getString("Island.Biome.Default.Type", "PLAINS").toUpperCase()) && compatibleBiome.isCompatible();
    }
}

